/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.tabs;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.somox.metrics.tabs.MetricTab;

public class NameResemblanceTab
extends MetricTab {
    protected Composite control;
    private Text suffixText;
    private Text prefixText;
    private List prefixList;
    private List suffixList;
    private final String DELIMITER = "\u00a7";
    public static final String NAME_RESEMBLANCE_CONFIGURATION_EXCLUDED_SUFFIXES = "org.somox.metrics.nameResemblance.excludedSuffixes";
    public static final String NAME_RESEMBLANCE_CONFIGURATION_EXCLUDED_PREFIXES = "org.somox.metrics.nameResemblance.excludedPrefixes";

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public boolean canSave() {
        return true;
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 2048);
        this.control.setLayout((Layout)new FillLayout(256));
        Group grpPrefixes = new Group(this.control, 2048);
        grpPrefixes.setLayout((Layout)new FillLayout(512));
        grpPrefixes.setText("Prefixes");
        Composite composite = new Composite((Composite)grpPrefixes, 0);
        this.prefixList = new List(composite, 2816);
        this.prefixList.setBounds(0, 0, 314, 205);
        composite = new Composite((Composite)grpPrefixes, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0);
        Button prefixRemoveButton = new Button(composite, 0);
        prefixRemoveButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                NameResemblanceTab.this.prefixList.remove(NameResemblanceTab.this.prefixList.getFocusIndex());
                NameResemblanceTab.this.setDirty(true);
                NameResemblanceTab.this.updateLaunchConfigurationDialog();
            }
        });
        prefixRemoveButton.setText("Remove selected");
        this.prefixText = new Text(composite, 2048);
        this.prefixText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button prefixAddButton = new Button(composite, 0);
        prefixAddButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String text = NameResemblanceTab.this.prefixText.getText();
                if (text != null && !text.equals("")) {
                    NameResemblanceTab.this.prefixList.add(text);
                    NameResemblanceTab.this.setDirty(true);
                    NameResemblanceTab.this.updateLaunchConfigurationDialog();
                }
                NameResemblanceTab.this.prefixText.setText("");
            }
        });
        prefixAddButton.setText("Add prefix");
        Group grpSuffixes = new Group(this.control, 2048);
        grpSuffixes.setLayout((Layout)new FillLayout(512));
        grpSuffixes.setText("Suffixes");
        composite = new Composite((Composite)grpSuffixes, 0);
        this.suffixList = new List(composite, 2816);
        this.suffixList.setBounds(0, 0, 314, 205);
        composite = new Composite((Composite)grpSuffixes, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0);
        Button suffixRemoveButton = new Button(composite, 0);
        suffixRemoveButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                NameResemblanceTab.this.suffixList.remove(NameResemblanceTab.this.suffixList.getFocusIndex());
                NameResemblanceTab.this.setDirty(true);
                NameResemblanceTab.this.updateLaunchConfigurationDialog();
            }
        });
        suffixRemoveButton.setText("Remove selected");
        this.suffixText = new Text(composite, 2048);
        this.suffixText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button suffixAddButton = new Button(composite, 0);
        suffixAddButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String text = NameResemblanceTab.this.suffixText.getText();
                if (text != null && !text.equals("")) {
                    NameResemblanceTab.this.suffixList.add(text);
                    NameResemblanceTab.this.setDirty(true);
                    NameResemblanceTab.this.updateLaunchConfigurationDialog();
                }
                NameResemblanceTab.this.suffixText.setText("");
            }
        });
        suffixAddButton.setText("Add suffix");
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return "NameResemblance";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String suffixString = configuration.getAttribute(NAME_RESEMBLANCE_CONFIGURATION_EXCLUDED_SUFFIXES, "");
            String prefixString = configuration.getAttribute(NAME_RESEMBLANCE_CONFIGURATION_EXCLUDED_PREFIXES, "");
            StringTokenizer tokenizer = new StringTokenizer(suffixString, "\u00a7");
            int tokenCount = tokenizer.countTokens();
            String[] suffixes = new String[tokenCount];
            int i = 0;
            while (i < tokenCount) {
                suffixes[i] = tokenizer.nextToken();
                ++i;
            }
            tokenizer = new StringTokenizer(prefixString, "\u00a7");
            tokenCount = tokenizer.countTokens();
            String[] prefixes = new String[tokenCount];
            int i2 = 0;
            while (i2 < tokenCount) {
                prefixes[i2] = tokenizer.nextToken();
                ++i2;
            }
            this.prefixList.setItems(prefixes);
            this.suffixList.setItems(suffixes);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public void launched(ILaunch launch) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String[] prefixes = this.prefixList.getItems();
        String[] suffixes = this.suffixList.getItems();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < prefixes.length) {
            buffer.append(prefixes[i]);
            buffer.append("\u00a7");
            ++i;
        }
        configuration.setAttribute(NAME_RESEMBLANCE_CONFIGURATION_EXCLUDED_PREFIXES, buffer.toString());
        buffer = new StringBuffer();
        i = 0;
        while (i < suffixes.length) {
            buffer.append(suffixes[i]);
            buffer.append("\u00a7");
            ++i;
        }
        configuration.setAttribute(NAME_RESEMBLANCE_CONFIGURATION_EXCLUDED_SUFFIXES, buffer.toString());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }
}

