/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper.metamodeladdition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.EnumDeclaration;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.PrimitiveType;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.kdmhelper.KDMHelper;

public class Root {
    private List<Model> models = new ArrayList<Model>();
    private static HashMap<ASTNode, String> nodeToIDMap = new HashMap();

    public List<Model> getModels() {
        return this.models;
    }

    public void addModels(Collection<Model> modelsFromResource) {
        this.models.addAll(modelsFromResource);
        this.addPackagesToIDMapping(modelsFromResource);
    }

    public static String getIdForPackage(ASTNode pack) {
        if (nodeToIDMap.containsKey(pack)) {
            return nodeToIDMap.get(pack);
        }
        return null;
    }

    private void addPackagesToIDMapping(Collection<Model> modelsFromResource) {
        for (Model model : modelsFromResource) {
            TreeIterator it = model.eAllContents();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (!(element instanceof Package) || nodeToIDMap.containsKey(element)) continue;
                nodeToIDMap.put((ASTNode)element, EcoreUtil.generateUUID());
            }
        }
    }

    public Collection<Package> getPackages() {
        ArrayList<Package> result = new ArrayList<Package>();
        for (Model model : this.models) {
            result.addAll((Collection<Package>)model.getOwnedElements());
        }
        return result;
    }

    public List<Type> getNormalClasses() {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Model model : this.models) {
            TreeIterator it = model.eAllContents();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (element instanceof ClassDeclaration) {
                    ClassDeclaration clazz = (ClassDeclaration)element;
                    if (KDMHelper.isInnerClass((Type)clazz)) continue;
                    result.add((Type)((ClassDeclaration)element));
                    continue;
                }
                if (element instanceof EnumDeclaration) {
                    result.add((Type)element);
                    continue;
                }
                if (!(element instanceof PrimitiveType)) continue;
                result.add((Type)element);
            }
        }
        return result;
    }
}

