/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.filter.BaseFilter;
import org.somox.kdmhelper.KDMHelper;

public class BlacklistFilter
extends BaseFilter<Type> {
    private static Logger logger = Logger.getLogger(BlacklistFilter.class);
    private Pattern matchPattern = null;

    public BlacklistFilter(Set<String> blacklist) {
        this.matchPattern = BlacklistFilter.deriveMatchPattern(blacklist);
    }

    @Override
    public boolean passes(Type object) {
        return !this.classMatchesBlacklist(object);
    }

    private static Pattern deriveMatchPattern(Set<String> blacklist) {
        StringBuffer sw = new StringBuffer();
        for (String s : blacklist) {
            sw.append(s);
            sw.append("|");
        }
        if (sw.length() > 0) {
            sw.deleteCharAt(sw.length() - 1);
        }
        Pattern matchPattern = Pattern.compile(sw.toString(), 2);
        logger.debug((Object)("Initialised Blacklist filter with pattern " + matchPattern.toString()));
        return matchPattern;
    }

    private boolean classMatchesBlacklist(Type currentClass) {
        boolean result = false;
        if (currentClass instanceof ASTNode) {
            result = this.matchPattern.matcher(KDMHelper.computeFullQualifiedName((ASTNode)currentClass)).matches();
            if (logger.isTraceEnabled() && result) {
                logger.trace((Object)("Blacklist filter matches " + KDMHelper.computeFullQualifiedName((ASTNode)currentClass)));
            }
        }
        return result;
    }
}

