/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.metricvalues;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import metricvalues.Component;
import metricvalues.ComponentCandidate;
import metricvalues.Iteration;
import metricvalues.MetricValue;
import metricvalues.MetricValuesModel;
import metricvalues.MetricvaluesFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.java.Type;
import org.jgrapht.DirectedGraph;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.somox.analyzer.simplemodelanalyzer.Activator;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.MetricID;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public class MetricValuesWriter {
    private static final String CONFIG_METRIC_VALUES_MODEL_PROPERTIES_FILE = "/config/MetricValuesModel.properties";
    private static final String CONFIG_METRIC_VALUES_MODEL_PATH = "metricvaluesmodel.path";
    private final SoMoXConfiguration somoxConfiguration;

    public MetricValuesWriter(SoMoXConfiguration somoxConfiguration) {
        this.somoxConfiguration = somoxConfiguration;
    }

    public void saveMetricValuesModel(DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> metricsGraph, int iteration, double currentThreshold, List<ComponentImplementingClassesLink> componentCandidates, boolean isMergeIteration) {
        URI resourceURI = this.getMetricValuesPlatformResourceURI();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI normalized = resourceSet.getURIConverter().normalize(resourceURI);
        Resource resource = null;
        MetricValuesModel model = null;
        if (iteration == 1) {
            resource = resourceSet.createResource(normalized);
            model = MetricvaluesFactory.eINSTANCE.createMetricValuesModel();
            this.setModelAttributes(model);
        } else {
            resource = resourceSet.getResource(normalized, true);
            model = (MetricValuesModel)resource.getContents().get(0);
        }
        Iteration currentIteration = this.createCurrentIteration(metricsGraph, iteration, currentThreshold, componentCandidates, isMergeIteration);
        model.getIterationsList().add((Object)currentIteration);
        if (iteration == 1) {
            resource.getContents().add((Object)model);
        }
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.somox.analyzer.simplemodelanalyzer", "Saved metric values of iteration " + iteration));
    }

    private void setModelAttributes(MetricValuesModel model) {
        model.setMinCompThreshold(this.somoxConfiguration.getClusteringConfig().getMinComposeClusteringThreshold());
        model.setMaxMergeThreshold(this.somoxConfiguration.getClusteringConfig().getMaxMergeClusteringThreshold());
        model.setWeightDirectoryMapping(this.somoxConfiguration.getWeightDirectoryMapping());
        model.setWeightDMS(this.somoxConfiguration.getWeightDMS());
        model.setWeightHighCoupling(this.somoxConfiguration.getWeightHighCoupling());
        model.setWeightHighNameResemblance(this.somoxConfiguration.getWeightHighNameResemblance());
        model.setWeightHighSLAQ(this.somoxConfiguration.getWeightHighSLAQ());
        model.setWeightHighestNameResemblance(this.somoxConfiguration.getWeightHighestNameResemblance());
        model.setWeightInterfaceViolationIrrelevant(this.somoxConfiguration.getWeightInterfaceViolationIrrelevant());
        model.setWeightInterfaceViolationRelevant(this.somoxConfiguration.getWeightInterfaceViolationRelevant());
        model.setWeightLowCoupling(this.somoxConfiguration.getWeightLowCoupling());
        model.setWeightLowNameResemblance(this.somoxConfiguration.getWeightLowNameResemblance());
        model.setWeightLowSLAQ(this.somoxConfiguration.getWeightLowSLAQ());
        model.setWeightMidNameResemblance(this.somoxConfiguration.getWeightMidNameResemblance());
        model.setWeightPackageMapping(this.somoxConfiguration.getWeightPackageMapping());
        model.setWildcardKey(this.getBlacklistString(this.somoxConfiguration.getBlacklist()));
        model.setMinMergeThreshold(this.somoxConfiguration.getClusteringConfig().getMinMergeClusteringThreshold());
        model.setMaxComposeThreshold(this.somoxConfiguration.getClusteringConfig().getMaxComposeClusteringThreshold());
        model.setComposeThresholdDecrement(this.somoxConfiguration.getClusteringConfig().getClusteringComposeThresholdDecrement());
        model.setMergeThresholdDecrement(this.somoxConfiguration.getClusteringConfig().getClusteringMergeThresholdDecrement());
        model.setExcludedPrefixesForNameResemblance(this.somoxConfiguration.getExcludedPrefixesForNameResemblance());
        model.setExcludedSuffixesForNameResemblance(this.somoxConfiguration.getExcludedSuffixesForNameResemblance());
    }

    private String getBlacklistString(Set<String> blacklist) {
        StringBuilder blacklistString = new StringBuilder();
        for (String string : blacklist) {
            blacklistString.append(String.valueOf(string) + "\u00a7");
        }
        return blacklistString.toString();
    }

    private Iteration createCurrentIteration(DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> metricsGraph, int iteration, double currentThreshold, List<ComponentImplementingClassesLink> componentCandidates, boolean isMergeIteration) {
        Iteration currentIteration = MetricvaluesFactory.eINSTANCE.createIteration();
        currentIteration.setNumber(iteration);
        currentIteration.setCurCompThreshold(currentThreshold);
        currentIteration.setCurMergeThreshold(currentThreshold);
        currentIteration.setIsMergeIteration(isMergeIteration);
        this.createComponents(componentCandidates, currentIteration);
        this.createComponentCandidates(metricsGraph, currentIteration);
        return currentIteration;
    }

    private void createComponentCandidates(DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> metricsGraph, Iteration currentIteration) {
        Set edges = metricsGraph.edgeSet();
        for (ClusteringRelation clusteringRelation : edges) {
            ComponentCandidate compCandidate = MetricvaluesFactory.eINSTANCE.createComponentCandidate();
            RepositoryComponent compA = clusteringRelation.getSourceComponent().getComponent();
            RepositoryComponent compB = clusteringRelation.getTargetComponent().getComponent();
            Component[] componentArray = currentIteration.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component.getId().equals(compA.getId())) {
                    compCandidate.setFirstComponent(component);
                } else if (component.getId().equals(compB.getId())) {
                    compCandidate.setSecondComponent(component);
                }
                ++n2;
            }
            this.createMetricValue(clusteringRelation, compCandidate);
            currentIteration.getComponentCandidatesList().add((Object)compCandidate);
        }
    }

    private void createMetricValue(ClusteringRelation clusteringRelation, ComponentCandidate compCandidate) {
        Set clusteringMetrics = clusteringRelation.getResult().entrySet();
        for (Map.Entry entry : clusteringMetrics) {
            MetricValue metricValue = MetricvaluesFactory.eINSTANCE.createMetricValue();
            metricValue.setMetricID(((MetricID)entry.getKey()).getMetricID());
            metricValue.setValue(((Double)entry.getValue()).doubleValue());
            compCandidate.getMetricValuesList().add((Object)metricValue);
        }
    }

    private void createComponents(List<ComponentImplementingClassesLink> components, Iteration currentIteration) {
        for (ComponentImplementingClassesLink compLink : components) {
            Component component = this.createComponent(currentIteration, compLink);
            currentIteration.getComponentsList().add((Object)component);
        }
    }

    private Component createComponent(Iteration currentIteration, ComponentImplementingClassesLink compCand) {
        Component component = MetricvaluesFactory.eINSTANCE.createComponent();
        RepositoryComponent comp = compCand.getComponent();
        component.setId(comp.getId());
        component.setName(comp.getEntityName());
        EList classes = compCand.getImplementingClasses();
        for (Type gastClass : classes) {
            component.getClassesList().add((Object)gastClass);
        }
        EList subComponents = compCand.getSubComponents();
        for (ComponentImplementingClassesLink componentImplementingClassesLink : subComponents) {
            Component subComponent = this.createComponent(currentIteration, componentImplementingClassesLink);
            component.getSubComponentsList().add((Object)subComponent);
        }
        return component;
    }

    private URI getMetricValuesPlatformResourceURI() {
        Properties properties = new Properties();
        try {
            InputStream inStream = Activator.getDefault().getBundle().getEntry(CONFIG_METRIC_VALUES_MODEL_PROPERTIES_FILE).openStream();
            properties.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URI fileURI = URI.createPlatformResourceURI((String)new File(String.valueOf(this.somoxConfiguration.getFileLocations().getProjectName()) + "/" + this.somoxConfiguration.getFileLocations().getOutputFolder() + "/" + properties.getProperty(CONFIG_METRIC_VALUES_MODEL_PATH)).getPath(), (boolean)true);
        return fileURI;
    }
}

