/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;

public class PairwiseRelationComputationTask
implements Callable<ClusteringRelation[]> {
    private static final Logger logger = Logger.getLogger(PairwiseRelationComputationTask.class);
    private final IMetric overallMetric;
    private final ClusteringRelation firstRelation;
    private final ClusteringRelation secondRelation;
    private final Map<MetricID, IMetric> allMetrics;

    public PairwiseRelationComputationTask(IMetric overallMetric, ClusteringRelation firstRelation, ClusteringRelation secondRelation, Map<MetricID, IMetric> allMetrics) {
        this.overallMetric = overallMetric;
        this.firstRelation = firstRelation;
        this.secondRelation = secondRelation;
        this.allMetrics = allMetrics;
    }

    @Override
    public ClusteringRelation[] call() throws Exception {
        ClusteringRelation[] result = new ClusteringRelation[]{this.computeClusteringRelation(this.firstRelation, null), this.computeClusteringRelation(this.secondRelation, this.firstRelation)};
        return result;
    }

    private ClusteringRelation computeClusteringRelation(ClusteringRelation relationToCompute, ClusteringRelation oppositeRelation) throws ModelAnalyzerException {
        if (oppositeRelation != null) {
            for (Map.Entry entry : oppositeRelation.getResult().entrySet()) {
                if (!this.allMetrics.get(entry.getKey()).isCommutative()) continue;
                relationToCompute.setResultMetric((MetricID)entry.getKey(), ((Double)entry.getValue()).doubleValue());
            }
        }
        this.overallMetric.computeDirected(relationToCompute);
        return relationToCompute;
    }
}

