/**
 */
package org.somox.sourcecodedecorator.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.somox.sourcecodedecorator.util.SourceCodeDecoratorAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class SourceCodeDecoratorItemProviderAdapterFactory extends SourceCodeDecoratorAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static final String copyright = "Copyright by palladiosimulator.org, 2008-2016";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public SourceCodeDecoratorItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.FileLevelSourceCodeLink} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FileLevelSourceCodeLinkItemProvider fileLevelSourceCodeLinkItemProvider;

    /**
     * This creates an adapter for a {@link org.somox.sourcecodedecorator.FileLevelSourceCodeLink}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFileLevelSourceCodeLinkAdapter() {
        if (this.fileLevelSourceCodeLinkItemProvider == null) {
            this.fileLevelSourceCodeLinkItemProvider = new FileLevelSourceCodeLinkItemProvider(this);
        }

        return this.fileLevelSourceCodeLinkItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.MethodLevelSourceCodeLink} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MethodLevelSourceCodeLinkItemProvider methodLevelSourceCodeLinkItemProvider;

    /**
     * This creates an adapter for a {@link org.somox.sourcecodedecorator.MethodLevelSourceCodeLink}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMethodLevelSourceCodeLinkAdapter() {
        if (this.methodLevelSourceCodeLinkItemProvider == null) {
            this.methodLevelSourceCodeLinkItemProvider = new MethodLevelSourceCodeLinkItemProvider(this);
        }

        return this.methodLevelSourceCodeLinkItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.SourceCodeDecoratorRepository} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SourceCodeDecoratorRepositoryItemProvider sourceCodeDecoratorRepositoryItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.somox.sourcecodedecorator.SourceCodeDecoratorRepository}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSourceCodeDecoratorRepositoryAdapter() {
        if (this.sourceCodeDecoratorRepositoryItemProvider == null) {
            this.sourceCodeDecoratorRepositoryItemProvider = new SourceCodeDecoratorRepositoryItemProvider(this);
        }

        return this.sourceCodeDecoratorRepositoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.InterfaceSourceCodeLink} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InterfaceSourceCodeLinkItemProvider interfaceSourceCodeLinkItemProvider;

    /**
     * This creates an adapter for a {@link org.somox.sourcecodedecorator.InterfaceSourceCodeLink}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInterfaceSourceCodeLinkAdapter() {
        if (this.interfaceSourceCodeLinkItemProvider == null) {
            this.interfaceSourceCodeLinkItemProvider = new InterfaceSourceCodeLinkItemProvider(this);
        }

        return this.interfaceSourceCodeLinkItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.ComponentImplementingClassesLink} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComponentImplementingClassesLinkItemProvider componentImplementingClassesLinkItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.somox.sourcecodedecorator.ComponentImplementingClassesLink}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComponentImplementingClassesLinkAdapter() {
        if (this.componentImplementingClassesLinkItemProvider == null) {
            this.componentImplementingClassesLinkItemProvider = new ComponentImplementingClassesLinkItemProvider(this);
        }

        return this.componentImplementingClassesLinkItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.PCMSystemImplementatingClassesLink} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMSystemImplementatingClassesLinkItemProvider pcmSystemImplementatingClassesLinkItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.somox.sourcecodedecorator.PCMSystemImplementatingClassesLink}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMSystemImplementatingClassesLinkAdapter() {
        if (this.pcmSystemImplementatingClassesLinkItemProvider == null) {
            this.pcmSystemImplementatingClassesLinkItemProvider = new PCMSystemImplementatingClassesLinkItemProvider(
                    this);
        }

        return this.pcmSystemImplementatingClassesLinkItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.somox.sourcecodedecorator.Seff2MethodLink} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected Seff2MethodLinkItemProvider seff2MethodLinkItemProvider;

    /**
     * This creates an adapter for a {@link org.somox.sourcecodedecorator.Seff2MethodLink}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSeff2MethodLinkAdapter() {
        if (this.seff2MethodLinkItemProvider == null) {
            this.seff2MethodLinkItemProvider = new Seff2MethodLinkItemProvider(this);
        }

        return this.seff2MethodLinkItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.fileLevelSourceCodeLinkItemProvider != null) {
            this.fileLevelSourceCodeLinkItemProvider.dispose();
        }
        if (this.methodLevelSourceCodeLinkItemProvider != null) {
            this.methodLevelSourceCodeLinkItemProvider.dispose();
        }
        if (this.sourceCodeDecoratorRepositoryItemProvider != null) {
            this.sourceCodeDecoratorRepositoryItemProvider.dispose();
        }
        if (this.interfaceSourceCodeLinkItemProvider != null) {
            this.interfaceSourceCodeLinkItemProvider.dispose();
        }
        if (this.componentImplementingClassesLinkItemProvider != null) {
            this.componentImplementingClassesLinkItemProvider.dispose();
        }
        if (this.pcmSystemImplementatingClassesLinkItemProvider != null) {
            this.pcmSystemImplementatingClassesLinkItemProvider.dispose();
        }
        if (this.seff2MethodLinkItemProvider != null) {
            this.seff2MethodLinkItemProvider.dispose();
        }
    }

}
