/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Type;
import org.jgrapht.Graph;
import org.somox.kdmhelper.KDMHelper;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public class GraphPrinter {
    public static final int ORIGINAL_GRAPH = -1;
    public static final int PROJECTED_GRAPH = 0;
    public static final String graphFolderSegment = "/dotClusterTrace";
    private static Logger logger = Logger.getLogger(GraphPrinter.class);

    public static void cleanOutputFolder(String outputFolder) {
        File baseDirectory;
        String fileURIString;
        if (logger.isTraceEnabled() && (fileURIString = GraphPrinter.getFileURI(outputFolder)) != null && (baseDirectory = new File(String.valueOf(fileURIString) + graphFolderSegment)).exists()) {
            File[] fileArray = baseDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            baseDirectory.delete();
        }
    }

    public static <V, T> void dumpGraph(ComponentToImplementingClassesHelper componentToClassesHelper, Graph<V, T> relationshipGraph, String outputFolder, int iteration, int subgraphNo) {
        String fileURIString = GraphPrinter.getFileURI(outputFolder);
        if (fileURIString != null) {
            File baseDirectory = new File(String.valueOf(fileURIString) + graphFolderSegment);
            if (!baseDirectory.exists()) {
                baseDirectory.mkdir();
            }
            String filename = String.valueOf(baseDirectory.getAbsolutePath()) + "/graph_iteration" + iteration;
            filename = subgraphNo > 0 ? String.valueOf(filename) + ".component" + subgraphNo : (subgraphNo == 0 ? String.valueOf(filename) + ".projected" : String.valueOf(filename) + ".full");
            GraphPrinter.dumpGraphToDot(componentToClassesHelper, relationshipGraph, String.valueOf(filename) + ".dot");
            GraphPrinter.dumpGraphToGML(componentToClassesHelper, relationshipGraph, String.valueOf(filename) + ".gml");
        }
    }

    private static String getFileURI(String outputFolder) {
        if (outputFolder == null) {
            logger.warn((Object)"Failed to export graph, filename not set!");
        } else {
            IResource fileURI = ResourcesPlugin.getWorkspace().getRoot().findMember(outputFolder);
            if (fileURI == null) {
                logger.warn((Object)"Failed to dump graph!");
            } else {
                IContainer parent = fileURI.getParent();
                if (parent != null) {
                    IPath rawLocation = parent.getLocation();
                    if (rawLocation != null) {
                        return rawLocation.toOSString();
                    }
                    logger.warn((Object)("Did not get raw location of " + parent.toString()));
                } else {
                    logger.warn((Object)("Did not find parent of " + fileURI.toString()));
                }
            }
        }
        return null;
    }

    private static <V, T> void dumpGraphToDot(ComponentToImplementingClassesHelper componentToClassesHelper, Graph<V, T> relationshipGraph, String filename) {
        try {
            File f = new File(filename);
            FileWriter fw = new FileWriter(f);
            fw.write("digraph G {\n");
            for (Object link : relationshipGraph.vertexSet()) {
                fw.write(String.valueOf(GraphPrinter.getNodeId(componentToClassesHelper, link, false)) + ";\n");
            }
            for (Object edge : relationshipGraph.edgeSet()) {
                fw.write(GraphPrinter.getNodeId(componentToClassesHelper, relationshipGraph.getEdgeSource(edge), false));
                fw.write(" -> ");
                fw.write(GraphPrinter.getNodeId(componentToClassesHelper, relationshipGraph.getEdgeTarget(edge), false));
                fw.write(" [label=\"" + edge.toString().replaceAll("\n", Matcher.quoteReplacement("\\n")) + "\"];\n");
            }
            fw.write("}\n");
            fw.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Producing DOT trace failed", (Throwable)e);
        }
    }

    private static <V, T> void dumpGraphToGML(ComponentToImplementingClassesHelper componentToClassesHelper, Graph<V, T> relationshipGraph, String filename) {
        try {
            File f = new File(filename);
            FileWriter fw = new FileWriter(f);
            fw.write("graph [\ndirected 1\n");
            for (Object link : relationshipGraph.vertexSet()) {
                fw.write("node [\nname " + GraphPrinter.getNodeId(componentToClassesHelper, link, true) + "\nlabel " + GraphPrinter.getNodeId(componentToClassesHelper, link, true) + "\n" + "graphics\n[hasFill 0\n]\n]\n");
            }
            for (Object edge : relationshipGraph.edgeSet()) {
                fw.write("edge [\nsource " + GraphPrinter.getNodeId(componentToClassesHelper, relationshipGraph.getEdgeSource(edge), true) + "\n");
                fw.write("target " + GraphPrinter.getNodeId(componentToClassesHelper, relationshipGraph.getEdgeTarget(edge), true) + "\n");
                fw.write("label \"" + edge.toString() + "\"\n" + "graphics\n[\ntargetArrow \"standard\"\n]\n]\n");
            }
            fw.write("]\n");
            fw.close();
        }
        catch (IOException e) {
            logger.warn((Object)"Producing GML trace failed", (Throwable)e);
        }
    }

    private static String getNodeId(ComponentToImplementingClassesHelper componentToClassesHelper, Object component, boolean useRealBreak) {
        if (component instanceof Type) {
            return "\"" + KDMHelper.computeFullQualifiedName((ASTNode)((Type)component)) + "\"";
        }
        if (component instanceof ComponentImplementingClassesLink) {
            return GraphPrinter.getNodeId(componentToClassesHelper, (ComponentImplementingClassesLink)component, useRealBreak);
        }
        return component.toString();
    }

    private static String getNodeId(ComponentToImplementingClassesHelper componentToClassesHelper, ComponentImplementingClassesLink component, boolean useRealBreak) {
        Set<Type> classes = componentToClassesHelper.deriveImplementingClasses(component);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        for (Type clazz : classes) {
            stringBuilder.append(KDMHelper.computeFullQualifiedName((ASTNode)clazz));
            stringBuilder.append(useRealBreak ? "\n" : "\\n");
        }
        if (!useRealBreak) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }
}

