/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.structure;

import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.kdmhelper.KDMHelper;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractMetric;

public class SliceLayerArchitectureQuality
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.SliceLayerArchitectureQuality");

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<Type> classes2;
        Set<Type> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Package prefixPackage = this.computePrefix(classes1, classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent()));
        if (prefixPackage == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        EList slices = prefixPackage.getOwnedPackages();
        EList layers = null;
        int max = 0;
        for (Package current : slices) {
            if (current.getOwnedPackages().size() < max) continue;
            layers = current.getOwnedPackages();
            max = layers.size();
        }
        if (max == 0) {
            relationToCompute.setResultMetric(this.getMID(), 1.0);
            return;
        }
        int expectedSubsystems = slices.size() * layers.size();
        int existingSubsystems = 0;
        for (Package currentSlice : slices) {
            EList currentLayers = currentSlice.getOwnedPackages();
            block2: for (Package currentReferencePackage : layers) {
                for (Package currentLayer : currentLayers) {
                    if (!currentLayer.getName().equals(currentReferencePackage.getName())) continue;
                    ++existingSubsystems;
                    continue block2;
                }
            }
        }
        if (expectedSubsystems == 0) {
            relationToCompute.setResultMetric(this.getMID(), 1.0);
        } else {
            relationToCompute.setResultMetric(this.getMID(), (double)existingSubsystems / (double)expectedSubsystems);
        }
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Package computePrefix(Set<Type> elements1, Set<Type> elements2) {
        String prefix = "";
        boolean prefixFound = false;
        Package currentPackage = null;
        for (Type current : elements1) {
            if (KDMHelper.getSurroundingPackage((Type)current) == null) continue;
            currentPackage = KDMHelper.getSurroundingPackage((Type)current);
            break;
        }
        if (currentPackage == null) {
            for (Type current : elements2) {
                if (KDMHelper.getSurroundingPackage((Type)current) == null) continue;
                currentPackage = KDMHelper.getSurroundingPackage((Type)current);
                break;
            }
        }
        if (currentPackage == null) {
            return null;
        }
        prefix = KDMHelper.computeFullQualifiedName(currentPackage);
        while (!prefixFound) {
            prefixFound = true;
            for (Type current : elements1) {
                if (KDMHelper.isInnerClass((Type)current) || KDMHelper.getSurroundingPackage((Type)current) == null || KDMHelper.computeFullQualifiedName((ASTNode)KDMHelper.getSurroundingPackage((Type)current)).contains(prefix)) continue;
                prefixFound = false;
                break;
            }
            if (prefixFound) continue;
            if ((currentPackage = currentPackage.getPackage()) == null) {
                return null;
            }
            prefix = KDMHelper.computeFullQualifiedName((ASTNode)currentPackage);
        }
        prefixFound = false;
        while (!prefixFound) {
            prefixFound = true;
            for (Type current : elements2) {
                if (KDMHelper.isInnerClass((Type)current) || KDMHelper.getSurroundingPackage((Type)current) == null || KDMHelper.computeFullQualifiedName((ASTNode)KDMHelper.getSurroundingPackage((Type)current)).contains(prefix)) continue;
                prefixFound = false;
                break;
            }
            if (prefixFound) continue;
            if ((currentPackage = currentPackage.getPackage()) == null) {
                return null;
            }
            prefix = KDMHelper.computeFullQualifiedName((ASTNode)currentPackage);
        }
        return currentPackage;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

