/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.helper;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.AccessedTargetBlacklistFilter;
import org.somox.filter.BaseFilter;
import org.somox.filter.EClassBasedFilter;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.util.GraphPrinter;

public class Class2ClassAccessGraphHelper {
    private static final Logger logger = Logger.getLogger(Class2ClassAccessGraphHelper.class);
    private static final BaseFilter<Type> primitiveTypeFilter = new BaseFilter<Type>(){

        public boolean passes(Type object) {
            return !KDMHelper.isPrimitive((Type)object);
        }
    };
    private static final EdgeFactory<Type, ClassAccessGraphEdge> edgeFactory = new EdgeFactory<Type, ClassAccessGraphEdge>(){

        public ClassAccessGraphEdge createEdge(Type source, Type target) {
            return new ClassAccessGraphEdge(source, target);
        }
    };
    private static final EClassBasedFilter<ASTNode> accessFilter = new EClassBasedFilter<ASTNode>(new EClass[0]){

        public boolean passes(EObject object) {
            return object == null || !(object instanceof TypeAccess) || !KDMHelper.isInheritanceTypeAccess((TypeAccess)((TypeAccess)object));
        }
    };

    public static DirectedGraph<Type, ClassAccessGraphEdge> computeFilteredClass2ClassAccessGraph(SoMoXConfiguration somoxConfiguration, Set<Type> componentsImplementingClasses) {
        SimpleDirectedGraph accessGraph = new SimpleDirectedGraph(edgeFactory);
        for (Type clazz : primitiveTypeFilter.filter(componentsImplementingClasses)) {
            accessGraph.addVertex((Object)clazz);
        }
        assert (Class2ClassAccessGraphHelper.noPrimitiveTypesAsVertexes((DirectedGraph<Type, ClassAccessGraphEdge>)accessGraph));
        AccessedTargetBlacklistFilter filter = new AccessedTargetBlacklistFilter(somoxConfiguration.getBlacklistFilter());
        for (Type clazz : componentsImplementingClasses) {
            Class2ClassAccessGraphHelper.addAccessesToGraph((Graph<Type, ClassAccessGraphEdge>)accessGraph, filter, clazz);
        }
        assert (Class2ClassAccessGraphHelper.noPrimitiveTypesAsVertexes((DirectedGraph<Type, ClassAccessGraphEdge>)accessGraph));
        if (logger.isDebugEnabled()) {
            GraphPrinter.dumpGraph(new ComponentToImplementingClassesHelper(), accessGraph, somoxConfiguration.getFileLocations().getAnalyserInputFile(), 0, 0);
        }
        return accessGraph;
    }

    private static boolean noPrimitiveTypesAsVertexes(DirectedGraph<Type, ClassAccessGraphEdge> accessGraph) {
        boolean result = true;
        for (Type clazz : accessGraph.vertexSet()) {
            result &= !KDMHelper.isPrimitive((Type)clazz);
        }
        return result;
    }

    private static void addAccessesToGraph(Graph<Type, ClassAccessGraphEdge> graph, AccessedTargetBlacklistFilter filter, Type clazz) {
        for (ASTNode singleAccess : accessFilter.filter(filter.filter((Iterable)KDMHelper.getAllAccesses((ASTNode)clazz)))) {
            Type accessedClass = GetAccessedType.getAccessedType((ASTNode)singleAccess);
            if (clazz == accessedClass) continue;
            ClassAccessGraphEdge edge = (ClassAccessGraphEdge)graph.getEdge((Object)clazz, (Object)accessedClass);
            if (edge == null) {
                if (graph.containsVertex((Object)clazz) && graph.containsVertex((Object)accessedClass)) {
                    edge = (ClassAccessGraphEdge)graph.addEdge((Object)clazz, (Object)accessedClass);
                } else {
                    logger.trace((Object)("Do not add edge between " + clazz + " and " + accessedClass));
                }
            }
            if (edge == null) continue;
            edge.incrementCount();
        }
    }
}

