/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.abstractmetrics;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.Type;
import org.jgrapht.DirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.parameter.ParameterDescriptor;
import org.somox.metrics.tabs.MetricTab;
import org.somox.metrics.util.AccessCacheGraph;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public abstract class AbstractMetric
implements IMetric {
    private final Logger logger = Logger.getLogger(AbstractMetric.class);
    private ComponentToImplementingClassesHelper componentToClassHelper;
    private AccessCacheGraph accessGraphCache;

    @Override
    public void computeDirected(ClusteringRelation relationToCompute) {
        assert (this.checkMetricPreCondition(relationToCompute));
        this.internalComputeDirected(relationToCompute);
        assert (this.checkMetricPostCondition(relationToCompute));
    }

    @Override
    public MetricTab getLaunchConfigurationTab() {
        return null;
    }

    @Override
    public ParameterDescriptor[] getMetricParameters() {
        return new ParameterDescriptor[0];
    }

    @Override
    public abstract boolean isCommutative();

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DirectedGraph<Type, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToClassHelper) {
        if (accessGraph == null) {
            this.logger.error((Object)"No access cache graph passed");
            throw new IllegalArgumentException("Access graph must not be null");
        }
        this.accessGraphCache = new AccessCacheGraph(accessGraph);
        this.componentToClassHelper = componentToClassHelper;
    }

    protected abstract void internalComputeDirected(ClusteringRelation var1);

    protected boolean checkMetricPostCondition(ClusteringRelation relationToCompute) {
        return relationToCompute.getResult().containsKey(this.getMID());
    }

    protected boolean checkMetricPreCondition(ClusteringRelation relationToCompute) {
        return !relationToCompute.getResult().containsKey(this.getMID());
    }

    protected AccessCacheGraph getAccessGraphCache() {
        return this.accessGraphCache;
    }

    protected IMetric getMetric(Map<MetricID, IMetric> allMetrics, MetricID metricId) {
        IMetric result = allMetrics.get(metricId);
        if (result == null) {
            throw new RuntimeException("Configuration error, Metric " + metricId + " needed but not available");
        }
        return result;
    }

    protected Set<Type> calculateUnion(Set<Type> classes1, Set<Type> classes2) {
        HashSet<Type> allInnerClasses = new HashSet<Type>(classes1);
        allInnerClasses.addAll(classes2);
        return allInnerClasses;
    }

    protected Set<Type> calculateUnion(ComponentImplementingClassesLink component1, ComponentImplementingClassesLink component2) {
        return this.calculateUnion(this.getComponentToClassHelper().deriveImplementingClasses(component1), this.getComponentToClassHelper().deriveImplementingClasses(component2));
    }

    protected ComponentToImplementingClassesHelper getComponentToClassHelper() {
        return this.componentToClassHelper;
    }
}

