/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.somox.gast2seff.visitors.AbstractFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;

public class BasicFunctionClassificationStrategy
extends AbstractFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    private static Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);
    private SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private BasicComponent primitiveComponent;

    public BasicFunctionClassificationStrategy(SourceCodeDecoratorRepository sourceCodeDecoratorRepository, BasicComponent primitiveComponent) {
        this.sourceCodeDecoratorRepository = sourceCodeDecoratorRepository;
        this.primitiveComponent = primitiveComponent;
    }

    @Override
    protected boolean isExternalCall(AbstractMethodInvocation functionAccess) {
        ComponentImplementingClassesLink compLink = this.queryComponentLink(this.primitiveComponent);
        for (InterfaceSourceCodeLink ifLink : compLink.getRequiredInterfaces()) {
            if (!KDMHelper.getMethods((Type)ifLink.getGastClass()).contains(functionAccess.getMethod())) continue;
            logger.debug((Object)("Classified call as external call: " + functionAccess.getMethod().getName() + " for component " + this.primitiveComponent.getEntityName()));
            return true;
        }
        logger.trace((Object)("no external call: " + functionAccess.getMethod().getName()));
        return false;
    }

    private ComponentImplementingClassesLink queryComponentLink(BasicComponent primitiveComponent) {
        for (ComponentImplementingClassesLink compLink : this.sourceCodeDecoratorRepository.getComponentImplementingClassesLink()) {
            if (!compLink.getComponent().equals(primitiveComponent)) continue;
            return compLink;
        }
        String msg = "Could not find a component implementing classes link in the source code decorator for component " + primitiveComponent.getEntityName();
        logger.error((Object)msg);
        throw new RuntimeException(msg);
    }

    @Override
    protected boolean isLibraryCall(AbstractMethodInvocation functionAccess) {
        Type targetClass = GetAccessedType.getAccessedType((ASTNode)functionAccess);
        if (targetClass == null) {
            logger.warn((Object)"Failed to classifiy library call because called GASTClass was unavailable.");
            return true;
        }
        logger.debug((Object)("Classified call as library call: " + functionAccess.getMethod().getName() + " for component " + this.primitiveComponent.getEntityName()));
        return KDMHelper.getJavaNodeSourceRegion((ASTNode)targetClass) == null || KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)targetClass)) == null;
    }
}

