/*
 * Decompiled with CFR 0.152.
 */
package org.somox.ui.runconfig.tabs;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.somox.common.SoMoXProjectPreferences;
import org.somox.configuration.ConfigurationDefinition;
import org.somox.ui.Activator;
import org.somox.ui.SoMoXUILogger;
import org.somox.ui.runconfig.tabs.WorkspaceButtonSelectionListener;

public class ModelExtractionInputTab
extends AbstractLaunchConfigurationTab {
    Text projectName = null;
    private HashMap<String, Text> stringAttributes = new HashMap();
    private HashMap<String, Button> booleanAttributes = new HashMap();

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (Map.Entry<String, Text> tmpEntry : this.stringAttributes.entrySet()) {
            SoMoXUILogger.logInfo("Extraction Setting: " + tmpEntry.getKey());
            configuration.setAttribute(tmpEntry.getKey(), tmpEntry.getValue().getText());
        }
        for (Map.Entry<String, Button> tmpEntry : this.booleanAttributes.entrySet()) {
            SoMoXUILogger.logInfo("Extraction Setting: " + tmpEntry.getKey());
            configuration.setAttribute(tmpEntry.getKey(), tmpEntry.getValue().getSelection());
        }
    }

    private HashMap<String, ConfigurationDefinition> getConfigurationDefinitions() {
        HashMap<String, ConfigurationDefinition> configurationDefinitions = null;
        if (configurationDefinitions == null) {
            configurationDefinitions = new HashMap<String, ConfigurationDefinition>();
            LinkedList<ConfigurationDefinition> configs = Activator.getDefault().getGuiSoMoXCoreController().getConfigurationDefinitions();
            for (ConfigurationDefinition config : configs) {
                configurationDefinitions.put(config.getId(), config);
            }
        }
        return configurationDefinitions;
    }

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelExtractionInputTab.this.setDirty(true);
                ModelExtractionInputTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group projectDirectoryTypeGroup = new Group(container, 0);
        GridLayout glProjectDirectoryTypeGroup = new GridLayout();
        glProjectDirectoryTypeGroup.numColumns = 2;
        projectDirectoryTypeGroup.setLayout((Layout)glProjectDirectoryTypeGroup);
        projectDirectoryTypeGroup.setText("Project:");
        projectDirectoryTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.projectName = new Text((Composite)projectDirectoryTypeGroup, 2052);
        GridData gd_projectDirectory = new GridData(4, 0x1000000, true, false);
        gd_projectDirectory.widthHint = 200;
        this.projectName.setLayoutData((Object)gd_projectDirectory);
        this.projectName.addModifyListener(modifyListener);
        Button projectworkspaceButton = new Button((Composite)projectDirectoryTypeGroup, 0);
        projectworkspaceButton.setText("Workspace...");
        projectworkspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(this.projectName, true, true, true));
        this.stringAttributes.put(SoMoXProjectPreferences.SOMOX_PROJECT_NAME, this.projectName);
        LinkedList<ConfigurationDefinition> configs = Activator.getDefault().getGuiSoMoXCoreController().getConfigurationDefinitions();
        SoMoXUILogger.logInfo("Number of configs to be build: " + configs.size());
        Set<String> configurationDefinitionKeys = this.getConfigurationDefinitions().keySet();
        Iterator<String> configIterator = configurationDefinitionKeys.iterator();
        Group typeGroup = new Group(container, 0);
        GridLayout glTypeGroup = new GridLayout();
        glTypeGroup.numColumns = 4;
        typeGroup.setLayout((Layout)glTypeGroup);
        typeGroup.setText("SISSy configuration");
        typeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        while (configIterator.hasNext()) {
            String key = configIterator.next();
            ConfigurationDefinition config = this.getConfigurationDefinitions().get(key);
            if (ConfigurationDefinition.Type.DIRECTORY.equals((Object)config.getType())) {
                final Text textDirectory = new Text((Composite)typeGroup, 2052);
                GridData gd_textResourceTypeRepository = new GridData(4, 0x1000000, true, false);
                gd_textResourceTypeRepository.horizontalSpan = 2;
                textDirectory.setLayoutData((Object)gd_textResourceTypeRepository);
                textDirectory.addModifyListener(modifyListener);
                Button workspaceButton = new Button((Composite)typeGroup, 0);
                workspaceButton.setText("Workspace...");
                workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(textDirectory, true, false, false));
                Button buttonResourceTypeRepository = new Button((Composite)typeGroup, 0);
                buttonResourceTypeRepository.setLayoutData((Object)new GridData());
                buttonResourceTypeRepository.setText("File System...");
                buttonResourceTypeRepository.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String resultOpenFileDialog = "";
                        DirectoryDialog dialog = new DirectoryDialog(ModelExtractionInputTab.this.getShell(), 4096);
                        dialog.setText("Select a folder.");
                        if (dialog.open() != null) {
                            resultOpenFileDialog = dialog.getFilterPath();
                        }
                        if (!resultOpenFileDialog.equals(new String(""))) {
                            textDirectory.setText(resultOpenFileDialog);
                        }
                    }
                });
                textDirectory.setText(config.getDefaultValue());
                this.stringAttributes.put(config.getId(), textDirectory);
                continue;
            }
            if (ConfigurationDefinition.Type.STRING.equals((Object)config.getType())) {
                Label stringLabel = new Label((Composite)typeGroup, 0);
                stringLabel.setText(config.getName());
                Text stringField = new Text((Composite)typeGroup, 2048);
                GridData gd_stringTypeGroup = new GridData(4, 0x1000000, true, false);
                gd_stringTypeGroup.horizontalSpan = 3;
                stringField.setLayoutData((Object)gd_stringTypeGroup);
                stringField.addModifyListener(modifyListener);
                stringField.setText(config.getDefaultValue());
                this.stringAttributes.put(config.getId(), stringField);
                continue;
            }
            if (!ConfigurationDefinition.Type.BOOLEAN.equals((Object)config.getType())) continue;
            Button booleanButton = new Button((Composite)typeGroup, 32);
            booleanButton.setText(config.getName());
            GridData gd_booleanTypeGroup = new GridData(0, 0x1000000, true, false);
            booleanButton.setLayoutData((Object)gd_booleanTypeGroup);
            booleanButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ModelExtractionInputTab.this.setDirty(true);
                    ModelExtractionInputTab.this.updateLaunchConfigurationDialog();
                }

                public void widgetSelected(SelectionEvent e) {
                    ModelExtractionInputTab.this.setDirty(true);
                    ModelExtractionInputTab.this.updateLaunchConfigurationDialog();
                }
            });
            gd_booleanTypeGroup.horizontalSpan = 4;
            if (config.getDefaultValue() != null && config.getDefaultValue().equals("true")) {
                booleanButton.setEnabled(true);
            }
            this.booleanAttributes.put(config.getId(), booleanButton);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            Map attributes = configuration.getAttributes();
            Set keys = attributes.keySet();
            for (String key : keys) {
                if (this.stringAttributes.containsKey(key)) {
                    this.stringAttributes.get(key).setText(attributes.get(key).toString());
                    continue;
                }
                if (!this.booleanAttributes.containsKey(key) || !attributes.get(key).toString().toLowerCase().equals("true")) continue;
                this.booleanAttributes.get(key).setSelection(true);
            }
        }
        catch (CoreException e) {
            SoMoXUILogger.logError(this.getName(), e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.projectName.getText().equals("")) {
            this.setErrorMessage("Project not specified");
            return false;
        }
        File projectDir = new File(String.valueOf(Platform.getInstanceLocation().getURL().getFile()) + this.projectName.getText());
        if (!projectDir.exists()) {
            this.setErrorMessage("Project " + this.projectName.getText() + " does not exist");
            return false;
        }
        Set<String> keys = this.getConfigurationDefinitions().keySet();
        for (String key : keys) {
            ConfigurationDefinition config = this.getConfigurationDefinitions().get(key);
            if (!config.isRequired() || !config.getType().equals((Object)ConfigurationDefinition.Type.DIRECTORY) && !config.getType().equals((Object)ConfigurationDefinition.Type.STRING) || !this.stringAttributes.get(key).getText().equals("")) continue;
            this.setErrorMessage("Field " + config.getName() + " must not be empty");
            return false;
        }
        return true;
    }

    public String getName() {
        return "Model Extraction";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Set<String> keys = this.getConfigurationDefinitions().keySet();
        for (String key : keys) {
            ConfigurationDefinition config = this.getConfigurationDefinitions().get(key);
            if (config.getType().equals((Object)ConfigurationDefinition.Type.DIRECTORY) || config.getType().equals((Object)ConfigurationDefinition.Type.STRING)) {
                configuration.setAttribute(config.getId(), config.getDefaultValue());
                continue;
            }
            if (!config.getType().equals((Object)ConfigurationDefinition.Type.BOOLEAN)) continue;
            configuration.setAttribute(config.getId(), config.getDefaultValue());
        }
    }

    public boolean canSave() {
        return true;
    }
}

