/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.naming;

import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.api.StringDistance;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.Type;
import org.jgrapht.DirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractMetric;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.naming.NamePair;
import org.somox.metrics.tabs.MetricTab;
import org.somox.metrics.tabs.NameResemblanceTab;

public class NameResemblance
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.NameResemblance");
    private static final String DELIMITER = "\u00a7";
    private static Logger logger = Logger.getLogger(NameResemblance.class);
    private static final StringDistance resemblanceMetric = new JaroWinkler();
    private Map<NamePair, Double> nameResemblanceMap = new HashMap<NamePair, Double>();
    private Set<String> excludedPrefixes;
    private Set<String> excludedSuffixes;
    private static final IStringChangerStrategy prefixRemover = new IStringChangerStrategy(){

        @Override
        public String modify(String s, String parameter) {
            return s.substring(parameter.length());
        }

        @Override
        public boolean isAffected(String s, String parameter) {
            return s.startsWith(parameter);
        }
    };
    private static final IStringChangerStrategy suffixRemover = new IStringChangerStrategy(){

        @Override
        public String modify(String s, String parameter) {
            return s.substring(0, s.length() - parameter.length());
        }

        @Override
        public boolean isAffected(String s, String parameter) {
            return s.endsWith(parameter);
        }
    };

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DirectedGraph<Type, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToImplementingClassesHelper) {
        super.initialize(gastModel, somoxConfiguration, allMetrics, accessGraph, componentToImplementingClassesHelper);
        this.excludedPrefixes = this.tokenizeString(somoxConfiguration.getExcludedPrefixesForNameResemblance());
        this.excludedSuffixes = this.tokenizeString(somoxConfiguration.getExcludedSuffixesForNameResemblance());
        for (Type class1 : accessGraph.vertexSet()) {
            for (Type class2 : accessGraph.vertexSet()) {
                Double resemblance = this.nameResemblanceMap.get(new NamePair(class1, class2));
                if (resemblance != null) continue;
                resemblance = resemblanceMetric.score(this.trimString(class1.getName()), this.trimString(class2.getName()));
                NamePair pair = new NamePair(class1, class2);
                this.nameResemblanceMap.put(pair, resemblance);
            }
        }
        this.nameResemblanceMap = Collections.unmodifiableMap(this.nameResemblanceMap);
    }

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<Type> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Set<Type> classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent());
        int totalCompares = classes1.size() * classes2.size();
        double nameResemblance = 0.0;
        for (Type class1 : classes1) {
            for (Type class2 : classes2) {
                Double resemblance = this.nameResemblanceMap.get(new NamePair(class1, class2));
                if (resemblance == null) {
                    throw new RuntimeException("This should not happen as all classes are precomputed");
                }
                nameResemblance += resemblance.doubleValue();
            }
        }
        if (totalCompares == 0) {
            logger.debug((Object)"Resemblance Map had a size of 0");
            relationToCompute.setResultMetric(this.getMID(), 0.0);
        } else {
            relationToCompute.setResultMetric(this.getMID(), nameResemblance / (double)totalCompares);
        }
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricTab getLaunchConfigurationTab() {
        return new NameResemblanceTab();
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Set<String> collectAllSimpleNames(Set<Type> classes) {
        HashSet<String> allSimpleTrimmedNames = new HashSet<String>();
        for (Type clazz : classes) {
            allSimpleTrimmedNames.add(this.trimString(clazz.getName()));
        }
        return allSimpleTrimmedNames;
    }

    private String trimString(String name) {
        String result = this.modifyString(name, this.excludedPrefixes, prefixRemover);
        result = this.modifyString(name, this.excludedSuffixes, suffixRemover);
        return result;
    }

    private String modifyString(String name, Set<String> parameters, IStringChangerStrategy strategy) {
        boolean changed = true;
        block0: while (changed) {
            changed = false;
            for (String currentParameter : parameters) {
                if (!strategy.isAffected(name, currentParameter)) continue;
                changed = true;
                name = strategy.modify(name, currentParameter);
                continue block0;
            }
        }
        return name;
    }

    private Set<String> tokenizeString(String nameResemblancePrefixString) {
        HashSet<String> nameResemblancePrefixes = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(nameResemblancePrefixString, DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            nameResemblancePrefixes.add(tokenizer.nextToken());
        }
        return Collections.unmodifiableSet(nameResemblancePrefixes);
    }

    @Override
    public boolean isNormalised() {
        return true;
    }

    private static interface IStringChangerStrategy {
        public boolean isAffected(String var1, String var2);

        public String modify(String var1, String var2);
    }
}

