/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.emf.JavaPackage;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage;
import org.eclipse.modisco.java.composition.javaapplication.JavaApplication;
import org.eclipse.modisco.java.composition.javaapplication.JavaapplicationPackage;
import org.somox.kdmhelper.metamodeladdition.Root;

public class KDMReader {
    private Root root = new Root();
    private static final Logger logger = Logger.getLogger((String)KDMReader.class.getName());

    public KDMReader() {
        JavaPackage.eINSTANCE.eClass();
        KdmPackage.eINSTANCE.eClass();
        JavaapplicationPackage.eINSTANCE.eClass();
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadFiles(Collection<String> filesLocationList) throws IOException {
        for (String fileLocation : filesLocationList) {
            File file = new File(fileLocation);
            URI URIfile = URI.createFileURI((String)file.getAbsolutePath());
            Resource resource = ModelUtils.loadModel((URI)URIfile);
            Map<Object, Object> loadOptions = this.setupLoadOptions(resource);
            this.addModelToRoot(resource);
        }
    }

    public void loadFile(URI file) throws IOException {
        Resource resource = ModelUtils.loadModel((URI)file);
        this.addModelToRoot(resource);
    }

    private void addModelToRoot(Resource resource) {
        this.root.addModels(this.getModelsFromResource(resource));
    }

    private Collection<Model> getModelsFromResource(Resource resource) {
        ArrayList<Model> modelList = new ArrayList<Model>();
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof JavaApplication)) continue;
            JavaApplication javaApp = (JavaApplication)obj;
            for (Object ref : javaApp.eCrossReferences()) {
                if (!(ref instanceof Model)) continue;
                Model model = (Model)ref;
                modelList.add(model);
            }
        }
        return modelList;
    }

    private Map<Object, Object> setupLoadOptions(Resource resource) {
        Map loadOptions = ((XMLResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        return loadOptions;
    }
}

