/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.ArrayAccess;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.ClassInstanceCreation;
import org.eclipse.gmt.modisco.java.FieldAccess;
import org.eclipse.gmt.modisco.java.InheritanceKind;
import org.eclipse.gmt.modisco.java.InterfaceDeclaration;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Modifier;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.ParameterizedType;
import org.eclipse.gmt.modisco.java.PrimitiveType;
import org.eclipse.gmt.modisco.java.SingleVariableAccess;
import org.eclipse.gmt.modisco.java.SuperFieldAccess;
import org.eclipse.gmt.modisco.java.TagElement;
import org.eclipse.gmt.modisco.java.ThisExpression;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.VisibilityKind;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceFile;
import org.eclipse.modisco.java.composition.javaapplication.Java2File;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.eclipse.modisco.java.composition.javaapplication.queries.GetASTNodeSourceRegion;
import org.somox.kdmhelper.EqualityChecker;
import org.somox.kdmhelper.GetAccessedType;

public class KDMHelper {
    public static boolean SISSYMODE = true;

    public static String computeFullQualifiedName(ASTNode input) {
        ASTNode pack = input;
        String result = "";
        if (pack instanceof NamedElement) {
            result = KDMHelper.getNameOfNamedElement((NamedElement)pack);
        }
        while (pack != null) {
            if (pack.eContainer() != null && pack.eContainer() instanceof NamedElement) {
                pack = pack.eContainer();
                result = String.valueOf(KDMHelper.getNameOfNamedElement((NamedElement)pack)) + "." + result;
                continue;
            }
            pack = pack.eContainer();
        }
        result = KDMHelper.removeLastPoint(result);
        return result;
    }

    public static String removeLastPoint(String result) {
        if (result != null) {
            if (result.charAt(result.length() - 1) == '.') {
                return result.substring(0, result.length() - 1);
            }
            return result;
        }
        return null;
    }

    private static String getNameOfNamedElement(NamedElement input) {
        String result = "";
        result = input instanceof AbstractMethodDeclaration ? String.valueOf(input.getName()) + "()" : input.getName();
        return result;
    }

    private static Set<Type> getAccessedTypes(ASTNode element) {
        HashSet<Type> result = new HashSet<Type>();
        Type accessedType = GetAccessedType.getAccessedType(element);
        if (SISSYMODE) {
            if (accessedType != null) {
                result.add(accessedType);
            }
        } else if (accessedType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)accessedType;
            result.add(paramType.getType().getType());
            for (TypeAccess typeAccess : paramType.getTypeArguments()) {
                if (typeAccess.getType() instanceof ParameterizedType) {
                    result.addAll(KDMHelper.getAccessedTypes((ASTNode)typeAccess));
                    continue;
                }
                result.add(GetAccessedType.getAccessedType((ASTNode)typeAccess));
            }
        } else {
            result.add(accessedType);
        }
        return result;
    }

    public static List<Type> getAllAccessedClasses(Type input) {
        HashSet<Type> resultList = new HashSet<Type>();
        List<ASTNode> accesses = KDMHelper.getAllAccesses((ASTNode)input);
        for (ASTNode node : accesses) {
            resultList.addAll(KDMHelper.getAccessedTypes(node));
        }
        ArrayList<Type> returnSet = new ArrayList<Type>();
        returnSet.addAll(resultList);
        return returnSet;
    }

    public static List<ASTNode> getAllAccesses(ASTNode input) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        TreeIterator iterator = input.eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof ASTNode) || !KDMHelper.isAccess((ASTNode)element) || element.eContainer() instanceof TagElement) continue;
            result.add((ASTNode)element);
        }
        return result;
    }

    public static List<TypeAccess> getInheritanceTypeAccesses(Type type) {
        ArrayList<TypeAccess> result = new ArrayList<TypeAccess>();
        if (type instanceof ClassDeclaration) {
            ClassDeclaration tempClass = (ClassDeclaration)type;
            result.addAll((Collection<TypeAccess>)tempClass.getSuperInterfaces());
            if (tempClass.getSuperClass() != null) {
                result.add(tempClass.getSuperClass());
            }
        }
        if (type instanceof InterfaceDeclaration) {
            InterfaceDeclaration tempInterface = (InterfaceDeclaration)type;
            result.addAll((Collection<TypeAccess>)tempInterface.getSuperInterfaces());
        }
        return result;
    }

    public static List<Type> getInnerClasses(Type clazz) {
        ArrayList<Type> result = new ArrayList<Type>();
        if (!(clazz instanceof ClassDeclaration)) {
            return result;
        }
        TreeIterator iterator = clazz.eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof ClassDeclaration) || !KDMHelper.isInnerClass((Type)element)) continue;
            result.add((Type)((ClassDeclaration)element));
        }
        return result;
    }

    public static JavaNodeSourceRegion getJavaNodeSourceRegion(ASTNode node) {
        GetASTNodeSourceRegion query = new GetASTNodeSourceRegion();
        try {
            return query.evaluate(node, null);
        }
        catch (ModelQueryExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<MethodDeclaration> getMethods(Type input) {
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>();
        if (!(input instanceof AbstractTypeDeclaration)) {
            return result;
        }
        AbstractTypeDeclaration clazz = (AbstractTypeDeclaration)input;
        for (BodyDeclaration body : clazz.getBodyDeclarations()) {
            if (!(body instanceof MethodDeclaration)) continue;
            result.add((MethodDeclaration)body);
        }
        return result;
    }

    public static MethodDeclaration getOverriddenMember(MethodDeclaration methDecInput) {
        MethodDeclaration redefinedMethodDeclaration = methDecInput.getRedefinedMethodDeclaration();
        if (redefinedMethodDeclaration != null) {
            return redefinedMethodDeclaration;
        }
        AbstractTypeDeclaration typeOfMethod = methDecInput.getAbstractTypeDeclaration();
        List<Type> superTypes = KDMHelper.getSuperTypes((Type)typeOfMethod);
        for (Type type : superTypes) {
            List<MethodDeclaration> method = KDMHelper.getMethods(type);
            for (MethodDeclaration methodDeclaration : method) {
                if (!EqualityChecker.areFunctionsEqual((AbstractMethodDeclaration)methDecInput, (AbstractMethodDeclaration)methodDeclaration)) continue;
                return methodDeclaration;
            }
        }
        return null;
    }

    public static String getSISSyID(ASTNode node) {
        return node.toString();
    }

    public static SourceFile getSourceFile(JavaNodeSourceRegion sourceRegion) {
        SourceFile result = null;
        if (sourceRegion != null && sourceRegion.eContainer() instanceof Java2File) {
            Java2File java2file = (Java2File)sourceRegion.eContainer();
            return java2file.getFile();
        }
        return result;
    }

    public static List<Type> getSuperTypes(Type type) {
        ArrayList<Type> result = new ArrayList<Type>();
        if (type == null) {
            return result;
        }
        for (TypeAccess typeAccess : KDMHelper.getInheritanceTypeAccesses(type)) {
            if (typeAccess == null) continue;
            result.add(typeAccess.getType());
        }
        return result;
    }

    public static Package getSurroundingPackage(Type input) {
        if (input instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)input;
            return type.getPackage();
        }
        return null;
    }

    public static boolean isAbstract(Type input) {
        InheritanceKind inhKind;
        BodyDeclaration body;
        Modifier modifier;
        if (input instanceof BodyDeclaration && (modifier = (body = (BodyDeclaration)input).getModifier()) != null && (inhKind = modifier.getInheritance()) != null) {
            return body.getModifier().getInheritance().equals((Object)InheritanceKind.ABSTRACT);
        }
        return false;
    }

    public static boolean isAccess(ASTNode element) {
        if (element instanceof ClassInstanceCreation) {
            return false;
        }
        if (element instanceof AbstractMethodInvocation) {
            return true;
        }
        if (element instanceof ArrayAccess) {
            return true;
        }
        if (element instanceof FieldAccess) {
            return true;
        }
        if (element instanceof TypeAccess) {
            return true;
        }
        if (element instanceof ThisExpression) {
            return true;
        }
        if (element instanceof SingleVariableAccess) {
            return true;
        }
        return element instanceof SuperFieldAccess;
    }

    public static boolean isInheritanceTypeAccess(TypeAccess inputTypeAccess) {
        if (inputTypeAccess.eContainer() instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration atd = (AbstractTypeDeclaration)inputTypeAccess.eContainer();
            for (TypeAccess ta : KDMHelper.getInheritanceTypeAccesses((Type)atd)) {
                if (ta != inputTypeAccess) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInnerClass(Type clazz) {
        return clazz instanceof ClassDeclaration & clazz.eContainer() instanceof ClassDeclaration;
    }

    public static boolean isInterface(ASTNode input) {
        return input instanceof InterfaceDeclaration;
    }

    public static boolean isModifierOfKind(MethodDeclaration method, VisibilityKind inputVisKind) {
        Modifier modifier = method.getModifier();
        if (modifier == null) {
            return false;
        }
        VisibilityKind kind = method.getModifier().getVisibility();
        if (kind == null) {
            return false;
        }
        return kind.equals((Object)inputVisKind);
    }

    public static boolean isPrimitive(Type input) {
        return input instanceof PrimitiveType;
    }

    public static boolean isVirtual(BodyDeclaration bodyDec) {
        if (bodyDec == null || bodyDec.getModifier() == null) {
            return false;
        }
        if (bodyDec.getModifier().getVisibility() != null && bodyDec.getModifier().getVisibility().equals((Object)VisibilityKind.PRIVATE)) {
            return false;
        }
        if (bodyDec.getModifier().isStatic()) {
            return false;
        }
        InheritanceKind inherKind = bodyDec.getModifier().getInheritance();
        return inherKind == null || !inherKind.equals((Object)InheritanceKind.FINAL);
    }
}

