/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.AssertStatement;
import org.eclipse.gmt.modisco.java.Block;
import org.eclipse.gmt.modisco.java.EnhancedForStatement;
import org.eclipse.gmt.modisco.java.ExpressionStatement;
import org.eclipse.gmt.modisco.java.ForStatement;
import org.eclipse.gmt.modisco.java.IfStatement;
import org.eclipse.gmt.modisco.java.Statement;
import org.eclipse.gmt.modisco.java.SwitchStatement;
import org.eclipse.gmt.modisco.java.SynchronizedStatement;
import org.eclipse.gmt.modisco.java.TryStatement;
import org.eclipse.gmt.modisco.java.VariableDeclarationStatement;
import org.eclipse.gmt.modisco.java.WhileStatement;
import org.eclipse.gmt.modisco.java.emf.util.JavaSwitch;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.somox.gast2seff.jobs.GAST2SEFFJob;
import org.somox.gast2seff.visitors.FunctionCallClassificationVisitor;
import org.somox.gast2seff.visitors.SwitchStatementHelper;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;

public class GastStatementVisitor
extends JavaSwitch<Object> {
    private static final Logger logger = Logger.getLogger(GastStatementVisitor.class);
    private final ResourceDemandingBehaviour seff;
    private final SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private final BasicComponent primitiveComponent;
    private final Map<Statement, BitSet> functionClassificationAnnotation;
    private BitSet lastType = null;

    public GastStatementVisitor(Map<Statement, BitSet> functionClassificationAnnotations, ResourceDemandingBehaviour resourceDemandingBehaviour, SourceCodeDecoratorRepository gastBehaviourRepository, BasicComponent primitiveComponent) {
        this.seff = resourceDemandingBehaviour;
        this.functionClassificationAnnotation = functionClassificationAnnotations;
        this.sourceCodeDecoratorRepository = gastBehaviourRepository;
        this.primitiveComponent = primitiveComponent;
    }

    public Object caseBlock(Block object) {
        for (Statement s : object.getStatements()) {
            BitSet thisType = this.functionClassificationAnnotation.get(s);
            if (!this.shouldSkip(this.lastType, thisType) && !this.isVisitedStatement(thisType)) {
                this.setVisited(thisType);
                this.doSwitch((EObject)s);
            }
            this.lastType = thisType;
        }
        return null;
    }

    public Object caseSwitchStatement(SwitchStatement switchStatement) {
        if (this.containsExternalCall((Statement)switchStatement)) {
            BranchAction branchAction = SeffFactory.eINSTANCE.createBranchAction();
            this.seff.getSteps_Behaviour().add((Object)branchAction);
            branchAction.setEntityName(this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)switchStatement)));
            ArrayList<ArrayList<Statement>> branches = SwitchStatementHelper.createBlockListFromSwitchStatement(switchStatement);
            for (ArrayList<Statement> branch : branches) {
                ProbabilisticBranchTransition bt = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
                bt.setBranchBehaviour_BranchTransition(SeffFactory.eINSTANCE.createResourceDemandingBehaviour());
                bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)SeffFactory.eINSTANCE.createStartAction());
                bt.setEntityName("parent " + this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)switchStatement)) + "/" + (branch.size() > 0 ? String.valueOf(this.positionToLineNumber(KDMHelper.getJavaNodeSourceRegion((ASTNode)((ASTNode)branch.get(0))))) + " to " + this.positionToLineNumber(KDMHelper.getJavaNodeSourceRegion((ASTNode)((ASTNode)branch.get(branch.size() - 1)))) : ""));
                branchAction.getBranches_Branch().add((Object)bt);
                GastStatementVisitor visitor = new GastStatementVisitor(this.functionClassificationAnnotation, bt.getBranchBehaviour_BranchTransition(), this.sourceCodeDecoratorRepository, this.primitiveComponent);
                for (Statement statement : branch) {
                    BitSet thisType = this.functionClassificationAnnotation.get(statement);
                    if (!this.shouldSkip(this.lastType, thisType)) {
                        visitor.doSwitch((EObject)statement);
                    }
                    this.lastType = thisType;
                }
                bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)SeffFactory.eINSTANCE.createStopAction());
                GAST2SEFFJob.connectActions(bt.getBranchBehaviour_BranchTransition());
            }
        } else {
            this.createInternalAction((Statement)switchStatement);
        }
        return null;
    }

    public Object caseIfStatement(IfStatement input) {
        if (this.containsExternalCall((Statement)input)) {
            BranchAction branch = SeffFactory.eINSTANCE.createBranchAction();
            this.seff.getSteps_Behaviour().add((Object)branch);
            branch.setEntityName(this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)input)));
            Statement ifStatement = input.getThenStatement();
            this.handleIfOrElseBranch(input, branch, ifStatement);
            Statement elseStatement = input.getElseStatement();
            if (elseStatement != null) {
                this.handleIfOrElseBranch(input, branch, elseStatement);
            }
        } else {
            this.createInternalAction((Statement)input);
        }
        return null;
    }

    private void handleIfOrElseBranch(IfStatement input, BranchAction branch, Statement ifElseStatement) {
        ProbabilisticBranchTransition bt = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
        bt.setBranchBehaviour_BranchTransition(SeffFactory.eINSTANCE.createResourceDemandingBehaviour());
        bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)SeffFactory.eINSTANCE.createStartAction());
        bt.setEntityName("parent " + this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)input)) + "/" + this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)ifElseStatement)));
        branch.getBranches_Branch().add((Object)bt);
        GastStatementVisitor visitor = new GastStatementVisitor(this.functionClassificationAnnotation, bt.getBranchBehaviour_BranchTransition(), this.sourceCodeDecoratorRepository, this.primitiveComponent);
        visitor.doSwitch((EObject)ifElseStatement);
        bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)SeffFactory.eINSTANCE.createStopAction());
        GAST2SEFFJob.connectActions(bt.getBranchBehaviour_BranchTransition());
    }

    public Object caseEnhancedForStatement(EnhancedForStatement object) {
        return this.handleLoopStatement((Statement)object, object.getBody());
    }

    public Object caseForStatement(ForStatement object) {
        return this.handleLoopStatement((Statement)object, object.getBody());
    }

    public Object caseWhileStatement(WhileStatement object) {
        return this.handleLoopStatement((Statement)object, object.getBody());
    }

    private Object handleLoopStatement(Statement loopStatement, Statement body) {
        if (this.containsExternalCall(loopStatement)) {
            LoopAction loop = SeffFactory.eINSTANCE.createLoopAction();
            loop.setBodyBehaviour_Loop(SeffFactory.eINSTANCE.createResourceDemandingBehaviour());
            this.seff.getSteps_Behaviour().add((Object)loop);
            loop.getBodyBehaviour_Loop().getSteps_Behaviour().add((Object)SeffFactory.eINSTANCE.createStartAction());
            loop.setEntityName(this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)loopStatement)));
            new GastStatementVisitor(this.functionClassificationAnnotation, loop.getBodyBehaviour_Loop(), this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)body);
            loop.getBodyBehaviour_Loop().getSteps_Behaviour().add((Object)SeffFactory.eINSTANCE.createStopAction());
            GAST2SEFFJob.connectActions(loop.getBodyBehaviour_Loop());
        } else {
            this.createInternalAction(loopStatement);
        }
        return null;
    }

    public Object caseTryStatement(TryStatement object) {
        if (this.containsExternalCall((Statement)object)) {
            new GastStatementVisitor(this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)object.getBody());
            if (object.getFinally() != null) {
                new GastStatementVisitor(this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)object.getFinally());
            }
        } else {
            this.createInternalAction((Statement)object);
        }
        return null;
    }

    public Object caseAssertStatement(AssertStatement object) {
        return this.handleFormerSimpleStatement((Statement)object);
    }

    private Object handleFormerSimpleStatement(Statement object) {
        BitSet statementAnnotation = this.functionClassificationAnnotation.get(object);
        if (this.isExternalCall(statementAnnotation)) {
            this.createExternalCallAction(object);
        } else if (this.isInternalCall(statementAnnotation)) {
            AbstractMethodInvocation functionAccess = this.getFunctionAccess(object);
            Block body = functionAccess.getMethod().getBody();
            if (body != null) {
                BitSet thisType = this.functionClassificationAnnotation.get(object);
                if (!this.isVisitedStatement(thisType)) {
                    this.setVisited(thisType);
                    this.doSwitch((EObject)body);
                }
            } else {
                String msg = "Behaviour not set in GAST for " + functionAccess.getMethod().getName();
                msg = KDMHelper.getJavaNodeSourceRegion((ASTNode)object) != null && KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)object)) != null && KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)object)).getPath() != null ? String.valueOf(msg) + ". Tried to call from " + KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)object)).getPath() + "." : String.valueOf(msg) + ". (caller position unknown)";
                logger.warn((Object)msg);
            }
        } else {
            this.createInternalAction(object);
        }
        return null;
    }

    public Object caseExpressionStatement(ExpressionStatement object) {
        return this.handleFormerSimpleStatement((Statement)object);
    }

    public Object caseVariableDeclarationStatement(VariableDeclarationStatement object) {
        return this.handleFormerSimpleStatement((Statement)object);
    }

    public Object caseSynchronizedStatement(SynchronizedStatement input) {
        PassiveResource passiveResource = RepositoryFactory.eINSTANCE.createPassiveResource();
        passiveResource.setEntityName(this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)input)));
        passiveResource.setCapacity_PassiveResource(CoreFactory.eINSTANCE.createPCMRandomVariable());
        this.primitiveComponent.getPassiveResource_BasicComponent().add((Object)passiveResource);
        passiveResource.getCapacity_PassiveResource().setSpecification("1");
        logger.debug((Object)"start handling synchronized statement");
        AcquireAction acquireAction = SeffFactory.eINSTANCE.createAcquireAction();
        logger.debug((Object)"create acquireAction");
        this.seff.getSteps_Behaviour().add((Object)acquireAction);
        acquireAction.setPassiveresource_AcquireAction(passiveResource);
        acquireAction.setEntityName(this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)input)));
        new GastStatementVisitor(this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)input.getBody());
        logger.debug((Object)"create releaseAction");
        ReleaseAction releaseAction = SeffFactory.eINSTANCE.createReleaseAction();
        this.seff.getSteps_Behaviour().add((Object)releaseAction);
        releaseAction.setPassiveResource_ReleaseAction(passiveResource);
        releaseAction.setEntityName(this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)input)));
        return null;
    }

    private boolean shouldSkip(BitSet lastType, BitSet thisType) {
        if (lastType == null) {
            return false;
        }
        if (this.isExternalCall(thisType)) {
            return false;
        }
        return !this.isExternalCall(lastType);
    }

    private void createExternalCallAction(Statement object) {
        ExternalCallAction call = SeffFactory.eINSTANCE.createExternalCallAction();
        AbstractMethodInvocation access = this.getFunctionAccess(object);
        call.setEntityName(access.getMethod().getName());
        InterfacePortOperationTuple ifOperationTuple = this.getCalledInterfacePort(access);
        call.setRole_ExternalService((OperationRequiredRole)ifOperationTuple.role);
        call.setCalledService_ExternalService((OperationSignature)ifOperationTuple.signature);
        this.seff.getSteps_Behaviour().add((Object)call);
    }

    private InterfacePortOperationTuple getCalledInterfacePort(AbstractMethodInvocation access) {
        InterfacePortOperationTuple interfacePortOperationTuple = new InterfacePortOperationTuple();
        for (RequiredRole requiredRole : this.primitiveComponent.getRequiredRoles_InterfaceRequiringEntity()) {
            for (InterfaceSourceCodeLink ifLink : this.sourceCodeDecoratorRepository.getInterfaceSourceCodeLink()) {
                OperationRequiredRole operReqRole;
                if (!(requiredRole instanceof OperationRequiredRole) || !(operReqRole = (OperationRequiredRole)requiredRole).getRequiredInterface__OperationRequiredRole().equals(ifLink.getInterface()) || !ifLink.getGastClass().equals(GetAccessedType.getAccessedType((ASTNode)access))) continue;
                logger.trace((Object)("accessed interface port " + operReqRole.getEntityName()));
                interfacePortOperationTuple.role = operReqRole;
                interfacePortOperationTuple.signature = this.queryInterfaceOperation(access);
                return interfacePortOperationTuple;
            }
        }
        logger.warn((Object)("found no if port for " + GetAccessedType.getAccessedType((ASTNode)access).getName()));
        return interfacePortOperationTuple;
    }

    private Signature queryInterfaceOperation(AbstractMethodInvocation methodInvocation) {
        for (MethodLevelSourceCodeLink methodLink : this.sourceCodeDecoratorRepository.getMethodLevelSourceCodeLink()) {
            if (!methodLink.getFunction().equals(methodInvocation.getMethod())) continue;
            logger.trace((Object)("accessed operation " + methodLink.getOperation().getEntityName()));
            return methodLink.getOperation();
        }
        logger.warn((Object)("no accessed operation found for " + methodInvocation.getMethod().getName()));
        return null;
    }

    private boolean isExternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }

    private boolean isInternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
    }

    private boolean isVisitedStatement(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.VISITED));
    }

    private void setVisited(BitSet thisType) {
        thisType.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.VISITED), true);
    }

    private AbstractMethodInvocation getFunctionAccess(Statement object) {
        for (ASTNode a : KDMHelper.getAllAccesses((ASTNode)object)) {
            if (!(a instanceof AbstractMethodInvocation)) continue;
            return (AbstractMethodInvocation)a;
        }
        return null;
    }

    private void createInternalAction(Statement statement) {
        InternalAction internalAction = SeffFactory.eINSTANCE.createInternalAction();
        internalAction.setEntityName("IA " + this.positionToString(KDMHelper.getJavaNodeSourceRegion((ASTNode)statement)));
        this.seff.getSteps_Behaviour().add((Object)internalAction);
    }

    private String blockToString(Block blockstatement) {
        if (blockstatement != null) {
            ASTNode access;
            ASTNode firstAccess;
            StringBuilder blockString = new StringBuilder("Block: ");
            blockString.append(blockstatement.toString());
            if (KDMHelper.getAllAccesses((ASTNode)blockstatement) != null && KDMHelper.getAllAccesses((ASTNode)blockstatement).size() >= 1 && (firstAccess = (ASTNode)KDMHelper.getAllAccesses((ASTNode)blockstatement).get(0)) instanceof ASTNode && GetAccessedType.getAccessedType((ASTNode)(access = firstAccess)) != null) {
                blockString.append(" " + GetAccessedType.getAccessedType((ASTNode)access).getName() + "...");
            }
            return blockString.toString();
        }
        return "No blockstatement";
    }

    private String statementsToString(EList<Statement> statements) {
        if (statements != null) {
            StringBuilder blockString = new StringBuilder("Block: ");
            blockString.append(statements.toString());
            for (Statement statement : statements) {
                ASTNode firstAccess;
                if (KDMHelper.getAllAccesses((ASTNode)statement) == null || KDMHelper.getAllAccesses((ASTNode)statement).size() < 1 || !((firstAccess = (ASTNode)KDMHelper.getAllAccesses((ASTNode)statement).get(0)) instanceof ASTNode)) continue;
                ASTNode access = firstAccess;
                if (GetAccessedType.getAccessedType((ASTNode)access) != null) {
                    blockString.append(" " + GetAccessedType.getAccessedType((ASTNode)access).getName() + "...");
                }
                return blockString.toString();
            }
            return blockString.toString();
        }
        return "No blockstatement";
    }

    private String positionToString(JavaNodeSourceRegion position) {
        StringBuilder positionString = new StringBuilder("position: ");
        if (position != null) {
            if (KDMHelper.getSourceFile((JavaNodeSourceRegion)position) != null && KDMHelper.getSourceFile((JavaNodeSourceRegion)position).getClass() != null) {
                positionString.append(KDMHelper.computeFullQualifiedName((ASTNode)position.getJavaNode()));
            }
            positionString.append(" from " + position.getStartLine());
            positionString.append(" to " + position.getEndLine());
        } else {
            positionString.append("no position information available");
        }
        return positionString.toString();
    }

    private String positionToLineNumber(JavaNodeSourceRegion position) {
        StringBuilder positionString = new StringBuilder("line ");
        if (position != null) {
            positionString.append(position.getStartLine());
        } else {
            positionString.append("no position information available");
        }
        return positionString.toString();
    }

    private boolean containsExternalCall(Statement object) {
        return this.functionClassificationAnnotation.get(object).get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }

    public Object defaultCase(EObject object) {
        logger.warn((Object)("Not handled object by statement visitor:\n  " + object));
        return super.defaultCase(object);
    }

    private class InterfacePortOperationTuple {
        public Role role;
        public Signature signature;

        private InterfacePortOperationTuple() {
        }
    }
}

