/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.BitSet;
import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.Statement;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.gast2seff.visitors.BasicFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.FunctionCallClassificationVisitor;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.kdmhelper.KDMHelper;

public abstract class AbstractFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    private Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);

    @Override
    public BitSet classifySimpleStatement(Statement object) {
        BitSet result = new BitSet();
        AbstractMethodInvocation functionAccess = this.getFunctionAccess(object);
        if (functionAccess != null) {
            if (this.isExternalCall(functionAccess)) {
                this.logger.debug((Object)("Found external call: " + functionAccess.getMethod().getName()));
                result.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
            } else if (this.isLibraryCall(functionAccess)) {
                this.logger.debug((Object)("Found library call: " + functionAccess.getMethod().getName()));
                result.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.LIBRARY));
            } else {
                this.logger.debug((Object)("Found internal call: " + functionAccess.getMethod().getName()));
                result.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
            }
        }
        return result;
    }

    @Override
    public void mergeFunctionCallType(BitSet myType, BitSet functionCallType) {
        myType.or(functionCallType);
    }

    protected abstract boolean isExternalCall(AbstractMethodInvocation var1);

    protected abstract boolean isLibraryCall(AbstractMethodInvocation var1);

    protected Type findHostingClass(Statement statement) {
        Statement current = statement;
        while (current != null && !(current instanceof Type)) {
            current = current.eContainer();
        }
        return (Type)current;
    }

    private AbstractMethodInvocation getFunctionAccess(Statement object) {
        for (ASTNode a : KDMHelper.getAllAccesses((ASTNode)object)) {
            if (!(a instanceof AbstractMethodInvocation)) continue;
            return (AbstractMethodInvocation)a;
        }
        return null;
    }
}

