/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.Block;
import org.eclipse.gmt.modisco.java.Statement;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.system.System;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.jobs.SoMoXBlackboard;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.gast2seff.jobs.DefaultQosAnnotationsBuilder;
import org.somox.gast2seff.visitors.BasicFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.FunctionCallClassificationVisitor;
import org.somox.gast2seff.visitors.GastStatementVisitor;
import org.somox.seff2javaast.SEFF2JavaAST;
import org.somox.seff2javaast.SEFF2MethodMapping;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;

public class GAST2SEFFJob
implements IBlackboardInteractingJob<SoMoXBlackboard> {
    private final Logger logger = Logger.getLogger(GAST2SEFFJob.class);
    private SoMoXBlackboard blackboard = null;
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private Resource gastInstance = null;
    private SEFF2JavaAST gastBehaviourRepositoryModel = null;
    private final Resource sourceCodeDecorator = null;
    private SourceCodeDecoratorRepository sourceCodeDecoratorModel = null;
    private QoSAnnotations sammQosAnnotationsModel = null;
    private SoMoXConfiguration somoxConfiguration = null;
    private FunctionCallClassificationVisitor typeVisitor = null;
    private final HashMap<String, EObject> idToeObjectMap;
    private final HashMap<Object, Object> xmlNameToFeatureMap;

    public GAST2SEFFJob(SoMoXConfiguration somoxConfiguration) {
        HashMap cache = new HashMap();
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(cache);
        this.idToeObjectMap = new HashMap();
        this.xmlNameToFeatureMap = new HashMap();
        this.somoxConfiguration = somoxConfiguration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String basePath = workspace.getRoot().getRawLocation().toOSString();
        String gastModelPath = this.somoxConfiguration.getFileLocations().getAnalyserInputFile();
        URI gastURI = URI.createFileURI((String)(String.valueOf(basePath) + File.separator + gastModelPath));
        this.logger.debug((Object)gastURI);
        this.gastInstance = this.loadResource(gastURI, true);
        monitor.subTask("loading models from blackboard");
        AnalysisResult result = this.blackboard.getAnalysisResult();
        System samm = result.getSystemModel();
        this.gastBehaviourRepositoryModel = result.getSeff2JavaAST();
        this.sammQosAnnotationsModel = result.getQosAnnotationModel();
        this.sourceCodeDecoratorModel = result.getSourceCodeDecoratorRepository();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        subMonitor.setTaskName("Creating SEFF behaviour");
        for (SEFF2MethodMapping astBehaviour : this.gastBehaviourRepositoryModel.getSeff2MethodMappings()) {
            ResourceDemandingSEFF seff = (ResourceDemandingSEFF)astBehaviour.getSeff();
            String name = seff.getId();
            this.logger.info((Object)("Found AST behaviour, generating SEFF behaviour for it: " + name));
            this.generateSEFFForGASTBehaviour(seff);
            monitor.worked(1);
        }
        DefaultQosAnnotationsBuilder qosAnnotationBuilder = new DefaultQosAnnotationsBuilder(this.sammQosAnnotationsModel);
        qosAnnotationBuilder.buildDefaultQosAnnotations((EList<SEFF2MethodMapping>)this.gastBehaviourRepositoryModel.getSeff2MethodMappings());
        subMonitor.done();
        monitor.subTask("saving models");
    }

    public String getName() {
        return "GAST2SEFF Transformation Job";
    }

    private Resource loadResource(URI uri, boolean loadFailAcceptable) throws JobFailedException {
        this.logger.debug((Object)("load start " + uri));
        Resource resource = this.resourceSet.createResource(uri);
        Map loadOptions = ((XMIResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", this.xmlNameToFeatureMap);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(this.idToeObjectMap);
        try {
            resource.load(loadOptions);
        }
        catch (IOException e) {
            if (loadFailAcceptable) {
                this.logger.warn((Object)"Loading of a required resource failed. This could result in a reduced model loading performance.", (Throwable)e);
            }
            throw new JobFailedException("Loading of a required resource failed", (Throwable)e);
        }
        this.logger.debug((Object)"load end");
        return resource;
    }

    private Resource createResource(URI uri) {
        Resource resource = this.resourceSet.createResource(uri);
        return resource;
    }

    private void saveResource(Resource resource) throws JobFailedException {
        try {
            resource.save(new HashMap());
        }
        catch (IOException e) {
            throw new JobFailedException("Saving model output failed", (Throwable)e);
        }
    }

    private ResourceDemandingSEFF createSeff(ResourceDemandingSEFF seff) throws JobFailedException {
        StartAction start = SeffFactory.eINSTANCE.createStartAction();
        StopAction stop = SeffFactory.eINSTANCE.createStopAction();
        BasicComponent basicComponent = (BasicComponent)seff.eContainer();
        this.typeVisitor = new FunctionCallClassificationVisitor(new BasicFunctionClassificationStrategy(this.sourceCodeDecoratorModel, basicComponent));
        seff.getSteps_Behaviour().add((Object)start);
        Block body = this.findBody(seff);
        this.logger.trace((Object)("visiting (seff entry): " + seff.getId()));
        if (body != null) {
            AbstractMethodDeclaration method = (AbstractMethodDeclaration)body.eContainer();
            if (method.getName().equals("orderProducts")) {
                int a = 0;
                ++a;
            }
            GastStatementVisitor visitor = new GastStatementVisitor(this.typeVisitor.getAnnotations(), (ResourceDemandingBehaviour)seff, this.sourceCodeDecoratorModel, basicComponent);
            for (Statement st : body.getStatements()) {
                this.typeVisitor.doSwitch((EObject)st);
                visitor.doSwitch((EObject)st);
            }
        } else {
            this.logger.warn((Object)("Found GAST behaviour (" + seff.getId() + ") without a method body... Skipping it..."));
        }
        seff.getSteps_Behaviour().add((Object)stop);
        GAST2SEFFJob.connectActions((ResourceDemandingBehaviour)seff);
        return seff;
    }

    private Block findBody(ResourceDemandingSEFF seff) throws JobFailedException {
        this.onlyOnceAsGastBehaviour((EList<SEFF2MethodMapping>)this.gastBehaviourRepositoryModel.getSeff2MethodMappings(), (ServiceEffectSpecification)seff);
        for (SEFF2MethodMapping behaviour : this.gastBehaviourRepositoryModel.getSeff2MethodMappings()) {
            if (!((ResourceDemandingSEFF)behaviour.getSeff()).getId().equals(seff.getId())) continue;
            this.logger.debug((Object)("Matching SEFF found " + seff.getId()));
            return behaviour.getBlockstatement();
        }
        this.logger.warn((Object)("Checked gastBehaviourRepository for " + seff.getId() + " but found none"));
        return null;
    }

    private boolean onlyOnceAsGastBehaviour(EList<SEFF2MethodMapping> seff2MethodMappings, ServiceEffectSpecification seff) {
        int i = 0;
        for (SEFF2MethodMapping mapping : seff2MethodMappings) {
            ResourceDemandingSEFF seffMapping = (ResourceDemandingSEFF)mapping.getSeff();
            ResourceDemandingSEFF seffInput = (ResourceDemandingSEFF)seff;
            if (!seffMapping.getId().equals(seffInput.getId())) continue;
            ++i;
        }
        if (i != 1) {
            this.logger.error((Object)("Assertion fails - onlyOnceAsGastBehaviour: i = " + i + " for " + ((ResourceDemandingSEFF)seff).getId()));
        }
        return i == 1;
    }

    public static void connectActions(ResourceDemandingBehaviour seff) {
        AbstractAction previous = null;
        for (AbstractAction a : seff.getSteps_Behaviour()) {
            a.setPredecessor_AbstractAction(previous);
            previous = a;
        }
    }

    private ResourceDemandingSEFF generateSEFFForGASTBehaviour(ResourceDemandingSEFF gastBehaviourStub) throws JobFailedException {
        this.createSeff(gastBehaviourStub);
        return gastBehaviourStub;
    }

    public void setBlackboard(SoMoXBlackboard blackBoard) {
        this.blackboard = blackBoard;
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        this.logger.warn((Object)"cleanup  called. Should not happen - nothing done.");
    }
}

