/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.emf.JavaPackage;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage;
import org.eclipse.modisco.java.composition.javaapplication.JavaApplication;
import org.eclipse.modisco.java.composition.javaapplication.JavaapplicationPackage;
import org.somox.kdmhelper.metamodeladdition.Root;

public final class KDMReader {
    static {
        JavaPackage.eINSTANCE.eClass();
        KdmPackage.eINSTANCE.eClass();
        JavaapplicationPackage.eINSTANCE.eClass();
    }

    public static final Root loadFile(URI file) throws IOException {
        Resource resource = KDMReader.loadModel(file);
        Root root = new Root();
        root.addModels(KDMReader.getModelsFromResource(resource));
        return root;
    }

    private static Collection<Model> getModelsFromResource(Resource resource) {
        ArrayList<Model> modelList = new ArrayList<Model>();
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof JavaApplication)) continue;
            JavaApplication javaApp = (JavaApplication)obj;
            for (Object ref : javaApp.eCrossReferences()) {
                if (!(ref instanceof Model)) continue;
                modelList.add((Model)ref);
            }
        }
        return modelList;
    }

    private static Resource loadModel(URI modelURI) throws IOException {
        Resource.Factory.Registry reg;
        Object resourceFactory;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (reg = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource result = resourceSet.createResource(modelURI);
        if (result != null) {
            result.load(null);
        }
        return result;
    }
}

