/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.AssertStatement;
import org.eclipse.gmt.modisco.java.Block;
import org.eclipse.gmt.modisco.java.EnhancedForStatement;
import org.eclipse.gmt.modisco.java.ExpressionStatement;
import org.eclipse.gmt.modisco.java.ForStatement;
import org.eclipse.gmt.modisco.java.IfStatement;
import org.eclipse.gmt.modisco.java.Statement;
import org.eclipse.gmt.modisco.java.SwitchStatement;
import org.eclipse.gmt.modisco.java.SynchronizedStatement;
import org.eclipse.gmt.modisco.java.TryStatement;
import org.eclipse.gmt.modisco.java.VariableDeclarationStatement;
import org.eclipse.gmt.modisco.java.WhileStatement;
import org.eclipse.gmt.modisco.java.emf.util.JavaSwitch;
import org.somox.gast2seff.visitors.GastStatementVisitor;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.SwitchStatementHelper;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;

public class FunctionCallClassificationVisitor
extends JavaSwitch<BitSet> {
    private static final Logger logger = Logger.getLogger(GastStatementVisitor.class);
    private final HashMap<Statement, BitSet> annotations = new HashMap();
    private IFunctionClassificationStrategy myStrategy = null;

    public FunctionCallClassificationVisitor(IFunctionClassificationStrategy strategy) {
        this.myStrategy = strategy;
    }

    public BitSet caseStatement(Statement object) {
        this.safePut(object, new BitSet());
        return new BitSet();
    }

    public BitSet caseBlock(Block object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), (List<Statement>)object.getStatements());
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseIfStatement(IfStatement object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        this.doSwitch((EObject)object.getThenStatement());
        if (object.getElseStatement() != null) {
            this.doSwitch((EObject)object.getElseStatement());
        }
        ArrayList<Statement> branchStatements = new ArrayList<Statement>();
        branchStatements.add(object.getThenStatement());
        if (object.getElseStatement() != null) {
            branchStatements.add(object.getElseStatement());
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), branchStatements);
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseSwitchStatement(SwitchStatement switchStatement) {
        if (this.annotations.containsKey(switchStatement)) {
            return this.annotations.get(switchStatement);
        }
        ArrayList<ArrayList<Statement>> branches = SwitchStatementHelper.createBlockListFromSwitchStatement(switchStatement);
        for (ArrayList<Statement> branch : branches) {
            this.computeChildAnnotations(new BitSet(), branch);
        }
        ArrayList<Statement> branchStatements = new ArrayList<Statement>();
        for (ArrayList<Statement> branch : branches) {
            branchStatements.addAll(branch);
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), branchStatements);
        this.annotations.put((Statement)switchStatement, myType);
        return myType;
    }

    private BitSet createBitSetLoop(Statement loop, Statement body) {
        if (this.annotations.containsKey(loop)) {
            return this.annotations.get(loop);
        }
        this.doSwitch((EObject)body);
        BitSet myType = this.annotations.get(body);
        this.annotations.put(loop, myType);
        return myType;
    }

    public BitSet caseEnhancedForStatement(EnhancedForStatement object) {
        return this.createBitSetLoop((Statement)object, object.getBody());
    }

    public BitSet caseForStatement(ForStatement object) {
        return this.createBitSetLoop((Statement)object, object.getBody());
    }

    public BitSet caseWhileStatement(WhileStatement object) {
        return this.createBitSetLoop((Statement)object, object.getBody());
    }

    public BitSet caseSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        return this.createBitSetLoop((Statement)synchronizedStatement, (Statement)synchronizedStatement.getBody());
    }

    public BitSet caseTryStatement(TryStatement object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        ArrayList<Statement> allChildStatements = new ArrayList<Statement>();
        this.doSwitch((EObject)object.getBody());
        allChildStatements.addAll((Collection<Statement>)object.getBody().getStatements());
        if (object.getFinally() != null) {
            this.doSwitch((EObject)object.getFinally());
            allChildStatements.addAll((Collection<Statement>)object.getFinally().getStatements());
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), allChildStatements);
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseAssertStatement(AssertStatement object) {
        return this.handleFormerSimpleStatement((Statement)object);
    }

    public BitSet caseExpressionStatement(ExpressionStatement object) {
        return this.handleFormerSimpleStatement((Statement)object);
    }

    public BitSet caseVariableDeclarationStatement(VariableDeclarationStatement object) {
        return this.handleFormerSimpleStatement((Statement)object);
    }

    private BitSet handleFormerSimpleStatement(Statement statement) {
        if (this.annotations.containsKey(statement)) {
            return this.annotations.get(statement);
        }
        BitSet myType = this.myStrategy.classifySimpleStatement(statement);
        this.annotations.put(statement, myType);
        if (myType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallType.INTERNAL))) {
            AbstractMethodInvocation functionAccess = this.getFunctionAccess(statement);
            Block targetFunctionBody = functionAccess.getMethod().getBody();
            if (targetFunctionBody != null) {
                logger.trace((Object)("visiting internal call. accessed class: " + GetAccessedType.getAccessedType((ASTNode)functionAccess)));
                this.doSwitch((EObject)targetFunctionBody);
            } else {
                logger.warn((Object)("Behaviour not set in GAST for " + functionAccess.getMethod().getName()));
            }
        }
        return myType;
    }

    private AbstractMethodInvocation getFunctionAccess(Statement object) {
        for (ASTNode a : KDMHelper.getAllAccesses((ASTNode)object)) {
            if (!(a instanceof AbstractMethodInvocation)) continue;
            return (AbstractMethodInvocation)a;
        }
        return null;
    }

    private void safePut(Statement object, BitSet type) {
        if (!this.annotations.containsKey(object)) {
            this.annotations.put(object, type);
        }
    }

    private BitSet computeChildAnnotations(BitSet initalValue, List<Statement> childStatements) {
        for (Statement s : childStatements) {
            this.doSwitch((EObject)s);
        }
        BitSet myType = initalValue;
        for (Statement s : childStatements) {
            this.myStrategy.mergeFunctionCallType(myType, this.annotations.get(s));
        }
        return myType;
    }

    public static int getIndex(FunctionCallType type) {
        switch (type) {
            case INTERNAL: {
                return 0;
            }
            case EXTERNAL: {
                return 1;
            }
            case LIBRARY: {
                return 2;
            }
            case VISITED: {
                return 3;
            }
        }
        throw new UnsupportedOperationException();
    }

    public Map<Statement, BitSet> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public BitSet defaultCase(EObject object) {
        logger.warn((Object)("Not handled object by function call visitor:\n  " + object));
        return (BitSet)super.defaultCase(object);
    }

    public static enum FunctionCallType {
        EXTERNAL,
        LIBRARY,
        INTERNAL,
        VISITED;

    }
}

