/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.jobs;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractInternalControlFlowAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformanceFactory;
import org.somox.analyzer.simplemodelanalyzer.builder.util.DefaultResourceEnvironment;
import org.somox.sourcecodedecorator.Seff2MethodLink;

public class DefaultQosAnnotationsBuilder {
    private final Logger logger = Logger.getLogger(DefaultQosAnnotationsBuilder.class);

    public DefaultQosAnnotationsBuilder(QoSAnnotations qosAnnotationsModel) {
    }

    public void buildDefaultQosAnnotations(List<Seff2MethodLink> listofSEFF2MethodMappings) {
        for (Seff2MethodLink mapping : listofSEFF2MethodMappings) {
            ServiceEffectSpecification seff = mapping.getSeff();
            TreeIterator elements = EcoreUtil.getAllContents((EObject)seff, (boolean)true);
            while (elements.hasNext()) {
                EObject eObject = (EObject)elements.next();
                if (eObject instanceof LoopAction) {
                    LoopAction loopAction = (LoopAction)eObject;
                    this.createDefaultLoopCount(loopAction);
                }
                if (eObject instanceof BranchAction) {
                    BranchAction branchAction = (BranchAction)eObject;
                    this.createDefaultBranchProbability(branchAction);
                }
                if (!(eObject instanceof InternalAction)) continue;
                InternalAction internalAction = (InternalAction)eObject;
                this.createDefaultCpuResourceDemand(internalAction);
            }
        }
    }

    private void createDefaultBranchProbability(BranchAction branchAction) {
        for (AbstractBranchTransition branchTransition : branchAction.getBranches_Branch()) {
            if (branchTransition instanceof ProbabilisticBranchTransition) {
                double probability = 1.0 / (double)branchAction.getBranches_Branch().size();
                ((ProbabilisticBranchTransition)branchTransition).setBranchProbability(probability);
                ((ProbabilisticBranchTransition)branchTransition).setEntityName("SoMoX default branch probability");
                continue;
            }
            this.logger.warn((Object)"Unsupported branch transition type. Only ProbabilisticBranchTransition supported");
        }
    }

    private void createDefaultLoopCount(LoopAction loopAction) {
        PCMRandomVariable loopCount = CoreFactory.eINSTANCE.createPCMRandomVariable();
        loopCount.setSpecification("1");
        loopAction.setIterationCount_LoopAction(loopCount);
        loopAction.setEntityName("SoMoX default loop count value");
    }

    private void createDefaultCpuResourceDemand(InternalAction internalAction) {
        ParametricResourceDemand prd = SeffPerformanceFactory.eINSTANCE.createParametricResourceDemand();
        PCMRandomVariable randomVar = CoreFactory.eINSTANCE.createPCMRandomVariable();
        randomVar.setSpecification("0");
        prd.setSpecification_ParametericResourceDemand(randomVar);
        internalAction.getResourceDemand_Action().add((Object)prd);
        prd.setRequiredResource_ParametricResourceDemand(DefaultResourceEnvironment.getCPUProcessingResourceType());
        prd.setAction_ParametricResourceDemand((AbstractInternalControlFlowAction)internalAction);
    }
}

