/*
 * Decompiled with CFR 0.152.
 */
package org.somox.core.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.ModelAnalyzer;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.configuration.ConfigurationDefinition;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.core.SoMoXCore;
import org.somox.extractor.ExtractionResult;
import org.somox.extractor.SoftwareExtractor;

public class SoMoXCoreStandard
implements SoMoXCore {
    private HashMap<String, SoftwareExtractor> softwareExtractorMap = new HashMap();
    private HashMap<String, ModelAnalyzer> modelAnalyzerMap = new HashMap();
    private HashMap<String, ExtractionResult> extractionResultMap = new HashMap();
    private List<SoftwareExtractor> executedList = new LinkedList<SoftwareExtractor>();
    private ResourceSet resourceSet = null;
    private Logger logger = Logger.getLogger((String)SoMoXCoreStandard.class.getName());

    public SoMoXCoreStandard() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    @Override
    public void runExtraction(IProgressMonitor progressMonitor, HashMap<String, String> preferences) {
        this.logger.info((Object)"extraction started");
        for (Map.Entry<String, SoftwareExtractor> entry : this.softwareExtractorMap.entrySet()) {
            ExtractionResult result = entry.getValue().runExtraction(entry.getKey(), preferences);
            this.extractionResultMap.put(entry.getKey(), result);
            this.executedList.add(entry.getValue());
        }
        this.logger.info((Object)"extraction finished");
    }

    @Override
    public AnalysisResult runAnalyzer(String analyzerID, IProgressMonitor progressMonitor, HashMap<String, String> preferences, SoMoXConfiguration somoxConfiguration) throws ModelAnalyzerException {
        this.logger.info((Object)"analysis started");
        this.logger.info((Object)("analysis of results: " + this.extractionResultMap));
        this.logger.info((Object)("Start model analyzer (" + analyzerID + ")"));
        ModelAnalyzer analyzer = this.modelAnalyzerMap.get(analyzerID);
        if (analyzer == null) {
            this.logger.error((Object)("Model Analyzer " + analyzerID + " not available."), null);
            throw new ModelAnalyzerException("Model Analyzer not available");
        }
        AnalysisResult result = analyzer.analyze(somoxConfiguration, this.extractionResultMap, progressMonitor);
        this.logger.info((Object)("Analysis finished with result: " + (Object)((Object)result.getResultStatus())));
        return result;
    }

    @Override
    public void runExport(IProgressMonitor progressMonitor) {
    }

    @Override
    public void addSoftwareExtractor(String id, SoftwareExtractor extractor) {
        this.softwareExtractorMap.put(id, extractor);
    }

    @Override
    public void removeSoftwareExtractor(String id) {
        this.softwareExtractorMap.remove(id);
    }

    @Override
    public void addModelAnalyzer(String id, ModelAnalyzer analyzer) {
        this.modelAnalyzerMap.put(id, analyzer);
    }

    @Override
    public void removeModelAnalyzer(String id) {
        this.modelAnalyzerMap.remove(id);
    }

    @Override
    public List<SoftwareExtractor> getExecutedSoftwareExtractors() {
        return this.executedList;
    }

    @Override
    public LinkedList<ConfigurationDefinition> getConfigurationDefinitions() {
        LinkedList<ConfigurationDefinition> definitions = new LinkedList<ConfigurationDefinition>();
        definitions.addAll(this.getCoreConfigurationDefinitions());
        Iterator<SoftwareExtractor> extractors = this.softwareExtractorMap.values().iterator();
        while (extractors.hasNext()) {
            definitions.addAll(extractors.next().getConfigurationDefinitions());
        }
        return definitions;
    }

    @Override
    public LinkedList<ConfigurationDefinition> getGlobalConfigurationDefinitions() {
        LinkedList<ConfigurationDefinition> definitions = new LinkedList<ConfigurationDefinition>();
        return definitions;
    }

    private Collection<ConfigurationDefinition> getCoreConfigurationDefinitions() {
        LinkedList<ConfigurationDefinition> configs = new LinkedList<ConfigurationDefinition>();
        return configs;
    }
}

