/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.analyzer.simplemodelanalyzer.detection.IInitializationStrategy;
import org.somox.filter.BaseFilter;
import org.somox.filter.DataObjectFilter;
import org.somox.kdmhelper.KDMHelper;

public abstract class AbstractInitializationStrategy
implements IInitializationStrategy {
    protected static final BaseFilter<Type> primitiveClassesFilter = new BaseFilter<Type>(){

        public boolean passes(Type object) {
            return !KDMHelper.isPrimitive((Type)object);
        }
    };
    protected static final BaseFilter<Type> unknownClassTypeFilter = new BaseFilter<Type>(){

        public boolean passes(Type object) {
            return !object.getName().equals("<unknownClassType>");
        }
    };
    protected static final BaseFilter<Type> improperStructFilter = new BaseFilter<Type>(){

        public boolean passes(Type object) {
            return true;
        }

        private boolean hasVirtualMethod(Type clazz) {
            boolean hasVirtualMethod = false;
            for (MethodDeclaration method : KDMHelper.getMethods((Type)clazz)) {
                if (!KDMHelper.isVirtual((BodyDeclaration)method)) continue;
                hasVirtualMethod = true;
                break;
            }
            return hasVirtualMethod;
        }
    };
    protected static final BaseFilter<Type> dataObjectFilter = new DataObjectFilter();
}

