/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.vorto.generator;

import de.fzi.sensidl.language.ui.handler.SettingsHandler;
import de.fzi.sensidl.language.ui.wizard.SensidlWizard;
import de.fzi.sensidl.language.ui.wizard.SensidlWizardDialog;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.osgi.framework.Bundle;

public class TransformationHandler {
    private String path;
    private String language;

    public void execute(InformationModel infomodel) {
        Bundle bundle = Platform.getBundle((String)"de.fzi.sensidl.vorto.transformation");
        URL fileURL = bundle.getEntry("transforms/Vorto2SensIDLTransformation.qvto");
        TransformationExecutor executor = null;
        try {
            executor = new TransformationExecutor(URI.createURI((String)FileLocator.resolve((URL)fileURL).toURI().toString()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        BasicEList inObjects = new BasicEList();
        inObjects.add((Object)((EObject)infomodel.eContents().get(0)).eContainer());
        BasicModelExtent input = new BasicModelExtent((List)inObjects);
        BasicModelExtent output = new BasicModelExtent();
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        executor.execute((ExecutionContext)context, new ModelExtent[]{input, output});
        List res = output.getContents();
        final Resource resource = resourceSet.createResource(URI.createURI((String)("file:///" + ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + "/model.sidl")));
        resource.getContents().addAll((Collection)res);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TransformationHandler.this.loadSettings();
                SensidlWizard swizard = new SensidlWizard("platform:/resource/", TransformationHandler.this.path, TransformationHandler.this.language, resource);
                SensidlWizardDialog dialog = new SensidlWizardDialog(new Shell(), swizard);
                dialog.open();
            }
        });
    }

    private void loadSettings() {
        this.path = SettingsHandler.loadPathSettings();
        this.language = SettingsHandler.loadLanguageSettings();
    }
}

