/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.templates.java.opcua;

import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OpcUaUtil {
    private static final String NAMESPACE_SUFFIX = "Namespace";
    private static final String INTERFACE_NAME_SUFFIX = "DataSet";
    private static final String DATA_SET_PREFIX = "OpcUa";

    public static String getDefaultPackageName(SensorInterface sensorInterface) {
        return sensorInterface.getName();
    }

    public static String getServerNamespaceName(SensorInterface sensorInterface) {
        String _name = sensorInterface.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        return String.valueOf(_firstUpper) + NAMESPACE_SUFFIX;
    }

    public static CharSequence getDefaultServerUrn(SensorInterface sensorInterface) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"urn:");
        String _name = sensorInterface.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)":opcua:server");
        return _builder;
    }

    public static CharSequence getDefaultNamespaceUrn(SensorInterface sensorInterface) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"urn:opcua:server:namespace:");
        String _name = sensorInterface.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        return _builder;
    }

    public static CharSequence getDefaultClassName(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        String _plus = DATA_SET_PREFIX + _firstUpper;
        _builder.append((Object)_plus, "");
        return _builder;
    }

    public static CharSequence getDefaultClassName(SensorInterface sensorInterface) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = sensorInterface.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public static CharSequence getDefaultInterfaceName(SensorInterface sensorInterface) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = sensorInterface.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        String _plus = String.valueOf(_firstUpper) + INTERFACE_NAME_SUFFIX;
        _builder.append((Object)_plus, "");
        return _builder;
    }
}

