/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.generationstep;

import com.google.common.io.Files;
import de.fzi.sensidl.language.generator.generationstep.GenerationStep;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FileGenerationStep
extends GenerationStep {
    private static final Logger logger = Logger.getLogger(FileGenerationStep.class);
    private static final int LINE_LENGTH = 80;
    private static final String SEPARATION_STRING = ", ";
    private static final String UNIFIED_TAB_DISTANCE = "\t\t\t\t\t\t\t\t";
    private static final String START_SYMBOL = "*";
    private static final String DEFAUL_FILE_PATH = "";
    private static final String TEXT_FILE_EXTENSION = "txt";
    private final IFileSystemAccess fsa;
    private static String filePath;
    private HashMap<String, ArrayList<String>> fileCache;

    public FileGenerationStep(IFileSystemAccess newFsa) {
        this.fsa = newFsa;
        HashMap _hashMap = new HashMap();
        this.fileCache = _hashMap;
        filePath = DEFAUL_FILE_PATH;
    }

    public static String setFilePath(String newFilePath) {
        filePath = newFilePath;
        return filePath;
    }

    @Override
    public void startGenerationTask() {
        Set<String> _keySet = GenerationStep.filesToGenerate.keySet();
        for (String file : _keySet) {
            logger.info((Object)("Start with code-generation of file " + file));
            this.insertVersioningCommentTo(file);
            String _filePathOf = this.getFilePathOf(file);
            CharSequence _contentOf = this.getContentOf(file);
            this.fsa.generateFile(_filePathOf, _contentOf);
            logger.info((Object)("File " + file + " was successfully generated"));
        }
        this.refreshWorkspace();
    }

    private void refreshWorkspace() {
        try {
            Class.forName("org.eclipse.core.resources.ResourcesPlugin");
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        IProject[] _projects = _root.getProjects();
        Consumer<IProject> _function = new Consumer<IProject>(){

            @Override
            public void accept(IProject eachProject) {
                try {
                    eachProject.refreshLocal(2, null);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        ((List)Conversions.doWrapArray((Object)_projects)).forEach(_function);
    }

    private CharSequence getContentOf(String file) {
        return GenerationStep.filesToGenerate.get(file);
    }

    private String getFilePathOf(String file) {
        String _xblockexpression = null;
        boolean _isTextFile = this.isTextFile(file);
        if (_isTextFile) {
            return file;
        }
        _xblockexpression = String.valueOf(filePath) + file;
        return _xblockexpression;
    }

    public boolean isTextFile(String file) {
        String _extension = FilenameUtils.getExtension((String)file);
        return _extension.equals(TEXT_FILE_EXTENSION);
    }

    public CharSequence insertVersioningCommentTo(String file) {
        boolean _equals;
        CharSequence _xblockexpression = null;
        String _fileExtension = Files.getFileExtension((String)file);
        ArrayList<String> fileExtensions = this.createExtensions(_fileExtension);
        boolean _extensionsAlreadyInCache = this.extensionsAlreadyInCache(fileExtensions);
        boolean bl = _equals = !_extensionsAlreadyInCache;
        if (_equals) {
            this.getAllFilesWithSameExtension(fileExtensions);
        }
        CharSequence _get = GenerationStep.filesToGenerate.get(file);
        StringBuilder fileToEdit = new StringBuilder(_get);
        String _property = System.getProperty("line.separator");
        fileToEdit.insert(0, _property);
        CharSequence _versioningComment = this.getVersioningComment(fileExtensions, file);
        fileToEdit.insert(0, _versioningComment);
        _xblockexpression = GenerationStep.filesToGenerate.put(file, fileToEdit);
        return _xblockexpression;
    }

    public boolean extensionsAlreadyInCache(final ArrayList<String> fileExtensions) {
        Set<String> _keySet = this.fileCache.keySet();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(final String cachedExtension) {
                Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String fileExtension) {
                        return fileExtension.equals(cachedExtension);
                    }
                };
                return IterableExtensions.exists((Iterable)fileExtensions, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.exists(_keySet, (Functions.Function1)_function);
    }

    public ArrayList<String> createExtensions(final String fileExtension) {
        final String editedCExtension = Files.getFileExtension((String)".c");
        final String editedHeaderExtension = Files.getFileExtension((String)".h");
        if (fileExtension.equals(editedCExtension) || fileExtension.equals(editedHeaderExtension)) {
            ArrayList _arrayList = new ArrayList();
            Procedures.Procedure1<ArrayList<String>> _function = new Procedures.Procedure1<ArrayList<String>>(){

                public void apply(ArrayList<String> it) {
                    it.add(editedCExtension);
                    it.add(editedHeaderExtension);
                }
            };
            return (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        }
        ArrayList _arrayList_1 = new ArrayList();
        Procedures.Procedure1<ArrayList<String>> _function_1 = new Procedures.Procedure1<ArrayList<String>>(){

            public void apply(ArrayList<String> it) {
                it.add(fileExtension);
            }
        };
        return (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList_1, (Procedures.Procedure1)_function_1);
    }

    public String getUnifiedIdentifier(ArrayList<String> fileExtensions) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String unifiedIdentifier = _builder.toString();
        for (String ext : fileExtensions) {
            String _unifiedIdentifier = unifiedIdentifier;
            unifiedIdentifier = String.valueOf(_unifiedIdentifier) + "_" + ext;
        }
        _xblockexpression = unifiedIdentifier;
        return _xblockexpression;
    }

    public void getAllFilesWithSameExtension(ArrayList<String> fileExtensions) {
        ArrayList<String> files = new ArrayList<String>();
        Set<String> _keySet = GenerationStep.filesToGenerate.keySet();
        for (final String filename : _keySet) {
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String fileExtension) {
                    String _fileExtension = Files.getFileExtension((String)filename);
                    return _fileExtension.equals(fileExtension);
                }
            };
            boolean _exists = IterableExtensions.exists(fileExtensions, (Functions.Function1)_function);
            if (!_exists) continue;
            files.add(filename);
        }
        String _unifiedIdentifier = this.getUnifiedIdentifier(fileExtensions);
        this.fileCache.put(_unifiedIdentifier, files);
    }

    public CharSequence getVersioningComment(ArrayList<String> fileExtensions, String currentFileName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"*File:\t\t\t\t\t\t\t");
        _builder.append((Object)currentFileName, DEFAUL_FILE_PATH);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*Version:\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"*Generate at:\t\t\t\t\t");
        SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date _date = new Date();
        String _format = _simpleDateFormat.format(_date);
        _builder.append((Object)_format, DEFAUL_FILE_PATH);
        _builder.newLineIfNotEmpty();
        Object _printFiles = this.printFiles(currentFileName, fileExtensions);
        _builder.append(_printFiles, DEFAUL_FILE_PATH);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        return _builder;
    }

    public Object printFiles(String currentEditedFile, ArrayList<String> fileExtensions) {
        Object _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String filesToPrint = _builder.toString();
        int counter = 1;
        String _unifiedIdentifier = this.getUnifiedIdentifier(fileExtensions);
        ArrayList<String> files = this.fileCache.get(_unifiedIdentifier);
        String _filesToPrint = filesToPrint;
        filesToPrint = String.valueOf(_filesToPrint) + "*Further generated artifacts:\t";
        for (String currentFile : files) {
            int _length;
            boolean _greaterEqualsThan;
            boolean _not;
            boolean _equals = currentFile.equals(currentEditedFile);
            boolean bl = _not = !_equals;
            if (_not) {
                String _filesToPrint_1 = filesToPrint;
                String _filesToPrint_2 = filesToPrint = String.valueOf(_filesToPrint_1) + currentFile;
                filesToPrint = String.valueOf(_filesToPrint_2) + SEPARATION_STRING;
            }
            boolean bl2 = _greaterEqualsThan = (_length = filesToPrint.length()) >= 80 * counter;
            if (!_greaterEqualsThan) continue;
            String _filesToPrint_3 = filesToPrint;
            String _property = System.getProperty("line.separator");
            String _filesToPrint_4 = filesToPrint = String.valueOf(_filesToPrint_3) + _property;
            filesToPrint = String.valueOf(_filesToPrint_4) + "*\t\t\t\t\t\t\t\t";
            ++counter;
        }
        StringBuilder _stringBuilder = new StringBuilder(filesToPrint);
        _xblockexpression = this.postProcessing(_stringBuilder);
        return _xblockexpression;
    }

    /*
     * Unable to fully structure code
     */
    public Object postProcessing(StringBuilder filesToPrint) {
        _xblockexpression = null;
        comma = ",";
        _string = filesToPrint.toString();
        _contains = _string.contains(",");
        v0 = _not = _contains == false;
        if (!_not) ** GOTO lbl12
        return filesToPrint;
lbl-1000:
        // 1 sources

        {
            _length = filesToPrint.length();
            _minus = _length - 1;
            filesToPrint.deleteCharAt(_minus);
lbl12:
            // 2 sources

            ** while (!filesToPrint.toString().endsWith((String)","))
        }
lbl13:
        // 1 sources

        _length = filesToPrint.length();
        _minus = _length - 1;
        filesToPrint.deleteCharAt(_minus);
        _xblockexpression = filesToPrint.toString();
        return _xblockexpression;
    }
}

