/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.csharp;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CSharpDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(CSharpDTOGenerator.class);
    private boolean createEmptyConstructor = true;
    private List<DataSet> dataSet;
    private boolean createProject = false;

    public CSharpDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    public CSharpDTOGenerator(List<DataSet> newDataSet, boolean createProject) {
        this.dataSet = newDataSet;
        this.createProject = createProject;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a java data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        if (this.createProject) {
            for (DataSet d : this.dataSet) {
                DataSet _get = this.dataSet.get(0);
                EList _eContents = _get.eContents();
                Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
                Data _get_1 = ((Data[])Conversions.unwrapArray((Object)_filter, Data.class))[0];
                EObject _eContainer = _get_1.eContainer();
                String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
                String _plus = "src/de/fzi/sensidl/" + _sensorInterfaceName;
                String _plus_1 = String.valueOf(_plus) + "/";
                String _nameUpper = GenerationUtil.toNameUpper(d);
                String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
                String _plus_2 = String.valueOf(_plus_1) + _addFileExtensionTo;
                String _nameUpper_1 = GenerationUtil.toNameUpper(d);
                CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d);
                filesToGenerate.put(_plus_2, _generateClassBody);
                String _nameUpper_2 = GenerationUtil.toNameUpper(d);
                String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
                String _plus_3 = "File: " + _addFileExtensionTo_1;
                String _plus_4 = String.valueOf(_plus_3) + " was generated in ";
                String _plus_5 = String.valueOf(_plus_4) + "./src-gen";
                logger.info((Object)_plus_5);
            }
        } else {
            for (DataSet d_1 : this.dataSet) {
                String _nameUpper = GenerationUtil.toNameUpper(d_1);
                String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
                String _nameUpper_1 = GenerationUtil.toNameUpper(d_1);
                CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d_1);
                filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
                String _nameUpper_2 = GenerationUtil.toNameUpper(d_1);
                String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
                String _plus = "File: " + _addFileExtensionTo_1;
                String _plus_1 = String.valueOf(_plus) + " was generated in ";
                String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
                logger.info((Object)_plus_2);
            }
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClassBody(String className, DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"using Gson;");
        _builder.newLine();
        _builder.append((Object)"using System;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/// <summary>");
        _builder.newLine();
        _builder.append((Object)"/// Data transfer object for ");
        _builder.append((Object)className, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/// ");
        _builder.newLine();
        _builder.append((Object)"/// </summary>");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private long SerialVersionUid = 1L;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private GeneratedCodeAttribute generatedCodeAttribute = new GeneratedCodeAttribute(\"SensIDLCodeGenerator\", SerialVersionUid);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateDataFieldsIncludeusedDataSets = this.generateDataFieldsIncludeusedDataSets(d);
        _builder.append((Object)_generateDataFieldsIncludeusedDataSets, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"/// <summary>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/// Constructor for the Data transfer object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/// </summary>");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateConstructorIncludeusedDataSets = this.generateConstructorIncludeusedDataSets(d, className);
        _builder.append((Object)_generateConstructorIncludeusedDataSets, "\t");
        _builder.append((Object)"\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        if (this.createEmptyConstructor) {
            _builder.append((Object)"\t");
            _builder.append((Object)"/// <summary>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/// empty constructor for the Data transfer object");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/// </summary>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            _builder.append((Object)className, "\t");
            _builder.append((Object)"()");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateDataMethodsIncludeusedDataSets = this.generateDataMethodsIncludeusedDataSets(d);
        _builder.append((Object)_generateDataMethodsIncludeusedDataSets, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String generateDataFieldsIncludeusedDataSets(DataSet d) {
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String dataFieldsString = _builder.toString();
        EList _eContents = dataSet.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
        for (NonMeasurementData data : _filter) {
            String _dataFieldsString = dataFieldsString;
            CharSequence _generateDataFields = this.generateDataFields(data);
            String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateDataFields;
            String _property = System.getProperty("line.separator");
            dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
        }
        EList _eContents_1 = dataSet.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
        for (MeasurementData data_1 : _filter_1) {
            String _dataFieldsString = dataFieldsString;
            CharSequence _generateDataFields = this.generateDataFields(data_1);
            String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateDataFields;
            String _property = System.getProperty("line.separator");
            dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
        }
        EList _usedDataSets = dataSet.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            EList _eContents_2 = pdataSet.eContents();
            Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, NonMeasurementData.class);
            for (NonMeasurementData data_2 : _filter_2) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateDataFields = this.generateDataFields(data_2);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateDataFields;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
            EList _eContents_3 = pdataSet.eContents();
            Iterable _filter_3 = Iterables.filter((Iterable)_eContents_3, MeasurementData.class);
            for (MeasurementData data_3 : _filter_3) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateDataFields = this.generateDataFields(data_3);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateDataFields;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
        }
        return dataFieldsString;
    }

    public String generateConstructorIncludeusedDataSets(DataSet d, String className) {
        String constructorString;
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        _builder.append((Object)className, "");
        _builder.append((Object)" (");
        CharSequence _generateConstructorArgumentsIncludeusedDataSetss = this.generateConstructorArgumentsIncludeusedDataSetss(d);
        _builder.append((Object)_generateConstructorArgumentsIncludeusedDataSetss, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        String _constructorString = constructorString = _builder.toString();
        String _property = System.getProperty("line.separator");
        constructorString = String.valueOf(_constructorString) + _property;
        ArrayList measurementDataList = new ArrayList();
        ArrayList nonMeasurementDataList = new ArrayList();
        EList _eContents = dataSet.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
        Iterables.addAll(measurementDataList, (Iterable)_filter);
        EList _eContents_1 = dataSet.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_1);
        EList _usedDataSets = dataSet.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            EList _eContents_2 = pdataSet.eContents();
            Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, MeasurementData.class);
            Iterables.addAll(measurementDataList, (Iterable)_filter_2);
            EList _eContents_3 = pdataSet.eContents();
            Iterable _filter_3 = Iterables.filter((Iterable)_eContents_3, NonMeasurementData.class);
            Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_3);
        }
        for (MeasurementData data : measurementDataList) {
            String _constructorString_1 = constructorString;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"\t");
            _builder_1.append((Object)"this.");
            String _nameLower = GenerationUtil.toNameLower((Data)data);
            _builder_1.append((Object)_nameLower, "\t");
            _builder_1.append((Object)" = ");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
            _builder_1.append((Object)_nameLower_1, "\t");
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            constructorString = String.valueOf(_constructorString_1) + _builder_1;
        }
        for (NonMeasurementData data_1 : nonMeasurementDataList) {
            boolean _not;
            boolean _isConstant = data_1.isConstant();
            boolean bl = _not = !_isConstant;
            if (!_not) continue;
            String _constructorString_2 = constructorString;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"\t");
            _builder_2.append((Object)"this.");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)data_1);
            _builder_2.append((Object)_nameLower_2, "\t");
            _builder_2.append((Object)" = ");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)data_1);
            _builder_2.append((Object)_nameLower_3, "\t");
            _builder_2.append((Object)";");
            _builder_2.newLineIfNotEmpty();
            constructorString = String.valueOf(_constructorString_2) + _builder_2;
        }
        return constructorString;
    }

    public String generateDataMethodsIncludeusedDataSets(DataSet d) {
        String _property;
        String _methodsString_1;
        CharSequence _generateProperties;
        String _methodsString;
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String methodsString = _builder.toString();
        ArrayList measurementDataList = new ArrayList();
        ArrayList nonMeasurementDataList = new ArrayList();
        EList _eContents = dataSet.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
        Iterables.addAll(measurementDataList, (Iterable)_filter);
        EList _eContents_1 = dataSet.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_1);
        EList _usedDataSets = dataSet.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            EList _eContents_2 = dataSet.eContents();
            Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, MeasurementData.class);
            Iterables.addAll(measurementDataList, (Iterable)_filter_2);
            EList _eContents_3 = dataSet.eContents();
            Iterable _filter_3 = Iterables.filter((Iterable)_eContents_3, NonMeasurementData.class);
            Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_3);
        }
        for (MeasurementData data : measurementDataList) {
            _methodsString = methodsString;
            _generateProperties = this.generateProperties(data);
            _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateProperties;
            _property = System.getProperty("line.separator");
            methodsString = String.valueOf(_methodsString_1) + _property;
        }
        for (NonMeasurementData data_1 : nonMeasurementDataList) {
            _methodsString = methodsString;
            _generateProperties = this.generateProperties(data_1);
            _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateProperties;
            _property = System.getProperty("line.separator");
            methodsString = String.valueOf(_methodsString_1) + _property;
        }
        return methodsString;
    }

    public CharSequence generateDataFields(MeasurementData d) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/// <summary>");
        _builder.newLine();
        String _description = d.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)" /// ");
            String _description_1 = d.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"/// Unit: ");
        Unit _unit = d.getUnit();
        _builder.append((Object)_unit, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/// </summary>");
        _builder.newLine();
        _builder.append((Object)"private ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateDataFields(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            boolean _notEquals;
            StringConcatenation _builder = new StringConcatenation();
            String _description = d.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                _builder.append((Object)"/// <summary> ");
                _builder.newLine();
                _builder.append((Object)"/// ");
                String _description_1 = d.getDescription();
                _builder.append((Object)_description_1, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"/// </summary>");
                _builder.newLine();
            }
            _builder.append((Object)"private ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            CharSequence _propertyName = this.toPropertyName((Data)d);
            _builder.append((Object)_propertyName, "");
            _builder.append((Object)" = ");
            DataType _dataType = d.getDataType();
            boolean _equals = Objects.equal((Object)_dataType, (Object)DataType.STRING);
            if (_equals) {
                _builder.append((Object)"\"");
                String _value = d.getValue();
                _builder.append((Object)_value, "");
                _builder.append((Object)"\"");
            } else {
                String _value_1 = d.getValue();
                _builder.append((Object)_value_1, "");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            boolean _not;
            boolean _notEquals_1;
            StringConcatenation _builder_1 = new StringConcatenation();
            String _description_2 = d.getDescription();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_description_2, null);
            if (_notEquals_1) {
                _builder_1.append((Object)"/// <summary>");
                _builder_1.newLine();
                _builder_1.append((Object)"/// ");
                String _description_3 = d.getDescription();
                _builder_1.append((Object)_description_3, "");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append((Object)"/// </summary>");
                _builder_1.newLine();
            }
            _builder_1.append((Object)"private ");
            String _typeName_1 = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName_1, "");
            _builder_1.append((Object)" ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, "");
            String _value_2 = d.getValue();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_value_2);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                _builder_1.append((Object)" = ");
                DataType _dataType_1 = d.getDataType();
                boolean _equals_1 = Objects.equal((Object)_dataType_1, (Object)DataType.STRING);
                if (_equals_1) {
                    _builder_1.append((Object)"\"");
                    String _value_3 = d.getValue();
                    _builder_1.append((Object)_value_3, "");
                    _builder_1.append((Object)"\"");
                } else {
                    String _value_4 = d.getValue();
                    _builder_1.append((Object)_value_4, "");
                }
            }
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    @Override
    public String toTypeName(Data d) {
        String _switchResult = null;
        DataType _dataType = d.getDataType();
        if (_dataType != null) {
            switch (_dataType) {
                case INT8: {
                    _switchResult = "byte";
                    break;
                }
                case UINT8: {
                    _switchResult = "byte";
                    break;
                }
                case INT16: {
                    _switchResult = "short";
                    break;
                }
                case UINT16: {
                    _switchResult = "ushort";
                    break;
                }
                case INT32: {
                    _switchResult = "int";
                    break;
                }
                case UINT32: {
                    _switchResult = "uint";
                    break;
                }
                case INT64: {
                    _switchResult = "long";
                    break;
                }
                case UINT64: {
                    _switchResult = "ulong";
                    break;
                }
                case FLOAT: {
                    _switchResult = "float";
                    break;
                }
                case DOUBLE: {
                    _switchResult = "double";
                    break;
                }
                case BOOLEAN: {
                    _switchResult = "bool";
                    break;
                }
                case STRING: {
                    _switchResult = "string";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String toSimpleTypeName(Data d) {
        String _typeName = this.toTypeName(d);
        String _typeName_1 = this.toTypeName(d);
        int _lastIndexOf = _typeName_1.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        String _substring = _typeName.substring(_plus);
        return _substring.toLowerCase();
    }

    public CharSequence generateConstructorArgumentsIncludeusedDataSetss(DataSet d) {
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        ArrayList<Data> dataList = new ArrayList<Data>();
        DataSet dataSet = d;
        EList _eContents = dataSet.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            if (data instanceof NonMeasurementData) {
                boolean _not;
                Iterator nmdata = (NonMeasurementData)data;
                boolean _isConstant = nmdata.isConstant();
                boolean bl = _not = !_isConstant;
                if (!_not) continue;
                dataList.add(data);
                continue;
            }
            dataList.add(data);
        }
        EList _usedDataSets = dataSet.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            EList _eContents_1 = pdataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, Data.class);
            for (Data data_1 : _filter_1) {
                if (data_1 instanceof NonMeasurementData) {
                    boolean _not_1;
                    NonMeasurementData nmdata_1 = (NonMeasurementData)data_1;
                    boolean _isConstant_1 = nmdata_1.isConstant();
                    boolean bl = _not_1 = !_isConstant_1;
                    if (!_not_1) continue;
                    dataList.add(data_1);
                    continue;
                }
                dataList.add(data_1);
            }
        }
        StringConcatenation _xifexpression = null;
        int _size = dataList.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            StringConcatenation _xblockexpression_1 = null;
            Data _get = (Data)dataList.get(0);
            String _typeName = this.toTypeName(_get);
            String _plus = String.valueOf(_typeName) + " ";
            Data _get_1 = (Data)dataList.get(0);
            String _nameLower = GenerationUtil.toNameLower(_get_1);
            String firstElement = String.valueOf(_plus) + _nameLower;
            dataList.remove(0);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)firstElement, "");
            for (Data data_2 : dataList) {
                _builder.append((Object)", ");
                String _typeName_1 = this.toTypeName(data_2);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)" ");
                String _nameLower_1 = GenerationUtil.toNameLower(data_2);
                _builder.append((Object)_nameLower_1, "");
            }
            _xifexpression = _xblockexpression_1 = _builder;
        } else {
            StringConcatenation _builder;
            StringConcatenation _xblockexpression_2 = null;
            this.createEmptyConstructor = false;
            _xifexpression = _xblockexpression_2 = (_builder = new StringConcatenation());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence generateProperties(MeasurementData d) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (dataAdj instanceof DataRange) {
                    _builder.append((Object)"///");
                    _builder.newLine();
                    _builder.append((Object)"/// <param name=\"");
                    String _nameLower = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower, "");
                    _builder.append((Object)"\"> </param>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"///\t<returns>");
                    String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_1, "");
                    _builder.append((Object)"</returns>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"///");
                    _builder.newLine();
                    _builder.append((Object)"public ");
                    String _typeName = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName, "");
                    _builder.append((Object)" ");
                    CharSequence _propertyName = this.toPropertyName((Data)d);
                    _builder.append((Object)_propertyName, "");
                    _builder.append((Object)"()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"get { return ");
                    String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_2, "\t");
                    _builder.append((Object)"; }");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"set {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"if (value >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t\t");
                    _builder.append((Object)" && value <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_3, "\t\t\t");
                    _builder.append((Object)" = value;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"throw new IllegalArgumentException(\"value is out of defined range\");\t");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"} \t\t");
                    _builder.newLine();
                }
                if (!(dataAdj instanceof DataConversion)) continue;
                if (dataAdj instanceof LinearDataConversion) {
                    _builder.append((Object)"///");
                    _builder.newLine();
                    _builder.append((Object)"/// <param name=\"");
                    String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_4, "");
                    _builder.append((Object)"\"> </param>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"///\t<returns>");
                    String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_5, "");
                    _builder.append((Object)"</returns>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"///");
                    _builder.newLine();
                    _builder.append((Object)"public ");
                    String _typeName_1 = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName_1, "");
                    _builder.append((Object)" ");
                    CharSequence _propertyName_1 = this.toPropertyName((Data)d);
                    _builder.append((Object)_propertyName_1, "");
                    _builder.append((Object)"(){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"get { return ");
                    String _nameLower_6 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_6, "\t");
                    _builder.append((Object)"; }");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"set { ");
                    String _nameLower_7 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_7, "\t");
                    _builder.append((Object)" = value *  ");
                    double _scalingFactor = ((LinearDataConversion)dataAdj).getScalingFactor();
                    _builder.append((Object)_scalingFactor, "\t");
                    _builder.append((Object)" +  ");
                    double _offset = ((LinearDataConversion)dataAdj).getOffset();
                    _builder.append((Object)_offset, "\t");
                    _builder.append((Object)";}\t");
                    _builder.newLineIfNotEmpty();
                }
                if (!(dataAdj instanceof LinearDataConversionWithInterval)) continue;
                _builder.append((Object)"///");
                _builder.newLine();
                _builder.append((Object)"/// <param name=\"");
                String _nameLower_8 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_8, "");
                _builder.append((Object)"\"> </param>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"///\t<returns>");
                String _nameLower_9 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_9, "");
                _builder.append((Object)"</returns>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"///");
                _builder.newLine();
                _builder.append((Object)"public ");
                CharSequence _propertyName_2 = this.toPropertyName((Data)d);
                _builder.append((Object)_propertyName_2, "");
                _builder.append((Object)"() ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"get { return ");
                String _nameLower_10 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_10, "\t");
                _builder.append((Object)"; }");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"set {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"try {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                CharSequence _generateSetterBodyForMeasurementData = this.generateSetterBodyForMeasurementData(d, (DataConversion)dataAdj);
                _builder.append((Object)_generateSetterBodyForMeasurementData, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"} catch (IllegalArgumentException e) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"//Do something");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"///");
            _builder.newLine();
            _builder.append((Object)"/// <param name=\"");
            String _nameLower_11 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_11, "");
            _builder.append((Object)"\"> </param>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"///\t<returns>");
            String _nameLower_12 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_12, "");
            _builder.append((Object)"</returns>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"///");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _typeName_2 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_2, "");
            _builder.append((Object)" ");
            CharSequence _propertyName_3 = this.toPropertyName((Data)d);
            _builder.append((Object)_propertyName_3, "");
            _builder.append((Object)"()");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"get { return ");
            String _nameLower_13 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_13, "\t");
            _builder.append((Object)"; }");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"set { ");
            String _nameLower_14 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_14, "\t");
            _builder.append((Object)" = value; }");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateProperties(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            _builder.append((Object)"///");
            _builder.newLine();
            _builder.append((Object)"///\t<returns>");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower, "");
            _builder.append((Object)"</returns>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"///");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            CharSequence _propertyName = this.toPropertyName((Data)d);
            _builder.append((Object)_propertyName, "");
            _builder.append((Object)"()");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"get { return ");
            boolean _isConstant_1 = d.isConstant();
            if (_isConstant_1) {
                CharSequence _propertyName_1 = this.toPropertyName((Data)d);
                _builder.append((Object)_propertyName_1, "\t");
            } else {
                String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_1, "\t");
            }
            _builder.append((Object)"; }");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"///");
            _builder.newLine();
            _builder.append((Object)"/// <param name=\"");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_2, "");
            _builder.append((Object)"\"> </param>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"///\t<returns>");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_3, "");
            _builder.append((Object)"</returns>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"///");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _typeName_1 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_1, "");
            _builder.append((Object)" ");
            CharSequence _propertyName_2 = this.toPropertyName((Data)d);
            _builder.append((Object)_propertyName_2, "");
            _builder.append((Object)"()");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"get { return ");
            String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_4, "\t");
            _builder.append((Object)"; }");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"set { ");
            String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_5, "\t");
            _builder.append((Object)" = value; }");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence toPropertyName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversion conversion) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"double offset = ");
        double _offset = conversion.getOffset();
        _builder.append((Object)_offset, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"double scalingFactor = ");
        double _scalingFactor = conversion.getScalingFactor();
        _builder.append((Object)_scalingFactor, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(");
        String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)", scalingFactor, offset);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversionWithInterval conversion) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" oldMin = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        Interval _fromInterval = conversion.getFromInterval();
        double _lowerBound = _fromInterval.getLowerBound();
        _builder.append((Object)_lowerBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_1 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_1, "");
        _builder.append((Object)" oldMax = (");
        String _simpleTypeName_1 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_1, "");
        _builder.append((Object)") ");
        Interval _fromInterval_1 = conversion.getFromInterval();
        double _upperBound = _fromInterval_1.getUpperBound();
        _builder.append((Object)_upperBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_2 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_2, "");
        _builder.append((Object)" newMin = (");
        String _simpleTypeName_2 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_2, "");
        _builder.append((Object)") ");
        Interval _toInterval = conversion.getToInterval();
        double _lowerBound_1 = _toInterval.getLowerBound();
        _builder.append((Object)_lowerBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_3 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_3, "");
        _builder.append((Object)" newMax = (");
        String _simpleTypeName_3 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_3, "");
        _builder.append((Object)") ");
        Interval _toInterval_1 = conversion.getToInterval();
        double _upperBound_1 = _toInterval_1.getUpperBound();
        _builder.append((Object)_upperBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = ((((value - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".cs";
    }

    public CharSequence generateSetterBodyForMeasurementData(MeasurementData data, DataConversion conversion) {
        if (conversion instanceof LinearDataConversion) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversion)conversion);
        }
        if (conversion instanceof LinearDataConversionWithInterval) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversionWithInterval)conversion);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data, conversion).toString());
    }
}

