/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.javascript;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaScriptDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(JavaScriptDTOGenerator.class);
    private List<DataSet> dataSet;

    public JavaScriptDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a JavaScript data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet d : this.dataSet) {
            String _nameUpper = GenerationUtil.toNameUpper(d);
            String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
            String _nameUpper_1 = GenerationUtil.toNameUpper(d);
            CharSequence _generateClass = this.generateClass(_nameUpper_1, d);
            filesToGenerate.put(_addFileExtensionTo, _generateClass);
            String _nameUpper_2 = GenerationUtil.toNameUpper(d);
            String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
            String _plus = "File: " + _addFileExtensionTo_1;
            String _plus_1 = String.valueOf(_plus) + " was generated in ";
            String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
            logger.info((Object)_plus_2);
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClass(String name, DataSet dataset) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _description = dataset.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)"/* ");
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.append((Object)" */");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"var ");
        _builder.append((Object)name, "");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateBodyIncludeParentDataSet = this.generateBodyIncludeParentDataSet(dataset);
        _builder.append((Object)_generateBodyIncludeParentDataSet, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.newLine();
        return _builder;
    }

    public String generateBodyIncludeParentDataSet(DataSet d) {
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String bodyString = _builder.toString();
        ArrayList measurementDataList = new ArrayList();
        ArrayList nonMeasurementDataList = new ArrayList();
        EList _eContents = dataSet.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
        Iterables.addAll(measurementDataList, (Iterable)_filter);
        EList _eContents_1 = dataSet.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_1);
        EList _usedDataSets = dataSet.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            EList _eContents_2 = pdataSet.eContents();
            Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, MeasurementData.class);
            Iterables.addAll(measurementDataList, (Iterable)_filter_2);
            EList _eContents_3 = pdataSet.eContents();
            Iterable _filter_3 = Iterables.filter((Iterable)_eContents_3, NonMeasurementData.class);
            Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_3);
        }
        MeasurementData mdatalast = (MeasurementData)IterableExtensions.last(measurementDataList);
        NonMeasurementData nmdatalast = (NonMeasurementData)IterableExtensions.last(nonMeasurementDataList);
        for (NonMeasurementData nmdata : nonMeasurementDataList) {
            String _bodyString = bodyString;
            StringConcatenation _builder_1 = new StringConcatenation();
            boolean _isConstant = nmdata.isConstant();
            if (_isConstant) {
                boolean _notEquals_1;
                boolean _notEquals;
                _builder_1.append((Object)"_");
                String _name = nmdata.getName();
                String _upperCase = _name.toUpperCase();
                _builder_1.append((Object)_upperCase, "");
                String _value = nmdata.getValue();
                boolean bl = _notEquals = !Objects.equal((Object)_value, null);
                if (_notEquals) {
                    _builder_1.append((Object)" : ");
                    DataType _dataType = nmdata.getDataType();
                    boolean _equals = Objects.equal((Object)_dataType, (Object)DataType.STRING);
                    if (_equals) {
                        _builder_1.append((Object)"\"");
                        String _value_1 = nmdata.getValue();
                        _builder_1.append((Object)_value_1, "");
                        _builder_1.append((Object)"\"");
                    } else {
                        String _value_2 = nmdata.getValue();
                        _builder_1.append((Object)_value_2, "");
                    }
                }
                _builder_1.append((Object)",");
                String _description = nmdata.getDescription();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_description, null);
                if (_notEquals_1) {
                    _builder_1.append((Object)"/*");
                    String _description_1 = nmdata.getDescription();
                    _builder_1.append((Object)_description_1, "");
                    _builder_1.append((Object)" */");
                }
                _builder_1.newLineIfNotEmpty();
            } else {
                boolean _notEquals_3;
                boolean _notEquals_2;
                _builder_1.append((Object)"_");
                String _nameLower = GenerationUtil.toNameLower((Data)nmdata);
                _builder_1.append((Object)_nameLower, "");
                _builder_1.append((Object)" : ");
                String _value_3 = nmdata.getValue();
                boolean bl = _notEquals_2 = !Objects.equal((Object)_value_3, null);
                if (_notEquals_2) {
                    DataType _dataType_1 = nmdata.getDataType();
                    boolean _equals_1 = Objects.equal((Object)_dataType_1, (Object)DataType.STRING);
                    if (_equals_1) {
                        _builder_1.append((Object)"\"");
                        String _value_4 = nmdata.getValue();
                        _builder_1.append((Object)_value_4, "");
                        _builder_1.append((Object)"\"");
                    } else {
                        String _value_5 = nmdata.getValue();
                        _builder_1.append((Object)_value_5, "");
                    }
                } else {
                    DataType _dataType_2 = nmdata.getDataType();
                    boolean _equals_2 = Objects.equal((Object)_dataType_2, (Object)DataType.STRING);
                    if (_equals_2) {
                        _builder_1.append((Object)"\"\"");
                    } else {
                        _builder_1.append((Object)"0");
                    }
                }
                _builder_1.append((Object)",");
                String _description_2 = nmdata.getDescription();
                boolean bl3 = _notEquals_3 = !Objects.equal((Object)_description_2, null);
                if (_notEquals_3) {
                    _builder_1.append((Object)"/*");
                    String _description_3 = nmdata.getDescription();
                    _builder_1.append((Object)_description_3, "");
                    _builder_1.append((Object)" */");
                }
                _builder_1.newLineIfNotEmpty();
            }
            bodyString = String.valueOf(_bodyString) + _builder_1;
        }
        String _bodyString_1 = bodyString;
        String _property = System.getProperty("line.separator");
        bodyString = String.valueOf(_bodyString_1) + _property;
        for (MeasurementData mdata : measurementDataList) {
            String _bodyString_2 = bodyString;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"_");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)mdata);
            _builder_2.append((Object)_nameLower_1, "");
            _builder_2.append((Object)" : ");
            DataType _dataType_3 = mdata.getDataType();
            boolean _equals_3 = Objects.equal((Object)_dataType_3, (Object)DataType.STRING);
            if (_equals_3) {
                _builder_2.append((Object)"\"\"");
            } else {
                _builder_2.append((Object)"0");
            }
            _builder_2.append((Object)", /*");
            String _description_4 = mdata.getDescription();
            _builder_2.append((Object)_description_4, "");
            _builder_2.append((Object)" Measured in Unit: ");
            Unit _unit = mdata.getUnit();
            _builder_2.append((Object)_unit, "");
            _builder_2.append((Object)" */ ");
            _builder_2.newLineIfNotEmpty();
            bodyString = String.valueOf(_bodyString_2) + _builder_2;
        }
        String _bodyString_3 = bodyString;
        String _property_1 = System.getProperty("line.separator");
        bodyString = String.valueOf(_bodyString_3) + _property_1;
        for (NonMeasurementData nmdata_1 : nonMeasurementDataList) {
            String _bodyString_4 = bodyString;
            StringConcatenation _builder_3 = new StringConcatenation();
            CharSequence _generateGetter = this.generateGetter(nmdata_1);
            _builder_3.append((Object)_generateGetter, "");
            _builder_3.append((Object)",");
            _builder_3.newLineIfNotEmpty();
            CharSequence _generateSetter = this.generateSetter(nmdata_1, nmdatalast);
            _builder_3.append((Object)_generateSetter, "");
            _builder_3.newLineIfNotEmpty();
            bodyString = String.valueOf(_bodyString_4) + _builder_3;
        }
        for (MeasurementData mdata_1 : measurementDataList) {
            String _bodyString_5 = bodyString;
            StringConcatenation _builder_4 = new StringConcatenation();
            CharSequence _generateGetter_1 = this.generateGetter(mdata_1);
            _builder_4.append((Object)_generateGetter_1, "");
            _builder_4.append((Object)",");
            _builder_4.newLineIfNotEmpty();
            CharSequence _generateSetter_1 = this.generateSetter(mdata_1, mdatalast);
            _builder_4.append((Object)_generateSetter_1, "");
            _builder_4.newLineIfNotEmpty();
            bodyString = String.valueOf(_bodyString_5) + _builder_4;
        }
        return bodyString;
    }

    public CharSequence generateGetter(MeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)" : function(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this._");
        String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        return _builder;
    }

    public CharSequence generateGetter(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)" : function(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this._");
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append((Object)_upperCase, "\t");
        } else {
            String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, "\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        return _builder;
    }

    public CharSequence toGetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence generateSetter(NonMeasurementData d, NonMeasurementData last) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
        } else {
            boolean _not;
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            CharSequence _setterName = this.toSetterName((Data)d);
            _builder.append((Object)_setterName, "");
            _builder.append((Object)" : function(");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_2, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"this._");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_3, "\t");
            _builder.append((Object)" = ");
            String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_4, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            boolean _isConstant_1 = d.isConstant();
            boolean bl = _not = !_isConstant_1;
            if (!(!_not || d.equals(last) && Objects.equal((Object)last, null))) {
                _builder.append((Object)",");
            }
            _builder.append((Object)" ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
        }
        _builder.append((Object)"\t");
        return _builder;
    }

    public CharSequence generateSetter(MeasurementData d, MeasurementData last) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                boolean _not_2;
                if (dataAdj instanceof DataRange) {
                    boolean _not;
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*\t\t\tthe ");
                    String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_1, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    CharSequence _setterName = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName, "");
                    _builder.append((Object)" : function(");
                    String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_2, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_3, "\t");
                    _builder.append((Object)" >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t");
                    _builder.append((Object)" && ");
                    String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_4, "\t");
                    _builder.append((Object)" <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this._");
                    String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_5, "\t\t");
                    _builder.append((Object)" = ");
                    String _nameLower_6 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_6, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"alert(\"value ");
                    String _nameLower_7 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_7, "\t\t");
                    _builder.append((Object)" is out of defined range\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    boolean _equals_1 = d.equals(last);
                    boolean bl2 = _not = !_equals_1;
                    if (_not) {
                        _builder.append((Object)",");
                    }
                    _builder.append((Object)"  ");
                    _builder.newLineIfNotEmpty();
                }
                if (!(dataAdj instanceof DataConversion)) continue;
                if (dataAdj instanceof LinearDataConversion) {
                    boolean _not_1;
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower_8 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_8, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*\t\t\tthe ");
                    String _nameLower_9 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_9, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    CharSequence _setterName_1 = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName_1, "");
                    _builder.append((Object)" : function(");
                    String _nameLower_10 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_10, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"this._");
                    String _nameLower_11 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_11, "\t");
                    _builder.append((Object)" = ");
                    String _nameLower_12 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_12, "\t");
                    _builder.append((Object)" *  ");
                    double _scalingFactor = ((LinearDataConversion)dataAdj).getScalingFactor();
                    _builder.append((Object)_scalingFactor, "\t");
                    _builder.append((Object)" +  ");
                    double _offset = ((LinearDataConversion)dataAdj).getOffset();
                    _builder.append((Object)_offset, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    boolean _equals_2 = d.equals(last);
                    boolean bl3 = _not_1 = !_equals_2;
                    if (_not_1) {
                        _builder.append((Object)",");
                    }
                    _builder.append((Object)"   ");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (!(dataAdj instanceof LinearDataConversionWithInterval)) continue;
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param ");
                String _nameLower_13 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_13, " ");
                _builder.append((Object)"  ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*\t\t\tthe ");
                String _nameLower_14 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_14, " ");
                _builder.append((Object)" to set");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                CharSequence _setterName_2 = this.toSetterName((Data)d);
                _builder.append((Object)_setterName_2, "");
                _builder.append((Object)" : function(");
                String _nameLower_15 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_15, "");
                _builder.append((Object)"){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (");
                String _nameLower_16 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_16, "\t");
                _builder.append((Object)" >= ");
                Interval _fromInterval = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _lowerBound_1 = _fromInterval.getLowerBound();
                _builder.append((Object)_lowerBound_1, "\t");
                _builder.append((Object)" && ");
                String _nameLower_17 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_17, "\t");
                _builder.append((Object)" <= ");
                Interval _fromInterval_1 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _upperBound_1 = _fromInterval_1.getUpperBound();
                _builder.append((Object)_upperBound_1, "\t");
                _builder.append((Object)"){\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var oldMin =  ");
                Interval _fromInterval_2 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _lowerBound_2 = _fromInterval_2.getLowerBound();
                _builder.append((Object)_lowerBound_2, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var oldMax =  ");
                Interval _fromInterval_3 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _upperBound_2 = _fromInterval_3.getUpperBound();
                _builder.append((Object)_upperBound_2, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var newMin =  ");
                Interval _toInterval = ((LinearDataConversionWithInterval)dataAdj).getToInterval();
                double _lowerBound_3 = _toInterval.getLowerBound();
                _builder.append((Object)_lowerBound_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var newMax =  ");
                Interval _toInterval_1 = ((LinearDataConversionWithInterval)dataAdj).getToInterval();
                double _upperBound_3 = _toInterval_1.getUpperBound();
                _builder.append((Object)_upperBound_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this._");
                String _nameLower_18 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_18, "\t\t");
                _builder.append((Object)" =  ((((");
                String _nameLower_19 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_19, "\t\t");
                _builder.append((Object)" - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"alert(\"value ");
                String _nameLower_20 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_20, "\t\t");
                _builder.append((Object)" is out of defined source Interval\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                boolean _equals_3 = d.equals(last);
                boolean bl4 = _not_2 = !_equals_3;
                if (_not_2) {
                    _builder.append((Object)",");
                }
                _builder.append((Object)"  \t\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _not_3;
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param ");
            String _nameLower_21 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_21, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _nameLower_22 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_22, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            CharSequence _setterName_3 = this.toSetterName((Data)d);
            _builder.append((Object)_setterName_3, "");
            _builder.append((Object)" : function(");
            String _nameLower_23 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_23, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"this._");
            String _nameLower_24 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_24, "\t");
            _builder.append((Object)" = ");
            String _nameLower_25 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_25, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            boolean _equals_4 = d.equals(last);
            boolean bl5 = _not_3 = !_equals_4;
            if (_not_3) {
                _builder.append((Object)",");
            }
            _builder.append((Object)" ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
        }
        return _builder;
    }

    public CharSequence toSetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".js";
    }

    @Override
    public String toTypeName(Data data) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }
}

