/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.EncodingSettings;
import de.fzi.sensidl.design.sensidl.Endianness;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.language.extensions.todo.SensIDLTodoTaskCustomizer;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IUtilityGenerator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaUtilityGenerator
implements IUtilityGenerator {
    private static final Logger logger = Logger.getLogger(JavaUtilityGenerator.class);
    private final List<MeasurementData> data;
    private final List<DataSet> dataSets;
    private final SensorInterface currentSensorInterface;
    private final String packagePrefix;
    private boolean bigEndian;

    public JavaUtilityGenerator(List<EObject> newData, String newPackagePrefix) {
        SensorInterface _get;
        List _list_1;
        List _list;
        Iterable _filter = Iterables.filter(newData, MeasurementData.class);
        this.data = _list = IterableExtensions.toList((Iterable)_filter);
        Iterable _filter_1 = Iterables.filter(newData, DataSet.class);
        this.dataSets = _list_1 = IterableExtensions.toList((Iterable)_filter_1);
        Iterable _filter_2 = Iterables.filter(newData, SensorInterface.class);
        this.currentSensorInterface = _get = ((SensorInterface[])Conversions.unwrapArray((Object)_filter_2, SensorInterface.class))[0];
        this.packagePrefix = newPackagePrefix;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        boolean _equals;
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the java utility class.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        String utilityName = GenerationUtil.getUtilityName((EObject)this.currentSensorInterface);
        EncodingSettings _encodingSettings = this.currentSensorInterface.getEncodingSettings();
        Endianness _endianness = _encodingSettings.getEndianness();
        this.bigEndian = _equals = Objects.equal((Object)_endianness, (Object)Endianness.BIG_ENDIAN);
        String _addFileExtensionTo = this.addFileExtensionTo(utilityName);
        CharSequence _generateClassBody = this.generateClassBody(utilityName);
        filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
        String _addFileExtensionTo_1 = this.addFileExtensionTo(utilityName);
        String _plus = "File: " + _addFileExtensionTo_1;
        String _plus_1 = String.valueOf(_plus) + " was generated in ";
        String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
        logger.info((Object)_plus_2);
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClassBody(String className) {
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packagePrefix, "");
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName((EObject)this.currentSensorInterface);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.io.BufferedReader;");
        _builder.newLine();
        _builder.append((Object)"import java.io.ByteArrayInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.append((Object)"import java.io.ObjectInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.Serializable;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.Gson;");
        _builder.newLine();
        if (!this.bigEndian) {
            _builder.append((Object)"import java.nio.ByteBuffer;");
            _builder.newLine();
            _builder.append((Object)"import java.nio.ByteOrder;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Data transfer object for ");
        _builder.append((Object)className, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        int _size = this.data.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append((Object)"\t");
            CharSequence _generateConversionMethods = this.generateConversionMethods();
            _builder.append((Object)_generateConversionMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        if (!this.bigEndian) {
            _builder.append((Object)"\t");
            CharSequence _generateEndiannessConverterMethods = this.generateEndiannessConverterMethods();
            _builder.append((Object)_generateEndiannessConverterMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        int _size_1 = this.dataSets.size();
        boolean bl2 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append((Object)"\t");
            CharSequence _generateMarshallingMethods = this.generateMarshallingMethods();
            _builder.append((Object)_generateMarshallingMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMarshallingMethods() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateJsonMarshal = this.generateJsonMarshal();
        _builder.append((Object)_generateJsonMarshal, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateJsonUnmarshal = this.generateJsonUnmarshal();
        _builder.append((Object)_generateJsonUnmarshal, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateByteArrayUnmarshal = this.generateByteArrayUnmarshal();
        _builder.append((Object)_generateByteArrayUnmarshal, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (DataSet dataSet : this.dataSets) {
            CharSequence _generateByteArrayMarshal = this.generateByteArrayMarshal(dataSet);
            _builder.append((Object)_generateByteArrayMarshal, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateJsonUnmarshal() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Alternative method responsible for deserializing the received");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* JSON-formatted L stage from sensor.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param dataset");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the dataset to unmarshall incoming from sensor side in a JSON");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            format");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return T unmarshalled T structure");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static <T> T unmarshalJSON(BufferedReader dataset, T obj) { ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Gson gson = new Gson();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"BufferedReader br = dataset;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"obj = (T) gson.fromJson(br, obj.getClass());");
        _builder.newLine();
        if (!this.bigEndian) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// use little endianness ");
            _builder.newLine();
            for (DataSet dataSet : this.dataSets) {
                _builder.append((Object)"\t");
                _builder.append((Object)"if (obj instanceof ");
                String _nameUpper = GenerationUtil.toNameUpper(dataSet);
                _builder.append((Object)_nameUpper, "\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"((");
                String _nameUpper_1 = GenerationUtil.toNameUpper(dataSet);
                _builder.append((Object)_nameUpper_1, "\t\t");
                _builder.append((Object)") obj).");
                _builder.append((Object)"convertAllToLittleEndian", "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
            }
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return obj;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateJsonMarshal() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Alternative method responsible for serializing JSON");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return Json String");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static String marshalJSON(Object elementToMarshall) { ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Gson gson = new Gson();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (DataSet dataSet : this.dataSets) {
            _builder.append((Object)"\t");
            _builder.append((Object)"if (elementToMarshall instanceof ");
            String _nameUpper = GenerationUtil.toNameUpper(dataSet);
            _builder.append((Object)_nameUpper, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            if (this.bigEndian) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return gson.toJson((");
                String _nameUpper_1 = GenerationUtil.toNameUpper(dataSet);
                _builder.append((Object)_nameUpper_1, "\t\t");
                _builder.append((Object)") elementToMarshall);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"// use little endianness");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"((");
                String _nameUpper_2 = GenerationUtil.toNameUpper(dataSet);
                _builder.append((Object)_nameUpper_2, "\t\t");
                _builder.append((Object)") elementToMarshall).");
                _builder.append((Object)"convertAllToLittleEndian", "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return gson.toJson(((");
                String _nameUpper_3 = GenerationUtil.toNameUpper(dataSet);
                _builder.append((Object)_nameUpper_3, "\t\t");
                _builder.append((Object)") elementToMarshall));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateByteArrayUnmarshal() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Method responsible for deserializing the received byte array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* representation of L from sensor.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param dataset");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the dataset to unmarshall incoming from sensor side as a byte");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return T unmarshalled T structure");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws IOException");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws ClassNotFoundException");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static <T> T unmarshalByteArray(byte[] dataset) throws IOException, ClassNotFoundException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ByteArrayInputStream in = new ByteArrayInputStream(dataset);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ObjectInputStream ois = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ois = new ObjectInputStream(in);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Object o = ois.readObject();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"T unmarshalledObject = (T) o; // ");
        String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
        _builder.append((Object)_sensIDLTodoTag, "\t");
        _builder.append((Object)": Ensure the type conversion is valid");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"in.close();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (in != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ois.close();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return unmarshalledObject;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateByteArrayMarshal(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Method responsible for serializing Byte-Array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static ");
        String _nameUpper = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" marshal");
        String _nameUpper_1 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)"ByteArray() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
        _builder.append((Object)_sensIDLTodoTag, "\t");
        _builder.append((Object)": implement Method");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateConversionMethods() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<MeasurementData, Boolean> _function = new Functions.Function1<MeasurementData, Boolean>(){

            public Boolean apply(MeasurementData data) {
                EList _adjustments = data.getAdjustments();
                DataAdjustment _get = (DataAdjustment)_adjustments.get(0);
                return _get instanceof LinearDataConversion;
            }
        };
        boolean _exists = IterableExtensions.exists(this.data, (Functions.Function1)_function);
        if (_exists) {
            CharSequence _generateLinearDataConversionMethod = this.generateLinearDataConversionMethod();
            _builder.append((Object)_generateLinearDataConversionMethod, "");
            _builder.newLineIfNotEmpty();
            CharSequence _generateGetMaxValueOfMethod = this.generateGetMaxValueOfMethod();
            _builder.append((Object)_generateGetMaxValueOfMethod, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1<MeasurementData, Boolean> _function_1 = new Functions.Function1<MeasurementData, Boolean>(){

            public Boolean apply(MeasurementData data) {
                EList _adjustments = data.getAdjustments();
                DataAdjustment _get = (DataAdjustment)_adjustments.get(0);
                return _get instanceof LinearDataConversionWithInterval;
            }
        };
        boolean _exists_1 = IterableExtensions.exists(this.data, (Functions.Function1)_function_1);
        if (_exists_1) {
            CharSequence _generateLinearDataConversionWithIntervalMethod = this.generateLinearDataConversionWithIntervalMethod();
            _builder.append((Object)_generateLinearDataConversionWithIntervalMethod, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateLinearDataConversionMethod() {
        StringConcatenation _xblockexpression = null;
        String dataType = "double";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public static ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" ");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(Number independentVariable, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" scalingFactor, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" offset) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Conversion is calculated by the linear-function f(x) = m*x + b");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"double calculatedValue = (scalingFactor * independentVariable.doubleValue()) + offset;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (getMaxValueOf(independentVariable) >= calculatedValue) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return calculatedValue;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"The value is larger than the range of the data type.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateLinearDataConversionWithIntervalMethod() {
        StringConcatenation _xblockexpression = null;
        String dataType = "double";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public static ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" ");
        _builder.append((Object)"linearConversionWithInterval", "");
        _builder.append((Object)"(Number independentVariable, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" oldMin, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" oldMax, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" newMin, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" newMax) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Conversion is calculated by the mapping rule f(x) = (((x - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (independentVariable.doubleValue() < oldMin || independentVariable.doubleValue() > oldMax) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"The value is larger than specified minimal and maximal range.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (((independentVariable.doubleValue() - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateGetMaxValueOfMethod() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"private static double getMaxValueOf(Number number) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (number instanceof Byte) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Byte.MAX_VALUE;\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Short) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Short.MAX_VALUE;\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Integer) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Integer.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Long) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Long.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Float) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Float.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Double.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateEndiannessConverterMethods() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian float into a little endian float");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param num the float to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return float the converted float");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static float convertToLittleEndian(float num) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"byte[] bytes = new byte[4];");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ByteBuffer.wrap(bytes).putFloat(num);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian double into a little endian double");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param num the double to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return double the converted double");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static double convertToLittleEndian(double num) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"byte[] bytes = new byte[8];");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ByteBuffer.wrap(bytes).putDouble(num);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getDouble();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian byte into a little endian byte");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param num the byte to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return byte the converted byte");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static byte convertToLittleEndian(byte num) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return num;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian short into a little endian short");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param num the short to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return short the converted short");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static short convertToLittleEndian(short num) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return Short.reverseBytes(num);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian int into a little endian int");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param num the int to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return int the converted int");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static int convertToLittleEndian(int num) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return Integer.reverseBytes(num);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian long into a little endian long");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param num the long to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return long the converted long");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static long convertToLittleEndian(long num) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return Long.reverseBytes(num);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian String into a little endian String");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param str the String to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return String the converted String");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static String convertToLittleEndian(String str) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
        _builder.append((Object)_sensIDLTodoTag, "\t");
        _builder.append((Object)": implement Method");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return str;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Converts a big endian boolean into a little endian boolean");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param bool the boolean to convert");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return boolean the converted boolean");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static boolean convertToLittleEndian(boolean bool) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//");
        String _sensIDLTodoTag_1 = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
        _builder.append((Object)_sensIDLTodoTag_1, "\t");
        _builder.append((Object)": implement Method");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return bool;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".java";
    }
}

