/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.c;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.EncodingSettings;
import de.fzi.sensidl.design.sensidl.Endianness;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Method;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.c.CDTOGenerator;
import de.fzi.sensidl.language.generator.factory.c.DataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CDTOFileGenerator
extends CDTOGenerator {
    private static Logger logger = Logger.getLogger(CDTOFileGenerator.class);
    private boolean bigEndian;

    public CDTOFileGenerator(List<DataSet> newDataSet) {
        super(newDataSet);
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        DataSet _get = (DataSet)this.dataSets.get(0);
        EList _eContents = _get.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        Data _get_1 = ((Data[])Conversions.unwrapArray((Object)_filter, Data.class))[0];
        EObject _eContainer = _get_1.eContainer();
        SensorInterface _sensorInterface = GenerationUtil.getSensorInterface(_eContainer);
        EncodingSettings _encodingSettings = _sensorInterface.getEncodingSettings();
        Endianness _endianness = _encodingSettings.getEndianness();
        boolean _equals = Objects.equal((Object)_endianness, (Object)Endianness.BIG_ENDIAN);
        this.bigEndian = _equals;
        logger.info((Object)"Start with code-generation of a c data transfer object.");
        for (DataSet dataset : this.dataSets) {
            String _nameUpper = GenerationUtil.toNameUpper(dataset);
            String fileName = this.addFileExtensionTo(_nameUpper);
            CharSequence _generateStructDeclaration = this.generateStructDeclaration(dataset);
            filesToGenerate.put(fileName, _generateStructDeclaration);
        }
        String _addFileExtensionTo = this.addFileExtensionTo("DataMarshalling");
        String _string = _addFileExtensionTo.toString();
        String _plus = "File: " + _string;
        String _plus_1 = String.valueOf(_plus) + " was generated in ";
        String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
        logger.info((Object)_plus_2);
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateStructDeclaration(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**\\brief\t\t");
        _builder.newLine();
        CharSequence _generateDescription = this.generateDescription(dataset);
        _builder.append((Object)_generateDescription, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _nameUpper = GenerationUtil.toNameUpper(dataset);
        String _plus = String.valueOf(_nameUpper) + ".h";
        _builder.append((Object)_plus, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        String _generateInitDatasetDeclaration = this.generateInitDatasetDeclaration(dataset);
        _builder.append((Object)_generateInitDatasetDeclaration, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateMethods = this.generateMethods(dataset);
        _builder.append((Object)_generateMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateDataMethodsIncludeUsedDataSets = this.generateDataMethodsIncludeUsedDataSets(dataset);
        _builder.append((Object)_generateDataMethodsIncludeUsedDataSets, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateEndiannessMethodsDeclarations = this.generateEndiannessMethodsDeclarations(dataset);
        _builder.append((Object)_generateEndiannessMethodsDeclarations, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateMarshalingJSONMethods = this.generateMarshalingJSONMethods(dataset);
        _builder.append((Object)_generateMarshalingJSONMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public String generateInitDatasetDeclaration(final DataSet d) {
        String methodsString;
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<DataSet>> _function = new Procedures.Procedure1<ArrayList<DataSet>>(){

            public void apply(ArrayList<DataSet> it) {
                it.add(d);
                EList _usedDataSets = d.getUsedDataSets();
                it.addAll((Collection<DataSet>)_usedDataSets);
            }
        };
        ArrayList dataSets = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        String _methodsString = methodsString = _builder.toString();
        CharSequence _generateInitTemplateStart = this.generateInitTemplateStart(d);
        methodsString = String.valueOf(_methodsString) + _generateInitTemplateStart;
        for (DataSet dataSet : dataSets) {
            String _methodsString_1 = methodsString;
            CharSequence _generateInit = this.generateInit(dataSet);
            methodsString = String.valueOf(_methodsString_1) + _generateInit;
        }
        String _methodsString_2 = methodsString;
        CharSequence _generateInitTemplateEnd = this.generateInitTemplateEnd(d);
        methodsString = String.valueOf(_methodsString_2) + _generateInitTemplateEnd;
        return methodsString;
    }

    public CharSequence generateInit(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = dataset.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
        for (NonMeasurementData data : _filter) {
            boolean _notEquals;
            String _value = data.getValue();
            boolean bl = _notEquals = !Objects.equal((Object)_value, null);
            if (!_notEquals) continue;
            _builder.append((Object)"p->");
            String _name = data.getName();
            String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)" = ");
            DataType _dataType = data.getDataType();
            boolean _equals = Objects.equal((Object)_dataType, (Object)DataType.STRING);
            if (_equals) {
                _builder.append((Object)"\"");
                String _value_1 = data.getValue();
                _builder.append((Object)_value_1, "");
                _builder.append((Object)"\"");
            } else {
                String _value_2 = data.getValue();
                _builder.append((Object)_value_2, "");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateInitTemplateStart(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"void init_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateInitTemplateEnd(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMethods(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Method.class);
        for (Method method : _filter) {
            boolean _not;
            _builder.newLine();
            String _methodReturnType = this.getMethodReturnType(method);
            _builder.append((Object)_methodReturnType, "");
            _builder.append((Object)" ");
            String _name = method.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"(");
            String _methodParameter = this.getMethodParameter(method);
            _builder.append((Object)_methodParameter, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"//TODO: Auto Generated method stub");
            _builder.newLine();
            String _methodReturnType_1 = this.getMethodReturnType(method);
            boolean _equals = _methodReturnType_1.equals("void");
            boolean bl = _not = !_equals;
            if (_not) {
                _builder.append((Object)"\t");
                _builder.append((Object)"return 0;");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public String getMethodReturnType(Method method) {
        boolean _notEquals_1;
        boolean _notEquals;
        DataType _returnType = method.getReturnType();
        boolean bl = _notEquals = !Objects.equal((Object)_returnType, (Object)DataType.UNDEFINED);
        if (_notEquals) {
            DataType _returnType_1 = method.getReturnType();
            return this.toTypeName(_returnType_1);
        }
        DataSet _returnTypeDataSet = method.getReturnTypeDataSet();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_returnTypeDataSet, null);
        if (_notEquals_1) {
            DataSet _returnTypeDataSet_1 = method.getReturnTypeDataSet();
            return _returnTypeDataSet_1.getName();
        }
        return "void";
    }

    public String getMethodParameter(Method method) {
        boolean _greaterThan;
        String str = "";
        EList _parameter = method.getParameter();
        int _size = _parameter.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _notEquals;
            EList _parameter_1 = method.getParameter();
            MethodParameter _head = (MethodParameter)IterableExtensions.head((Iterable)_parameter_1);
            DataType _dataType = _head.getDataType();
            boolean bl2 = _notEquals = !Objects.equal((Object)_dataType, (Object)DataType.UNDEFINED);
            if (_notEquals) {
                String _plus_1;
                EList _parameter_2 = method.getParameter();
                MethodParameter _head_1 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_2);
                DataType _dataType_1 = _head_1.getDataType();
                String _typeName = this.toTypeName(_dataType_1);
                String _plus = String.valueOf(_typeName) + " ";
                EList _parameter_3 = method.getParameter();
                MethodParameter _head_2 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_3);
                String _name = _head_2.getName();
                str = _plus_1 = String.valueOf(_plus) + _name;
            } else {
                boolean _notEquals_1;
                EList _parameter_4 = method.getParameter();
                MethodParameter _head_3 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_4);
                DataSet _dataTypeDataSet = _head_3.getDataTypeDataSet();
                boolean bl3 = _notEquals_1 = !Objects.equal((Object)_dataTypeDataSet, null);
                if (_notEquals_1) {
                    String _plus_3;
                    EList _parameter_5 = method.getParameter();
                    MethodParameter _head_4 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_5);
                    DataSet _dataTypeDataSet_1 = _head_4.getDataTypeDataSet();
                    String _name_1 = _dataTypeDataSet_1.getName();
                    String _plus_2 = String.valueOf(_name_1) + " ";
                    EList _parameter_6 = method.getParameter();
                    MethodParameter _head_5 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_6);
                    String _name_2 = _head_5.getName();
                    str = _plus_3 = String.valueOf(_plus_2) + _name_2;
                }
            }
            EList _parameter_7 = method.getParameter();
            Iterable _tail = IterableExtensions.tail((Iterable)_parameter_7);
            for (MethodParameter p : _tail) {
                boolean _notEquals_3;
                boolean _notEquals_2;
                DataType _dataType_2 = p.getDataType();
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)_dataType_2, (Object)DataType.UNDEFINED);
                if (_notEquals_2) {
                    String _str = str;
                    DataType _dataType_3 = p.getDataType();
                    String _typeName_1 = this.toTypeName(_dataType_3);
                    String _plus_4 = ", " + _typeName_1;
                    String _plus_5 = String.valueOf(_plus_4) + " ";
                    String _name_3 = p.getName();
                    String _plus_6 = String.valueOf(_plus_5) + _name_3;
                    str = String.valueOf(_str) + _plus_6;
                    continue;
                }
                DataSet _dataTypeDataSet_2 = p.getDataTypeDataSet();
                boolean bl5 = _notEquals_3 = !Objects.equal((Object)_dataTypeDataSet_2, null);
                if (!_notEquals_3) continue;
                String _str_1 = str;
                DataSet _dataTypeDataSet_3 = p.getDataTypeDataSet();
                String _name_4 = _dataTypeDataSet_3.getName();
                String _plus_7 = ", " + _name_4;
                String _plus_8 = String.valueOf(_plus_7) + " ";
                String _name_5 = p.getName();
                String _plus_9 = String.valueOf(_plus_8) + _name_5;
                str = String.valueOf(_str_1) + _plus_9;
            }
        }
        return str;
    }

    public String generateDataMethodsIncludeUsedDataSets(final DataSet d) {
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<DataSet>> _function = new Procedures.Procedure1<ArrayList<DataSet>>(){

            public void apply(ArrayList<DataSet> it) {
                it.add(d);
                EList _usedDataSets = d.getUsedDataSets();
                it.addAll((Collection<DataSet>)_usedDataSets);
            }
        };
        ArrayList dataSets = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        String methodsString = _builder.toString();
        DataSet usedDataSets = d;
        for (DataSet dataSet : dataSets) {
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
            for (NonMeasurementData data : _filter) {
                EList _excludedMethods_1;
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                EList _excludedMethods = data.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"getter");
                boolean bl = _not = !_contains;
                if (_not) {
                    String _methodsString = methodsString;
                    CharSequence _generateGetterDeclaration = this.generateGetterDeclaration(data, usedDataSets);
                    String _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetterDeclaration;
                    String _property = System.getProperty("line.separator");
                    methodsString = String.valueOf(_methodsString_1) + _property;
                }
                boolean bl2 = _not_1 = !(_contains_1 = (_excludedMethods_1 = data.getExcludedMethods()).contains((Object)"setter"));
                if (!_not_1) continue;
                String _methodsString_2 = methodsString;
                CharSequence _generateSetterDeclaration = this.generateSetterDeclaration((Data)data, usedDataSets);
                String _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetterDeclaration;
                String _property_1 = System.getProperty("line.separator");
                methodsString = String.valueOf(_methodsString_3) + _property_1;
            }
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
            for (MeasurementData data_1 : _filter_1) {
                EList _excludedMethods_1;
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                EList _excludedMethods = data_1.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"getter");
                boolean bl = _not = !_contains;
                if (_not) {
                    String _methodsString = methodsString;
                    CharSequence _generateGetterDeclaration = this.generateGetterDeclaration(data_1, usedDataSets);
                    String _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetterDeclaration;
                    String _property = System.getProperty("line.separator");
                    methodsString = String.valueOf(_methodsString_1) + _property;
                }
                boolean bl3 = _not_1 = !(_contains_1 = (_excludedMethods_1 = data_1.getExcludedMethods()).contains((Object)"setter"));
                if (!_not_1) continue;
                String _methodsString_2 = methodsString;
                CharSequence _generateSetterDeclaration = this.generateSetterDeclaration((Data)data_1, usedDataSets);
                String _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetterDeclaration;
                String _property_1 = System.getProperty("line.separator");
                methodsString = String.valueOf(_methodsString_3) + _property_1;
            }
        }
        return methodsString;
    }

    public CharSequence generateGetterDeclaration(MeasurementData d, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasLinearDataConversionWithInterval = this.hasLinearDataConversionWithInterval(d);
        boolean bl = _not = !_hasLinearDataConversionWithInterval;
        if (_not) {
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" get_");
            String _name = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"_");
            String _name_1 = d.getName();
            String _replaceAll = _name_1.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"(");
            String _name_2 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"* p) { return p->");
            String _name_3 = d.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)"; }");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _generateAdjustedGetterPrototypes = this.generateAdjustedGetterPrototypes(d, dataset);
            _builder.append((Object)_generateAdjustedGetterPrototypes, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateAdjustedGetterPrototypes(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _returnDataType = this.getReturnDataType(d);
        _builder.append((Object)_returnDataType, "");
        _builder.append((Object)" get_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_");
        String _name_1 = d.getName();
        String _replaceAll = _name_1.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_2 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p) { return p->");
        String _name_3 = d.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"Adjusted; }");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_4 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"_");
        String _name_5 = d.getName();
        String _replaceAll_1 = _name_5.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll_1, "");
        _builder.append((Object)"NotAdjusted(");
        String _name_6 = dataset.getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_6);
        _builder.append((Object)_firstUpper_3, "");
        _builder.append((Object)"* p) { return p->");
        String _name_7 = d.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)"; }");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetterDeclaration(NonMeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_");
        String _name_1 = d.getName();
        String _replaceAll = _name_1.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_2 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p) { return p->");
        String _name_3 = d.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"; }");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateSetterDeclaration(MeasurementData d, DataSet dataset) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (dataAdj instanceof DataRange) {
                    _builder.append((Object)"void set_");
                    String _name = dataset.getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    _builder.append((Object)_firstUpper, "");
                    _builder.append((Object)"_");
                    String _name_1 = d.getName();
                    String _replaceAll = _name_1.replaceAll("[^a-zA-Z0-9]", "");
                    _builder.append((Object)_replaceAll, "");
                    _builder.append((Object)"(");
                    String _name_2 = dataset.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"* p, ");
                    String _typeName = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName, "");
                    _builder.append((Object)" ");
                    String _name_3 = d.getName();
                    String _firstLower = StringExtensions.toFirstLower((String)_name_3);
                    _builder.append((Object)_firstLower, "");
                    _builder.append((Object)" ){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _name_4 = d.getName();
                    String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
                    _builder.append((Object)_firstLower_1, "\t");
                    _builder.append((Object)" >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t");
                    _builder.append((Object)" && ");
                    String _name_5 = d.getName();
                    String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
                    _builder.append((Object)_firstLower_2, "\t");
                    _builder.append((Object)" <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t ");
                    _builder.append((Object)"p->");
                    String _name_6 = d.getName();
                    String _firstLower_3 = StringExtensions.toFirstLower((String)_name_6);
                    _builder.append((Object)_firstLower_3, "\t\t ");
                    _builder.append((Object)" = ");
                    String _name_7 = d.getName();
                    String _firstLower_4 = StringExtensions.toFirstLower((String)_name_7);
                    _builder.append((Object)_firstLower_4, "\t\t ");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"//Do something");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.newLine();
                if (!(dataAdj instanceof DataConversion)) continue;
                if (dataAdj instanceof LinearDataConversion) {
                    _builder.append((Object)"void set_");
                    String _name_8 = dataset.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_8);
                    _builder.append((Object)_firstUpper_2, "");
                    _builder.append((Object)"_");
                    String _name_9 = d.getName();
                    String _replaceAll_1 = _name_9.replaceAll("[^a-zA-Z0-9]", "");
                    _builder.append((Object)_replaceAll_1, "");
                    _builder.append((Object)"_WithDataConversion(");
                    String _name_10 = dataset.getName();
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_10);
                    _builder.append((Object)_firstUpper_3, "");
                    _builder.append((Object)"* p, ");
                    String _typeName_1 = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName_1, "");
                    _builder.append((Object)" ");
                    String _name_11 = d.getName();
                    String _firstLower_5 = StringExtensions.toFirstLower((String)_name_11);
                    _builder.append((Object)_firstLower_5, "");
                    _builder.append((Object)" ){\t\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"p->");
                    String _name_12 = d.getName();
                    String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
                    _builder.append((Object)_firstLower_6, "\t");
                    _builder.append((Object)" =  ");
                    String _name_13 = d.getName();
                    String _firstLower_7 = StringExtensions.toFirstLower((String)_name_13);
                    _builder.append((Object)_firstLower_7, "\t");
                    _builder.append((Object)" *  ");
                    double _scalingFactor = ((LinearDataConversion)dataAdj).getScalingFactor();
                    _builder.append((Object)_scalingFactor, "\t");
                    _builder.append((Object)" +  ");
                    double _offset = ((LinearDataConversion)dataAdj).getOffset();
                    _builder.append((Object)_offset, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"} ");
                    _builder.newLine();
                    continue;
                }
                if (!(dataAdj instanceof LinearDataConversionWithInterval)) continue;
                _builder.append((Object)"void set_");
                String _name_14 = dataset.getName();
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_14);
                _builder.append((Object)_firstUpper_4, "");
                _builder.append((Object)"_");
                String _name_15 = d.getName();
                String _replaceAll_2 = _name_15.replaceAll("[^a-zA-Z0-9]", "");
                _builder.append((Object)_replaceAll_2, "");
                _builder.append((Object)"(");
                String _name_16 = dataset.getName();
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_16);
                _builder.append((Object)_firstUpper_5, "");
                _builder.append((Object)"* p, ");
                String _typeName_2 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_2, "");
                _builder.append((Object)" ");
                String _name_17 = d.getName();
                String _firstLower_8 = StringExtensions.toFirstLower((String)_name_17);
                _builder.append((Object)_firstLower_8, "");
                _builder.append((Object)" ){\t\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (");
                String _name_18 = d.getName();
                String _firstLower_9 = StringExtensions.toFirstLower((String)_name_18);
                _builder.append((Object)_firstLower_9, "\t");
                _builder.append((Object)" >= ");
                Interval _fromInterval = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _lowerBound_1 = _fromInterval.getLowerBound();
                _builder.append((Object)_lowerBound_1, "\t");
                _builder.append((Object)" && ");
                String _name_19 = d.getName();
                String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
                _builder.append((Object)_firstLower_10, "\t");
                _builder.append((Object)" <= ");
                Interval _fromInterval_1 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _upperBound_1 = _fromInterval_1.getUpperBound();
                _builder.append((Object)_upperBound_1, "\t");
                _builder.append((Object)"){\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                String _returnDataType = this.getReturnDataType(d);
                _builder.append((Object)_returnDataType, "\t\t");
                _builder.append((Object)" oldMin =  ");
                Interval _fromInterval_2 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _lowerBound_2 = _fromInterval_2.getLowerBound();
                int _intValue = Double.valueOf(_lowerBound_2).intValue();
                _builder.append((Object)_intValue, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                String _returnDataType_1 = this.getReturnDataType(d);
                _builder.append((Object)_returnDataType_1, "\t\t");
                _builder.append((Object)" oldMax =  ");
                Interval _fromInterval_3 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _upperBound_2 = _fromInterval_3.getUpperBound();
                int _intValue_1 = Double.valueOf(_upperBound_2).intValue();
                _builder.append((Object)_intValue_1, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                String _returnDataType_2 = this.getReturnDataType(d);
                _builder.append((Object)_returnDataType_2, "\t\t");
                _builder.append((Object)" newMin =  ");
                Interval _toInterval = ((LinearDataConversionWithInterval)dataAdj).getToInterval();
                double _lowerBound_3 = _toInterval.getLowerBound();
                int _intValue_2 = Double.valueOf(_lowerBound_3).intValue();
                _builder.append((Object)_intValue_2, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                String _returnDataType_3 = this.getReturnDataType(d);
                _builder.append((Object)_returnDataType_3, "\t\t");
                _builder.append((Object)" newMax =  ");
                Interval _toInterval_1 = ((LinearDataConversionWithInterval)dataAdj).getToInterval();
                double _upperBound_3 = _toInterval_1.getUpperBound();
                int _intValue_3 = Double.valueOf(_upperBound_3).intValue();
                _builder.append((Object)_intValue_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"p->");
                String _name_20 = d.getName();
                String _firstLower_11 = StringExtensions.toFirstLower((String)_name_20);
                _builder.append((Object)_firstLower_11, "\t\t");
                _builder.append((Object)" = ");
                String _name_21 = d.getName();
                String _firstLower_12 = StringExtensions.toFirstLower((String)_name_21);
                _builder.append((Object)_firstLower_12, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"p->");
                String _name_22 = d.getName();
                String _firstLower_13 = StringExtensions.toFirstLower((String)_name_22);
                _builder.append((Object)_firstLower_13, "\t\t");
                _builder.append((Object)"Adjusted =  ((((");
                String _name_23 = d.getName();
                String _firstLower_14 = StringExtensions.toFirstLower((String)_name_23);
                _builder.append((Object)_firstLower_14, "\t\t");
                _builder.append((Object)" - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"//Do something");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"} \t\t");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"void set_");
            String _name_24 = dataset.getName();
            String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_24);
            _builder.append((Object)_firstUpper_6, "");
            _builder.append((Object)"_");
            String _name_25 = d.getName();
            String _replaceAll_3 = _name_25.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll_3, "");
            _builder.append((Object)"(");
            String _name_26 = dataset.getName();
            String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_26);
            _builder.append((Object)_firstUpper_7, "");
            _builder.append((Object)"* p, ");
            String _typeName_3 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_3, "");
            _builder.append((Object)" ");
            String _name_27 = d.getName();
            String _firstLower_15 = StringExtensions.toFirstLower((String)_name_27);
            _builder.append((Object)_firstLower_15, "");
            _builder.append((Object)" ) { p->");
            String _name_28 = d.getName();
            String _firstLower_16 = StringExtensions.toFirstLower((String)_name_28);
            _builder.append((Object)_firstLower_16, "");
            _builder.append((Object)" = ");
            String _name_29 = d.getName();
            String _firstLower_17 = StringExtensions.toFirstLower((String)_name_29);
            _builder.append((Object)_firstLower_17, "");
            _builder.append((Object)"; }");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterDeclaration(NonMeasurementData d, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = d.isConstant();
        boolean bl = _not = !_isConstant;
        if (_not) {
            _builder.append((Object)"void set_");
            String _name = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"_");
            String _name_1 = d.getName();
            String _replaceAll = _name_1.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"(");
            String _name_2 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"* p, ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name_3 = d.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower, "");
            _builder.append((Object)" ) { p->");
            String _name_4 = d.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)" = ");
            String _name_5 = d.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_2, "");
            _builder.append((Object)"; }");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateEndiannessMethodsDeclarations(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateAdjustAllEndianness = this.generateAdjustAllEndianness(d);
        _builder.append((Object)_generateAdjustAllEndianness, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        CharSequence _generateSwapEndiannessOnDemand = this.generateSwapEndiannessOnDemand(d);
        _builder.append((Object)_generateSwapEndiannessOnDemand, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateAdjustAllEndianness(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"void adjust_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_allEndianness(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"int n = 1;");
        _builder.newLine();
        _builder.newLine();
        if (this.bigEndian) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// if little endian device architecture then convert (big endian defined)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if(*(char *)&n == 1) {");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"// if big endian device architecture then convert (little endian defined)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if(*(char *)&n != 1) {");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        String _swapEndiannessIncludeusedDataSets = this.swapEndiannessIncludeusedDataSets(dataset);
        _builder.append((Object)_swapEndiannessIncludeusedDataSets, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSwapEndiannessOnDemand(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"void swap_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_all_endianness(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _swapEndiannessIncludeusedDataSets = this.swapEndiannessIncludeusedDataSets(dataset);
        _builder.append((Object)_swapEndiannessIncludeusedDataSets, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public String swapEndiannessIncludeusedDataSets(DataSet d) {
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String methodsString = _builder.toString();
        while (dataSet != null) {
            DataSet _head;
            String _methodsString = methodsString;
            CharSequence _swapEndianness = this.swapEndianness(dataSet);
            methodsString = String.valueOf(_methodsString) + _swapEndianness;
            EList _usedDataSets = dataSet.getUsedDataSets();
            dataSet = _head = (DataSet)IterableExtensions.head((Iterable)_usedDataSets);
        }
        return methodsString;
    }

    public CharSequence swapEndianness(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = dataset.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
        for (MeasurementData data : _filter) {
            DataType _dataType_7;
            boolean _equals_7;
            DataType _dataType_6;
            boolean _equals_6;
            DataType _dataType_5;
            boolean _equals_5;
            DataType _dataType_4;
            boolean _equals_4;
            DataType _dataType_3;
            boolean _equals_3;
            DataType _dataType_2;
            boolean _equals_2;
            DataType _dataType_1;
            boolean _equals_1;
            DataType _dataType = data.getDataType();
            boolean _equals = Objects.equal((Object)_dataType, (Object)DataType.INT16);
            if (_equals) {
                _builder.append((Object)"p->");
                String _nameLower = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower, "");
                _builder.append((Object)" = swap_int16( p->");
                String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_1, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_1 = Objects.equal((Object)(_dataType_1 = data.getDataType()), (Object)DataType.UINT16)) {
                _builder.append((Object)"p->");
                String _nameLower_2 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_2, "");
                _builder.append((Object)" = swap_uint16( p->");
                String _nameLower_3 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_3, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_2 = Objects.equal((Object)(_dataType_2 = data.getDataType()), (Object)DataType.INT32)) {
                _builder.append((Object)"p->");
                String _nameLower_4 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_4, "");
                _builder.append((Object)" = swap_int32( p->");
                String _nameLower_5 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_5, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_3 = Objects.equal((Object)(_dataType_3 = data.getDataType()), (Object)DataType.UINT32)) {
                _builder.append((Object)"p->");
                String _nameLower_6 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_6, "");
                _builder.append((Object)" = swap_uint32( p->");
                String _nameLower_7 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_7, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_4 = Objects.equal((Object)(_dataType_4 = data.getDataType()), (Object)DataType.INT64)) {
                _builder.append((Object)"p->");
                String _nameLower_8 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_8, "");
                _builder.append((Object)" = swap_int64( p->");
                String _nameLower_9 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_9, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_5 = Objects.equal((Object)(_dataType_5 = data.getDataType()), (Object)DataType.UINT64)) {
                _builder.append((Object)"p->");
                String _nameLower_10 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_10, "");
                _builder.append((Object)" = swap_uint64( p->");
                String _nameLower_11 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_11, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_6 = Objects.equal((Object)(_dataType_6 = data.getDataType()), (Object)DataType.FLOAT)) {
                _builder.append((Object)"p->");
                String _nameLower_12 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_12, "");
                _builder.append((Object)" = swap_float( p->");
                String _nameLower_13 = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower_13, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (!(_equals_7 = Objects.equal((Object)(_dataType_7 = data.getDataType()), (Object)DataType.DOUBLE))) continue;
            _builder.append((Object)"p->");
            String _nameLower_14 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_14, "");
            _builder.append((Object)" = swap_double( p->");
            String _nameLower_15 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_15, "");
            _builder.append((Object)" );");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_1 = dataset.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        for (NonMeasurementData data_1 : _filter_1) {
            DataType _dataType_15;
            boolean _equals_15;
            DataType _dataType_14;
            boolean _equals_14;
            DataType _dataType_13;
            boolean _equals_13;
            DataType _dataType_12;
            boolean _equals_12;
            DataType _dataType_11;
            boolean _equals_11;
            DataType _dataType_10;
            boolean _equals_10;
            DataType _dataType_9;
            boolean _equals_9;
            DataType _dataType_8 = data_1.getDataType();
            boolean _equals_8 = Objects.equal((Object)_dataType_8, (Object)DataType.INT16);
            if (_equals_8) {
                _builder.append((Object)"p->");
                String _nameLower_16 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_16, "");
                _builder.append((Object)" = swap_int16( p->");
                String _nameLower_17 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_17, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_9 = Objects.equal((Object)(_dataType_9 = data_1.getDataType()), (Object)DataType.UINT16)) {
                _builder.append((Object)"p->");
                String _nameLower_18 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_18, "");
                _builder.append((Object)" = swap_uint16( p->");
                String _nameLower_19 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_19, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_10 = Objects.equal((Object)(_dataType_10 = data_1.getDataType()), (Object)DataType.INT32)) {
                _builder.append((Object)"p->");
                String _nameLower_20 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_20, "");
                _builder.append((Object)" = swap_int32( p->");
                String _nameLower_21 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_21, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_11 = Objects.equal((Object)(_dataType_11 = data_1.getDataType()), (Object)DataType.UINT32)) {
                _builder.append((Object)"p->");
                String _nameLower_22 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_22, "");
                _builder.append((Object)" = swap_uint32( p->");
                String _nameLower_23 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_23, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_12 = Objects.equal((Object)(_dataType_12 = data_1.getDataType()), (Object)DataType.INT64)) {
                _builder.append((Object)"p->");
                String _nameLower_24 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_24, "");
                _builder.append((Object)" = swap_int64( p->");
                String _nameLower_25 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_25, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_13 = Objects.equal((Object)(_dataType_13 = data_1.getDataType()), (Object)DataType.UINT64)) {
                _builder.append((Object)"p->");
                String _nameLower_26 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_26, "");
                _builder.append((Object)" = swap_uint64( p->");
                String _nameLower_27 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_27, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (_equals_14 = Objects.equal((Object)(_dataType_14 = data_1.getDataType()), (Object)DataType.FLOAT)) {
                _builder.append((Object)"p->");
                String _nameLower_28 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_28, "");
                _builder.append((Object)" = swap_float( p->");
                String _nameLower_29 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_29, "");
                _builder.append((Object)" );");
                _builder.newLineIfNotEmpty();
            }
            if (!(_equals_15 = Objects.equal((Object)(_dataType_15 = data_1.getDataType()), (Object)DataType.DOUBLE))) continue;
            _builder.append((Object)"p->");
            String _nameLower_30 = GenerationUtil.toNameLower((Data)data_1);
            _builder.append((Object)_nameLower_30, "");
            _builder.append((Object)" = swap_double( p->");
            String _nameLower_31 = GenerationUtil.toNameLower((Data)data_1);
            _builder.append((Object)_nameLower_31, "");
            _builder.append((Object)" );");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateMarshalingJSONMethods(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateMarshalJSON = this.generateMarshalJSON(dataset);
        _builder.append((Object)_generateMarshalJSON, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateUnmarshalJSON = this.generateUnmarshalJSON(dataset);
        _builder.append((Object)_generateUnmarshalJSON, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateMarshalJSON(final DataSet d) {
        StringConcatenation _xblockexpression = null;
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<DataSet>> _function = new Procedures.Procedure1<ArrayList<DataSet>>(){

            public void apply(ArrayList<DataSet> it) {
                it.add(d);
                EList _usedDataSets = d.getUsedDataSets();
                it.addAll((Collection<DataSet>)_usedDataSets);
            }
        };
        ArrayList dataSets = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"char * marshalJSON_");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _name_1 = d.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"JsonNode *jsonObject = json_mkobject();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (DataSet dataSet : dataSets) {
            EList _data = dataSet.getData();
            for (Data data : _data) {
                boolean _not;
                EList _excludedMethods = data.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"getter");
                boolean bl = _not = !_contains;
                if (_not) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"json_append_member(jsonObject, \"");
                    String _nameLower = GenerationUtil.toNameLower(data);
                    _builder.append((Object)_nameLower, "\t");
                    _builder.append((Object)"\", json_mknumber(get_");
                    String _name_2 = dataSet.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
                    _builder.append((Object)_firstUpper_2, "\t");
                    _builder.append((Object)"_");
                    String _name_3 = data.getName();
                    String _replaceAll = _name_3.replaceAll("[^a-zA-Z0-9]", "");
                    _builder.append((Object)_replaceAll, "\t");
                    _builder.append((Object)"(p)));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"json_append_member(jsonObject, \"");
                String _nameLower_1 = GenerationUtil.toNameLower(data);
                _builder.append((Object)_nameLower_1, "\t");
                _builder.append((Object)"\", json_mknumber(0));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return json_stringify(jsonObject, \"\\t\");");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateUnmarshalJSON(final DataSet d) {
        StringConcatenation _xblockexpression = null;
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<DataSet>> _function = new Procedures.Procedure1<ArrayList<DataSet>>(){

            public void apply(ArrayList<DataSet> it) {
                it.add(d);
                EList _usedDataSets = d.getUsedDataSets();
                it.addAll((Collection<DataSet>)_usedDataSets);
            }
        };
        ArrayList dataSets = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"void unmarshalJSON_");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _name_1 = d.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p, const char *jsonString){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"JsonNode *jsonObject = json_decode(jsonString);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (DataSet dataSet : dataSets) {
            EList _data = dataSet.getData();
            for (Data data : _data) {
                _builder.append((Object)"\t");
                _builder.append((Object)"if (json_find_member(jsonObject, \"");
                String _nameLower = GenerationUtil.toNameLower(data);
                _builder.append((Object)_nameLower, "\t");
                _builder.append((Object)"\") != NULL)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"p->");
                String _name_2 = data.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)" = (");
                String _typeName = this.toTypeName(data);
                _builder.append((Object)_typeName, "\t\t");
                _builder.append((Object)") json_find_member(jsonObject, \"");
                String _nameLower_1 = GenerationUtil.toNameLower(data);
                _builder.append((Object)_nameLower_1, "\t\t");
                _builder.append((Object)"\")->number_;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"json_delete(jsonObject);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateDescription(DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = dataset.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = dataset.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public boolean hasLinearDataConversionWithInterval(MeasurementData data) {
        EList _adjustments = data.getAdjustments();
        Iterable _filter = Iterables.filter((Iterable)_adjustments, LinearDataConversionWithInterval.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
        return !_isEmpty;
    }

    public String getReturnDataType(MeasurementData d) {
        String _xblockexpression = null;
        boolean _isAdjustedByLinearConversionWithInterval = this.isAdjustedByLinearConversionWithInterval(d);
        if (_isAdjustedByLinearConversionWithInterval) {
            DataType _dataTypeOfDataConversionAdjustment = GenerationUtil.getDataTypeOfDataConversionAdjustment(d);
            return DataTypes.getDataTypeBy(_dataTypeOfDataConversionAdjustment);
        }
        _xblockexpression = this.toTypeName((Data)d);
        return _xblockexpression;
    }

    public boolean isAdjustedByLinearConversionWithInterval(MeasurementData data) {
        return data.getAdjustments().size() > 0 && data.getAdjustments().get(0) instanceof LinearDataConversionWithInterval;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".c";
    }

    public CharSequence generateSetterDeclaration(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateSetterDeclaration((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateSetterDeclaration((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }
}

