/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.extensions.todo;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SensIDLTodoTaskCustomizer {
    private static final String SENSIDL_TODO_TAG = "SENSIDL_TODO";
    private static final String JDT_PROPERTIES_QUALIFIER = "org.eclipse.jdt.core";
    private static final String TODO_TASK_TAG_PROPERTY_QUALIFIER = "org.eclipse.jdt.core.compiler.taskTags";
    private static final String TODO_TASK_PRIORITY_PROPERTY_QUALIFIER = "org.eclipse.jdt.core.compiler.taskPriorities";
    private static final String SENSIDL_TODO_TAG_PRIORITY = "NORMAL";
    private static final Logger logger = Logger.getLogger(SensIDLTodoTaskCustomizer.class);

    public static String getSensIDLTodoTag() {
        boolean _isEclipseWorkspace = SensIDLTodoTaskCustomizer.isEclipseWorkspace();
        if (_isEclipseWorkspace) {
            SensIDLTodoTaskCustomizer.registerSensIDLTodoTagIfNecessary();
        }
        return SENSIDL_TODO_TAG;
    }

    private static void registerSensIDLTodoTagIfNecessary() {
        ScopedPreferenceStore jdt = new ScopedPreferenceStore(InstanceScope.INSTANCE, JDT_PROPERTIES_QUALIFIER);
        SensIDLTodoTaskCustomizer.addSensIDLTodoTag(jdt);
        try {
            jdt.save();
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                logger.error((Object)"Error occurred, preferences could not be saved.", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static void addSensIDLTodoTag(ScopedPreferenceStore jdt) {
        try {
            String taskTags = jdt.getString(TODO_TASK_TAG_PROPERTY_QUALIFIER);
            boolean _contains = taskTags.contains(SENSIDL_TODO_TAG);
            if (_contains) {
                return;
            }
            taskTags = String.valueOf(taskTags) + "," + SENSIDL_TODO_TAG;
            jdt.putValue(TODO_TASK_TAG_PROPERTY_QUALIFIER, taskTags);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)"Error occurred, registering SensIDL todo tag failed.", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        SensIDLTodoTaskCustomizer.addSensIDLTodoTagPriority(jdt);
    }

    private static void addSensIDLTodoTagPriority(ScopedPreferenceStore jdt) {
        try {
            String taskPriorities = jdt.getString(TODO_TASK_PRIORITY_PROPERTY_QUALIFIER);
            taskPriorities = String.valueOf(taskPriorities) + "," + SENSIDL_TODO_TAG_PRIORITY;
            jdt.putValue(TODO_TASK_PRIORITY_PROPERTY_QUALIFIER, taskPriorities);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)"Error occurred, SensIDL todo tag priority couldn't be set.");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static boolean isEclipseWorkspace() {
        try {
            Class.forName("org.eclipse.ui.preferences.ScopedPreferenceStore");
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

