/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.converters;

import de.fzi.sensidl.language.converters.ConvertionValidator;
import org.eclipse.xtext.conversion.ValueConverterException;

public class NumericalValidator
extends ConvertionValidator {
    private static final String NUMBERS_REGEX = "[0-9]*";
    private static final String HEX_REGEX = "^(0x)[0-9A-Fa-f]+";
    private static final String EMPTY_STRING = "";
    private static final String ERROR_MESSAGE = "The numerical representation is not correct.";

    public NumericalValidator(ConvertionValidator nextValidator) {
        super(nextValidator);
    }

    @Override
    public String validate(String stringToValidate) throws ValueConverterException {
        if (!NumericalValidator.isHex(stringToValidate).booleanValue() && !NumericalValidator.isNumber(stringToValidate).booleanValue()) {
            throw new ValueConverterException(ERROR_MESSAGE, node, null);
        }
        return this.nextValidationRoutine(stringToValidate);
    }

    public static Boolean isNumber(String string) {
        return string.replaceAll(NUMBERS_REGEX, EMPTY_STRING).equals(EMPTY_STRING);
    }

    public static Boolean isHex(String string) {
        return string.matches(HEX_REGEX);
    }
}

