package de.fzi.sensidl.language.generator.factory.java;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.EncodingSettings;
import de.fzi.sensidl.design.sensidl.Endianness;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.ListData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Method;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.extensions.todo.SensIDLTodoTaskCustomizer;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensIDLOutputConfigurationProvider;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Java code generator for the SensIDL Model.
 * Code will be generated by running the {@code generate()}-Method
 * 
 * @author Sven Eckhardt
 * @author Pawel Bielski
 * @author Max Peters
 * @author Fabian Scheytt
 */
@SuppressWarnings("all")
public class JavaDTOGenerator implements IDTOGenerator {
  private final static Logger logger = Logger.getLogger(JavaDTOGenerator.class);
  
  private final static String LONG_FORMATTED = "l";
  
  private final static String FLOAT_FORMATTED = "f";
  
  private final static String DOUBLE_FORMATTED = ".0";
  
  private final String packagePrefix;
  
  private final List<DataSet> dataSet;
  
  private boolean bigEndian;
  
  /**
   * The constructor calls the constructor of the superclass to set a
   * list of DataSet-elements.
   * @param newDataSet - represents the list of DataSet-elements.
   */
  public JavaDTOGenerator(final List<DataSet> newDataSet, final String newPackagePrefix) {
    this.dataSet = newDataSet;
    this.packagePrefix = newPackagePrefix;
  }
  
  /**
   * Generates the .java file for each data transfer object.
   * @see IDTOGenerator#generate()
   */
  public HashMap<String, CharSequence> generate() {
    HashMap<String, CharSequence> _xblockexpression = null;
    {
      JavaDTOGenerator.logger.info("Start with code-generation of a java data transfer object.");
      final HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
      boolean _isBigEndian = this.isBigEndian();
      this.bigEndian = _isBigEndian;
      for (final DataSet d : this.dataSet) {
        {
          String _nameUpper = GenerationUtil.toNameUpper(d);
          String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
          String _nameUpper_1 = GenerationUtil.toNameUpper(d);
          CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d);
          filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
          String _nameUpper_2 = GenerationUtil.toNameUpper(d);
          String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
          String _plus = ("File: " + _addFileExtensionTo_1);
          String _plus_1 = (_plus + " was generated in ");
          String _plus_2 = (_plus_1 + SensIDLOutputConfigurationProvider.SENSIDL_GEN);
          JavaDTOGenerator.logger.info(_plus_2);
        }
      }
      _xblockexpression = filesToGenerate;
    }
    return _xblockexpression;
  }
  
  private boolean isBigEndian() {
    DataSet _get = this.dataSet.get(0);
    EObject _eContainer = _get.eContainer();
    SensorInterface _sensorInterface = GenerationUtil.getSensorInterface(_eContainer);
    EncodingSettings _encodingSettings = _sensorInterface.getEncodingSettings();
    Endianness _endianness = _encodingSettings.getEndianness();
    return Objects.equal(_endianness, Endianness.BIG_ENDIAN);
  }
  
  /**
   * Generates the class
   */
  public CharSequence generateClassBody(final String className, final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(this.packagePrefix, "");
    DataSet _get = this.dataSet.get(0);
    EObject _eContainer = _get.eContainer();
    String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
    _builder.append(_sensorInterfaceName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.newLine();
    {
      if ((!this.bigEndian)) {
        _builder.append("import java.nio.ByteBuffer;");
        _builder.newLine();
        _builder.append("import java.nio.ByteOrder;");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
      }
    }
    _builder.append(" ");
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Data transfer object for ");
    _builder.append(className, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public class ");
    _builder.append(className, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateDataFieldsIncludeusedDataSets = this.generateDataFieldsIncludeusedDataSets(d);
    _builder.append(_generateDataFieldsIncludeusedDataSets, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateConstructorIncludeusedDataSets = this.generateConstructorIncludeusedDataSets(d, className);
    _builder.append(_generateConstructorIncludeusedDataSets, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* empty constructor for the Data transfer object");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    _builder.append(className, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateMethods = this.generateMethods(d);
    _builder.append(_generateMethods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateDataMethodsIncludeusedDataSets = this.generateDataMethodsIncludeusedDataSets(d);
    _builder.append(_generateDataMethodsIncludeusedDataSets, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      if ((!this.bigEndian)) {
        _builder.append("\t");
        CharSequence _generateConverterMethods = this.generateConverterMethods(d);
        _builder.append(_generateConverterMethods, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates Methods
   */
  public CharSequence generateMethods(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<EObject> _eContents = d.eContents();
      Iterable<Method> _filter = Iterables.<Method>filter(_eContents, Method.class);
      for(final Method method : _filter) {
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Method for ");
        String _name = method.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        String _description = method.getDescription();
        _builder.append(_description, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t");
        _builder.newLine();
        String _methodVisibility = this.getMethodVisibility(method);
        _builder.append(_methodVisibility, "");
        _builder.append(" ");
        String _methodReturnType = this.getMethodReturnType(method);
        _builder.append(_methodReturnType, "");
        _builder.append(" ");
        String _name_1 = method.getName();
        _builder.append(_name_1, "");
        _builder.append("(");
        String _methodParameter = this.getMethodParameter(method);
        _builder.append(_methodParameter, "");
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//");
        String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
        _builder.append(_sensIDLTodoTag, "\t");
        _builder.append(": Auto Generated method stub");
        _builder.newLineIfNotEmpty();
        {
          String _methodReturnType_1 = this.getMethodReturnType(method);
          boolean _equals = _methodReturnType_1.equals("void");
          boolean _not = (!_equals);
          if (_not) {
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  /**
   * Returns the visibility of a method
   */
  public String getMethodVisibility(final Method method) {
    String _xifexpression = null;
    String _visibility = method.getVisibility();
    boolean _notEquals = (!Objects.equal(_visibility, null));
    if (_notEquals) {
      String _visibility_1 = method.getVisibility();
      _xifexpression = SensIDLConstants.getVisibilityOf(_visibility_1);
    } else {
      _xifexpression = SensIDLConstants.getDefaultVisibility();
    }
    return _xifexpression;
  }
  
  /**
   * Returns the return type of a method
   */
  public String getMethodReturnType(final Method method) {
    DataType _returnType = method.getReturnType();
    boolean _notEquals = (!Objects.equal(_returnType, DataType.UNDEFINED));
    if (_notEquals) {
      DataType _returnType_1 = method.getReturnType();
      return this.toTypeName(_returnType_1);
    } else {
      DataSet _returnTypeDataSet = method.getReturnTypeDataSet();
      boolean _notEquals_1 = (!Objects.equal(_returnTypeDataSet, null));
      if (_notEquals_1) {
        DataSet _returnTypeDataSet_1 = method.getReturnTypeDataSet();
        return _returnTypeDataSet_1.getName();
      } else {
        return "void";
      }
    }
  }
  
  /**
   * Returns the parameter of a method
   */
  public String getMethodParameter(final Method method) {
    String str = "";
    EList<MethodParameter> _parameter = method.getParameter();
    int _size = _parameter.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      EList<MethodParameter> _parameter_1 = method.getParameter();
      MethodParameter _head = IterableExtensions.<MethodParameter>head(_parameter_1);
      DataType _dataType = _head.getDataType();
      boolean _notEquals = (!Objects.equal(_dataType, DataType.UNDEFINED));
      if (_notEquals) {
        EList<MethodParameter> _parameter_2 = method.getParameter();
        MethodParameter _head_1 = IterableExtensions.<MethodParameter>head(_parameter_2);
        DataType _dataType_1 = _head_1.getDataType();
        String _typeName = this.toTypeName(_dataType_1);
        String _plus = (_typeName + " ");
        EList<MethodParameter> _parameter_3 = method.getParameter();
        MethodParameter _head_2 = IterableExtensions.<MethodParameter>head(_parameter_3);
        String _name = _head_2.getName();
        String _plus_1 = (_plus + _name);
        str = _plus_1;
      } else {
        EList<MethodParameter> _parameter_4 = method.getParameter();
        MethodParameter _head_3 = IterableExtensions.<MethodParameter>head(_parameter_4);
        DataSet _dataTypeDataSet = _head_3.getDataTypeDataSet();
        boolean _notEquals_1 = (!Objects.equal(_dataTypeDataSet, null));
        if (_notEquals_1) {
          EList<MethodParameter> _parameter_5 = method.getParameter();
          MethodParameter _head_4 = IterableExtensions.<MethodParameter>head(_parameter_5);
          DataSet _dataTypeDataSet_1 = _head_4.getDataTypeDataSet();
          String _name_1 = _dataTypeDataSet_1.getName();
          String _plus_2 = (_name_1 + " ");
          EList<MethodParameter> _parameter_6 = method.getParameter();
          MethodParameter _head_5 = IterableExtensions.<MethodParameter>head(_parameter_6);
          String _name_2 = _head_5.getName();
          String _plus_3 = (_plus_2 + _name_2);
          str = _plus_3;
        }
      }
      EList<MethodParameter> _parameter_7 = method.getParameter();
      Iterable<MethodParameter> _tail = IterableExtensions.<MethodParameter>tail(_parameter_7);
      for (final MethodParameter p : _tail) {
        DataType _dataType_2 = p.getDataType();
        boolean _notEquals_2 = (!Objects.equal(_dataType_2, DataType.UNDEFINED));
        if (_notEquals_2) {
          String _str = str;
          DataType _dataType_3 = p.getDataType();
          String _typeName_1 = this.toTypeName(_dataType_3);
          String _plus_4 = (", " + _typeName_1);
          String _plus_5 = (_plus_4 + " ");
          String _name_3 = p.getName();
          String _plus_6 = (_plus_5 + _name_3);
          str = (_str + _plus_6);
        } else {
          DataSet _dataTypeDataSet_2 = p.getDataTypeDataSet();
          boolean _notEquals_3 = (!Objects.equal(_dataTypeDataSet_2, null));
          if (_notEquals_3) {
            String _str_1 = str;
            DataSet _dataTypeDataSet_3 = p.getDataTypeDataSet();
            String _name_4 = _dataTypeDataSet_3.getName();
            String _plus_7 = (", " + _name_4);
            String _plus_8 = (_plus_7 + " ");
            String _name_5 = p.getName();
            String _plus_9 = (_plus_8 + _name_5);
            str = (_str_1 + _plus_9);
          }
        }
      }
    }
    return str;
  }
  
  /**
   * returns the appropriate type name for string
   */
  public String toTypeName(final String s) {
    String _switchResult = null;
    boolean _matched = false;
    if (Objects.equal(s, "INT8")) {
      _matched=true;
      _switchResult = Byte.class.getName();
    }
    if (!_matched) {
      if (Objects.equal(s, "UINT8")) {
        _matched=true;
        _switchResult = Byte.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "INT16")) {
        _matched=true;
        _switchResult = Short.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "UINT16")) {
        _matched=true;
        _switchResult = Short.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "INT32")) {
        _matched=true;
        _switchResult = Integer.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "UINT32")) {
        _matched=true;
        _switchResult = Integer.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "INT64")) {
        _matched=true;
        _switchResult = Long.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "UINT64")) {
        _matched=true;
        _switchResult = Long.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "FLOAT")) {
        _matched=true;
        _switchResult = Float.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "DOUBLE")) {
        _matched=true;
        _switchResult = Double.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "BOOLEAN")) {
        _matched=true;
        _switchResult = Boolean.class.getName();
      }
    }
    if (!_matched) {
      if (Objects.equal(s, "STRING")) {
        _matched=true;
        _switchResult = String.class.getName();
      }
    }
    return _switchResult;
  }
  
  /**
   * Generates the data fields for this data set including used data sets.
   */
  public CharSequence generateDataFieldsIncludeusedDataSets(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<EObject> _eContents = d.eContents();
      Iterable<NonMeasurementData> _filter = Iterables.<NonMeasurementData>filter(_eContents, NonMeasurementData.class);
      for(final NonMeasurementData data : _filter) {
        _builder.newLine();
        CharSequence _generateDataFields = this.generateDataFields(data);
        _builder.append(_generateDataFields, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<EObject> _eContents_1 = d.eContents();
      Iterable<MeasurementData> _filter_1 = Iterables.<MeasurementData>filter(_eContents_1, MeasurementData.class);
      for(final MeasurementData data_1 : _filter_1) {
        CharSequence _generateDataFields_1 = this.generateDataFields(data_1);
        _builder.append(_generateDataFields_1, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<EObject> _eContents_2 = d.eContents();
      Iterable<ListData> _filter_2 = Iterables.<ListData>filter(_eContents_2, ListData.class);
      for(final ListData data_2 : _filter_2) {
        CharSequence _generateDataFields_2 = this.generateDataFields(data_2);
        _builder.append(_generateDataFields_2, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<DataSet> _usedDataSets = d.getUsedDataSets();
      for(final DataSet dataSet : _usedDataSets) {
        CharSequence _generateDataFields_3 = this.generateDataFields(dataSet);
        _builder.append(_generateDataFields_3, "");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * generate the fields for datasets
   */
  public CharSequence generateDataFields(final DataSet dataSet) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/*\t");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* ");
    String _description = dataSet.getDescription();
    _builder.append(_description, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("private ");
    String _nameUpper = GenerationUtil.toNameUpper(dataSet);
    _builder.append(_nameUpper, "");
    _builder.append(" ");
    String _nameLower = GenerationUtil.toNameLower(dataSet);
    _builder.append(_nameLower, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateDataFields(final ListData data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      String _description = data.getDescription();
      boolean _notEquals = (!Objects.equal(_description, null));
      if (_notEquals) {
        _builder.append("/* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        String _description_1 = data.getDescription();
        _builder.append(_description_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/ ");
        _builder.newLine();
      }
    }
    _builder.append("private List<");
    String _listType = this.getListType(data);
    _builder.append(_listType, "");
    _builder.append("> ");
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "");
    _builder.append(" = new ArrayList<");
    String _listType_1 = this.getListType(data);
    _builder.append(_listType_1, "");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Generates the fields for the measurement data
   */
  public CharSequence generateDataFields(final MeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/*");
    _builder.newLine();
    {
      String _description = d.getDescription();
      boolean _notEquals = (!Objects.equal(_description, null));
      if (_notEquals) {
        _builder.append(" ");
        _builder.append("* ");
        String _description_1 = d.getDescription();
        _builder.append(_description_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
      }
    }
    _builder.append(" ");
    _builder.append("* Unit: ");
    Unit<?> _unit = d.getUnit();
    _builder.append(_unit, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("private ");
    String _typeName = this.toTypeName(d);
    _builder.append(_typeName, "");
    _builder.append(" ");
    String _nameLower = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _hasLinearDataConversionWithInterval = this.hasLinearDataConversionWithInterval(d);
      if (_hasLinearDataConversionWithInterval) {
        _builder.append("/*");
        _builder.newLine();
        {
          String _description_2 = d.getDescription();
          boolean _notEquals_1 = (!Objects.equal(_description_2, null));
          if (_notEquals_1) {
            _builder.append(" * ");
            String _description_3 = d.getDescription();
            _builder.append(_description_3, "");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* ");
            _builder.newLine();
          }
        }
        _builder.append(" ");
        _builder.append("* Unit: ");
        Unit<?> _unit_1 = d.getUnit();
        _builder.append(_unit_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* Adjusted");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("private ");
        DataType _dataConversionType = this.getDataConversionType(d);
        String _typeName_1 = this.toTypeName(_dataConversionType);
        _builder.append(_typeName_1, "");
        _builder.append(" ");
        String _nameLower_1 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_1, "");
        _builder.append("Adjusted;");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * Generates the fields for the non measurement data
   */
  public CharSequence generateDataFields(final NonMeasurementData d) {
    CharSequence _xifexpression = null;
    boolean _isConstant = d.isConstant();
    if (_isConstant) {
      StringConcatenation _builder = new StringConcatenation();
      {
        String _description = d.getDescription();
        boolean _notEquals = (!Objects.equal(_description, null));
        if (_notEquals) {
          _builder.append("/*");
          _builder.newLine();
          _builder.append(" ");
          _builder.append("*");
          String _description_1 = d.getDescription();
          _builder.append(_description_1, " ");
          _builder.newLineIfNotEmpty();
          {
            DataType _dataType = d.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
              _builder.append(" ");
              _builder.append("*");
              _builder.newLine();
              _builder.append(" ");
              _builder.append("* Java has no option for unsigned data types, so if the data has an ");
              _builder.newLine();
              _builder.append(" ");
              _builder.append("* unsigned data type the value is calculated by subtracting the maximum ");
              _builder.newLine();
              _builder.append(" ");
              _builder.append("* value from the signed data type and adding it again, if it is used.");
              _builder.newLine();
              _builder.append(" ");
              _builder.append("*");
              _builder.newLine();
            }
          }
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
        }
      }
      _builder.append("private ");
      String _typeName = this.toTypeName(d);
      _builder.append(_typeName, "");
      _builder.append(" ");
      String _name = d.getName();
      String _upperCase = _name.toUpperCase();
      _builder.append(_upperCase, "");
      _builder.append(" = ");
      {
        DataType _dataType_1 = d.getDataType();
        boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
        if (_isUnsigned_1) {
          _builder.append("(");
          String _simpleTypeName = this.toSimpleTypeName(d);
          _builder.append(_simpleTypeName, "");
          _builder.append(") (");
          String _value = d.getValue();
          _builder.append(_value, "");
          _builder.append(" - ");
          String _typeName_1 = this.toTypeName(d);
          _builder.append(_typeName_1, "");
          _builder.append(".MAX_VALUE)");
        } else {
          {
            DataType _dataType_2 = d.getDataType();
            boolean _equals = Objects.equal(_dataType_2, DataType.STRING);
            if (_equals) {
              _builder.append("\"");
              String _value_1 = d.getValue();
              _builder.append(_value_1, "");
              _builder.append("\"");
            } else {
              String _formatedValue = this.getFormatedValue(d);
              _builder.append(_formatedValue, "");
            }
          }
        }
      }
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        String _description_2 = d.getDescription();
        boolean _notEquals_1 = (!Objects.equal(_description_2, null));
        if (_notEquals_1) {
          _builder_1.append("/*");
          _builder_1.newLine();
          _builder_1.append(" ");
          _builder_1.append("*");
          String _description_3 = d.getDescription();
          _builder_1.append(_description_3, " ");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append(" ");
          _builder_1.append("*/");
          _builder_1.newLine();
        }
      }
      _builder_1.append("private ");
      String _typeName_2 = this.toTypeName(d);
      _builder_1.append(_typeName_2, "");
      _builder_1.append(" ");
      String _nameLower = GenerationUtil.toNameLower(d);
      _builder_1.append(_nameLower, "");
      {
        String _value_2 = d.getValue();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_2);
        boolean _not = (!_isNullOrEmpty);
        if (_not) {
          _builder_1.append(" = ");
          {
            DataType _dataType_3 = d.getDataType();
            boolean _equals_1 = Objects.equal(_dataType_3, DataType.STRING);
            if (_equals_1) {
              _builder_1.append("\"");
              String _value_3 = d.getValue();
              _builder_1.append(_value_3, "");
              _builder_1.append("\"");
            } else {
              String _formatedValue_1 = this.getFormatedValue(d);
              _builder_1.append(_formatedValue_1, "");
            }
          }
        }
      }
      _builder_1.append(";");
      _builder_1.newLineIfNotEmpty();
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }
  
  private String getFormatedValue(final NonMeasurementData data) {
    String _xblockexpression = null;
    {
      String value = data.getValue();
      String _typeName = this.toTypeName(data);
      String _name = Long.class.getName();
      boolean _equals = _typeName.equals(_name);
      if (_equals) {
        String _value = value;
        value = (_value + JavaDTOGenerator.LONG_FORMATTED);
      }
      String _typeName_1 = this.toTypeName(data);
      String _name_1 = Float.class.getName();
      boolean _equals_1 = _typeName_1.equals(_name_1);
      if (_equals_1) {
        String _value_1 = value;
        value = (_value_1 + JavaDTOGenerator.FLOAT_FORMATTED);
      }
      String _typeName_2 = this.toTypeName(data);
      String _name_2 = Double.class.getName();
      boolean _equals_2 = _typeName_2.equals(_name_2);
      if (_equals_2) {
        String _value_2 = value;
        value = (_value_2 + JavaDTOGenerator.DOUBLE_FORMATTED);
      }
      _xblockexpression = value;
    }
    return _xblockexpression;
  }
  
  /**
   * Generates the constructor for this data set including used data sets.
   */
  public CharSequence generateConstructorIncludeusedDataSets(final DataSet d, final String className) {
    CharSequence _xifexpression = null;
    ArrayList<Data> _nonConstantData = this.getNonConstantData(d);
    int _size = _nonConstantData.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Constructor for the Data transfer object");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public ");
      _builder.append(className, "");
      _builder.append("(");
      CharSequence _generateConstructorArgumentsIncludeusedDataSetss = this.generateConstructorArgumentsIncludeusedDataSetss(d);
      _builder.append(_generateConstructorArgumentsIncludeusedDataSetss, "");
      _builder.append(") {");
      _builder.newLineIfNotEmpty();
      {
        EList<EObject> _eContents = d.eContents();
        Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_eContents, MeasurementData.class);
        for(final MeasurementData data : _filter) {
          _builder.append("\t");
          _builder.append("this.");
          String _nameLower = GenerationUtil.toNameLower(data);
          _builder.append(_nameLower, "\t");
          _builder.append(" = ");
          {
            DataType _dataType = data.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
              _builder.append("(");
              String _simpleTypeName = this.toSimpleTypeName(data);
              _builder.append(_simpleTypeName, "\t");
              _builder.append(") (");
              String _nameLower_1 = GenerationUtil.toNameLower(data);
              _builder.append(_nameLower_1, "\t");
              _builder.append(" - ");
              String _typeName = this.toTypeName(data);
              _builder.append(_typeName, "\t");
              _builder.append(".MAX_VALUE)");
            } else {
              String _nameLower_2 = GenerationUtil.toNameLower(data);
              _builder.append(_nameLower_2, "\t");
            }
          }
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        EList<EObject> _eContents_1 = d.eContents();
        Iterable<NonMeasurementData> _filter_1 = Iterables.<NonMeasurementData>filter(_eContents_1, NonMeasurementData.class);
        for(final NonMeasurementData data_1 : _filter_1) {
          {
            boolean _isConstant = data_1.isConstant();
            boolean _not = (!_isConstant);
            if (_not) {
              _builder.append("\t");
              _builder.append("this.");
              String _nameLower_3 = GenerationUtil.toNameLower(data_1);
              _builder.append(_nameLower_3, "\t");
              _builder.append(" = ");
              {
                DataType _dataType_1 = data_1.getDataType();
                boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
                if (_isUnsigned_1) {
                  _builder.append("(");
                  String _simpleTypeName_1 = this.toSimpleTypeName(data_1);
                  _builder.append(_simpleTypeName_1, "\t");
                  _builder.append(") (");
                  String _nameLower_4 = GenerationUtil.toNameLower(data_1);
                  _builder.append(_nameLower_4, "\t");
                  _builder.append(" - ");
                  String _typeName_1 = this.toTypeName(data_1);
                  _builder.append(_typeName_1, "\t");
                  _builder.append(".MAX_VALUE)");
                } else {
                  String _nameLower_5 = GenerationUtil.toNameLower(data_1);
                  _builder.append(_nameLower_5, "\t");
                }
              }
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      {
        EList<DataSet> _usedDataSets = d.getUsedDataSets();
        for(final DataSet pdataSet : _usedDataSets) {
          _builder.append("\t");
          _builder.append("this.");
          String _nameLower_6 = GenerationUtil.toNameLower(pdataSet);
          _builder.append(_nameLower_6, "\t");
          _builder.append(" = ");
          String _nameLower_7 = GenerationUtil.toNameLower(pdataSet);
          _builder.append(_nameLower_7, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }
  
  /**
   * Generates the Constructor arguments
   */
  public CharSequence generateConstructorArgumentsIncludeusedDataSetss(final DataSet d) {
    CharSequence _xblockexpression = null;
    {
      ArrayList<Data> dataList = this.getNonConstantData(d);
      CharSequence _xifexpression = null;
      int _size = dataList.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        CharSequence _xblockexpression_1 = null;
        {
          Data _get = dataList.get(0);
          String _typeName = this.toTypeName(_get);
          String _plus = (_typeName + " ");
          Data _get_1 = dataList.get(0);
          String _nameLower = GenerationUtil.toNameLower(_get_1);
          String firstElement = (_plus + _nameLower);
          dataList.remove(0);
          CharSequence _xifexpression_1 = null;
          EList<DataSet> _usedDataSets = d.getUsedDataSets();
          int _size_1 = _usedDataSets.size();
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(firstElement, "");
            {
              for(final Data data : dataList) {
                _builder.append(", ");
                String _typeName_1 = this.toTypeName(data);
                _builder.append(_typeName_1, "");
                _builder.append(" ");
                String _nameLower_1 = GenerationUtil.toNameLower(data);
                _builder.append(_nameLower_1, "");
              }
            }
            {
              EList<DataSet> _usedDataSets_1 = d.getUsedDataSets();
              for(final DataSet pdataSet : _usedDataSets_1) {
                _builder.append(", ");
                String _nameUpper = GenerationUtil.toNameUpper(pdataSet);
                _builder.append(_nameUpper, "");
                _builder.append(" ");
                String _nameLower_2 = GenerationUtil.toNameLower(pdataSet);
                _builder.append(_nameLower_2, "");
              }
            }
            _xifexpression_1 = _builder;
          } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(firstElement, "");
            {
              for(final Data data_1 : dataList) {
                _builder_1.append(", ");
                String _typeName_2 = this.toTypeName(data_1);
                _builder_1.append(_typeName_2, "");
                _builder_1.append(" ");
                String _nameLower_3 = GenerationUtil.toNameLower(data_1);
                _builder_1.append(_nameLower_3, "");
              }
            }
            _xifexpression_1 = _builder_1;
          }
          _xblockexpression_1 = _xifexpression_1;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        StringConcatenation _builder = new StringConcatenation();
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  /**
   * returns all non constant data (i.e. all measurement data and all non constant non measurement data)
   */
  public ArrayList<Data> getNonConstantData(final DataSet d) {
    ArrayList<Data> dataList = new ArrayList<Data>();
    DataSet dataSet = d;
    EList<EObject> _eContents = dataSet.eContents();
    Iterable<Data> _filter = Iterables.<Data>filter(_eContents, Data.class);
    for (final Data data : _filter) {
      if ((data instanceof NonMeasurementData)) {
        NonMeasurementData nmdata = ((NonMeasurementData) data);
        boolean _isConstant = nmdata.isConstant();
        boolean _not = (!_isConstant);
        if (_not) {
          dataList.add(data);
        }
      } else {
        if ((!(data instanceof ListData))) {
          dataList.add(data);
        }
      }
    }
    return dataList;
  }
  
  /**
   * Generates the getter and setter methods for the data of this data set including used data sets.
   */
  public CharSequence generateDataMethodsIncludeusedDataSets(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<EObject> _eContents = d.eContents();
      Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_eContents, MeasurementData.class);
      for(final MeasurementData data : _filter) {
        {
          EList<String> _excludedMethods = data.getExcludedMethods();
          boolean _contains = _excludedMethods.contains("getter");
          boolean _not = (!_contains);
          if (_not) {
            CharSequence _generateGetter = this.generateGetter(data);
            _builder.append(_generateGetter, "");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          EList<String> _excludedMethods_1 = data.getExcludedMethods();
          boolean _contains_1 = _excludedMethods_1.contains("setter");
          boolean _not_1 = (!_contains_1);
          if (_not_1) {
            CharSequence _generateSetter = this.generateSetter(data);
            _builder.append(_generateSetter, "");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      EList<EObject> _eContents_1 = d.eContents();
      Iterable<NonMeasurementData> _filter_1 = Iterables.<NonMeasurementData>filter(_eContents_1, NonMeasurementData.class);
      for(final NonMeasurementData data_1 : _filter_1) {
        {
          EList<String> _excludedMethods_2 = data_1.getExcludedMethods();
          boolean _contains_2 = _excludedMethods_2.contains("getter");
          boolean _not_2 = (!_contains_2);
          if (_not_2) {
            CharSequence _generateGetter_1 = this.generateGetter(data_1);
            _builder.append(_generateGetter_1, "");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          EList<String> _excludedMethods_3 = data_1.getExcludedMethods();
          boolean _contains_3 = _excludedMethods_3.contains("setter");
          boolean _not_3 = (!_contains_3);
          if (_not_3) {
            CharSequence _generateSetter_1 = this.generateSetter(data_1);
            _builder.append(_generateSetter_1, "");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      EList<EObject> _eContents_2 = d.eContents();
      Iterable<ListData> _filter_2 = Iterables.<ListData>filter(_eContents_2, ListData.class);
      for(final ListData data_2 : _filter_2) {
        CharSequence _generateAddMethod = this.generateAddMethod(data_2);
        _builder.append(_generateAddMethod, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateGetter_2 = this.generateGetter(data_2);
        _builder.append(_generateGetter_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateSetter_2 = this.generateSetter(data_2);
        _builder.append(_generateSetter_2, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<DataSet> _usedDataSets = d.getUsedDataSets();
      for(final DataSet pdataSet : _usedDataSets) {
        _builder.newLine();
        CharSequence _generateGetter_3 = this.generateGetter(pdataSet);
        _builder.append(_generateGetter_3, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateSetter_3 = this.generateSetter(pdataSet);
        _builder.append(_generateSetter_3, "");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * return the type of the list
   */
  public String getListType(final ListData data) {
    DataType _dataType = data.getDataType();
    boolean _notEquals = (!Objects.equal(_dataType, DataType.UNDEFINED));
    if (_notEquals) {
      DataType _dataType_1 = data.getDataType();
      return this.toTypeName(_dataType_1);
    } else {
      DataSet _dataTypeDataSet = data.getDataTypeDataSet();
      boolean _notEquals_1 = (!Objects.equal(_dataTypeDataSet, null));
      if (_notEquals_1) {
        DataSet _dataTypeDataSet_1 = data.getDataTypeDataSet();
        return _dataTypeDataSet_1.getName();
      }
    }
    return null;
  }
  
  /**
   * returns the Getter Name
   */
  public CharSequence toGetterName(final Data d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _name = d.getName();
    String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
    String _firstUpper = StringExtensions.toFirstUpper(_replaceAll);
    _builder.append(_firstUpper, "");
    return _builder;
  }
  
  /**
   * returns the Setter Name
   */
  public CharSequence toSetterName(final Data d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("set");
    String _name = d.getName();
    String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
    String _firstUpper = StringExtensions.toFirstUpper(_replaceAll);
    _builder.append(_firstUpper, "");
    return _builder;
  }
  
  /**
   * Generates the Getter Method for the list data
   */
  public CharSequence generateGetter(final ListData data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Get the ");
    String _name = data.getName();
    _builder.append(_name, " ");
    _builder.append(" list");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public List<");
    String _listType = this.getListType(data);
    _builder.append(_listType, "");
    _builder.append("> ");
    CharSequence _getterName = this.toGetterName(data);
    _builder.append(_getterName, "");
    _builder.append("(){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return this.");
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Get the a specific element from the ");
    String _name_1 = data.getName();
    _builder.append(_name_1, " ");
    _builder.append(" list or null if not found");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public ");
    String _listType_1 = this.getListType(data);
    _builder.append(_listType_1, "");
    _builder.append(" ");
    CharSequence _getterName_1 = this.toGetterName(data);
    _builder.append(_getterName_1, "");
    _builder.append("(");
    String _listType_2 = this.getListType(data);
    _builder.append(_listType_2, "");
    _builder.append(" obj){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if(this.");
    String _nameLower_1 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_1, "\t");
    _builder.append(".indexOf(obj) == -1){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return this.");
    String _nameLower_2 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_2, "\t");
    _builder.append(".get(this.");
    String _nameLower_3 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_3, "\t");
    _builder.append(".indexOf(obj));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the Getter Method for the dataset
   */
  public CharSequence generateGetter(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @return the ");
    String _nameLower = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public ");
    String _nameUpper = GenerationUtil.toNameUpper(d);
    _builder.append(_nameUpper, "");
    _builder.append(" get");
    String _nameUpper_1 = GenerationUtil.toNameUpper(d);
    _builder.append(_nameUpper_1, "");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return this.");
    String _nameLower_1 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_1, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the Getter Method for the measurement data
   */
  public CharSequence generateGetter(final MeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasLinearDataConversionWithInterval = this.hasLinearDataConversionWithInterval(d);
      boolean _not = (!_hasLinearDataConversionWithInterval);
      if (_not) {
        _builder.append("/**");
        _builder.newLine();
        {
          DataType _dataType = d.getDataType();
          boolean _isUnsigned = this.isUnsigned(_dataType);
          if (_isUnsigned) {
            _builder.append(" ");
            _builder.append("* Java has no option for unsigned data types, so if the data has an ");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* unsigned data type the value is calculated by subtracting the maximum ");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* value from the signed data type and adding it again, if it is used.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
          }
        }
        _builder.append(" ");
        _builder.append("* @return the ");
        String _nameLower = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _typeName = this.toTypeName(d);
        _builder.append(_typeName, "");
        _builder.append(" ");
        CharSequence _getterName = this.toGetterName(d);
        _builder.append(_getterName, "");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        {
          DataType _dataType_1 = d.getDataType();
          boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
          if (_isUnsigned_1) {
            _builder.append("(");
            String _simpleTypeName = this.toSimpleTypeName(d);
            _builder.append(_simpleTypeName, "\t");
            _builder.append(") (this.");
            String _nameLower_1 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_1, "\t");
            _builder.append(" + ");
            String _typeName_1 = this.toTypeName(d);
            _builder.append(_typeName_1, "\t");
            _builder.append(".MAX_VALUE)");
          } else {
            _builder.append("this.");
            String _nameLower_2 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_2, "\t");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the ");
        String _nameLower_3 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        DataType _dataConversionType = this.getDataConversionType(d);
        String _typeName_2 = this.toTypeName(_dataConversionType);
        _builder.append(_typeName_2, "");
        _builder.append(" ");
        CharSequence _getterName_1 = this.toGetterName(d);
        _builder.append(_getterName_1, "");
        _builder.append("(){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return this.");
        String _nameLower_4 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_4, "\t");
        _builder.append("Adjusted;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the ");
        String _nameLower_5 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_5, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _typeName_3 = this.toTypeName(d);
        _builder.append(_typeName_3, "");
        _builder.append(" ");
        CharSequence _getterName_2 = this.toGetterName(d);
        _builder.append(_getterName_2, "");
        _builder.append("NotAdjusted(){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        {
          DataType _dataType_2 = d.getDataType();
          boolean _isUnsigned_2 = this.isUnsigned(_dataType_2);
          if (_isUnsigned_2) {
            _builder.append("(");
            String _simpleTypeName_1 = this.toSimpleTypeName(d);
            _builder.append(_simpleTypeName_1, "\t");
            _builder.append(") (this.");
            String _nameLower_6 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_6, "\t");
            _builder.append(" + ");
            String _typeName_4 = this.toTypeName(d);
            _builder.append(_typeName_4, "\t");
            _builder.append(".MAX_VALUE)");
          } else {
            _builder.append("this.");
            String _nameLower_7 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_7, "\t");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  /**
   * Generates the Getter Method for the non measurement data
   */
  public CharSequence generateGetter(final NonMeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    {
      DataType _dataType = d.getDataType();
      boolean _isUnsigned = this.isUnsigned(_dataType);
      if (_isUnsigned) {
        _builder.append(" ");
        _builder.append("* Java has no option for unsigned data types, so if the data has an ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* unsigned data type the value is calculated by subtracting the maximum ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* value from the signed data type and adding it again, if it is used.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
      }
    }
    _builder.append(" ");
    _builder.append("* @return the ");
    String _nameLower = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public ");
    String _typeName = this.toTypeName(d);
    _builder.append(_typeName, "");
    _builder.append(" ");
    CharSequence _getterName = this.toGetterName(d);
    _builder.append(_getterName, "");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    {
      DataType _dataType_1 = d.getDataType();
      boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
      if (_isUnsigned_1) {
        _builder.append("(");
        String _simpleTypeName = this.toSimpleTypeName(d);
        _builder.append(_simpleTypeName, "\t");
        _builder.append(") (");
        {
          boolean _isConstant = d.isConstant();
          if (_isConstant) {
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "\t");
          } else {
            _builder.append("this.");
            String _nameLower_1 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_1, "\t");
          }
        }
        _builder.append(" + ");
        String _typeName_1 = this.toTypeName(d);
        _builder.append(_typeName_1, "\t");
        _builder.append(".MAX_VALUE)");
      } else {
        _builder.append("this.");
        {
          boolean _isConstant_1 = d.isConstant();
          if (_isConstant_1) {
            String _name_1 = d.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder.append(_upperCase_1, "\t");
          } else {
            String _nameLower_2 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_2, "\t");
          }
        }
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the add method to add data to a data List
   */
  public CharSequence generateAddMethod(final ListData data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Add Data to the ");
    String _name = data.getName();
    _builder.append(_name, " ");
    _builder.append(" list");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @param ");
    String _name_1 = data.getName();
    String _firstLower = StringExtensions.toFirstLower(_name_1);
    _builder.append(_firstLower, " ");
    _builder.append("Element ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*\t\t\t\tthe object to add to the list");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public void add");
    String _name_2 = data.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name_2);
    _builder.append(_firstUpper, "");
    _builder.append("(");
    String _listType = this.getListType(data);
    _builder.append(_listType, "");
    _builder.append(" ");
    String _name_3 = data.getName();
    String _firstLower_1 = StringExtensions.toFirstLower(_name_3);
    _builder.append(_firstLower_1, "");
    _builder.append("Element){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "\t");
    _builder.append(".add(");
    String _name_4 = data.getName();
    String _firstLower_2 = StringExtensions.toFirstLower(_name_4);
    _builder.append(_firstLower_2, "\t");
    _builder.append("Element);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the Setter Method for list data
   */
  public CharSequence generateSetter(final ListData data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Set the ");
    String _name = data.getName();
    _builder.append(_name, " ");
    _builder.append(" list");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @param ");
    String _name_1 = data.getName();
    String _firstLower = StringExtensions.toFirstLower(_name_1);
    _builder.append(_firstLower, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* \t\t\t\tthe list to set");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public void ");
    CharSequence _setterName = this.toSetterName(data);
    _builder.append(_setterName, "");
    _builder.append("(List<");
    String _listType = this.getListType(data);
    _builder.append(_listType, "");
    _builder.append("> ");
    String _name_2 = data.getName();
    String _firstLower_1 = StringExtensions.toFirstLower(_name_2);
    _builder.append(_firstLower_1, "");
    _builder.append("){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.");
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "\t");
    _builder.append(" = ");
    String _name_3 = data.getName();
    String _firstLower_2 = StringExtensions.toFirstLower(_name_3);
    _builder.append(_firstLower_2, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the Setter Method for the dataset
   */
  public CharSequence generateSetter(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @param info");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*            the ");
    String _nameLower = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower, " ");
    _builder.append(" to set");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public void set");
    String _nameUpper = GenerationUtil.toNameUpper(d);
    _builder.append(_nameUpper, "");
    _builder.append("(");
    String _nameUpper_1 = GenerationUtil.toNameUpper(d);
    _builder.append(_nameUpper_1, "");
    _builder.append(" ");
    String _nameLower_1 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_1, "");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.");
    String _nameLower_2 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_2, "\t");
    _builder.append(" = ");
    String _nameLower_3 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_3, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the Setter Method for the measurement data
   */
  public CharSequence generateSetter(final MeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<DataAdjustment> _adjustments = d.getAdjustments();
      boolean _isEmpty = _adjustments.isEmpty();
      boolean _equals = (_isEmpty == false);
      if (_equals) {
        {
          EList<DataAdjustment> _adjustments_1 = d.getAdjustments();
          for(final DataAdjustment dataAdj : _adjustments_1) {
            {
              if ((dataAdj instanceof DataRange)) {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param ");
                String _nameLower = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower, " ");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*            the ");
                String _nameLower_1 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_1, " ");
                _builder.append(" to set");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("public void ");
                CharSequence _setterName = this.toSetterName(d);
                _builder.append(_setterName, "");
                _builder.append("WithRange(");
                String _typeName = this.toTypeName(d);
                _builder.append(_typeName, "");
                _builder.append(" ");
                String _nameLower_2 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_2, "");
                _builder.append("){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (");
                String _nameLower_3 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_3, "\t");
                _builder.append(" >= ");
                Interval _range = ((DataRange)dataAdj).getRange();
                double _lowerBound = _range.getLowerBound();
                _builder.append(_lowerBound, "\t");
                _builder.append(" && ");
                String _nameLower_4 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_4, "\t");
                _builder.append(" <= ");
                Interval _range_1 = ((DataRange)dataAdj).getRange();
                double _upperBound = _range_1.getUpperBound();
                _builder.append(_upperBound, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("this.");
                String _nameLower_5 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_5, "\t\t");
                _builder.append(" = ");
                String _nameLower_6 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_6, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("else");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("throw new IllegalArgumentException(\"value is out of defined range\");\t");
                _builder.newLine();
                _builder.append("} ");
                _builder.newLine();
              } else {
                if ((dataAdj instanceof DataConversion)) {
                  _builder.append("/**");
                  _builder.newLine();
                  _builder.append(" ");
                  _builder.append("* @param ");
                  String _nameLower_7 = GenerationUtil.toNameLower(d);
                  _builder.append(_nameLower_7, " ");
                  _builder.newLineIfNotEmpty();
                  _builder.append(" ");
                  _builder.append("*            the ");
                  String _nameLower_8 = GenerationUtil.toNameLower(d);
                  _builder.append(_nameLower_8, " ");
                  _builder.append(" to set");
                  _builder.newLineIfNotEmpty();
                  _builder.append(" ");
                  _builder.append("*/");
                  _builder.newLine();
                  _builder.append("public void ");
                  CharSequence _setterName_1 = this.toSetterName(d);
                  _builder.append(_setterName_1, "");
                  _builder.append("WithDataConversion(");
                  String _typeName_1 = this.toTypeName(d);
                  _builder.append(_typeName_1, "");
                  _builder.append(" ");
                  String _nameLower_9 = GenerationUtil.toNameLower(d);
                  _builder.append(_nameLower_9, "");
                  _builder.append(") {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("try {");
                  _builder.newLine();
                  _builder.append("\t\t");
                  CharSequence _generateSetterBodyForMeasurementData = this.generateSetterBodyForMeasurementData(d, ((DataConversion) dataAdj));
                  _builder.append(_generateSetterBodyForMeasurementData, "\t\t");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("} catch (IllegalArgumentException e) {");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("//Do something");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                }
              }
            }
          }
        }
      }
    }
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @param ");
    String _nameLower_10 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_10, " ");
    _builder.append("  ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*            the ");
    String _nameLower_11 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_11, " ");
    _builder.append(" to set");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public void ");
    CharSequence _setterName_2 = this.toSetterName(d);
    _builder.append(_setterName_2, "");
    _builder.append("(");
    String _typeName_2 = this.toTypeName(d);
    _builder.append(_typeName_2, "");
    _builder.append(" ");
    String _nameLower_12 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_12, "");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.");
    String _nameLower_13 = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower_13, "\t");
    _builder.append(" = ");
    {
      DataType _dataType = d.getDataType();
      boolean _isUnsigned = this.isUnsigned(_dataType);
      if (_isUnsigned) {
        _builder.append("(");
        String _simpleTypeName = this.toSimpleTypeName(d);
        _builder.append(_simpleTypeName, "\t");
        _builder.append(") (");
        String _nameLower_14 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_14, "\t");
        _builder.append(" - ");
        String _typeName_3 = this.toTypeName(d);
        _builder.append(_typeName_3, "\t");
        _builder.append(".MAX_VALUE)");
      } else {
        String _nameLower_15 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_15, "\t");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("} ");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _generateSetterBodyForMeasurementData(final MeasurementData data, final LinearDataConversion conversion) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("final double offset = ");
    double _offset = conversion.getOffset();
    _builder.append(_offset, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("final double scalingFactor = ");
    double _scalingFactor = conversion.getScalingFactor();
    _builder.append(_scalingFactor, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("this.");
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "");
    _builder.append(" = (");
    String _simpleTypeName = this.toSimpleTypeName(data);
    _builder.append(_simpleTypeName, "");
    _builder.append(") ");
    EObject _eContainer = data.eContainer();
    String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
    _builder.append(_sensorInterfaceName, "");
    _builder.append(SensIDLConstants.UTILITY_CLASS_NAME, "");
    _builder.append(".");
    _builder.append(SensIDLConstants.LINEAR_CONVERSION_METHOD_NAME, "");
    _builder.append("(");
    String _nameLower_1 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_1, "");
    _builder.append(", scalingFactor, offset);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _generateSetterBodyForMeasurementData(final MeasurementData data, final LinearDataConversionWithInterval conversion) {
    StringConcatenation _builder = new StringConcatenation();
    DataType _dataType = conversion.getDataType();
    String _typeName = this.toTypeName(_dataType);
    _builder.append(_typeName, "");
    _builder.append(" oldMin = (");
    DataType _dataType_1 = conversion.getDataType();
    String _simpleTypeName = this.toSimpleTypeName(_dataType_1);
    _builder.append(_simpleTypeName, "");
    _builder.append(") ");
    Interval _fromInterval = conversion.getFromInterval();
    double _lowerBound = _fromInterval.getLowerBound();
    _builder.append(_lowerBound, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    DataType _dataType_2 = conversion.getDataType();
    String _typeName_1 = this.toTypeName(_dataType_2);
    _builder.append(_typeName_1, "");
    _builder.append(" oldMax = (");
    DataType _dataType_3 = conversion.getDataType();
    String _simpleTypeName_1 = this.toSimpleTypeName(_dataType_3);
    _builder.append(_simpleTypeName_1, "");
    _builder.append(") ");
    Interval _fromInterval_1 = conversion.getFromInterval();
    double _upperBound = _fromInterval_1.getUpperBound();
    _builder.append(_upperBound, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    DataType _dataType_4 = conversion.getDataType();
    String _typeName_2 = this.toTypeName(_dataType_4);
    _builder.append(_typeName_2, "");
    _builder.append(" newMin = (");
    DataType _dataType_5 = conversion.getDataType();
    String _simpleTypeName_2 = this.toSimpleTypeName(_dataType_5);
    _builder.append(_simpleTypeName_2, "");
    _builder.append(") ");
    Interval _toInterval = conversion.getToInterval();
    double _lowerBound_1 = _toInterval.getLowerBound();
    _builder.append(_lowerBound_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    DataType _dataType_6 = conversion.getDataType();
    String _typeName_3 = this.toTypeName(_dataType_6);
    _builder.append(_typeName_3, "");
    _builder.append(" newMax = (");
    DataType _dataType_7 = conversion.getDataType();
    String _simpleTypeName_3 = this.toSimpleTypeName(_dataType_7);
    _builder.append(_simpleTypeName_3, "");
    _builder.append(") ");
    Interval _toInterval_1 = conversion.getToInterval();
    double _upperBound_1 = _toInterval_1.getUpperBound();
    _builder.append(_upperBound_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("this.");
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "");
    _builder.append(" = ");
    {
      DataType _dataType_8 = data.getDataType();
      boolean _isUnsigned = this.isUnsigned(_dataType_8);
      if (_isUnsigned) {
        _builder.append("(");
        String _simpleTypeName_4 = this.toSimpleTypeName(data);
        _builder.append(_simpleTypeName_4, "");
        _builder.append(") (");
        String _nameLower_1 = GenerationUtil.toNameLower(data);
        _builder.append(_nameLower_1, "");
        _builder.append(" - ");
        String _typeName_4 = this.toTypeName(data);
        _builder.append(_typeName_4, "");
        _builder.append(".MAX_VALUE)");
      } else {
        String _nameLower_2 = GenerationUtil.toNameLower(data);
        _builder.append(_nameLower_2, "");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("this.");
    String _nameLower_3 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_3, "");
    _builder.append("Adjusted = (");
    DataType _dataType_9 = conversion.getDataType();
    String _simpleTypeName_5 = this.toSimpleTypeName(_dataType_9);
    _builder.append(_simpleTypeName_5, "");
    _builder.append(") ");
    EObject _eContainer = data.eContainer();
    String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
    _builder.append(_sensorInterfaceName, "");
    _builder.append(SensIDLConstants.UTILITY_CLASS_NAME, "");
    _builder.append(".");
    _builder.append(SensIDLConstants.LINEAR_CONVERSION_WITH_INTERVAL_METHOD_NAME, "");
    _builder.append("(");
    String _nameLower_4 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_4, "");
    _builder.append(", oldMin, oldMax, newMin, newMax);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Generates the Setter Method for the non measurement data
   */
  public CharSequence generateSetter(final NonMeasurementData d) {
    CharSequence _xifexpression = null;
    boolean _isConstant = d.isConstant();
    if (_isConstant) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("// no setter for constant value");
      _builder.newLine();
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("/**");
      _builder_1.newLine();
      {
        DataType _dataType = d.getDataType();
        boolean _isUnsigned = this.isUnsigned(_dataType);
        if (_isUnsigned) {
          _builder_1.append(" ");
          _builder_1.append("* Java has no option for unsigned data types, so if the data has an ");
          _builder_1.newLine();
          _builder_1.append(" ");
          _builder_1.append("* unsigned data type the value is calculated by subtracting the maximum ");
          _builder_1.newLine();
          _builder_1.append(" ");
          _builder_1.append("* value from the signed data type and adding it again, if it is used.");
          _builder_1.newLine();
          _builder_1.append(" ");
          _builder_1.append("*");
          _builder_1.newLine();
        }
      }
      _builder_1.append(" ");
      _builder_1.append("* @param ");
      String _nameLower = GenerationUtil.toNameLower(d);
      _builder_1.append(_nameLower, " ");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append(" ");
      _builder_1.append("*            the ");
      String _nameLower_1 = GenerationUtil.toNameLower(d);
      _builder_1.append(_nameLower_1, " ");
      _builder_1.append(" to set");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append(" ");
      _builder_1.append("*/");
      _builder_1.newLine();
      _builder_1.append("public void ");
      CharSequence _setterName = this.toSetterName(d);
      _builder_1.append(_setterName, "");
      _builder_1.append("(");
      String _typeName = this.toTypeName(d);
      _builder_1.append(_typeName, "");
      _builder_1.append(" ");
      String _nameLower_2 = GenerationUtil.toNameLower(d);
      _builder_1.append(_nameLower_2, "");
      _builder_1.append("){");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.append("this.");
      String _nameLower_3 = GenerationUtil.toNameLower(d);
      _builder_1.append(_nameLower_3, "\t");
      _builder_1.append(" = ");
      {
        DataType _dataType_1 = d.getDataType();
        boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
        if (_isUnsigned_1) {
          _builder_1.append("(");
          String _simpleTypeName = this.toSimpleTypeName(d);
          _builder_1.append(_simpleTypeName, "\t");
          _builder_1.append(") (");
          String _nameLower_4 = GenerationUtil.toNameLower(d);
          _builder_1.append(_nameLower_4, "\t");
          _builder_1.append(" - ");
          String _typeName_1 = this.toTypeName(d);
          _builder_1.append(_typeName_1, "\t");
          _builder_1.append(".MAX_VALUE)");
        } else {
          String _nameLower_5 = GenerationUtil.toNameLower(d);
          _builder_1.append(_nameLower_5, "\t");
        }
      }
      _builder_1.append(";");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("} ");
      _builder_1.newLine();
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }
  
  /**
   * Maps to the corresponding language data type.
   * @see IDTOGenerator#toTypeName(Data)
   */
  public String toTypeName(final Data d) {
    DataType _dataType = d.getDataType();
    return this.toTypeName(_dataType);
  }
  
  /**
   * returns the appropriate type name for DataType
   */
  public String toTypeName(final DataType d) {
    String _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT8:
          _switchResult = Byte.class.getName();
          break;
        case UINT8:
          _switchResult = Byte.class.getName();
          break;
        case INT16:
          _switchResult = Short.class.getName();
          break;
        case UINT16:
          _switchResult = Short.class.getName();
          break;
        case INT32:
          _switchResult = Integer.class.getName();
          break;
        case UINT32:
          _switchResult = Integer.class.getName();
          break;
        case INT64:
          _switchResult = Long.class.getName();
          break;
        case UINT64:
          _switchResult = Long.class.getName();
          break;
        case FLOAT:
          _switchResult = Float.class.getName();
          break;
        case DOUBLE:
          _switchResult = Double.class.getName();
          break;
        case BOOLEAN:
          _switchResult = Boolean.class.getName();
          break;
        case STRING:
          _switchResult = String.class.getName();
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * returns true if the DataType is an unsigned DataType
   */
  public boolean isUnsigned(final DataType d) {
    if ((((Objects.equal(d, DataType.UINT8) || Objects.equal(d, DataType.UINT16)) || Objects.equal(d, DataType.UINT32)) || Objects.equal(d, DataType.UINT64))) {
      return true;
    }
    return false;
  }
  
  /**
   * returns the appropriate simple type name suitable for casting
   */
  public String toSimpleTypeName(final Data d) {
    DataType _dataType = d.getDataType();
    return this.toSimpleTypeName(_dataType);
  }
  
  /**
   * returns the appropriate simple type name suitable for casting for dataType
   */
  public String toSimpleTypeName(final DataType d) {
    String _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT8:
          _switchResult = "byte";
          break;
        case UINT8:
          _switchResult = "byte";
          break;
        case INT16:
          _switchResult = "short";
          break;
        case UINT16:
          _switchResult = "short";
          break;
        case INT32:
          _switchResult = "int";
          break;
        case UINT32:
          _switchResult = "int";
          break;
        case INT64:
          _switchResult = "long";
          break;
        case UINT64:
          _switchResult = "long";
          break;
        case FLOAT:
          _switchResult = "float";
          break;
        case DOUBLE:
          _switchResult = "double";
          break;
        case BOOLEAN:
          _switchResult = "boolean";
          break;
        case STRING:
          _switchResult = "String";
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * returns the Data Conversion type (at the moment
   * only LinearDataConversionWithIntervall has a type)
   */
  public DataType getDataConversionType(final MeasurementData d) {
    EList<DataAdjustment> _adjustments = d.getAdjustments();
    boolean _isEmpty = _adjustments.isEmpty();
    if (_isEmpty) {
      return null;
    }
    EList<DataAdjustment> _adjustments_1 = d.getAdjustments();
    Iterable<LinearDataConversionWithInterval> conversion = Iterables.<LinearDataConversionWithInterval>filter(_adjustments_1, LinearDataConversionWithInterval.class);
    if ((IterableExtensions.isEmpty(conversion) || Objects.equal(conversion, null))) {
      return null;
    }
    LinearDataConversionWithInterval _head = IterableExtensions.<LinearDataConversionWithInterval>head(conversion);
    return _head.getDataType();
  }
  
  /**
   * @return true if the MeasurementData is adjusted
   * with linear data conversion with interval
   */
  public boolean hasLinearDataConversionWithInterval(final MeasurementData data) {
    EList<DataAdjustment> _adjustments = data.getAdjustments();
    Iterable<LinearDataConversionWithInterval> _filter = Iterables.<LinearDataConversionWithInterval>filter(_adjustments, LinearDataConversionWithInterval.class);
    boolean _isEmpty = IterableExtensions.isEmpty(_filter);
    return (!_isEmpty);
  }
  
  public String addFileExtensionTo(final String ClassName) {
    return (ClassName + SensIDLConstants.JAVA_EXTENSION);
  }
  
  public CharSequence generateConverterMethods(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<DataSet> _usedDataSets = d.getUsedDataSets();
      for(final DataSet pdataSet : _usedDataSets) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Converts a big endian ");
        String _nameUpper = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper, " ");
        _builder.append(" Object into a little endian ");
        String _nameUpper_1 = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper_1, " ");
        _builder.append(" Object");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*\t");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param the ");
        String _nameUpper_2 = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper_2, " ");
        _builder.append(" Object to convert");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return ");
        String _nameUpper_3 = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper_3, " ");
        _builder.append(" the converted ");
        String _nameUpper_4 = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper_4, " ");
        _builder.append(" Object");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _nameUpper_5 = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper_5, "");
        _builder.append(" convertToLittleEndian(");
        String _nameUpper_6 = GenerationUtil.toNameUpper(pdataSet);
        _builder.append(_nameUpper_6, "");
        _builder.append(" ");
        String _nameLower = GenerationUtil.toNameLower(pdataSet);
        _builder.append(_nameLower, "");
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//");
        String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
        _builder.append(_sensIDLTodoTag, "\t");
        _builder.append(": implement Method");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    CharSequence _convertAllToTLitteEndian = this.convertAllToTLitteEndian(d);
    _builder.append(_convertAllToTLitteEndian, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence convertAllToTLitteEndian(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void ");
    _builder.append(SensIDLConstants.JAVA_CONVERT_ALL_TO_LITTLE_ENDIAN_METHOD_NAME, "");
    _builder.append("(){");
    _builder.newLineIfNotEmpty();
    {
      EList<EObject> _eContents = d.eContents();
      Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_eContents, MeasurementData.class);
      for(final MeasurementData data : _filter) {
        _builder.append("\t");
        String _nameLower = GenerationUtil.toNameLower(data);
        _builder.append(_nameLower, "\t");
        _builder.append(" = ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append(_sensorInterfaceName, "\t");
        _builder.append(SensIDLConstants.UTILITY_CLASS_NAME, "\t");
        _builder.append(".convertToLittleEndian(");
        String _nameLower_1 = GenerationUtil.toNameLower(data);
        _builder.append(_nameLower_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<EObject> _eContents_1 = d.eContents();
      Iterable<NonMeasurementData> _filter_1 = Iterables.<NonMeasurementData>filter(_eContents_1, NonMeasurementData.class);
      for(final NonMeasurementData data_1 : _filter_1) {
        {
          boolean _isConstant = data_1.isConstant();
          if (_isConstant) {
            _builder.append("\t");
            String _name = data_1.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "\t");
            _builder.append(" = ");
            EObject _eContainer_1 = data_1.eContainer();
            String _sensorInterfaceName_1 = GenerationUtil.getSensorInterfaceName(_eContainer_1);
            _builder.append(_sensorInterfaceName_1, "\t");
            _builder.append(SensIDLConstants.UTILITY_CLASS_NAME, "\t");
            _builder.append(".convertToLittleEndian(");
            String _name_1 = data_1.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder.append(_upperCase_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            String _nameLower_2 = GenerationUtil.toNameLower(data_1);
            _builder.append(_nameLower_2, "\t");
            _builder.append(" = ");
            EObject _eContainer_2 = data_1.eContainer();
            String _sensorInterfaceName_2 = GenerationUtil.getSensorInterfaceName(_eContainer_2);
            _builder.append(_sensorInterfaceName_2, "\t");
            _builder.append(SensIDLConstants.UTILITY_CLASS_NAME, "\t");
            _builder.append(".convertToLittleEndian(");
            String _nameLower_3 = GenerationUtil.toNameLower(data_1);
            _builder.append(_nameLower_3, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      EList<DataSet> _usedDataSets = d.getUsedDataSets();
      for(final DataSet pdataSet : _usedDataSets) {
        _builder.append("\t");
        String _nameLower_4 = GenerationUtil.toNameLower(pdataSet);
        _builder.append(_nameLower_4, "\t");
        _builder.append(" = convertToLittleEndian(");
        String _nameLower_5 = GenerationUtil.toNameLower(pdataSet);
        _builder.append(_nameLower_5, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateSetterBodyForMeasurementData(final MeasurementData data, final DataConversion conversion) {
    if (conversion instanceof LinearDataConversion) {
      return _generateSetterBodyForMeasurementData(data, (LinearDataConversion)conversion);
    } else if (conversion instanceof LinearDataConversionWithInterval) {
      return _generateSetterBodyForMeasurementData(data, (LinearDataConversionWithInterval)conversion);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(data, conversion).toString());
    }
  }
}
