package de.fzi.sensidl.language.generator.factory.c;

import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import de.fzi.sensidl.language.generator.factory.c.DataTypes;
import java.util.List;

/**
 * C code generator for the SensIDL Model.
 * Code will be generated by running the {@code generate()}-Method
 */
@SuppressWarnings("all")
public abstract class CDTOGenerator implements IDTOGenerator {
  protected List<DataSet> dataSets;
  
  /**
   * The constructor calls the constructor of the superclass to set a list of DataSet-elements.
   * @param newDataSet Represents the list of DataSet-elements.
   */
  public CDTOGenerator(final List<DataSet> newDataSet) {
    this.dataSets = newDataSet;
  }
  
  /**
   * Maps to the corresponding language type.
   * @see IDTOGenerator#toTypeName(Data)
   */
  public String toTypeName(final Data data) {
    DataType _dataType = data.getDataType();
    return DataTypes.getDataTypeBy(_dataType);
  }
  
  public String toTypeName(final DataType dataType) {
    return DataTypes.getDataTypeBy(dataType);
  }
}
