/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.design.sensidl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Endianness implements Enumerator
{
    BIG_ENDIAN(0, "BIG_ENDIAN", "BIG_ENDIAN"),
    LITTLE_ENDIAN(1, "LITTLE_ENDIAN", "LITTLE_ENDIAN");

    public static final int BIG_ENDIAN_VALUE = 0;
    public static final int LITTLE_ENDIAN_VALUE = 1;
    private static final Endianness[] VALUES_ARRAY;
    public static final List<Endianness> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Endianness[]{BIG_ENDIAN, LITTLE_ENDIAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Endianness get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Endianness result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Endianness getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Endianness result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Endianness get(int value) {
        switch (value) {
            case 0: {
                return BIG_ENDIAN;
            }
            case 1: {
                return LITTLE_ENDIAN;
            }
        }
        return null;
    }

    private Endianness(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

