/**
 */
package de.fzi.sensidl.design.sensidl.dataRepresentation.provider;

import de.fzi.sensidl.design.sensidl.dataRepresentation.util.DataRepresentationAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DataRepresentationItemProviderAdapterFactory extends DataRepresentationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataRepresentationItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SensorDataDescriptionItemProvider sensorDataDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSensorDataDescriptionAdapter() {
		if (sensorDataDescriptionItemProvider == null) {
			sensorDataDescriptionItemProvider = new SensorDataDescriptionItemProvider(this);
		}

		return sensorDataDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSetItemProvider dataSetItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataSetAdapter() {
		if (dataSetItemProvider == null) {
			dataSetItemProvider = new DataSetItemProvider(this);
		}

		return dataSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MeasurementDataItemProvider measurementDataItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMeasurementDataAdapter() {
		if (measurementDataItemProvider == null) {
			measurementDataItemProvider = new MeasurementDataItemProvider(this);
		}

		return measurementDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NonMeasurementDataItemProvider nonMeasurementDataItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNonMeasurementDataAdapter() {
		if (nonMeasurementDataItemProvider == null) {
			nonMeasurementDataItemProvider = new NonMeasurementDataItemProvider(this);
		}

		return nonMeasurementDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataRangeItemProvider dataRangeItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataRangeAdapter() {
		if (dataRangeItemProvider == null) {
			dataRangeItemProvider = new DataRangeItemProvider(this);
		}

		return dataRangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataConversionItemProvider dataConversionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataConversionAdapter() {
		if (dataConversionItemProvider == null) {
			dataConversionItemProvider = new DataConversionItemProvider(this);
		}

		return dataConversionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinearDataConversionItemProvider linearDataConversionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinearDataConversionAdapter() {
		if (linearDataConversionItemProvider == null) {
			linearDataConversionItemProvider = new LinearDataConversionItemProvider(this);
		}

		return linearDataConversionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinearDataConversionWithIntervalItemProvider linearDataConversionWithIntervalItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinearDataConversionWithIntervalAdapter() {
		if (linearDataConversionWithIntervalItemProvider == null) {
			linearDataConversionWithIntervalItemProvider = new LinearDataConversionWithIntervalItemProvider(this);
		}

		return linearDataConversionWithIntervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.Interval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntervalItemProvider intervalItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.Interval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntervalAdapter() {
		if (intervalItemProvider == null) {
			intervalItemProvider = new IntervalItemProvider(this);
		}

		return intervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.Method} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodItemProvider methodItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.Method}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodAdapter() {
		if (methodItemProvider == null) {
			methodItemProvider = new MethodItemProvider(this);
		}

		return methodItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodParameterItemProvider methodParameterItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodParameterAdapter() {
		if (methodParameterItemProvider == null) {
			methodParameterItemProvider = new MethodParameterItemProvider(this);
		}

		return methodParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.sensidl.design.sensidl.dataRepresentation.ListData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListDataItemProvider listDataItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.sensidl.design.sensidl.dataRepresentation.ListData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListDataAdapter() {
		if (listDataItemProvider == null) {
			listDataItemProvider = new ListDataItemProvider(this);
		}

		return listDataItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (sensorDataDescriptionItemProvider != null) sensorDataDescriptionItemProvider.dispose();
		if (dataSetItemProvider != null) dataSetItemProvider.dispose();
		if (measurementDataItemProvider != null) measurementDataItemProvider.dispose();
		if (nonMeasurementDataItemProvider != null) nonMeasurementDataItemProvider.dispose();
		if (dataRangeItemProvider != null) dataRangeItemProvider.dispose();
		if (dataConversionItemProvider != null) dataConversionItemProvider.dispose();
		if (linearDataConversionItemProvider != null) linearDataConversionItemProvider.dispose();
		if (linearDataConversionWithIntervalItemProvider != null) linearDataConversionWithIntervalItemProvider.dispose();
		if (intervalItemProvider != null) intervalItemProvider.dispose();
		if (methodItemProvider != null) methodItemProvider.dispose();
		if (methodParameterItemProvider != null) methodParameterItemProvider.dispose();
		if (listDataItemProvider != null) listDataItemProvider.dispose();
	}

}
