/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.vorto.generator;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.fzi.sensidl.language.SensidlStandaloneSetup;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensidlGenerator;
import de.fzi.sensidl.language.ui.exception.NoSidlFileException;
import java.io.FileNotFoundException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.service.AbstractGenericModule;

public class GenerationHandlerVorto {
    private static SensidlGenerator generator;
    private static SensIDLConstants.GenerationLanguage generationLanguage;

    static {
        generationLanguage = SensIDLConstants.GenerationLanguage.NONE;
    }

    private GenerationHandlerVorto() {
    }

    public static boolean generate(String outputPath, Resource sensidlModel, String language) throws NoSidlFileException, FileNotFoundException {
        GenerationHandlerVorto.setGenerationLanguage(language);
        Injector injector = new SensidlStandaloneSetup().createInjectorAndDoEMFRegistration();
        JavaIoFileSystemAccess fsa = new JavaIoFileSystemAccess();
        fsa.setOutputPath(outputPath);
        generator = (SensidlGenerator)injector.getInstance(SensidlGenerator.class);
        generator.setGenerationLanguage(generationLanguage);
        Guice.createInjector((Module[])new Module[]{new AbstractGenericModule(){

            public Class<? extends IEncodingProvider> bindIEncodingProvider() {
                return IEncodingProvider.Runtime.class;
            }
        }}).injectMembers((Object)fsa);
        generator.doGenerate(sensidlModel, (IFileSystemAccess)fsa);
        return true;
    }

    public static SensIDLConstants.GenerationLanguage getGenerationLanguage() {
        return generationLanguage;
    }

    private static void setGenerationLanguage(String language) {
        switch (language) {
            case "Java": {
                generationLanguage = SensIDLConstants.GenerationLanguage.JAVA;
                break;
            }
            case "Java Plug-in Project": {
                generationLanguage = SensIDLConstants.GenerationLanguage.JAVA_PLUGIN_PROJECT;
                break;
            }
            case "JavaScript": {
                generationLanguage = SensIDLConstants.GenerationLanguage.JAVASCRIPT;
                break;
            }
            case "C#": {
                generationLanguage = SensIDLConstants.GenerationLanguage.CSHARP;
                break;
            }
            case "C": {
                generationLanguage = SensIDLConstants.GenerationLanguage.C;
                break;
            }
            case "All": {
                generationLanguage = SensIDLConstants.GenerationLanguage.ALL;
                break;
            }
            default: {
                generationLanguage = SensIDLConstants.GenerationLanguage.NONE;
            }
        }
    }
}

