/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.generationstep.filegenerationstep;

import com.google.common.io.Files;
import de.fzi.sensidl.language.generator.generationstep.GenerationStep;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FileGenerationStep
extends GenerationStep {
    private static final Logger logger = Logger.getLogger(FileGenerationStep.class);
    private static final int LINE_LENGTH = 80;
    private static final String SEPARATION_STRING = ", ";
    private static final String UNIFIED_TAB_DISTANCE = "\t\t\t\t\t\t\t\t";
    private static final String START_SYMBOL = "*";
    private final IFileSystemAccess fsa;
    private HashMap<String, ArrayList<String>> fileCache;

    public FileGenerationStep(IFileSystemAccess newFsa) {
        this.fsa = newFsa;
        HashMap _hashMap = new HashMap();
        this.fileCache = _hashMap;
    }

    @Override
    public void startGenerationTask() {
        Set<String> _keySet = GenerationStep.filesToGenerate.keySet();
        for (String file : _keySet) {
            logger.info((Object)("Start with code-generation of file " + file));
            this.insertVersioningCommentTo(file);
            CharSequence _get = GenerationStep.filesToGenerate.get(file);
            this.fsa.generateFile(file, _get);
            logger.info((Object)("File " + file + " was successfully generated"));
        }
    }

    public CharSequence insertVersioningCommentTo(String file) {
        boolean _equals;
        CharSequence _xblockexpression = null;
        String _fileExtension = Files.getFileExtension((String)file);
        ArrayList<String> fileExtensions = this.createExtensions(_fileExtension);
        boolean _extensionsAlreadyInCache = this.extensionsAlreadyInCache(fileExtensions);
        boolean bl = _equals = !_extensionsAlreadyInCache;
        if (_equals) {
            this.getAllFilesWithSameExtension(fileExtensions);
        }
        CharSequence _get = GenerationStep.filesToGenerate.get(file);
        StringBuilder fileToEdit = new StringBuilder(_get);
        String _property = System.getProperty("line.separator");
        fileToEdit.insert(0, _property);
        CharSequence _versioningComment = this.getVersioningComment(fileExtensions, file);
        fileToEdit.insert(0, _versioningComment);
        _xblockexpression = GenerationStep.filesToGenerate.put(file, fileToEdit);
        return _xblockexpression;
    }

    public boolean extensionsAlreadyInCache(final ArrayList<String> fileExtensions) {
        Set<String> _keySet = this.fileCache.keySet();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(final String cachedExtension) {
                Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String fileExtension) {
                        return fileExtension.equals(cachedExtension);
                    }
                };
                return IterableExtensions.exists((Iterable)fileExtensions, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.exists(_keySet, (Functions.Function1)_function);
    }

    public ArrayList<String> createExtensions(final String fileExtension) {
        boolean _equals_1;
        final String editedCExtension = Files.getFileExtension((String)".c");
        final String editedHeaderExtension = Files.getFileExtension((String)".h");
        boolean _or = false;
        boolean _equals = fileExtension.equals(editedCExtension);
        _or = _equals ? true : (_equals_1 = fileExtension.equals(editedHeaderExtension));
        if (_or) {
            ArrayList _arrayList = new ArrayList();
            Procedures.Procedure1<ArrayList<String>> _function = new Procedures.Procedure1<ArrayList<String>>(){

                public void apply(ArrayList<String> it) {
                    it.add(editedCExtension);
                    it.add(editedHeaderExtension);
                }
            };
            return (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        }
        ArrayList _arrayList_1 = new ArrayList();
        Procedures.Procedure1<ArrayList<String>> _function_1 = new Procedures.Procedure1<ArrayList<String>>(){

            public void apply(ArrayList<String> it) {
                it.add(fileExtension);
            }
        };
        return (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList_1, (Procedures.Procedure1)_function_1);
    }

    public String getUnifiedIdentifier(ArrayList<String> fileExtensions) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String unifiedIdentifier = _builder.toString();
        for (String ext : fileExtensions) {
            String _unifiedIdentifier = unifiedIdentifier;
            unifiedIdentifier = String.valueOf(_unifiedIdentifier) + "_" + ext;
        }
        _xblockexpression = unifiedIdentifier;
        return _xblockexpression;
    }

    public void getAllFilesWithSameExtension(ArrayList<String> fileExtensions) {
        ArrayList<String> files = new ArrayList<String>();
        Set<String> _keySet = GenerationStep.filesToGenerate.keySet();
        for (final String filename : _keySet) {
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String fileExtension) {
                    String _fileExtension = Files.getFileExtension((String)filename);
                    return _fileExtension.equals(fileExtension);
                }
            };
            boolean _exists = IterableExtensions.exists(fileExtensions, (Functions.Function1)_function);
            if (!_exists) continue;
            files.add(filename);
        }
        String _unifiedIdentifier = this.getUnifiedIdentifier(fileExtensions);
        this.fileCache.put(_unifiedIdentifier, files);
    }

    public CharSequence getVersioningComment(ArrayList<String> fileExtensions, String currentFileName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"*File:\t\t\t\t\t\t\t");
        _builder.append((Object)currentFileName, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*Version:\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"*Generate at:\t\t\t\t\t");
        SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date _date = new Date();
        String _format = _simpleDateFormat.format(_date);
        _builder.append((Object)_format, "");
        _builder.newLineIfNotEmpty();
        Object _printFiles = this.printFiles(currentFileName, fileExtensions);
        _builder.append(_printFiles, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        return _builder;
    }

    public Object printFiles(String currentEditedFile, ArrayList<String> fileExtensions) {
        Object _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String filesToPrint = _builder.toString();
        int counter = 1;
        String _unifiedIdentifier = this.getUnifiedIdentifier(fileExtensions);
        ArrayList<String> files = this.fileCache.get(_unifiedIdentifier);
        String _filesToPrint = filesToPrint;
        filesToPrint = String.valueOf(_filesToPrint) + "*Further generated artifacts:\t";
        for (String currentFile : files) {
            int _length;
            boolean _greaterEqualsThan;
            boolean _not;
            boolean _equals = currentFile.equals(currentEditedFile);
            boolean bl = _not = !_equals;
            if (_not) {
                String _filesToPrint_1 = filesToPrint;
                String _filesToPrint_2 = filesToPrint = String.valueOf(_filesToPrint_1) + currentFile;
                filesToPrint = String.valueOf(_filesToPrint_2) + SEPARATION_STRING;
            }
            boolean bl2 = _greaterEqualsThan = (_length = filesToPrint.length()) >= 80 * counter;
            if (!_greaterEqualsThan) continue;
            String _filesToPrint_3 = filesToPrint;
            String _property = System.getProperty("line.separator");
            String _filesToPrint_4 = filesToPrint = String.valueOf(_filesToPrint_3) + _property;
            filesToPrint = String.valueOf(_filesToPrint_4) + "*\t\t\t\t\t\t\t\t";
            ++counter;
        }
        StringBuilder _stringBuilder = new StringBuilder(filesToPrint);
        _xblockexpression = this.postProcessing(_stringBuilder);
        return _xblockexpression;
    }

    /*
     * Unable to fully structure code
     */
    public Object postProcessing(StringBuilder filesToPrint) {
        _xblockexpression = null;
        comma = ",";
        _string = filesToPrint.toString();
        _contains = _string.contains(",");
        v0 = _not = _contains == false;
        if (!_not) ** GOTO lbl12
        return filesToPrint;
lbl-1000:
        // 1 sources

        {
            _length = filesToPrint.length();
            _minus = _length - 1;
            filesToPrint.deleteCharAt(_minus);
lbl12:
            // 2 sources

            ** while (!filesToPrint.toString().endsWith((String)","))
        }
lbl13:
        // 1 sources

        _length = filesToPrint.length();
        _minus = _length - 1;
        filesToPrint.deleteCharAt(_minus);
        _xblockexpression = filesToPrint.toString();
        return _xblockexpression;
    }
}

