/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.sidl;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SidlDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(SidlDTOGenerator.class);
    private List<DataSet> dataSet;

    public SidlDTOGenerator(List<DataSet> sets) {
        this.dataSet = sets;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a JavaScript data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        DataSet _get = this.dataSet.get(0);
        EObject _eContainer = _get.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        String _addFileExtensionTo = this.addFileExtensionTo(_sensorInterfaceName);
        DataSet _get_1 = this.dataSet.get(0);
        EObject _eContainer_1 = _get_1.eContainer();
        String _sensorInterfaceName_1 = GenerationUtil.getSensorInterfaceName(_eContainer_1);
        DataSet _get_2 = this.dataSet.get(0);
        EObject _eContainer_2 = _get_2.eContainer();
        CharSequence _generateClass = this.generateClass(_sensorInterfaceName_1, _eContainer_2);
        filesToGenerate.put(_addFileExtensionTo, _generateClass);
        DataSet _get_3 = this.dataSet.get(0);
        EObject _eContainer_3 = _get_3.eContainer();
        String _sensorInterfaceName_2 = GenerationUtil.getSensorInterfaceName(_eContainer_3);
        String _addFileExtensionTo_1 = this.addFileExtensionTo(_sensorInterfaceName_2);
        String _plus = "File: " + _addFileExtensionTo_1;
        String _plus_1 = String.valueOf(_plus) + " was generated in ";
        String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
        logger.info((Object)_plus_2);
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClass(String name, EObject sensorInterface) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"sensorInterface ");
        _builder.append((Object)name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"encoding: SENSIDL_BINARY, endianness: BIG_ENDIAN, alignment: 1 BIT");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"sensorData {");
        _builder.newLine();
        for (DataSet d : this.dataSet) {
            _builder.append((Object)"\t\t");
            CharSequence _generateDataSet = this.generateDataSet(d);
            _builder.append((Object)_generateDataSet, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder;
    }

    public CharSequence generateDataSet(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"dataSet ");
        String _name = d.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        CharSequence _uses = this.getUses(d);
        _builder.append((Object)_uses, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            _builder.append((Object)"\t");
            String _name_1 = data.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)" as ");
            DataType _dataType = data.getDataType();
            _builder.append((Object)_dataType, "\t");
            _builder.append((Object)" ");
            CharSequence _createUnit = this.createUnit(data);
            _builder.append((Object)_createUnit, "\t");
            _builder.append((Object)" ");
            CharSequence _createDescription = this.createDescription(data);
            _builder.append((Object)_createDescription, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createDescription(Data d) {
        boolean _notEquals;
        StringConcatenation _xifexpression = null;
        String _description = d.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/** ");
            String _description_1 = d.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.append((Object)" */ ");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1;
            _xifexpression = _builder_1 = new StringConcatenation();
        }
        return _xifexpression;
    }

    public CharSequence createUnit(Data d) {
        StringConcatenation _xifexpression = null;
        if (d instanceof MeasurementData) {
            boolean _notEquals;
            StringConcatenation _xifexpression_1 = null;
            Unit _unit = ((MeasurementData)d).getUnit();
            boolean bl = _notEquals = !Objects.equal((Object)_unit, null);
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"in ");
                Unit _unit_1 = ((MeasurementData)d).getUnit();
                _builder.append((Object)_unit_1, "");
                _xifexpression_1 = _builder;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"in Dimensionless");
                _xifexpression_1 = _builder_1;
            }
            _xifexpression = _xifexpression_1;
        } else {
            StringConcatenation _builder_2;
            _xifexpression = _builder_2 = new StringConcatenation();
        }
        return _xifexpression;
    }

    public CharSequence getUses(DataSet d) {
        boolean _not;
        StringConcatenation _xifexpression = null;
        EList _usedDataSets = d.getUsedDataSets();
        boolean _isEmpty = _usedDataSets.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"uses ");
            EList _usedDataSets_1 = d.getUsedDataSets();
            DataSet _head = (DataSet)IterableExtensions.head((Iterable)_usedDataSets_1);
            String _name = _head.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" ");
            EList _usedDataSets_2 = d.getUsedDataSets();
            Iterable _tail = IterableExtensions.tail((Iterable)_usedDataSets_2);
            for (DataSet dataSet : _tail) {
                _builder.append((Object)", ");
                String _name_1 = dataSet.getName();
                _builder.append((Object)_name_1, "");
            }
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1;
            _xifexpression = _builder_1 = new StringConcatenation();
        }
        return _xifexpression;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".sidl";
    }

    @Override
    public String toTypeName(Data data) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }
}

