/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.csharp;

import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IUtilityGenerator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CSharpUtilityGenerator
implements IUtilityGenerator {
    private static Logger logger = Logger.getLogger(CSharpUtilityGenerator.class);
    private List<MeasurementData> data;
    private SensorInterface currentSensorInterface;
    private boolean createProject = false;

    public CSharpUtilityGenerator(List<EObject> newData) {
        SensorInterface _get;
        List _list;
        Iterable _filter = Iterables.filter(newData, MeasurementData.class);
        this.data = _list = IterableExtensions.toList((Iterable)_filter);
        Iterable _filter_1 = Iterables.filter(newData, SensorInterface.class);
        this.currentSensorInterface = _get = ((SensorInterface[])Conversions.unwrapArray((Object)_filter_1, SensorInterface.class))[0];
    }

    public CSharpUtilityGenerator(List<MeasurementData> newData, boolean createProject) {
        SensorInterface _get;
        this.data = newData;
        Iterable _filter = Iterables.filter(newData, SensorInterface.class);
        this.currentSensorInterface = _get = ((SensorInterface[])Conversions.unwrapArray((Object)_filter, SensorInterface.class))[0];
        this.createProject = createProject;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the csharp utility class.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        String utilityName = GenerationUtil.getUtilityName((EObject)this.currentSensorInterface);
        if (this.createProject) {
            String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName((EObject)this.currentSensorInterface);
            String _plus = "src/de/fzi/sensidl/" + _sensorInterfaceName;
            String _plus_1 = String.valueOf(_plus) + "/";
            String _addFileExtensionTo = this.addFileExtensionTo(utilityName);
            String _plus_2 = String.valueOf(_plus_1) + _addFileExtensionTo;
            CharSequence _generateClassBody = this.generateClassBody(utilityName);
            filesToGenerate.put(_plus_2, _generateClassBody);
        } else {
            String _addFileExtensionTo_1 = this.addFileExtensionTo(utilityName);
            CharSequence _generateClassBody_1 = this.generateClassBody(utilityName);
            filesToGenerate.put(_addFileExtensionTo_1, _generateClassBody_1);
        }
        String _addFileExtensionTo_2 = this.addFileExtensionTo(utilityName);
        String _plus_3 = "File: " + _addFileExtensionTo_2;
        String _plus_4 = String.valueOf(_plus_3) + " was generated in ";
        String _plus_5 = String.valueOf(_plus_4) + "./src-gen";
        logger.info((Object)_plus_5);
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClassBody(String className) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/// <summary>");
        _builder.newLine();
        _builder.append((Object)"/// Data transfer object for ");
        _builder.append((Object)className, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/// ");
        _builder.newLine();
        _builder.append((Object)"/// @generated");
        _builder.newLine();
        _builder.append((Object)"/// </summary>");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        int _size = this.data.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append((Object)"\t");
            CharSequence _generateConversionMethods = this.generateConversionMethods();
            _builder.append((Object)_generateConversionMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateConversionMethods() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<MeasurementData, Boolean> _function = new Functions.Function1<MeasurementData, Boolean>(){

            public Boolean apply(MeasurementData data) {
                EList _adjustments = data.getAdjustments();
                DataAdjustment _get = (DataAdjustment)_adjustments.get(0);
                return _get instanceof LinearDataConversion;
            }
        };
        boolean _exists = IterableExtensions.exists(this.data, (Functions.Function1)_function);
        if (_exists) {
            CharSequence _generateLinearDataConversionMethod = this.generateLinearDataConversionMethod();
            _builder.append((Object)_generateLinearDataConversionMethod, "");
            _builder.newLineIfNotEmpty();
            CharSequence _generateGetMaxValueOfMethod = this.generateGetMaxValueOfMethod();
            _builder.append((Object)_generateGetMaxValueOfMethod, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1<MeasurementData, Boolean> _function_1 = new Functions.Function1<MeasurementData, Boolean>(){

            public Boolean apply(MeasurementData data) {
                EList _adjustments = data.getAdjustments();
                DataAdjustment _get = (DataAdjustment)_adjustments.get(0);
                return _get instanceof LinearDataConversionWithInterval;
            }
        };
        boolean _exists_1 = IterableExtensions.exists(this.data, (Functions.Function1)_function_1);
        if (_exists_1) {
            CharSequence _generateLinearDataConversionWithIntervalMethod = this.generateLinearDataConversionWithIntervalMethod();
            _builder.append((Object)_generateLinearDataConversionWithIntervalMethod, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateLinearDataConversionMethod() {
        StringConcatenation _xblockexpression = null;
        String dataType = "double";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public static ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" ");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(Number independentVariable, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" scalingFactor, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" offset) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Conversion is calculated by the linear-function f(x) = m*x + b");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"double calculatedValue = (scalingFactor * independentVariable.doubleValue()) + offset;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (getMaxValueOf(independentVariable) >= calculatedValue) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return calculatedValue;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"The value is larger than the range of the data type.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateLinearDataConversionWithIntervalMethod() {
        StringConcatenation _xblockexpression = null;
        String dataType = "double";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public static ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" ");
        _builder.append((Object)"linearConversionWithInterval", "");
        _builder.append((Object)"(Number independentVariable, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" oldMin, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" oldMax, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" newMin, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" newMax) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Conversion is calculated by the mapping rule f(x) = (((x - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (independentVariable.doubleValue() < oldMin || independentVariable.doubleValue() > oldMax) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"The value is larger than specified minimal and maximal range.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (((independentVariable.doubleValue() - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateGetMaxValueOfMethod() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"private static double getMaxValueOf(Number number) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (number instanceof Byte) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Byte.MAX_VALUE;\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Short) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Short.MAX_VALUE;\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Integer) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Integer.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Long) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Long.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Float) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Float.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Double.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".cs";
    }
}

