/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.converters;

import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class StringHexConverter
implements IValueConverter<String> {
    private static final String HEX_INDICATOR = "0x";
    private static final String QUOTATION_MARK = "\"";
    private static final String REGEX_FOR_NUMBERS = "[0-9]*";
    private static final String HEX_REGEX = "^(0x)[0-9A-Fa-f]+";
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int MAX_8_BIT_VALUE = 255;
    private static final int MAX_16_BIT_VALUE = 65535;

    public String toValue(String string, INode node) throws ValueConverterException {
        int base = 10;
        string = string.replaceAll(QUOTATION_MARK, "");
        NonMeasurementData data = (NonMeasurementData)node.getSemanticElement();
        if (data.getDataType().getValue() == 11) {
            return string;
        }
        if (data.getDataType().getValue() == 10) {
            if (string.toLowerCase().equals("true")) {
                return "true";
            }
            if (string.toLowerCase().equals("false")) {
                return "false";
            }
            throw new ValueConverterException("No valide string.", node, null);
        }
        if (!(node.getSemanticElement() instanceof NonMeasurementData)) {
            return string;
        }
        if (string == null || string == "") {
            throw new ValueConverterException("No valide string.", node, null);
        }
        if (this.isHex(string).booleanValue()) {
            base = 16;
            string = string.replaceAll(HEX_INDICATOR, "");
        } else if (!this.isNumber(string).booleanValue()) {
            throw new ValueConverterException("No valide string.", node, null);
        }
        switch (data.getDataType().getValue()) {
            case 0: {
                Byte value = Byte.parseByte(string, base);
                return ((Object)value).toString();
            }
            case 1: {
                Integer value = Integer.parseUnsignedInt(string, base) & 0xFF;
                return ((Object)value).toString();
            }
            case 2: {
                Short value = Short.parseShort(string, base);
                return ((Object)value).toString();
            }
            case 3: {
                Integer value = Integer.parseUnsignedInt(string, base) & 0xFFFF;
                return ((Object)value).toString();
            }
            case 4: {
                Integer value = Integer.parseInt(string, base);
                return ((Object)value).toString();
            }
            case 5: {
                Integer value = Integer.parseUnsignedInt(string, base);
                return ((Object)value).toString();
            }
            case 6: {
                Long value = Long.parseLong(string, base);
                return ((Object)value).toString();
            }
            case 7: {
                Long value = Long.parseUnsignedLong(string, base);
                return ((Object)value).toString();
            }
            case 8: {
                Integer value = Integer.parseInt(string, base);
                return ((Object)value).toString();
            }
            case 9: {
                Long value = Long.parseLong(string, base);
                return ((Object)value).toString();
            }
        }
        throw new ValueConverterException("Data type not supported", node, null);
    }

    private Boolean isNumber(String string) {
        return string.replaceAll(REGEX_FOR_NUMBERS, "").equals("");
    }

    private Boolean isHex(String string) {
        return string.matches(HEX_REGEX);
    }

    public String toString(String value) throws ValueConverterException {
        return value;
    }
}

