/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.converters;

import com.google.inject.Inject;
import de.fzi.sensidl.language.converters.DOUBLEValueConverter;
import de.fzi.sensidl.language.converters.JScienceUnitValueConverter;
import de.fzi.sensidl.language.converters.StringHexConverter;
import javax.measure.unit.Unit;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class SensIDLValueConverterService
extends DefaultTerminalConverters {
    @Inject
    private DOUBLEValueConverter doubleValueConverter;
    @Inject
    private JScienceUnitValueConverter jScienceUnitValueConverter;

    @ValueConverter(rule="DOUBLE")
    public IValueConverter<Double> DOUBLE() {
        return this.doubleValueConverter;
    }

    @ValueConverter(rule="UNIT")
    public IValueConverter<Unit> UNIT() {
        return this.jScienceUnitValueConverter;
    }

    @ValueConverter(rule="DESCRIPTION")
    public IValueConverter<String> DESCRIPTION() {
        return new IValueConverter<String>(){

            public String toValue(String string, INode node) throws ValueConverterException {
                return this.toString(string);
            }

            public String toString(String value) throws ValueConverterException {
                return value.substring(3, value.length() - 2);
            }
        };
    }

    @ValueConverter(rule="STRING")
    public IValueConverter<String> STRING() {
        return new StringHexConverter();
    }
}

