/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.templates.java.opcua;

import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.language.generator.templates.EclipsePuplicLicenseTemplate;
import de.fzi.sensidl.language.generator.templates.ITemplate;
import de.fzi.sensidl.language.generator.templates.java.opcua.OpcUaUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OpcUaServerTemplate
extends ITemplate<SensorInterface> {
    private static final String CLASS_NAME_SUFFIX = "OpcUaServer";
    private static final int DEFAULT_PORT = 12686;
    private final String packagePrefix;

    public OpcUaServerTemplate(SensorInterface newElement, String newPackagePrefix) {
        super(newElement);
        this.packagePrefix = newPackagePrefix;
    }

    @Override
    public CharSequence getCode() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _text = EclipsePuplicLicenseTemplate.getText();
        _builder.append((Object)_text, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packagePrefix, "");
        String _defaultPackageName = OpcUaUtil.getDefaultPackageName((SensorInterface)this.element);
        _builder.append((Object)_defaultPackageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.OpcUaServer;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateManager;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateValidator;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"import static com.google.common.collect.Lists.newArrayList;");
        _builder.newLine();
        _builder.append((Object)"import static com.google.common.io.Files.createTempDir;");
        _builder.newLine();
        _builder.append((Object)"import static java.util.Collections.singletonList;");
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"import java.util.Scanner;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _className = this.getClassName((SensorInterface)this.element);
        _builder.append((Object)_className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static String BINDING_ADDRESS = \"localhost\";\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static int PORT = ");
        int _defaultPort = this.getDefaultPort();
        _builder.append((Object)_defaultPort, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static String SERVER_NAME = \"");
        String _defaultName = this.getDefaultName((SensorInterface)this.element);
        _builder.append((Object)_defaultName, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static String URN = \"");
        CharSequence _defaultServerUrn = OpcUaUtil.getDefaultServerUrn((SensorInterface)this.element);
        _builder.append((Object)_defaultServerUrn, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static String STOP_TOKEN = \"exit\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final OpcUaServer server;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void main(String[] args) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _className_1 = this.getClassName((SensorInterface)this.element);
        _builder.append((Object)_className_1, "\t\t");
        _builder.append((Object)" ");
        String _objectName = this.getObjectName((SensorInterface)this.element);
        _builder.append((Object)_objectName, "\t\t");
        _builder.append((Object)" = new ");
        String _className_2 = this.getClassName((SensorInterface)this.element);
        _builder.append((Object)_className_2, "\t\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _objectName_1 = this.getObjectName((SensorInterface)this.element);
        _builder.append((Object)_objectName_1, "\t\t");
        _builder.append((Object)".start();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(\"\\n\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(\"Hit \" + \"\\'\" + STOP_TOKEN + \"\\'\" + \" to shutdown the server.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(\"\\n\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Scanner userInput = new Scanner(System.in);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while (!userInput.next().equals(STOP_TOKEN)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"userInput.close();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _objectName_2 = this.getObjectName((SensorInterface)this.element);
        _builder.append((Object)_objectName_2, "\t\t");
        _builder.append((Object)".shutdown();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _className_3 = this.getClassName((SensorInterface)this.element);
        _builder.append((Object)_className_3, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"OpcUaServerConfig serverConfig = OpcUaServerConfig.builder()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".setApplicationUri(URN).setBindAddresses(newArrayList(BINDING_ADDRESS))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".setBindPort(PORT).setCertificateManager(new DefaultCertificateManager())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".setCertificateValidator(new DefaultCertificateValidator(createTempDir())).setServerName(SERVER_NAME)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".setUserTokenPolicies(singletonList(USER_TOKEN_POLICY_ANONYMOUS))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".build();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"server = new OpcUaServer(serverConfig);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"server.getNamespaceManager().registerAndAdd(");
        String _serverNamespaceName = OpcUaUtil.getServerNamespaceName((SensorInterface)this.element);
        _builder.append((Object)_serverNamespaceName, "\t\t");
        _builder.append((Object)".NAMESPACE_URI,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"idx -> new ");
        String _serverNamespaceName_1 = OpcUaUtil.getServerNamespaceName((SensorInterface)this.element);
        _builder.append((Object)_serverNamespaceName_1, "\t\t\t\t");
        _builder.append((Object)"(server, idx));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void shutdown() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"server.shutdown();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(\"Server has been successfully stopped.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void start() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"server.startup();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private String getDefaultName(SensorInterface sensorInterface) {
        return sensorInterface.getName();
    }

    private String getClassName(SensorInterface sensorInterface) {
        String _name = sensorInterface.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        return String.valueOf(_firstUpper) + CLASS_NAME_SUFFIX;
    }

    private String getObjectName(SensorInterface sensorInterface) {
        String _name = sensorInterface.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name);
        return String.valueOf(_firstLower) + CLASS_NAME_SUFFIX;
    }

    private int getDefaultPort() {
        return 12686;
    }

    @Override
    public String getFileName() {
        String _name = ((SensorInterface)this.element).getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        return String.valueOf(_firstUpper) + CLASS_NAME_SUFFIX;
    }
}

