/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.templates.java.opcua;

import com.google.common.base.Objects;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription;
import de.fzi.sensidl.language.generator.templates.EclipsePuplicLicenseTemplate;
import de.fzi.sensidl.language.generator.templates.ITemplate;
import de.fzi.sensidl.language.generator.templates.java.opcua.OpcUaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OpcUaServerNamespaceTemplate
extends ITemplate<SensorInterface> {
    private String dataSetInterfaceClassName;
    private String dataSetInterfaceObjectName;
    private String packagePrefix;
    private ArrayList<CharSequence> dataSetInterfaceImplementer = new ArrayList();

    public OpcUaServerNamespaceTemplate(SensorInterface newElement, String newPackagePrefix) {
        super(newElement);
        String _plus;
        String _string;
        this.packagePrefix = newPackagePrefix;
        CharSequence _defaultInterfaceName = OpcUaUtil.getDefaultInterfaceName((SensorInterface)this.element);
        this.dataSetInterfaceClassName = _string = _defaultInterfaceName.toString();
        String _firstLower = StringExtensions.toFirstLower((String)this.dataSetInterfaceClassName);
        this.dataSetInterfaceObjectName = _plus = String.valueOf(_firstLower) + "s";
        this.addAllImplementers();
    }

    private void addAllImplementers() {
        SensorDataDescription _dataDescription = ((SensorInterface)this.element).getDataDescription();
        EList _dataSets = _dataDescription.getDataSets();
        Consumer<DataSet> _function = new Consumer<DataSet>(){

            @Override
            public void accept(DataSet dataSet) {
                CharSequence _stringRepresentation = OpcUaServerNamespaceTemplate.this.getStringRepresentation(dataSet);
                OpcUaServerNamespaceTemplate.this.dataSetInterfaceImplementer.add(_stringRepresentation);
            }
        };
        _dataSets.forEach((Consumer)_function);
    }

    private CharSequence getStringRepresentation(DataSet set) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"add(new ");
        CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName(set);
        _builder.append((Object)_defaultClassName, "");
        _builder.append((Object)"(namespaceIndex");
        String _addSubtypesIfNecessary = this.addSubtypesIfNecessary(set);
        _builder.append((Object)_addSubtypesIfNecessary, "");
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private String addSubtypesIfNecessary(final DataSet set) {
        String _xblockexpression = null;
        SensorDataDescription _dataDescription = ((SensorInterface)this.element).getDataDescription();
        EList _dataSets = _dataDescription.getDataSets();
        BasicEList availableDataSets = new BasicEList((Collection)_dataSets);
        Predicate<DataSet> _function = new Predicate<DataSet>(){

            @Override
            public boolean test(DataSet currentSet) {
                return Objects.equal((Object)currentSet, (Object)set) || !currentSet.getUsedDataSets().contains((Object)set);
            }
        };
        availableDataSets.removeIf((Predicate)_function);
        boolean _isEmpty = availableDataSets.isEmpty();
        if (_isEmpty) {
            return "";
        }
        final StringBuilder builder = new StringBuilder();
        Consumer<DataSet> _function_1 = new Consumer<DataSet>(){

            @Override
            public void accept(DataSet availabeDataSet) {
                builder.append(", ");
                CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName(availabeDataSet);
                String _plus = "new " + _defaultClassName;
                String _plus_1 = String.valueOf(_plus) + "(namespaceIndex)";
                builder.append(_plus_1);
            }
        };
        availableDataSets.forEach((Consumer)_function_1);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    @Override
    public String getFileName() {
        return OpcUaUtil.getServerNamespaceName((SensorInterface)this.element);
    }

    private String print(List<CharSequence> elementsToPrint) {
        String _xblockexpression = null;
        final StringBuilder builder = new StringBuilder();
        Consumer<CharSequence> _function = new Consumer<CharSequence>(){

            @Override
            public void accept(CharSequence element) {
                builder.append(element);
            }
        };
        elementsToPrint.forEach(_function);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    @Override
    public CharSequence getCode() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _text = EclipsePuplicLicenseTemplate.getText();
        _builder.append((Object)_text, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packagePrefix, "");
        String _defaultPackageName = OpcUaUtil.getDefaultPackageName((SensorInterface)this.element);
        _builder.append((Object)_defaultPackageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned.ubyte;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Optional;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.CompletableFuture;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.core.AccessLevel;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.core.Reference;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.OpcUaServer;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.api.DataItem;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.api.MethodInvocationHandler;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.api.Namespace;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.model.UaFolderNode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.model.UaMethodNode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.model.UaNode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.model.UaObjectNode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.model.UaObjectTypeNode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.model.UaVariableNode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.Identifiers;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.StatusCodes;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.UaException;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.google.common.collect.Lists;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _serverNamespaceName = OpcUaUtil.getServerNamespaceName((SensorInterface)this.element);
        _builder.append((Object)_serverNamespaceName, "");
        _builder.append((Object)" implements Namespace {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final String NAMESPACE_URI = \"");
        CharSequence _defaultNamespaceUrn = OpcUaUtil.getDefaultNamespaceUrn((SensorInterface)this.element);
        _builder.append((Object)_defaultNamespaceUrn, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final List<");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t");
        _builder.append((Object)"> ");
        _builder.append((Object)this.dataSetInterfaceObjectName, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final Logger logger = LoggerFactory.getLogger(getClass());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final SubscriptionModel subscriptionModel;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final OpcUaServer server;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final UShort namespaceIndex;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _serverNamespaceName_1 = OpcUaUtil.getServerNamespaceName((SensorInterface)this.element);
        _builder.append((Object)_serverNamespaceName_1, "\t");
        _builder.append((Object)"(OpcUaServer server, UShort namespaceIndex) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.server = server;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.namespaceIndex = namespaceIndex;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.subscriptionModel = new SubscriptionModel(server, this);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        _builder.append((Object)this.dataSetInterfaceObjectName, "\t\t");
        _builder.append((Object)" = new ArrayList<");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t\t");
        _builder.append((Object)">() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t\t\t ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"private static final long serialVersionUID = 1L;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        String _print = this.print(this.dataSetInterfaceImplementer);
        _builder.append((Object)_print, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"initialize();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void initialize() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"extendUaNamespace();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"add");
        String _name = ((SensorInterface)this.element).getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "\t\t");
        _builder.append((Object)"Nodes();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void extendUaNamespace() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        _builder.append((Object)this.dataSetInterfaceObjectName, "\t\t");
        _builder.append((Object)".forEach(dataSet -> addObjectType(dataSet));");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void addObjectType(");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t");
        _builder.append((Object)" dataSet) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UaObjectTypeNode node = new UaObjectTypeNode(this.server.getNodeManager(), dataSet.getObjectTypeNodeId(),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"new QualifiedName(this.server.getUaNamespace().getNamespaceIndex(), dataSet.getObjectTypeName()),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"new LocalizedText(\"en\", dataSet.getObjectTypeName()),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"Optional.of(new LocalizedText(\"en\", dataSet.getDescription())), Optional.of(UInteger.valueOf(0L)),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"Optional.of(UInteger.valueOf(0L)), false);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.server.getNodeManager().addNode(node);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.server.getUaNamespace().addReference(Identifiers.BaseObjectType, Identifiers.HasSubtype, true,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"dataSet.getObjectTypeNodeId().expanded(), NodeClass.ObjectType);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.server.getUaNamespace().addReference(dataSet.getObjectTypeNodeId(), Identifiers.HasSubtype,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"false, Identifiers.BaseObjectType.expanded(), NodeClass.ObjectType);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (UaException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void add");
        String _name_1 = ((SensorInterface)this.element).getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t");
        _builder.append((Object)"Nodes() {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"NodeId folderNodeId = new NodeId(namespaceIndex, \"");
        String _name_2 = ((SensorInterface)this.element).getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UaFolderNode folderNode = new UaFolderNode(server.getNodeManager(), folderNodeId,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"new QualifiedName(namespaceIndex, \"");
        String _name_3 = ((SensorInterface)this.element).getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_3, "\t\t\t");
        _builder.append((Object)"\"), LocalizedText.english(\"");
        String _name_4 = ((SensorInterface)this.element).getName();
        String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper_4, "\t\t\t");
        _builder.append((Object)"\"));");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"server.getNodeManager().addNode(folderNode);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"server.getUaNamespace().addReference(Identifiers.ObjectsFolder, Identifiers.Organizes, true,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"folderNodeId.expanded(), NodeClass.Object);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (UaException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"add");
        String _name_5 = ((SensorInterface)this.element).getName();
        String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_5);
        _builder.append((Object)_firstUpper_5, "\t\t");
        _builder.append((Object)"NodesTo(folderNode);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void add");
        String _name_6 = ((SensorInterface)this.element).getName();
        String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_6);
        _builder.append((Object)_firstUpper_6, "\t");
        _builder.append((Object)"NodesTo(UaFolderNode folderNode) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        _builder.append((Object)this.dataSetInterfaceObjectName, "\t\t");
        _builder.append((Object)".stream().filter(dataSet -> dataSet.getSubtypes() == null)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".forEach(dataSetWithoutSubtype -> addObject(dataSetWithoutSubtype, folderNode));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        _builder.append((Object)this.dataSetInterfaceObjectName, "\t\t");
        _builder.append((Object)".stream().filter(dataSet -> dataSet.getSubtypes() != null)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".forEach(dataSetWithSubtype -> addObjectWithSubtype(dataSetWithSubtype, folderNode));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void addObject(");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t");
        _builder.append((Object)" dataSet, UaFolderNode folderNode) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UaObjectNode node = new UaObjectNode(this.server.getNodeManager(), dataSet.getObjectNodeId(),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"new QualifiedName(this.namespaceIndex, dataSet.getObjectName()),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"LocalizedText.english(dataSet.getObjectName()));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.server.getNodeManager().addNode(node);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.server.getUaNamespace().addReference(dataSet.getObjectNodeId(), Identifiers.HasTypeDefinition,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"true, dataSet.getObjectTypeNodeId().expanded(), NodeClass.ObjectType);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"addVariablesTo(node, dataSet);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (UaException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"folderNode.addOrganizes(node);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void addObjectWithSubtype(");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t");
        _builder.append((Object)" dataSet, UaFolderNode folderNode) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"addObject(dataSet, folderNode);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dataSet.getSubtypes().forEach(subtype -> addHasSubtypeReferences(dataSet, subtype));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void addHasSubtypeReferences(");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t");
        _builder.append((Object)" supertype, ");
        _builder.append((Object)this.dataSetInterfaceClassName, "\t");
        _builder.append((Object)" subtype) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.server.getUaNamespace().addReference(supertype.getObjectNodeId(), Identifiers.HasSubtype, true,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"subtype.getObjectNodeId().expanded(), NodeClass.Object);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.server.getUaNamespace().addReference(subtype.getObjectNodeId(), Identifiers.HasSubtype, false,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"supertype.getObjectNodeId().expanded(), NodeClass.Object);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (UaException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void addVariablesTo(UaObjectNode node, ");
        CharSequence _defaultInterfaceName = OpcUaUtil.getDefaultInterfaceName((SensorInterface)this.element);
        _builder.append((Object)_defaultInterfaceName, "\t");
        _builder.append((Object)" dataSet) throws UaException {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (dataSet.getVariables() == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Object[] variable : dataSet.getVariables()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"String name = (String) variable[0];");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"NodeId typeId = (NodeId) variable[1];");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Variant variant = (Variant) variable[2];");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"String description = (String) variable[3];");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"UaVariableNode variableNode = new UaVariableNode.UaVariableNodeBuilder(server.getNodeManager())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".setNodeId(");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t\t");
        _builder.append((Object)"new NodeId(this.namespaceIndex, node.getNodeId().getIdentifier().toString() + \"/\" + name))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".setAccessLevel(ubyte(AccessLevel.getMask(AccessLevel.READ_WRITE)))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".setBrowseName(new QualifiedName(this.namespaceIndex, name))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".setDisplayName(LocalizedText.english(name)).setDataType(typeId)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".setDescription(LocalizedText.english(description))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".setTypeDefinition(Identifiers.BaseDataVariableType).build();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"variableNode.setValue(new DataValue(variant));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"server.getNodeManager().addNode(variableNode);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.server.getUaNamespace().addReference(node.getNodeId(), Identifiers.HasComponent, true,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"variableNode.getNodeId().expanded(), NodeClass.Variable);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public CompletableFuture<List<Reference>> getReferences(NodeId nodeId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UaNode node = server.getNodeManager().get(nodeId);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (node != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return CompletableFuture.completedFuture(node.getReferences());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return failedFuture(new UaException(StatusCodes.Bad_NodeIdUnknown));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private <T> CompletableFuture<T> failedFuture(Throwable ex) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"CompletableFuture<T> f = new CompletableFuture<>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"f.completeExceptionally(ex);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return f;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void read(ReadContext context, Double maxAge, TimestampsToReturn timestamps,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"List<ReadValueId> readValueIds) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<DataValue> results = Lists.newArrayListWithCapacity(readValueIds.size());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (ReadValueId readValueId : readValueIds) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"UaNode node = server.getNodeManager().get(readValueId.getNodeId());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (node != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"DataValue value = node.readAttribute(readValueId.getAttributeId().intValue(), timestamps,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"readValueId.getIndexRange());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"results.add(value);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"results.add(new DataValue(StatusCodes.Bad_NodeIdUnknown));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"context.complete(results);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void write(WriteContext context, List<WriteValue> writeValues) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<StatusCode> results = Lists.newArrayListWithCapacity(writeValues.size());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (WriteValue writeValue : writeValues) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"UaNode node = server.getNodeManager().get(writeValue.getNodeId());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (node != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"node.writeAttribute(server.getNamespaceManager(), writeValue.getAttributeId(),");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t\t");
        _builder.append((Object)"writeValue.getValue(), writeValue.getIndexRange());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"results.add(StatusCode.GOOD);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"} catch (UaException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"logger.error(\"Unable to write value={}\", writeValue.getValue(), e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"results.add(e.getStatusCode());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"results.add(new StatusCode(StatusCodes.Bad_NodeIdUnknown));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"context.complete(results);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onDataItemsCreated(List<DataItem> dataItems) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"subscriptionModel.onDataItemsCreated(dataItems);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onDataItemsModified(List<DataItem> dataItems) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"subscriptionModel.onDataItemsModified(dataItems);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onDataItemsDeleted(List<DataItem> dataItems) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"subscriptionModel.onDataItemsDeleted(dataItems);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"subscriptionModel.onMonitoringModeChanged(monitoredItems);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Optional<MethodInvocationHandler> getInvocationHandler(NodeId methodId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Optional<UaNode> node = server.getNodeManager().getNode(methodId);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return node.flatMap(n -> {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (n instanceof UaMethodNode) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return ((UaMethodNode) n).getInvocationHandler();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return Optional.empty();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public UShort getNamespaceIndex() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return namespaceIndex;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getNamespaceUri() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return NAMESPACE_URI;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

