/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.templates.java.opcua;

import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.templates.EclipsePuplicLicenseTemplate;
import de.fzi.sensidl.language.generator.templates.ITemplate;
import de.fzi.sensidl.language.generator.templates.java.opcua.OpcUaDataType;
import de.fzi.sensidl.language.generator.templates.java.opcua.OpcUaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OpcUaDataSetTemplate
extends ITemplate<DataSet> {
    private static final String OBJECT_TYPE_SUFFIX = "ObjectType";
    private static final String DEFAULT_NUMERICAL_VALUE = "0";
    private static final String DEFAULT_STRING_VALUE = "\"\"";
    private static final String DEFAULT_BOOLEAN_VALUE = "false";
    private static final String EMPTY_STRING = "";
    private final String packagePrefix;
    private final ArrayList<CharSequence> members = new ArrayList();
    private final ArrayList<CharSequence> constructors = new ArrayList();
    private final ArrayList<CharSequence> methodsToImplement = new ArrayList();

    public OpcUaDataSetTemplate(DataSet newElement, String newPackagePrefix) {
        super(newElement);
        this.packagePrefix = newPackagePrefix;
        this.addMembers();
        this.addConstructors();
        this.addMethodsToImplement();
    }

    @Override
    public CharSequence getCode() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _text = EclipsePuplicLicenseTemplate.getText();
        _builder.append((Object)_text, EMPTY_STRING);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packagePrefix, EMPTY_STRING);
        SensorInterface _sensorInterface = GenerationUtil.getSensorInterface((EObject)this.element);
        String _defaultPackageName = OpcUaUtil.getDefaultPackageName(_sensorInterface);
        _builder.append((Object)_defaultPackageName, EMPTY_STRING);
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.Identifiers;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName((DataSet)this.element);
        _builder.append((Object)_defaultClassName, EMPTY_STRING);
        _builder.append((Object)" implements ");
        CharSequence _interfaceName = this.getInterfaceName();
        _builder.append((Object)_interfaceName, EMPTY_STRING);
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _print = this.print(this.members);
        _builder.append((Object)_print, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _property = System.getProperty("line.separator");
        _builder.append((Object)_property, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _print_1 = this.print(this.constructors);
        _builder.append((Object)_print_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _property_1 = System.getProperty("line.separator");
        _builder.append((Object)_property_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _print_2 = this.print(this.methodsToImplement);
        _builder.append((Object)_print_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private String print(List<CharSequence> sequencesToPrint) {
        String _xblockexpression = null;
        final StringBuilder builder = new StringBuilder();
        Consumer<CharSequence> _function = new Consumer<CharSequence>(){

            @Override
            public void accept(CharSequence sequenceToPrint) {
                builder.append(sequenceToPrint);
                builder.append("\n");
            }
        };
        sequencesToPrint.forEach(_function);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    private boolean addMethodsToImplement() {
        boolean _xblockexpression = false;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public String getObjectTypeName() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.objectTypeName;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        this.methodsToImplement.add((CharSequence)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"@Override");
        _builder_1.newLine();
        _builder_1.append((Object)"public NodeId getObjectTypeNodeId() {");
        _builder_1.newLine();
        _builder_1.append((Object)"\t");
        _builder_1.append((Object)"return this.objectTypeNodeId;");
        _builder_1.newLine();
        _builder_1.append((Object)"}");
        _builder_1.newLine();
        this.methodsToImplement.add((CharSequence)_builder_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"@Override");
        _builder_2.newLine();
        _builder_2.append((Object)"public String getObjectName() {");
        _builder_2.newLine();
        _builder_2.append((Object)"\t");
        _builder_2.append((Object)"return this.objectName;");
        _builder_2.newLine();
        _builder_2.append((Object)"}");
        _builder_2.newLine();
        this.methodsToImplement.add((CharSequence)_builder_2);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append((Object)"@Override");
        _builder_3.newLine();
        _builder_3.append((Object)"public NodeId getObjectNodeId() {");
        _builder_3.newLine();
        _builder_3.append((Object)"\t");
        _builder_3.append((Object)"return this.objectNodeId;");
        _builder_3.newLine();
        _builder_3.append((Object)"}");
        _builder_3.newLine();
        this.methodsToImplement.add((CharSequence)_builder_3);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append((Object)"@Override");
        _builder_4.newLine();
        _builder_4.append((Object)"public String getDescription() {");
        _builder_4.newLine();
        _builder_4.append((Object)"\t");
        _builder_4.append((Object)"return this.description;");
        _builder_4.newLine();
        _builder_4.append((Object)"}");
        _builder_4.newLine();
        this.methodsToImplement.add((CharSequence)_builder_4);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append((Object)"@Override");
        _builder_5.newLine();
        _builder_5.append((Object)"public Object[][] getVariables() {");
        _builder_5.newLine();
        _builder_5.append((Object)"\t");
        _builder_5.append((Object)"return this.variables;");
        _builder_5.newLine();
        _builder_5.append((Object)"}");
        _builder_5.newLine();
        _xblockexpression = this.methodsToImplement.add((CharSequence)_builder_5);
        return _xblockexpression;
    }

    private boolean addConstructors() {
        CharSequence _constructorCode = this.getConstructorCode();
        return this.constructors.add(_constructorCode);
    }

    private boolean addMembers() {
        boolean _xblockexpression = false;
        String _name = ((DataSet)this.element).getName();
        String _plus = "private final String objectTypeName = \"" + _name;
        String _plus_1 = String.valueOf(_plus) + OBJECT_TYPE_SUFFIX;
        String _plus_2 = String.valueOf(_plus_1) + "\";";
        this.members.add(_plus_2);
        this.members.add("private final NodeId objectTypeNodeId;");
        String _name_1 = ((DataSet)this.element).getName();
        String _plus_3 = "private final String objectName = \"" + _name_1;
        String _plus_4 = String.valueOf(_plus_3) + "\";";
        this.members.add(_plus_4);
        this.members.add("private final NodeId objectNodeId;");
        String _description = ((DataSet)this.element).getDescription();
        String _plus_5 = "private final String description = \"" + _description;
        String _plus_6 = String.valueOf(_plus_5) + "\";";
        this.members.add(_plus_6);
        String _allVariables = this.getAllVariables();
        _xblockexpression = this.members.add(_allVariables);
        return _xblockexpression;
    }

    private String getAllVariables() {
        boolean _equals;
        String _xblockexpression = null;
        EList _data = ((DataSet)this.element).getData();
        int _size = _data.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return EMPTY_STRING;
        }
        final StringBuilder variables = new StringBuilder();
        variables.append("private final Object[][] variables = new Object[][] {");
        variables.append("\n");
        EList _data_1 = ((DataSet)this.element).getData();
        Consumer<Data> _function = new Consumer<Data>(){

            @Override
            public void accept(Data singleData) {
                String _addInitilizationStringOf = OpcUaDataSetTemplate.this.addInitilizationStringOf(singleData);
                OpcUaDataSetTemplate.this.to(_addInitilizationStringOf, variables);
            }
        };
        _data_1.forEach((Consumer)_function);
        variables.append("};");
        _xblockexpression = variables.toString();
        return _xblockexpression;
    }

    private String _addInitilizationStringOf(MeasurementData data) {
        DataType _dataType = data.getDataType();
        String _defaultValue = this.getDefaultValue(_dataType);
        return this.getStringRepresenation((Data)data, _defaultValue);
    }

    private String _addInitilizationStringOf(NonMeasurementData data) {
        String _xblockexpression = null;
        String value = data.getValue();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)value);
        if (_isNullOrEmpty) {
            String _defaultValue;
            DataType _dataType = data.getDataType();
            value = _defaultValue = this.getDefaultValue(_dataType);
        }
        _xblockexpression = this.getStringRepresenation((Data)data, value);
        return _xblockexpression;
    }

    private String getStringRepresenation(Data data, String value) {
        String _name = data.getName();
        DataType _dataType = data.getDataType();
        String _dataTypeAsNodeIdOf = OpcUaDataType.getDataTypeAsNodeIdOf(_dataType);
        String _trim = value.trim();
        String _description = data.getDescription();
        return String.format("\t{ \"%1s\", %2s, new Variant(%3s), \"%4s\" }, \n", _name, _dataTypeAsNodeIdOf, _trim, _description);
    }

    private String getDefaultValue(DataType dataType) {
        boolean _equals_1;
        String _xblockexpression = null;
        String defaultValue = DEFAULT_NUMERICAL_VALUE;
        boolean _equals = dataType.equals((Object)DataType.STRING);
        if (_equals) {
            defaultValue = DEFAULT_STRING_VALUE;
        }
        if (_equals_1 = dataType.equals((Object)DataType.BOOLEAN)) {
            defaultValue = DEFAULT_BOOLEAN_VALUE;
        }
        _xblockexpression = defaultValue;
        return _xblockexpression;
    }

    private StringBuilder to(String stringToAdd, StringBuilder builder) {
        return builder.append(stringToAdd);
    }

    private CharSequence getConstructorCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName((DataSet)this.element);
        _builder.append((Object)_defaultClassName, EMPTY_STRING);
        _builder.append((Object)"(UShort namespaceIndex");
        String _addSubtypesArguments = this.addSubtypesArguments((DataSet)this.element);
        _builder.append((Object)_addSubtypesArguments, EMPTY_STRING);
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"objectTypeNodeId = new NodeId(namespaceIndex, this.objectTypeName);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"objectNodeId = new NodeId(namespaceIndex, this.objectName);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private String addSubtypesArguments(DataSet dataset) {
        boolean _not;
        String _xblockexpression = null;
        String optionalArgument = EMPTY_STRING;
        Iterable<DataSet> subtypes = this.getAllSubtypes(dataset);
        boolean _isEmpty = IterableExtensions.isEmpty(subtypes);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _asArgument;
            optionalArgument = _asArgument = this.asArgument(dataset);
        }
        _xblockexpression = optionalArgument;
        return _xblockexpression;
    }

    public Iterable<DataSet> getAllSubtypes(final DataSet usedDataSet) {
        Iterable _xblockexpression = null;
        ArrayList allDataSets = new ArrayList();
        SensorInterface _sensorInterface = GenerationUtil.getSensorInterface((EObject)usedDataSet);
        SensorDataDescription _dataDescription = _sensorInterface.getDataDescription();
        EList _dataSets = _dataDescription.getDataSets();
        allDataSets.addAll(_dataSets);
        Functions.Function1<DataSet, Boolean> _function = new Functions.Function1<DataSet, Boolean>(){

            public Boolean apply(DataSet dataset) {
                EList _usedDataSets = dataset.getUsedDataSets();
                return _usedDataSets.contains((Object)usedDataSet);
            }
        };
        _xblockexpression = IterableExtensions.filter(allDataSets, (Functions.Function1)_function);
        return _xblockexpression;
    }

    private String asArgument(DataSet set) {
        String _xblockexpression = null;
        SensorInterface _sensorInterface = GenerationUtil.getSensorInterface((EObject)set);
        CharSequence _defaultInterfaceName = OpcUaUtil.getDefaultInterfaceName(_sensorInterface);
        String interfaceName = _defaultInterfaceName.toString();
        _xblockexpression = String.format(", %1s... subtypes", interfaceName);
        return _xblockexpression;
    }

    private CharSequence getInterfaceName() {
        SensorInterface _sensorInterface = GenerationUtil.getSensorInterface((EObject)this.element);
        return OpcUaUtil.getDefaultInterfaceName(_sensorInterface);
    }

    @Override
    public String getFileName() {
        CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName((DataSet)this.element);
        return _defaultClassName.toString();
    }

    private String addInitilizationStringOf(Data data) {
        if (data instanceof MeasurementData) {
            return this._addInitilizationStringOf((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._addInitilizationStringOf((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }
}

