/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.generationstep;

import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.language.generator.IExecuter;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.elementfilter.ElementFilter;
import de.fzi.sensidl.language.generator.factory.projects.JavaPluginProjectGenerator;
import de.fzi.sensidl.language.generator.factory.projects.MavenProjectGenerator;
import de.fzi.sensidl.language.generator.generationstep.FileGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.GenerationStep;
import java.util.HashMap;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProjectGenerationStep
extends GenerationStep {
    private static final String PATH_SEPERATOR = "/";
    private final String projectName;
    private final IFileSystemAccess fsa;

    public ProjectGenerationStep(ElementFilter filter, IFileSystemAccess newFsa) {
        String _name;
        Object _filterData = filter.filterData();
        this.projectName = _name = ((SensorInterface)_filterData).getName();
        this.fsa = newFsa;
    }

    @Override
    public void startGenerationTask() {
        HashMap<SensIDLConstants.GenerationLanguage, IExecuter> _resourcesToGenerateMapping = this.getResourcesToGenerateMapping();
        IExecuter _get = _resourcesToGenerateMapping.get((Object)GenerationStep.generationLanguage);
        _get.execute();
    }

    private void resetGenerationSettings(String projectPath, String path) {
        GenerationStep.javaPackagePrefix = "de.fzi.sensidl.";
        String _filePathOf = this.getFilePathOf(path);
        FileGenerationStep.setFilePath(_filePathOf);
        ((JavaIoFileSystemAccess)this.fsa).setOutputPath(projectPath);
    }

    private String getFilePathOf(String path) {
        String _xblockexpression = null;
        StringBuilder builder = new StringBuilder(path);
        builder.append(PATH_SEPERATOR);
        builder.append(this.projectName);
        builder.append(PATH_SEPERATOR);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    private HashMap<SensIDLConstants.GenerationLanguage, IExecuter> getResourcesToGenerateMapping() {
        final JavaPluginProjectGenerator pluginGenerator = new JavaPluginProjectGenerator(this.projectName);
        final MavenProjectGenerator mavenGenerator = new MavenProjectGenerator(this.projectName);
        HashMap _hashMap = new HashMap();
        Procedures.Procedure1<HashMap<SensIDLConstants.GenerationLanguage, IExecuter>> _function = new Procedures.Procedure1<HashMap<SensIDLConstants.GenerationLanguage, IExecuter>>(){

            public void apply(HashMap<SensIDLConstants.GenerationLanguage, IExecuter> it) {
                IExecuter _function = new IExecuter(){

                    @Override
                    public void execute() {
                        try {
                            pluginGenerator.createProject();
                            String _projectPath = pluginGenerator.getProjectPath();
                            ProjectGenerationStep.this.resetGenerationSettings(_projectPath, "src/de/fzi/sensidl/");
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                it.put(SensIDLConstants.GenerationLanguage.JAVA_PLUGIN_PROJECT, _function);
                IExecuter _function_1 = new IExecuter(){

                    @Override
                    public void execute() {
                        try {
                            mavenGenerator.createProject();
                            String _projectPath = mavenGenerator.getProjectPath();
                            ProjectGenerationStep.this.resetGenerationSettings(_projectPath, "src/de/fzi/sensidl/");
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                it.put(SensIDLConstants.GenerationLanguage.OPCUA, _function_1);
            }
        };
        return (HashMap)ObjectExtensions.operator_doubleArrow(_hashMap, (Procedures.Procedure1)_function);
    }
}

