/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.plaintext;

import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.IdentifiableElement;
import de.fzi.sensidl.design.sensidl.NamedElement;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.ListData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Method;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PlaintextDTOGenerator
implements IDTOGenerator {
    private StringConcatenation _builder = new StringConcatenation();
    private List<DataSet> dataSet;
    private static Logger logger = Logger.getLogger(PlaintextDTOGenerator.class);
    private static final String TEXT_EXTENSION = ".txt";

    public PlaintextDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + TEXT_EXTENSION;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        logger.info((Object)"Start with text generation.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        SensorInterface sensorInterface = GenerationUtil.getSensorInterface(this.dataSet.get(0).eContainer());
        filesToGenerate.put(this.addFileExtensionTo(StringExtensions.toFirstUpper((String)sensorInterface.getName())), this.generateDocumentation(sensorInterface));
        logger.info((Object)("File: " + this.addFileExtensionTo(StringExtensions.toFirstUpper((String)sensorInterface.getName())) + " was generated in " + "./src-gen"));
        return filesToGenerate;
    }

    public CharSequence generateDocumentation(SensorInterface sensorInterface) {
        TreeIterator _eAllContents = sensorInterface.eAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_eAllContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, DataSet.class);
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>();
        Calendar cal = Calendar.getInstance();
        for (DataSet dataSet : _filter) {
            dataSetList.add(dataSet);
        }
        this._builder.append((Object)"----------------------------------------");
        this._builder.newLine();
        this._builder.append((Object)("name: " + sensorInterface.getName()));
        this._builder.newLine();
        this._builder.append((Object)("time: " + cal.getTime()));
        this._builder.newLine();
        this._builder.append((Object)"----------------------------------------");
        this._builder.newLine();
        this._builder.append((Object)("This is the documentation for the sensor interface \"" + sensorInterface.getName() + "\""));
        this.addID((IdentifiableElement)sensorInterface);
        this._builder.append((Object)".");
        this._builder.newLineIfNotEmpty();
        this._builder.append((Object)"The encoding");
        this.addID((IdentifiableElement)sensorInterface.getEncodingSettings());
        this._builder.append((Object)(" is " + sensorInterface.getEncodingSettings().getCoding().getName().toLowerCase().replace("_", " ") + " and "));
        this._builder.append((Object)("the endianness is " + sensorInterface.getEncodingSettings().getEndianness().getName().toLowerCase().replace("_", " ") + ". "));
        this._builder.append((Object)("It is aligned by " + sensorInterface.getEncodingSettings().getAlignment() + (sensorInterface.getEncodingSettings().getAlignment() > 1 ? " bits" : " bit") + "."));
        this._builder.newLineIfNotEmpty();
        this.addDescription((NamedElement)sensorInterface);
        this._builder.append((Object)"The sensor data");
        this.addID((IdentifiableElement)sensorInterface.getDataDescription());
        this.addContainment(dataSetList, "data set", " of \"" + sensorInterface.getName() + "\" consists of", true);
        this._builder.newLine();
        this._builder.append((Object)"====================================================================================================");
        this._builder.newLine();
        this._builder.newLine();
        for (DataSet localDataSet : dataSetList) {
            this._builder.append((Object)("The data set \"" + localDataSet.getName() + "\""));
            this.addID((IdentifiableElement)localDataSet);
            this.addContainment((List<? extends NamedElement>)localDataSet.getData(), "data", " contains", true);
            this.addContainment((List<? extends NamedElement>)localDataSet.getUsedDataSets(), "data set", "This data set uses the", false);
            this.addContainment((List<? extends NamedElement>)localDataSet.getMethod(), "additional method", "It provides", true);
            this.addDescription((NamedElement)localDataSet);
            for (Data data : localDataSet.getData()) {
                this._builder.newLineIfNotEmpty();
                this._builder.newLine();
                if (data instanceof MeasurementData) {
                    this._builder.append((Object)("The measurement data \"" + data.getName() + "\""));
                    this.addID((IdentifiableElement)data);
                } else if (data instanceof NonMeasurementData) {
                    this._builder.append((Object)("The non measurement data \"" + data.getName() + "\""));
                    this.addID((IdentifiableElement)data);
                    if (((NonMeasurementData)data).isConstant()) {
                        this._builder.append((Object)" is constant and");
                    }
                    if (((NonMeasurementData)data).getValue() != null) {
                        this._builder.append((Object)(" has the value " + ((NonMeasurementData)data).getValue() + "."));
                        this._builder.newLine();
                        this._builder.append((Object)"It");
                    }
                } else if (data instanceof ListData) {
                    this._builder.append((Object)("The list data \"" + data.getName() + "\""));
                    this.addID((IdentifiableElement)data);
                }
                this._builder.append((Object)(" has the data type " + data.getDataType().getName() + "."));
                this._builder.newLineIfNotEmpty();
                if (data instanceof MeasurementData) {
                    if (((MeasurementData)data).getUnit() != null) {
                        this._builder.append((Object)("It has the unit " + ((MeasurementData)data).getUnit()));
                    } else {
                        this._builder.append((Object)"It is dimensionless");
                    }
                    for (DataAdjustment dataAdjustment : ((MeasurementData)data).getAdjustments()) {
                        if (((MeasurementData)data).getAdjustments().indexOf((Object)dataAdjustment) == 0) {
                            this._builder.append((Object)" and it is adjusted ");
                        } else {
                            this._builder.append((Object)"Additionally it is adjusted ");
                        }
                        if (dataAdjustment instanceof DataRange) {
                            if (((DataRange)dataAdjustment).getRange() != null) {
                                this._builder.append((Object)"with data range");
                                this.addID((IdentifiableElement)dataAdjustment);
                                this._builder.append((Object)" from ");
                                this._builder.append((Object)(String.valueOf(((DataRange)dataAdjustment).getRange().getLowerBound()) + " to " + ((DataRange)dataAdjustment).getRange().getUpperBound()));
                            }
                        } else if (dataAdjustment instanceof DataConversion) {
                            this._builder.append((Object)"by linear data conversion");
                            this.addID((IdentifiableElement)dataAdjustment);
                            if (dataAdjustment instanceof LinearDataConversion) {
                                if (((LinearDataConversion)dataAdjustment).getOffset() != 0.0) {
                                    this._builder.append((Object)(" with offset: " + ((LinearDataConversion)dataAdjustment).getOffset()));
                                    if (((LinearDataConversion)dataAdjustment).getScalingFactor() != 0.0) {
                                        this._builder.append((Object)" and");
                                    }
                                }
                                if (((LinearDataConversion)dataAdjustment).getScalingFactor() != 0.0) {
                                    this._builder.append((Object)(" with scaling factor: " + ((LinearDataConversion)dataAdjustment).getScalingFactor()));
                                }
                            } else if (dataAdjustment instanceof LinearDataConversionWithInterval) {
                                this._builder.append((Object)(" with interval from [" + ((LinearDataConversionWithInterval)dataAdjustment).getFromInterval().getLowerBound() + " , " + ((LinearDataConversionWithInterval)dataAdjustment).getFromInterval().getUpperBound() + "] to [" + ((LinearDataConversionWithInterval)dataAdjustment).getToInterval().getLowerBound() + " , " + ((LinearDataConversionWithInterval)dataAdjustment).getToInterval().getUpperBound() + "]"));
                            }
                        }
                        this._builder.append((Object)".");
                        this._builder.newLine();
                    }
                    if (((MeasurementData)data).getAdjustments().isEmpty()) {
                        this._builder.append((Object)".");
                        this._builder.newLine();
                    }
                }
                if (data.getExcludedMethods().size() == 1) {
                    this._builder.append((Object)("There is no " + (String)data.getExcludedMethods().get(0) + " for this data."));
                } else if (data.getExcludedMethods().size() == 2) {
                    this._builder.append((Object)"There is neither a setter nor a getter for this data.");
                }
                this._builder.newLineIfNotEmpty();
                this.addDescription((NamedElement)data);
            }
            for (Method method : localDataSet.getMethod()) {
                block58: {
                    block57: {
                        this._builder.newLineIfNotEmpty();
                        this._builder.newLine();
                        this._builder.append((Object)("The method \"" + method.getName() + "\""));
                        this.addID((IdentifiableElement)method);
                        this._builder.append((Object)" is ");
                        if (method.getVisibility() != null) break block57;
                        this._builder.append((Object)"package-private");
                        break block58;
                    }
                    switch (method.getVisibility()) {
                        case "+": {
                            this._builder.append((Object)"public");
                            break;
                        }
                        case "-": {
                            this._builder.append((Object)"private");
                            break;
                        }
                        case "#": {
                            this._builder.append((Object)"protected");
                            break;
                        }
                        case "~": {
                            this._builder.append((Object)"package-private");
                        }
                    }
                }
                if (method.getReturnType().getValue() != 12) {
                    this._builder.append((Object)(" and its return value is of the data type " + method.getReturnType() + "."));
                } else if (method.getReturnTypeDataSet() != null) {
                    this._builder.append((Object)(" and its return value is of the data set " + method.getReturnTypeDataSet().getName() + "."));
                } else {
                    this._builder.append((Object)" and its return value is void.");
                }
                this._builder.newLine();
                if (method.getParameter().size() == 0) {
                    this._builder.append((Object)"It has no parameter.");
                    continue;
                }
                if (method.getParameter().size() == 1) {
                    this._builder.append((Object)"Its parameter is ");
                } else {
                    this._builder.append((Object)"Its parameters are ");
                }
                for (MethodParameter parameter : method.getParameter()) {
                    this._builder.append((Object)("\"" + parameter.getName() + "\" of the " + (parameter.getDataType().getValue() != 12 ? "data type " + parameter.getDataType() : "") + (parameter.getDataTypeDataSet() != null ? "data set " + parameter.getDataTypeDataSet().getName() : "")));
                    if (method.getParameter().indexOf((Object)parameter) == method.getParameter().size() - 2) {
                        this._builder.append((Object)" and ");
                        continue;
                    }
                    if (method.getParameter().indexOf((Object)parameter) == method.getParameter().size() - 1) {
                        this._builder.append((Object)".");
                        continue;
                    }
                    this._builder.append((Object)", ");
                }
            }
            this._builder.newLineIfNotEmpty();
            this._builder.newLine();
            this._builder.append((Object)"----------------------------------------------------------------------------------------------------");
            this._builder.newLine();
            this._builder.newLine();
        }
        return this._builder;
    }

    @Override
    public String toTypeName(Data data) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    private void addContainment(List<? extends NamedElement> list, String name, String verb, boolean showQuantity) {
        if (showQuantity || list.size() != 0) {
            this._builder.append((Object)(String.valueOf(verb) + (showQuantity ? " " + (list.size() == 0 ? "no" : Integer.valueOf(list.size())) : "") + (list.size() > 1 ? " " + name + "s: " : (list.size() == 0 ? " " + name : " " + name + ": "))));
            String string = "";
            int i = 0;
            while (i < list.size()) {
                string = String.valueOf(string) + list.get(i).getName();
                if (i < list.size() - 2) {
                    string = String.valueOf(string) + ", ";
                } else if (i == list.size() - 2) {
                    string = String.valueOf(string) + " and ";
                }
                ++i;
            }
            this._builder.append((Object)(String.valueOf(string) + "."));
            this._builder.newLine();
        }
    }

    private void addDescription(NamedElement element) {
        if (element.getDescription() != null) {
            this._builder.append((Object)("The user added this description: \"" + element.getDescription() + "\""));
            this._builder.newLineIfNotEmpty();
        }
    }

    private void addID(IdentifiableElement element) {
        if (element.getID() != null) {
            this._builder.append((Object)(" (ID: " + element.getID() + ")"));
        }
    }
}

