/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java.unittest;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.ListData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaUnitTestDTOGenerator
implements IDTOGenerator {
    private static final Logger logger = Logger.getLogger(JavaUnitTestDTOGenerator.class);
    private final String packagePrefix;
    private final List<DataSet> dataSet;

    public JavaUnitTestDTOGenerator(List<DataSet> newDataSet, String newPackagePrefix) {
        this.dataSet = newDataSet;
        this.packagePrefix = newPackagePrefix;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a java test data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet d : this.dataSet) {
            String _nameUpper = GenerationUtil.toNameUpper(d);
            String _plus = String.valueOf(_nameUpper) + "Test";
            String _addFileExtensionTo = this.addFileExtensionTo(_plus);
            String _nameUpper_1 = GenerationUtil.toNameUpper(d);
            String _plus_1 = String.valueOf(_nameUpper_1) + "Test";
            CharSequence _generateClassBody = this.generateClassBody(_plus_1, d);
            filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
            String _nameUpper_2 = GenerationUtil.toNameUpper(d);
            String _plus_2 = String.valueOf(_nameUpper_2) + "Test";
            String _addFileExtensionTo_1 = this.addFileExtensionTo(_plus_2);
            String _plus_3 = "File: " + _addFileExtensionTo_1;
            String _plus_4 = String.valueOf(_plus_3) + " was generated in ";
            String _plus_5 = String.valueOf(_plus_4) + "./src-gen";
            logger.info((Object)_plus_5);
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClassBody(String className, DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packagePrefix, "");
        DataSet _get = this.dataSet.get(0);
        EObject _eContainer = _get.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import static org.junit.Assert.assertTrue;");
        _builder.newLine();
        _builder.append((Object)"import java.lang.reflect.Method;");
        _builder.newLine();
        _builder.append((Object)"import org.junit.After;");
        _builder.newLine();
        _builder.append((Object)"import org.junit.Assert;");
        _builder.newLine();
        _builder.append((Object)"import org.junit.Before;");
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Test cases of ");
        int _length = className.length();
        int _minus = _length - 4;
        String _substring = className.substring(0, _minus);
        _builder.append((Object)_substring, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "\t");
        _builder.append((Object)" ");
        String _name_1 = d.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Sets up the test environment.");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Before public void setUp() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _name_2 = d.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t");
        _builder.append((Object)" = new ");
        String _name_3 = d.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Cleans the test environment.");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@After public void tearDown() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _name_4 = d.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_2, "\t\t");
        _builder.append((Object)" = null;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateConstructorTest = this.generateConstructorTest(d);
        _builder.append((Object)_generateConstructorTest, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateSetterTests = this.generateSetterTests(d);
        _builder.append((Object)_generateSetterTests, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateInitialValueTests = this.generateInitialValueTests(d);
        _builder.append((Object)_generateInitialValueTests, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateExcludedMethodsTest = this.generateExcludedMethodsTest(d);
        _builder.append((Object)_generateExcludedMethodsTest, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateRangeAdjustmentTests = this.generateRangeAdjustmentTests(d);
        _builder.append((Object)_generateRangeAdjustmentTests, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateLinearDataConversionTests = this.generateLinearDataConversionTests(d);
        _builder.append((Object)_generateLinearDataConversionTests, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateLinearDataConversionWithIntervalTests = this.generateLinearDataConversionWithIntervalTests(d);
        _builder.append((Object)_generateLinearDataConversionWithIntervalTests, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateListTests = this.generateListTests(d);
        _builder.append((Object)_generateListTests, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateListTests(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        Iterable _filter = Iterables.filter((Iterable)_data, ListData.class);
        for (ListData data : _filter) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Test case for setter of list ");
            String _name = data.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* testing basic functionality");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/\t");
            _builder.newLine();
            _builder.append((Object)"@org.junit.Test public void test");
            String _name_1 = data.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"ListSetter() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"List<");
            String _typeName = this.toTypeName((Data)data);
            _builder.append((Object)_typeName, "\t");
            _builder.append((Object)"> list = new ArrayList<");
            String _typeName_1 = this.toTypeName((Data)data);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)">();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_2 = d.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name_2);
            _builder.append((Object)_firstLower, "\t");
            _builder.append((Object)".set");
            String _name_3 = data.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper_2, "\t");
            _builder.append((Object)"(list);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"assertTrue(");
            String _name_4 = d.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)".get");
            String _name_5 = data.getName();
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_5);
            _builder.append((Object)_firstUpper_3, "\t");
            _builder.append((Object)"().equals(list));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Test case for add(*) of ");
            String _name_6 = data.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_4, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* testing basic functionality");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/\t");
            _builder.newLine();
            _builder.append((Object)"@org.junit.Test public void test");
            String _name_7 = data.getName();
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_7);
            _builder.append((Object)_firstUpper_5, "");
            _builder.append((Object)"AddToList() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_8 = d.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
            _builder.append((Object)_firstLower_2, "\t");
            _builder.append((Object)".add");
            String _name_9 = data.getName();
            String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_9);
            _builder.append((Object)_firstUpper_6, "\t");
            _builder.append((Object)"(");
            DataType _dataType = data.getDataType();
            Object _minValue = this.getMinValue((Data)data);
            CharSequence _numberWithCast = this.getNumberWithCast(_dataType, _minValue);
            _builder.append((Object)_numberWithCast, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_10 = d.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)".add");
            String _name_11 = data.getName();
            String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_11);
            _builder.append((Object)_firstUpper_7, "\t");
            _builder.append((Object)"(");
            DataType _dataType_1 = data.getDataType();
            Object _maxValue = this.getMaxValue((Data)data);
            CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, _maxValue);
            _builder.append((Object)_numberWithCast_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"assertTrue(");
            String _name_12 = d.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_4, "\t");
            _builder.append((Object)".get");
            String _name_13 = data.getName();
            String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_13);
            _builder.append((Object)_firstUpper_8, "\t");
            _builder.append((Object)"(");
            DataType _dataType_2 = data.getDataType();
            Object _minValue_1 = this.getMinValue((Data)data);
            CharSequence _numberWithCast_2 = this.getNumberWithCast(_dataType_2, _minValue_1);
            _builder.append((Object)_numberWithCast_2, "\t");
            _builder.append((Object)") == ");
            DataType _dataType_3 = data.getDataType();
            Object _minValue_2 = this.getMinValue((Data)data);
            CharSequence _numberWithCast_3 = this.getNumberWithCast(_dataType_3, _minValue_2);
            _builder.append((Object)_numberWithCast_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"assertTrue(");
            String _name_14 = d.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_14);
            _builder.append((Object)_firstLower_5, "\t");
            _builder.append((Object)".get");
            String _name_15 = data.getName();
            String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_15);
            _builder.append((Object)_firstUpper_9, "\t");
            _builder.append((Object)"(");
            DataType _dataType_4 = data.getDataType();
            Object _maxValue_1 = this.getMaxValue((Data)data);
            CharSequence _numberWithCast_4 = this.getNumberWithCast(_dataType_4, _maxValue_1);
            _builder.append((Object)_numberWithCast_4, "\t");
            _builder.append((Object)") == ");
            DataType _dataType_5 = data.getDataType();
            Object _maxValue_2 = this.getMaxValue((Data)data);
            CharSequence _numberWithCast_5 = this.getNumberWithCast(_dataType_5, _maxValue_2);
            _builder.append((Object)_numberWithCast_5, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateLinearDataConversionWithIntervalTests(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        Iterable _filter = Iterables.filter((Iterable)_data, MeasurementData.class);
        for (MeasurementData data : _filter) {
            EList _adjustments = data.getAdjustments();
            for (DataAdjustment adj : _adjustments) {
                boolean _not;
                if (!(adj instanceof LinearDataConversionWithInterval)) continue;
                EList _excludedMethods = data.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"setter");
                boolean bl = _not = !_contains;
                if (_not) {
                    boolean _greaterEqualsThan;
                    boolean _lessEqualsThan;
                    boolean _not_3;
                    boolean _not_2;
                    boolean _not_1;
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with linear data conversion with interval of ");
                    String _name = data.getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    _builder.append((Object)_firstUpper, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing conversion");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void test");
                    String _name_1 = data.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"SetterWithLinearDataConversionWithIntervalPositiv() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName, "\t");
                    _builder.append((Object)" minValue = ");
                    DataType _dataType = data.getDataType();
                    Interval _fromInterval = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound = _fromInterval.getLowerBound();
                    CharSequence _numberWithCast = this.getNumberWithCast(_dataType, _lowerBound);
                    _builder.append((Object)_numberWithCast, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName_1 = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName_1, "\t");
                    _builder.append((Object)" maxValue = ");
                    DataType _dataType_1 = data.getDataType();
                    Interval _fromInterval_1 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound = _fromInterval_1.getUpperBound();
                    CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, _upperBound);
                    _builder.append((Object)_numberWithCast_1, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName_2 = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName_2, "\t");
                    _builder.append((Object)" midValue = ");
                    DataType _dataType_2 = data.getDataType();
                    Interval _fromInterval_2 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_1 = _fromInterval_2.getUpperBound();
                    Interval _fromInterval_3 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_1 = _fromInterval_3.getLowerBound();
                    double _minus = _upperBound_1 - _lowerBound_1;
                    double _divide = _minus / 2.0;
                    Interval _fromInterval_4 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_2 = _fromInterval_4.getLowerBound();
                    double _plus = _divide + _lowerBound_2;
                    CharSequence _numberWithCast_2 = this.getNumberWithCast(_dataType_2, _plus);
                    _builder.append((Object)_numberWithCast_2, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    DataType _dataType_3 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _typeName_3 = this.toTypeName(_dataType_3);
                    _builder.append((Object)_typeName_3, "\t");
                    _builder.append((Object)" minValueAdj = (");
                    DataType _dataType_4 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _simpleTypeName = this.toSimpleTypeName(_dataType_4);
                    _builder.append((Object)_simpleTypeName, "\t");
                    _builder.append((Object)") (");
                    Interval _fromInterval_5 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_3 = _fromInterval_5.getLowerBound();
                    Interval _fromInterval_6 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_4 = _fromInterval_6.getLowerBound();
                    Interval _fromInterval_7 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_2 = _fromInterval_7.getUpperBound();
                    Interval _toInterval = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _lowerBound_5 = _toInterval.getLowerBound();
                    Interval _toInterval_1 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _upperBound_3 = _toInterval_1.getUpperBound();
                    CharSequence _linearDataConversionWithInterval = this.getLinearDataConversionWithInterval(_lowerBound_3, _lowerBound_4, _upperBound_2, _lowerBound_5, _upperBound_3);
                    _builder.append((Object)_linearDataConversionWithInterval, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    DataType _dataType_5 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _typeName_4 = this.toTypeName(_dataType_5);
                    _builder.append((Object)_typeName_4, "\t");
                    _builder.append((Object)" maxValueAdj = (");
                    DataType _dataType_6 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _simpleTypeName_1 = this.toSimpleTypeName(_dataType_6);
                    _builder.append((Object)_simpleTypeName_1, "\t");
                    _builder.append((Object)") (");
                    Interval _fromInterval_8 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_4 = _fromInterval_8.getUpperBound();
                    Interval _fromInterval_9 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_6 = _fromInterval_9.getLowerBound();
                    Interval _fromInterval_10 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_5 = _fromInterval_10.getUpperBound();
                    Interval _toInterval_2 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _lowerBound_7 = _toInterval_2.getLowerBound();
                    Interval _toInterval_3 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _upperBound_6 = _toInterval_3.getUpperBound();
                    CharSequence _linearDataConversionWithInterval_1 = this.getLinearDataConversionWithInterval(_upperBound_4, _lowerBound_6, _upperBound_5, _lowerBound_7, _upperBound_6);
                    _builder.append((Object)_linearDataConversionWithInterval_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    DataType _dataType_7 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _typeName_5 = this.toTypeName(_dataType_7);
                    _builder.append((Object)_typeName_5, "\t");
                    _builder.append((Object)" midValueAdj = (");
                    DataType _dataType_8 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _simpleTypeName_2 = this.toSimpleTypeName(_dataType_8);
                    _builder.append((Object)_simpleTypeName_2, "\t");
                    _builder.append((Object)") (");
                    DataType _dataType_9 = data.getDataType();
                    Interval _fromInterval_11 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_7 = _fromInterval_11.getUpperBound();
                    Interval _fromInterval_12 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_8 = _fromInterval_12.getLowerBound();
                    double _minus_1 = _upperBound_7 - _lowerBound_8;
                    double _divide_1 = _minus_1 / 2.0;
                    Interval _fromInterval_13 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_9 = _fromInterval_13.getLowerBound();
                    double _plus_1 = _divide_1 + _lowerBound_9;
                    Number _dataType_10 = this.toDataType(_dataType_9, _plus_1);
                    double _doubleValue = _dataType_10.doubleValue();
                    Interval _fromInterval_14 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_10 = _fromInterval_14.getLowerBound();
                    Interval _fromInterval_15 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_8 = _fromInterval_15.getUpperBound();
                    Interval _toInterval_4 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _lowerBound_11 = _toInterval_4.getLowerBound();
                    Interval _toInterval_5 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _upperBound_9 = _toInterval_5.getUpperBound();
                    CharSequence _linearDataConversionWithInterval_2 = this.getLinearDataConversionWithInterval(_doubleValue, _lowerBound_10, _upperBound_8, _lowerBound_11, _upperBound_9);
                    _builder.append((Object)_linearDataConversionWithInterval_2, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _name_2 = d.getName();
                    String _firstLower = StringExtensions.toFirstLower((String)_name_2);
                    _builder.append((Object)_firstLower, "\t");
                    _builder.append((Object)".set");
                    String _name_3 = data.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                    _builder.append((Object)_firstUpper_2, "\t");
                    _builder.append((Object)"WithDataConversion(minValue);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_1 = data.getExcludedMethods();
                    boolean _contains_1 = _excludedMethods_1.contains((Object)"getter");
                    boolean bl2 = _not_1 = !_contains_1;
                    if (_not_1) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_4 = d.getName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
                        _builder.append((Object)_firstLower_1, "\t");
                        _builder.append((Object)".get");
                        String _name_5 = data.getName();
                        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_5);
                        _builder.append((Object)_firstUpper_3, "\t");
                        _builder.append((Object)"().equals(minValueAdj));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_6 = data.getName();
                        String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
                        _builder.append((Object)_firstUpper_4, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    String _name_7 = d.getName();
                    String _firstLower_2 = StringExtensions.toFirstLower((String)_name_7);
                    _builder.append((Object)_firstLower_2, "\t");
                    _builder.append((Object)".set");
                    String _name_8 = data.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_8);
                    _builder.append((Object)_firstUpper_5, "\t");
                    _builder.append((Object)"WithDataConversion(maxValue);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_2 = data.getExcludedMethods();
                    boolean _contains_2 = _excludedMethods_2.contains((Object)"getter");
                    boolean bl3 = _not_2 = !_contains_2;
                    if (_not_2) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_9 = d.getName();
                        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_9);
                        _builder.append((Object)_firstLower_3, "\t");
                        _builder.append((Object)".get");
                        String _name_10 = data.getName();
                        String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_10);
                        _builder.append((Object)_firstUpper_6, "\t");
                        _builder.append((Object)"().equals(maxValueAdj));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_11 = data.getName();
                        String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_11);
                        _builder.append((Object)_firstUpper_7, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    String _name_12 = d.getName();
                    String _firstLower_4 = StringExtensions.toFirstLower((String)_name_12);
                    _builder.append((Object)_firstLower_4, "\t");
                    _builder.append((Object)".set");
                    String _name_13 = data.getName();
                    String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_13);
                    _builder.append((Object)_firstUpper_8, "\t");
                    _builder.append((Object)"WithDataConversion(midValue);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_3 = data.getExcludedMethods();
                    boolean _contains_3 = _excludedMethods_3.contains((Object)"getter");
                    boolean bl4 = _not_3 = !_contains_3;
                    if (_not_3) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_14 = d.getName();
                        String _firstLower_5 = StringExtensions.toFirstLower((String)_name_14);
                        _builder.append((Object)_firstLower_5, "\t");
                        _builder.append((Object)".get");
                        String _name_15 = data.getName();
                        String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_15);
                        _builder.append((Object)_firstUpper_9, "\t");
                        _builder.append((Object)"().equals(midValueAdj));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_16 = data.getName();
                        String _firstUpper_10 = StringExtensions.toFirstUpper((String)_name_16);
                        _builder.append((Object)_firstUpper_10, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with linear data conversion with interval of ");
                    String _name_17 = data.getName();
                    String _firstUpper_11 = StringExtensions.toFirstUpper((String)_name_17);
                    _builder.append((Object)_firstUpper_11, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing overflow");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void test");
                    String _name_18 = data.getName();
                    String _firstUpper_12 = StringExtensions.toFirstUpper((String)_name_18);
                    _builder.append((Object)_firstUpper_12, "");
                    _builder.append((Object)"SetterWithLinearDataConversionWithIntervalNegativHigher() {");
                    _builder.newLineIfNotEmpty();
                    Interval _fromInterval_16 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_10 = _fromInterval_16.getUpperBound();
                    double _plus_2 = _upperBound_10 + 1.0;
                    Object _maxValue = this.getMaxValue((Data)data);
                    String _string = _maxValue.toString();
                    Double _valueOf = Double.valueOf(_string);
                    boolean bl5 = _lessEqualsThan = _plus_2 <= _valueOf;
                    if (_lessEqualsThan) {
                        boolean _not_4;
                        _builder.append((Object)"\t");
                        String _typeName_6 = this.toTypeName((Data)data);
                        _builder.append((Object)_typeName_6, "\t");
                        _builder.append((Object)" value = ");
                        DataType _dataType_11 = data.getDataType();
                        Interval _fromInterval_17 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _upperBound_11 = _fromInterval_17.getUpperBound();
                        double _plus_3 = _upperBound_11 + 1.0;
                        CharSequence _numberWithCast_3 = this.getNumberWithCast(_dataType_11, _plus_3);
                        _builder.append((Object)_numberWithCast_3, "\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        String _name_19 = d.getName();
                        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_19);
                        _builder.append((Object)_firstLower_6, "\t");
                        _builder.append((Object)".set");
                        String _name_20 = data.getName();
                        String _firstUpper_13 = StringExtensions.toFirstUpper((String)_name_20);
                        _builder.append((Object)_firstUpper_13, "\t");
                        _builder.append((Object)"WithDataConversion(value);");
                        _builder.newLineIfNotEmpty();
                        EList _excludedMethods_4 = data.getExcludedMethods();
                        boolean _contains_4 = _excludedMethods_4.contains((Object)"getter");
                        boolean bl6 = _not_4 = !_contains_4;
                        if (_not_4) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"assertTrue(");
                            String _name_21 = d.getName();
                            String _firstLower_7 = StringExtensions.toFirstLower((String)_name_21);
                            _builder.append((Object)_firstLower_7, "\t");
                            _builder.append((Object)".get");
                            String _name_22 = data.getName();
                            String _firstUpper_14 = StringExtensions.toFirstUpper((String)_name_22);
                            _builder.append((Object)_firstUpper_14, "\t");
                            _builder.append((Object)"() == null);");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"//no getter for ");
                            String _name_23 = data.getName();
                            String _firstUpper_15 = StringExtensions.toFirstUpper((String)_name_23);
                            _builder.append((Object)_firstUpper_15, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//test value ");
                        Interval _fromInterval_18 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _upperBound_12 = _fromInterval_18.getUpperBound();
                        double _plus_4 = _upperBound_12 + 1.0;
                        _builder.append((Object)_plus_4, "\t");
                        _builder.append((Object)" causes overflow");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with linear data conversion with interval of ");
                    String _name_24 = data.getName();
                    String _firstUpper_16 = StringExtensions.toFirstUpper((String)_name_24);
                    _builder.append((Object)_firstUpper_16, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing underflow");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void test");
                    String _name_25 = data.getName();
                    String _firstUpper_17 = StringExtensions.toFirstUpper((String)_name_25);
                    _builder.append((Object)_firstUpper_17, "");
                    _builder.append((Object)"SetterWithLinearDataConversionWithIntervalNegativLower() {");
                    _builder.newLineIfNotEmpty();
                    Interval _fromInterval_19 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_12 = _fromInterval_19.getLowerBound();
                    double _minus_2 = _lowerBound_12 - 1.0;
                    Object _minValue = this.getMinValue((Data)data);
                    String _string_1 = _minValue.toString();
                    Double _valueOf_1 = Double.valueOf(_string_1);
                    boolean bl7 = _greaterEqualsThan = _minus_2 >= _valueOf_1;
                    if (_greaterEqualsThan) {
                        boolean _not_5;
                        _builder.append((Object)"\t");
                        String _typeName_7 = this.toTypeName((Data)data);
                        _builder.append((Object)_typeName_7, "\t");
                        _builder.append((Object)" value = ");
                        DataType _dataType_12 = data.getDataType();
                        Interval _fromInterval_20 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_13 = _fromInterval_20.getLowerBound();
                        double _minus_3 = _lowerBound_13 - 1.0;
                        CharSequence _numberWithCast_4 = this.getNumberWithCast(_dataType_12, _minus_3);
                        _builder.append((Object)_numberWithCast_4, "\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        String _name_26 = d.getName();
                        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_26);
                        _builder.append((Object)_firstLower_8, "\t");
                        _builder.append((Object)".set");
                        String _name_27 = data.getName();
                        String _firstUpper_18 = StringExtensions.toFirstUpper((String)_name_27);
                        _builder.append((Object)_firstUpper_18, "\t");
                        _builder.append((Object)"WithDataConversion(value);");
                        _builder.newLineIfNotEmpty();
                        EList _excludedMethods_5 = data.getExcludedMethods();
                        boolean _contains_5 = _excludedMethods_5.contains((Object)"getter");
                        boolean bl8 = _not_5 = !_contains_5;
                        if (_not_5) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"assertTrue(");
                            String _name_28 = d.getName();
                            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_28);
                            _builder.append((Object)_firstLower_9, "\t");
                            _builder.append((Object)".get");
                            String _name_29 = data.getName();
                            String _firstUpper_19 = StringExtensions.toFirstUpper((String)_name_29);
                            _builder.append((Object)_firstUpper_19, "\t");
                            _builder.append((Object)"() == null);");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"//no getter for ");
                            String _name_30 = data.getName();
                            String _firstUpper_20 = StringExtensions.toFirstUpper((String)_name_30);
                            _builder.append((Object)_firstUpper_20, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//");
                        Interval _fromInterval_21 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_14 = _fromInterval_21.getLowerBound();
                        double _minus_4 = _lowerBound_14 - 1.0;
                        String _plus_5 = Double.valueOf(_minus_4) + " ";
                        Object _minValue_1 = this.getMinValue((Data)data);
                        String _string_2 = _minValue_1.toString();
                        Double _valueOf_2 = Double.valueOf(_string_2);
                        String _plus_6 = String.valueOf(_plus_5) + _valueOf_2;
                        String _plus_7 = String.valueOf(_plus_6) + " ";
                        Interval _fromInterval_22 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_15 = _fromInterval_22.getLowerBound();
                        double _minus_5 = _lowerBound_15 - 1.0;
                        Object _minValue_2 = this.getMinValue((Data)data);
                        String _string_3 = _minValue_2.toString();
                        Double _valueOf_3 = Double.valueOf(_string_3);
                        boolean _lessThan = _minus_5 < _valueOf_3;
                        String _plus_8 = String.valueOf(_plus_7) + Boolean.valueOf(_lessThan);
                        System.out.println(_plus_8);
                        Interval _fromInterval_23 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_16 = _fromInterval_23.getLowerBound();
                        double _minus_6 = _lowerBound_16 - 1.0;
                        Object _minValue_3 = this.getMinValue((Data)data);
                        String _string_4 = _minValue_3.toString();
                        Double _valueOf_4 = Double.valueOf(_string_4);
                        boolean _greaterEqualsThan_1 = _minus_6 >= _valueOf_4;
                        _builder.append((Object)_greaterEqualsThan_1, "\t");
                        Object _minValue_4 = this.getMinValue((Data)data);
                        String _string_5 = _minValue_4.toString();
                        Double _valueOf_5 = Double.valueOf(_string_5);
                        _builder.append((Object)_valueOf_5, "\t");
                        _builder.append((Object)" test value ");
                        Interval _fromInterval_24 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_17 = _fromInterval_24.getLowerBound();
                        double _minus_7 = _lowerBound_17 - 1.0;
                        _builder.append((Object)_minus_7, "\t");
                        _builder.append((Object)" causes underflow");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Test case for excluded setter with linear data conversion with interval of ");
                String _name_31 = data.getName();
                String _firstUpper_21 = StringExtensions.toFirstUpper((String)_name_31);
                _builder.append((Object)_firstUpper_21, " ");
                _builder.append((Object)".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"* testing existence");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @generated");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/\t");
                _builder.newLine();
                _builder.append((Object)"@org.junit.Test public void test");
                String _name_32 = data.getName();
                String _firstUpper_22 = StringExtensions.toFirstUpper((String)_name_32);
                _builder.append((Object)_firstUpper_22, "");
                _builder.append((Object)"ExcludedSetterWithDataConversion() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (Method m : ");
                String _name_33 = d.getName();
                String _firstLower_10 = StringExtensions.toFirstLower((String)_name_33);
                _builder.append((Object)_firstLower_10, "\t");
                _builder.append((Object)".getClass().getMethods()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Assert.assertNotEquals(m.getName(), \"set");
                String _name_34 = data.getName();
                String _firstUpper_23 = StringExtensions.toFirstUpper((String)_name_34);
                _builder.append((Object)_firstUpper_23, "\t\t");
                _builder.append((Object)"WithDataConversion\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateLinearDataConversionTests(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        Iterable _filter = Iterables.filter((Iterable)_data, MeasurementData.class);
        for (MeasurementData data : _filter) {
            EList _adjustments = data.getAdjustments();
            for (DataAdjustment adj : _adjustments) {
                boolean _not;
                if (!(adj instanceof LinearDataConversion)) continue;
                EList _excludedMethods = data.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"setter");
                boolean bl = _not = !_contains;
                if (_not) {
                    boolean _not_2;
                    boolean _not_1;
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with linear data conversion of ");
                    String _name = data.getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    _builder.append((Object)_firstUpper, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing conversion");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void test");
                    String _name_1 = data.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"SetterWithLinearDataConversionPositiv() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName, "\t");
                    _builder.append((Object)" value = ");
                    DataType _dataType = data.getDataType();
                    Object _maxValue = this.getMaxValue((Data)data);
                    String _string = _maxValue.toString();
                    Double _valueOf = Double.valueOf(_string);
                    double _scalingFactor = ((LinearDataConversion)adj).getScalingFactor();
                    double _multiply = _scalingFactor * 10.0;
                    double _divide = _valueOf / _multiply;
                    double _offset = ((LinearDataConversion)adj).getOffset();
                    double _minus = _divide - _offset;
                    CharSequence _numberWithCast = this.getNumberWithCast(_dataType, _minus);
                    _builder.append((Object)_numberWithCast, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _name_2 = d.getName();
                    String _firstLower = StringExtensions.toFirstLower((String)_name_2);
                    _builder.append((Object)_firstLower, "\t");
                    _builder.append((Object)".set");
                    String _name_3 = data.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                    _builder.append((Object)_firstUpper_2, "\t");
                    _builder.append((Object)"WithDataConversion(value);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_1 = data.getExcludedMethods();
                    boolean _contains_1 = _excludedMethods_1.contains((Object)"getter");
                    boolean bl2 = _not_1 = !_contains_1;
                    if (_not_1) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"Double d = (value * ");
                        double _scalingFactor_1 = ((LinearDataConversion)adj).getScalingFactor();
                        _builder.append((Object)_scalingFactor_1, "\t");
                        _builder.append((Object)") + ");
                        double _offset_1 = ((LinearDataConversion)adj).getOffset();
                        _builder.append((Object)_offset_1, "\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_4 = d.getName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
                        _builder.append((Object)_firstLower_1, "\t");
                        _builder.append((Object)".get");
                        String _name_5 = data.getName();
                        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_5);
                        _builder.append((Object)_firstUpper_3, "\t");
                        _builder.append((Object)"().equals(d.");
                        String _typeName_1 = this.toTypeName((Data)data);
                        String _typeName_2 = this.toTypeName((Data)data);
                        int _lastIndexOf = _typeName_2.lastIndexOf(".");
                        int _plus = _lastIndexOf + 1;
                        String _typeName_3 = this.toTypeName((Data)data);
                        int _length = _typeName_3.length();
                        String _substring = _typeName_1.substring(_plus, _length);
                        String _firstLower_2 = StringExtensions.toFirstLower((String)_substring);
                        String _replace = _firstLower_2.replace("integer", "int");
                        _builder.append((Object)_replace, "\t");
                        _builder.append((Object)"Value()));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_6 = data.getName();
                        String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
                        _builder.append((Object)_firstUpper_4, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with linear data conversion of ");
                    String _name_7 = data.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_7);
                    _builder.append((Object)_firstUpper_5, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing overflow");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void test");
                    String _name_8 = data.getName();
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_8);
                    _builder.append((Object)_firstUpper_6, "");
                    _builder.append((Object)"SetterWithLinearDataConversionNegativ() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName_4 = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName_4, "\t");
                    _builder.append((Object)" value = ");
                    DataType _dataType_1 = data.getDataType();
                    Object _maxValue_1 = this.getMaxValue((Data)data);
                    String _string_1 = _maxValue_1.toString();
                    Double _valueOf_1 = Double.valueOf(_string_1);
                    CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, _valueOf_1);
                    _builder.append((Object)_numberWithCast_1, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _name_9 = d.getName();
                    String _firstLower_3 = StringExtensions.toFirstLower((String)_name_9);
                    _builder.append((Object)_firstLower_3, "\t");
                    _builder.append((Object)".set");
                    String _name_10 = data.getName();
                    String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_10);
                    _builder.append((Object)_firstUpper_7, "\t");
                    _builder.append((Object)"WithDataConversion(value);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_2 = data.getExcludedMethods();
                    boolean _contains_2 = _excludedMethods_2.contains((Object)"getter");
                    boolean bl3 = _not_2 = !_contains_2;
                    if (_not_2) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_11 = d.getName();
                        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_11);
                        _builder.append((Object)_firstLower_4, "\t");
                        _builder.append((Object)".get");
                        String _name_12 = data.getName();
                        String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_12);
                        _builder.append((Object)_firstUpper_8, "\t");
                        _builder.append((Object)"() == null);");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_13 = data.getName();
                        String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_13);
                        _builder.append((Object)_firstUpper_9, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Test case for excluded setter with linear data conversion of ");
                String _name_14 = data.getName();
                String _firstUpper_10 = StringExtensions.toFirstUpper((String)_name_14);
                _builder.append((Object)_firstUpper_10, " ");
                _builder.append((Object)".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"* testing existence");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @generated");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/\t");
                _builder.newLine();
                _builder.append((Object)"@org.junit.Test public void test");
                String _name_15 = data.getName();
                String _firstUpper_11 = StringExtensions.toFirstUpper((String)_name_15);
                _builder.append((Object)_firstUpper_11, "");
                _builder.append((Object)"ExcludedSetterWithDataConversion() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (Method m : ");
                String _name_16 = d.getName();
                String _firstLower_5 = StringExtensions.toFirstLower((String)_name_16);
                _builder.append((Object)_firstLower_5, "\t");
                _builder.append((Object)".getClass().getMethods()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Assert.assertNotEquals(m.getName(), \"set");
                String _name_17 = data.getName();
                String _firstUpper_12 = StringExtensions.toFirstUpper((String)_name_17);
                _builder.append((Object)_firstUpper_12, "\t\t");
                _builder.append((Object)"WithDataConversion\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateRangeAdjustmentTests(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        Iterable _filter = Iterables.filter((Iterable)_data, MeasurementData.class);
        for (MeasurementData data : _filter) {
            EList _adjustments = data.getAdjustments();
            for (DataAdjustment adj : _adjustments) {
                boolean _not;
                if (!(adj instanceof DataRange)) continue;
                EList _excludedMethods = data.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"setter");
                boolean bl = _not = !_contains;
                if (_not) {
                    boolean _not_5;
                    boolean _not_4;
                    boolean _not_3;
                    boolean _greaterEqualsThan;
                    boolean _lessEqualsThan;
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with range of ");
                    String _name = data.getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    _builder.append((Object)_firstUpper, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing range overflow");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test (expected = IllegalArgumentException.class) public void test");
                    String _name_1 = data.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"SetterWithRangeNegativHigher() {");
                    _builder.newLineIfNotEmpty();
                    Interval _range = ((DataRange)adj).getRange();
                    double _upperBound = _range.getUpperBound();
                    double _plus = _upperBound + 1.0;
                    Object _maxValue = this.getMaxValue((Data)data);
                    String _string = _maxValue.toString();
                    Double _valueOf = Double.valueOf(_string);
                    boolean bl2 = _lessEqualsThan = _plus <= _valueOf;
                    if (_lessEqualsThan) {
                        boolean _not_1;
                        _builder.append((Object)"\t");
                        String _typeName = this.toTypeName((Data)data);
                        _builder.append((Object)_typeName, "\t");
                        _builder.append((Object)" value = ");
                        DataType _dataType = data.getDataType();
                        Interval _range_1 = ((DataRange)adj).getRange();
                        double _upperBound_1 = _range_1.getUpperBound();
                        double _plus_1 = _upperBound_1 + 1.0;
                        CharSequence _numberWithCast = this.getNumberWithCast(_dataType, _plus_1);
                        _builder.append((Object)_numberWithCast, "\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        String _name_2 = d.getName();
                        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
                        _builder.append((Object)_firstLower, "\t");
                        _builder.append((Object)".set");
                        String _name_3 = data.getName();
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                        _builder.append((Object)_firstUpper_2, "\t");
                        _builder.append((Object)"WithRange(value);");
                        _builder.newLineIfNotEmpty();
                        EList _excludedMethods_1 = data.getExcludedMethods();
                        boolean _contains_1 = _excludedMethods_1.contains((Object)"getter");
                        boolean bl3 = _not_1 = !_contains_1;
                        if (_not_1) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"assertTrue(");
                            String _name_4 = d.getName();
                            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
                            _builder.append((Object)_firstLower_1, "\t");
                            _builder.append((Object)".get");
                            String _name_5 = data.getName();
                            String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_5);
                            _builder.append((Object)_firstUpper_3, "\t");
                            _builder.append((Object)"().equals(value));");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"//no getter for ");
                            String _name_6 = data.getName();
                            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
                            _builder.append((Object)_firstUpper_4, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//test value ");
                        Interval _range_2 = ((DataRange)adj).getRange();
                        double _upperBound_2 = _range_2.getUpperBound();
                        double _plus_2 = _upperBound_2 + 1.0;
                        _builder.append((Object)_plus_2, "\t");
                        _builder.append((Object)" causes overflow");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with range of ");
                    String _name_7 = data.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_7);
                    _builder.append((Object)_firstUpper_5, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing range underflow");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test (expected = IllegalArgumentException.class) public void test");
                    String _name_8 = data.getName();
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_8);
                    _builder.append((Object)_firstUpper_6, "");
                    _builder.append((Object)"SetterWithRangeNegativLower() {");
                    _builder.newLineIfNotEmpty();
                    Interval _range_3 = ((DataRange)adj).getRange();
                    double _lowerBound = _range_3.getLowerBound();
                    double _minus = _lowerBound - 1.0;
                    Object _minValue = this.getMinValue((Data)data);
                    String _string_1 = _minValue.toString();
                    Double _valueOf_1 = Double.valueOf(_string_1);
                    boolean bl4 = _greaterEqualsThan = _minus >= _valueOf_1;
                    if (_greaterEqualsThan) {
                        boolean _not_2;
                        _builder.append((Object)"\t");
                        String _typeName_1 = this.toTypeName((Data)data);
                        _builder.append((Object)_typeName_1, "\t");
                        _builder.append((Object)" value = ");
                        DataType _dataType_1 = data.getDataType();
                        Interval _range_4 = ((DataRange)adj).getRange();
                        double _lowerBound_1 = _range_4.getLowerBound();
                        double _minus_1 = _lowerBound_1 - 1.0;
                        CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, _minus_1);
                        _builder.append((Object)_numberWithCast_1, "\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        String _name_9 = d.getName();
                        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_9);
                        _builder.append((Object)_firstLower_2, "\t");
                        _builder.append((Object)".set");
                        String _name_10 = data.getName();
                        String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_10);
                        _builder.append((Object)_firstUpper_7, "\t");
                        _builder.append((Object)"WithRange(value);");
                        _builder.newLineIfNotEmpty();
                        EList _excludedMethods_2 = data.getExcludedMethods();
                        boolean _contains_2 = _excludedMethods_2.contains((Object)"getter");
                        boolean bl5 = _not_2 = !_contains_2;
                        if (_not_2) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"assertTrue(");
                            String _name_11 = d.getName();
                            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
                            _builder.append((Object)_firstLower_3, "\t");
                            _builder.append((Object)".get");
                            String _name_12 = data.getName();
                            String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_12);
                            _builder.append((Object)_firstUpper_8, "\t");
                            _builder.append((Object)"().equals(value));");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"//no getter for ");
                            String _name_13 = data.getName();
                            String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_13);
                            _builder.append((Object)_firstUpper_9, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//test value ");
                        Interval _range_5 = ((DataRange)adj).getRange();
                        double _lowerBound_2 = _range_5.getLowerBound();
                        double _minus_2 = _lowerBound_2 - 1.0;
                        _builder.append((Object)_minus_2, "\t");
                        _builder.append((Object)" causes underflow");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for setter with range of ");
                    String _name_14 = data.getName();
                    String _firstUpper_10 = StringExtensions.toFirstUpper((String)_name_14);
                    _builder.append((Object)_firstUpper_10, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing with valid values");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void test");
                    String _name_15 = data.getName();
                    String _firstUpper_11 = StringExtensions.toFirstUpper((String)_name_15);
                    _builder.append((Object)_firstUpper_11, "");
                    _builder.append((Object)"SetterWithRangePositiv() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName_2 = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName_2, "\t");
                    _builder.append((Object)" minValue = ");
                    DataType _dataType_2 = data.getDataType();
                    Interval _range_6 = ((DataRange)adj).getRange();
                    double _lowerBound_3 = _range_6.getLowerBound();
                    CharSequence _numberWithCast_2 = this.getNumberWithCast(_dataType_2, _lowerBound_3);
                    _builder.append((Object)_numberWithCast_2, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName_3 = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName_3, "\t");
                    _builder.append((Object)" maxValue = ");
                    DataType _dataType_3 = data.getDataType();
                    Interval _range_7 = ((DataRange)adj).getRange();
                    double _upperBound_3 = _range_7.getUpperBound();
                    CharSequence _numberWithCast_3 = this.getNumberWithCast(_dataType_3, _upperBound_3);
                    _builder.append((Object)_numberWithCast_3, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _typeName_4 = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName_4, "\t");
                    _builder.append((Object)" midValue = ");
                    DataType _dataType_4 = data.getDataType();
                    Interval _range_8 = ((DataRange)adj).getRange();
                    double _upperBound_4 = _range_8.getUpperBound();
                    Interval _range_9 = ((DataRange)adj).getRange();
                    double _lowerBound_4 = _range_9.getLowerBound();
                    double _minus_3 = _upperBound_4 - _lowerBound_4;
                    double _divide = _minus_3 / 2.0;
                    Interval _range_10 = ((DataRange)adj).getRange();
                    double _lowerBound_5 = _range_10.getLowerBound();
                    double _plus_3 = _divide + _lowerBound_5;
                    CharSequence _numberWithCast_4 = this.getNumberWithCast(_dataType_4, _plus_3);
                    _builder.append((Object)_numberWithCast_4, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _name_16 = d.getName();
                    String _firstLower_4 = StringExtensions.toFirstLower((String)_name_16);
                    _builder.append((Object)_firstLower_4, "\t");
                    _builder.append((Object)".set");
                    String _name_17 = data.getName();
                    String _firstUpper_12 = StringExtensions.toFirstUpper((String)_name_17);
                    _builder.append((Object)_firstUpper_12, "\t");
                    _builder.append((Object)"WithRange(minValue);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_3 = data.getExcludedMethods();
                    boolean _contains_3 = _excludedMethods_3.contains((Object)"getter");
                    boolean bl6 = _not_3 = !_contains_3;
                    if (_not_3) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_18 = d.getName();
                        String _firstLower_5 = StringExtensions.toFirstLower((String)_name_18);
                        _builder.append((Object)_firstLower_5, "\t");
                        _builder.append((Object)".get");
                        String _name_19 = data.getName();
                        String _firstUpper_13 = StringExtensions.toFirstUpper((String)_name_19);
                        _builder.append((Object)_firstUpper_13, "\t");
                        _builder.append((Object)"().equals(minValue));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_20 = data.getName();
                        String _firstUpper_14 = StringExtensions.toFirstUpper((String)_name_20);
                        _builder.append((Object)_firstUpper_14, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    String _name_21 = d.getName();
                    String _firstLower_6 = StringExtensions.toFirstLower((String)_name_21);
                    _builder.append((Object)_firstLower_6, "\t");
                    _builder.append((Object)".set");
                    String _name_22 = data.getName();
                    String _firstUpper_15 = StringExtensions.toFirstUpper((String)_name_22);
                    _builder.append((Object)_firstUpper_15, "\t");
                    _builder.append((Object)"WithRange(midValue);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_4 = data.getExcludedMethods();
                    boolean _contains_4 = _excludedMethods_4.contains((Object)"getter");
                    boolean bl7 = _not_4 = !_contains_4;
                    if (_not_4) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_23 = d.getName();
                        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_23);
                        _builder.append((Object)_firstLower_7, "\t");
                        _builder.append((Object)".get");
                        String _name_24 = data.getName();
                        String _firstUpper_16 = StringExtensions.toFirstUpper((String)_name_24);
                        _builder.append((Object)_firstUpper_16, "\t");
                        _builder.append((Object)"().equals(midValue));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_25 = data.getName();
                        String _firstUpper_17 = StringExtensions.toFirstUpper((String)_name_25);
                        _builder.append((Object)_firstUpper_17, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    String _name_26 = d.getName();
                    String _firstLower_8 = StringExtensions.toFirstLower((String)_name_26);
                    _builder.append((Object)_firstLower_8, "\t");
                    _builder.append((Object)".set");
                    String _name_27 = data.getName();
                    String _firstUpper_18 = StringExtensions.toFirstUpper((String)_name_27);
                    _builder.append((Object)_firstUpper_18, "\t");
                    _builder.append((Object)"WithRange(maxValue);");
                    _builder.newLineIfNotEmpty();
                    EList _excludedMethods_5 = data.getExcludedMethods();
                    boolean _contains_5 = _excludedMethods_5.contains((Object)"getter");
                    boolean bl8 = _not_5 = !_contains_5;
                    if (_not_5) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"assertTrue(");
                        String _name_28 = d.getName();
                        String _firstLower_9 = StringExtensions.toFirstLower((String)_name_28);
                        _builder.append((Object)_firstLower_9, "\t");
                        _builder.append((Object)".get");
                        String _name_29 = data.getName();
                        String _firstUpper_19 = StringExtensions.toFirstUpper((String)_name_29);
                        _builder.append((Object)_firstUpper_19, "\t");
                        _builder.append((Object)"().equals(maxValue));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"//no getter for ");
                        String _name_30 = data.getName();
                        String _firstUpper_20 = StringExtensions.toFirstUpper((String)_name_30);
                        _builder.append((Object)_firstUpper_20, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Test case for excluded setter with range of ");
                String _name_31 = data.getName();
                String _firstUpper_21 = StringExtensions.toFirstUpper((String)_name_31);
                _builder.append((Object)_firstUpper_21, " ");
                _builder.append((Object)".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"* testing existence");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @generated");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/\t");
                _builder.newLine();
                _builder.append((Object)"@org.junit.Test public void test");
                String _name_32 = data.getName();
                String _firstUpper_22 = StringExtensions.toFirstUpper((String)_name_32);
                _builder.append((Object)_firstUpper_22, "");
                _builder.append((Object)"ExcludedSetterWithRange() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (Method m : ");
                String _name_33 = d.getName();
                String _firstLower_10 = StringExtensions.toFirstLower((String)_name_33);
                _builder.append((Object)_firstLower_10, "\t");
                _builder.append((Object)".getClass().getMethods()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Assert.assertNotEquals(m.getName(), \"set");
                String _name_34 = data.getName();
                String _firstUpper_23 = StringExtensions.toFirstUpper((String)_name_34);
                _builder.append((Object)_firstUpper_23, "\t\t");
                _builder.append((Object)"WithRange\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateExcludedMethodsTest(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        for (Data data : _data) {
            EList _excludedMethods = data.getExcludedMethods();
            for (String method : _excludedMethods) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Test case for excluded ");
                _builder.append((Object)method, " ");
                _builder.append((Object)" of ");
                String _name = data.getName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                _builder.append((Object)_firstUpper, " ");
                _builder.append((Object)".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"* testing existence");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @generated");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/\t");
                _builder.newLine();
                _builder.append((Object)"@org.junit.Test public void test");
                String _name_1 = data.getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                _builder.append((Object)_firstUpper_1, "");
                _builder.append((Object)"Excluded");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)method);
                _builder.append((Object)_firstUpper_2, "");
                _builder.append((Object)"() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (Method m : ");
                String _name_2 = d.getName();
                String _firstLower = StringExtensions.toFirstLower((String)_name_2);
                _builder.append((Object)_firstLower, "\t");
                _builder.append((Object)".getClass().getMethods()) {");
                _builder.newLineIfNotEmpty();
                boolean _equals = method.equals("setter");
                if (_equals) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"Assert.assertNotEquals(m.getName(), \"set");
                    String _name_3 = data.getName();
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_3);
                    _builder.append((Object)_firstUpper_3, "\t\t");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _equals_1 = method.equals("getter");
                    if (_equals_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"Assert.assertNotEquals(m.getName(), \"get");
                        String _name_4 = data.getName();
                        String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_4);
                        _builder.append((Object)_firstUpper_4, "\t\t");
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateConstructorTest(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Test case for constructor of ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* testing basic functionality");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/\t");
        _builder.newLine();
        _builder.append((Object)"@org.junit.Test public void testConstructor() {");
        _builder.newLine();
        EList _data = d.getData();
        for (Data data : _data) {
            if (data instanceof NonMeasurementData) {
                boolean _not;
                boolean _isConstant = ((NonMeasurementData)data).isConstant();
                boolean bl = _not = !_isConstant;
                if (!_not) continue;
                _builder.append((Object)"\t");
                String _typeName = this.toTypeName(data);
                _builder.append((Object)_typeName, "\t");
                _builder.append((Object)" ");
                String _name_1 = ((NonMeasurementData)data).getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append((Object)" = ");
                Object _minValue = this.getMinValue(data);
                _builder.append(_minValue, "\t");
                DataType _dataType = ((NonMeasurementData)data).getDataType();
                String _dataTypeExtention = this.getDataTypeExtention(_dataType);
                _builder.append((Object)_dataTypeExtention, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(data instanceof MeasurementData)) continue;
            _builder.append((Object)"\t");
            String _typeName_1 = this.toTypeName(data);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)" ");
            String _name_2 = data.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" = ");
            Object _minValue_1 = this.getMinValue(data);
            _builder.append(_minValue_1, "\t");
            DataType _dataType_1 = data.getDataType();
            String _dataTypeExtention_1 = this.getDataTypeExtention(_dataType_1);
            _builder.append((Object)_dataTypeExtention_1, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet dataSet : _usedDataSets) {
            _builder.append((Object)"\t");
            String _name_3 = dataSet.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper_1, "\t");
            _builder.append((Object)" ");
            String _name_4 = dataSet.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name_4);
            _builder.append((Object)_firstLower, "\t");
            _builder.append((Object)" = new ");
            String _name_5 = dataSet.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_5);
            _builder.append((Object)_firstUpper_2, "\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        String _name_6 = d.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_6);
        _builder.append((Object)_firstLower_1, "\t");
        _builder.append((Object)" = new ");
        String _name_7 = d.getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_7);
        _builder.append((Object)_firstUpper_3, "\t");
        _builder.append((Object)"(");
        String _attributesInLine = this.getAttributesInLine(d);
        _builder.append((Object)_attributesInLine, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        EList _data_1 = d.getData();
        for (Data data_1 : _data_1) {
            boolean _not_3;
            if (data_1 instanceof NonMeasurementData) {
                boolean _not_2;
                boolean _not_1;
                boolean _isConstant_1 = ((NonMeasurementData)data_1).isConstant();
                boolean bl = _not_1 = !_isConstant_1;
                if (!_not_1) continue;
                EList _excludedMethods = ((NonMeasurementData)data_1).getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"getter");
                boolean bl2 = _not_2 = !_contains;
                if (_not_2) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"assertTrue(");
                    String _name_8 = d.getName();
                    String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
                    _builder.append((Object)_firstLower_2, "\t");
                    _builder.append((Object)".get");
                    String _name_9 = ((NonMeasurementData)data_1).getName();
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_9);
                    _builder.append((Object)_firstUpper_4, "\t");
                    _builder.append((Object)"().equals(");
                    String _name_10 = ((NonMeasurementData)data_1).getName();
                    _builder.append((Object)_name_10, "\t");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"//no getter for ");
                String _name_11 = ((NonMeasurementData)data_1).getName();
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_11);
                _builder.append((Object)_firstUpper_5, "\t");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(data_1 instanceof MeasurementData)) continue;
            EList _excludedMethods_1 = data_1.getExcludedMethods();
            boolean _contains_1 = _excludedMethods_1.contains((Object)"getter");
            boolean bl = _not_3 = !_contains_1;
            if (_not_3) {
                boolean _isAdjustedByLinearDataConversionWithInterval = this.isAdjustedByLinearDataConversionWithInterval(data_1);
                if (_isAdjustedByLinearDataConversionWithInterval) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"assertTrue(");
                    String _name_12 = d.getName();
                    String _firstLower_3 = StringExtensions.toFirstLower((String)_name_12);
                    _builder.append((Object)_firstLower_3, "\t");
                    _builder.append((Object)".get");
                    String _name_13 = data_1.getName();
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_13);
                    _builder.append((Object)_firstUpper_6, "\t");
                    _builder.append((Object)"NotAdjusted().equals(");
                    String _name_14 = data_1.getName();
                    _builder.append((Object)_name_14, "\t");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"assertTrue(");
                String _name_15 = d.getName();
                String _firstLower_4 = StringExtensions.toFirstLower((String)_name_15);
                _builder.append((Object)_firstLower_4, "\t");
                _builder.append((Object)".get");
                String _name_16 = data_1.getName();
                String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_16);
                _builder.append((Object)_firstUpper_7, "\t");
                _builder.append((Object)"().equals(");
                String _name_17 = data_1.getName();
                _builder.append((Object)_name_17, "\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"//no getter for ");
            String _name_18 = data_1.getName();
            String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_18);
            _builder.append((Object)_firstUpper_8, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _usedDataSets_1 = d.getUsedDataSets();
        for (DataSet dataSet_1 : _usedDataSets_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"assertTrue(");
            String _name_19 = d.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_19);
            _builder.append((Object)_firstLower_5, "\t");
            _builder.append((Object)".get");
            String _name_20 = dataSet_1.getName();
            String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_20);
            _builder.append((Object)_firstUpper_9, "\t");
            _builder.append((Object)"().equals(");
            String _name_21 = dataSet_1.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_21);
            _builder.append((Object)_firstLower_6, "\t");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateInitialValueTests(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        Iterable _filter = Iterables.filter((Iterable)_data, NonMeasurementData.class);
        for (NonMeasurementData data : _filter) {
            boolean _not;
            boolean _notEquals;
            String _value = data.getValue();
            boolean bl = _notEquals = !Objects.equal((Object)_value, null);
            if (!_notEquals) continue;
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Test case for initial value of non measurement data ");
            String _name = data.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* testing if initial value is set correctly");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/\t");
            _builder.newLine();
            _builder.append((Object)"@org.junit.Test public void test");
            String _name_1 = data.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"InitialValue() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _typeName = this.toTypeName((Data)data);
            _builder.append((Object)_typeName, "\t");
            _builder.append((Object)" initialValue = ");
            String _typeName_1 = this.toTypeName((Data)data);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)".valueOf(\"");
            String _value_1 = data.getValue();
            _builder.append((Object)_value_1, "\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            EList _excludedMethods = data.getExcludedMethods();
            boolean _contains = _excludedMethods.contains((Object)"getter");
            boolean bl2 = _not = !_contains;
            if (_not) {
                _builder.append((Object)"\t");
                _builder.append((Object)"assertTrue(");
                String _name_2 = d.getName();
                String _firstLower = StringExtensions.toFirstLower((String)_name_2);
                _builder.append((Object)_firstLower, "\t");
                _builder.append((Object)".get");
                String _name_3 = data.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_2, "\t");
                _builder.append((Object)"().equals(initialValue));");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"//no getter for ");
                String _name_4 = data.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_3, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateSetterTests(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _data = d.getData();
        Iterable _filter = Iterables.filter((Iterable)_data, Data.class);
        for (Data data : _filter) {
            boolean _not_1;
            if (data instanceof NonMeasurementData) {
                boolean _not;
                boolean _isConstant = ((NonMeasurementData)data).isConstant();
                if (_isConstant) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Test case for constant non measurement data ");
                    String _name = ((NonMeasurementData)data).getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    _builder.append((Object)_firstUpper, " ");
                    _builder.append((Object)".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* testing if there is no setter for constant datas");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @generated");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/\t");
                    _builder.newLine();
                    _builder.append((Object)"@org.junit.Test public void testConstant");
                    String _name_1 = ((NonMeasurementData)data).getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (Method m : ");
                    String _name_2 = d.getName();
                    String _firstLower = StringExtensions.toFirstLower((String)_name_2);
                    _builder.append((Object)_firstLower, "\t");
                    _builder.append((Object)".getClass().getMethods()) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"Assert.assertNotEquals(m.getName(), \"set");
                    String _name_3 = ((NonMeasurementData)data).getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                    _builder.append((Object)_firstUpper_2, "\t\t");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    continue;
                }
                EList _excludedMethods = ((NonMeasurementData)data).getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"setter");
                boolean bl = _not = !_contains;
                if (!_not) continue;
                CharSequence _setterTest = this.getSetterTest(data);
                _builder.append((Object)_setterTest, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(data instanceof MeasurementData)) continue;
            EList _excludedMethods_1 = data.getExcludedMethods();
            boolean _contains_1 = _excludedMethods_1.contains((Object)"setter");
            boolean bl = _not_1 = !_contains_1;
            if (!_not_1) continue;
            CharSequence _setterTest_1 = this.getSetterTest(data);
            _builder.append((Object)_setterTest_1, "");
            _builder.newLineIfNotEmpty();
        }
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet dataSet : _usedDataSets) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Test case for setter of ");
            String _name_4 = dataSet.getName();
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper_3, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* testing basic functionality");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/\t");
            _builder.newLine();
            _builder.append((Object)"@org.junit.Test public void test");
            String _name_5 = dataSet.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_5);
            _builder.append((Object)_firstUpper_4, "");
            _builder.append((Object)"Setter() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_6 = dataSet.getName();
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_5, "\t");
            _builder.append((Object)" ");
            String _name_7 = dataSet.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)" = new ");
            String _name_8 = dataSet.getName();
            String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_8);
            _builder.append((Object)_firstUpper_6, "\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_9 = d.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_2, "\t");
            _builder.append((Object)".set");
            String _name_10 = dataSet.getName();
            String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_10);
            _builder.append((Object)_firstUpper_7, "\t");
            _builder.append((Object)"(");
            String _name_11 = dataSet.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"assertTrue(");
            String _name_12 = d.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_4, "\t");
            _builder.append((Object)".get");
            String _name_13 = dataSet.getName();
            String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_13);
            _builder.append((Object)_firstUpper_8, "\t");
            _builder.append((Object)"().equals(");
            String _name_14 = dataSet.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_14);
            _builder.append((Object)_firstLower_5, "\t");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    private String getAttributesInLine(DataSet d) {
        String s = "";
        EList _data = d.getData();
        for (Data data : _data) {
            if (data instanceof NonMeasurementData) {
                boolean _not;
                boolean _isConstant = ((NonMeasurementData)data).isConstant();
                boolean bl = _not = !_isConstant;
                if (!_not) continue;
                String _s = s;
                String _name = ((NonMeasurementData)data).getName();
                String _plus = String.valueOf(_name) + ",";
                s = String.valueOf(_s) + _plus;
                continue;
            }
            if (!(data instanceof MeasurementData)) continue;
            String _s_1 = s;
            String _name_1 = ((MeasurementData)data).getName();
            String _plus_1 = String.valueOf(_name_1) + ",";
            s = String.valueOf(_s_1) + _plus_1;
        }
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet dataSet : _usedDataSets) {
            String _s_2 = s;
            String _name_2 = dataSet.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name_2);
            String _plus_2 = String.valueOf(_firstLower) + ",";
            s = String.valueOf(_s_2) + _plus_2;
        }
        boolean _isEmpty = s.isEmpty();
        if (_isEmpty) {
            return "";
        }
        int _length = s.length();
        int _minus = _length - 1;
        return s.substring(0, _minus);
    }

    private CharSequence getImports(EList<DataSet> dataSets) {
        StringConcatenation _builder = new StringConcatenation();
        for (DataSet dataSet : dataSets) {
            _builder.append((Object)"import ");
            SensorDataDescription _sensorDataDescription = dataSet.getSensorDataDescription();
            SensorInterface _sensorInterface = _sensorDataDescription.getSensorInterface();
            String _name = _sensorInterface.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".");
            String _name_1 = dataSet.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)".");
            String _name_2 = dataSet.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence getSetterTest(Data data) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Test case for setter of ");
        String _name = data.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* testing basic functionality");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/\t");
        _builder.newLine();
        _builder.append((Object)"@org.junit.Test public void test");
        String _name_1 = data.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"Setter() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _typeName = this.toTypeName(data);
        _builder.append((Object)_typeName, "\t");
        _builder.append((Object)" minValue = ");
        Object _minValue = this.getMinValue(data);
        _builder.append(_minValue, "\t");
        DataType _dataType = data.getDataType();
        String _dataTypeExtention = this.getDataTypeExtention(_dataType);
        _builder.append((Object)_dataTypeExtention, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _typeName_1 = this.toTypeName(data);
        _builder.append((Object)_typeName_1, "\t");
        _builder.append((Object)" maxValue = ");
        Object _maxValue = this.getMaxValue(data);
        _builder.append(_maxValue, "\t");
        DataType _dataType_1 = data.getDataType();
        String _dataTypeExtention_1 = this.getDataTypeExtention(_dataType_1);
        _builder.append((Object)_dataTypeExtention_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        DataSet _dataSet = data.getDataSet();
        String _name_2 = _dataSet.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)".set");
        String _name_3 = data.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "\t");
        _builder.append((Object)"(minValue);");
        _builder.newLineIfNotEmpty();
        EList _excludedMethods = data.getExcludedMethods();
        boolean _contains = _excludedMethods.contains((Object)"getter");
        boolean bl = _not = !_contains;
        if (_not) {
            boolean _isAdjustedByLinearDataConversionWithInterval = this.isAdjustedByLinearDataConversionWithInterval(data);
            if (_isAdjustedByLinearDataConversionWithInterval) {
                _builder.append((Object)"\t");
                _builder.append((Object)"assertTrue(");
                DataSet _dataSet_1 = data.getDataSet();
                String _name_4 = _dataSet_1.getName();
                String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
                _builder.append((Object)_firstLower_1, "\t");
                _builder.append((Object)".get");
                String _name_5 = data.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_5);
                _builder.append((Object)_firstUpper_3, "\t");
                _builder.append((Object)"NotAdjusted().equals(minValue));");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"assertTrue(");
                DataSet _dataSet_2 = data.getDataSet();
                String _name_6 = _dataSet_2.getName();
                String _firstLower_2 = StringExtensions.toFirstLower((String)_name_6);
                _builder.append((Object)_firstLower_2, "\t");
                _builder.append((Object)".get");
                String _name_7 = data.getName();
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_7);
                _builder.append((Object)_firstUpper_4, "\t");
                _builder.append((Object)"().equals(minValue));");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"//no getter for ");
            String _name_8 = data.getName();
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_8);
            _builder.append((Object)_firstUpper_5, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        DataSet _dataSet_3 = data.getDataSet();
        String _name_9 = _dataSet_3.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_9);
        _builder.append((Object)_firstLower_3, "\t");
        _builder.append((Object)".set");
        String _name_10 = data.getName();
        String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_10);
        _builder.append((Object)_firstUpper_6, "\t");
        _builder.append((Object)"(maxValue);");
        _builder.newLineIfNotEmpty();
        EList _excludedMethods_1 = data.getExcludedMethods();
        boolean _contains_1 = _excludedMethods_1.contains((Object)"getter");
        boolean bl2 = _not_1 = !_contains_1;
        if (_not_1) {
            boolean _isAdjustedByLinearDataConversionWithInterval_1 = this.isAdjustedByLinearDataConversionWithInterval(data);
            if (_isAdjustedByLinearDataConversionWithInterval_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"assertTrue(");
                DataSet _dataSet_4 = data.getDataSet();
                String _name_11 = _dataSet_4.getName();
                String _firstLower_4 = StringExtensions.toFirstLower((String)_name_11);
                _builder.append((Object)_firstLower_4, "\t");
                _builder.append((Object)".get");
                String _name_12 = data.getName();
                String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_12);
                _builder.append((Object)_firstUpper_7, "\t");
                _builder.append((Object)"NotAdjusted().equals(maxValue));");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"assertTrue(");
                DataSet _dataSet_5 = data.getDataSet();
                String _name_13 = _dataSet_5.getName();
                String _firstLower_5 = StringExtensions.toFirstLower((String)_name_13);
                _builder.append((Object)_firstLower_5, "\t");
                _builder.append((Object)".get");
                String _name_14 = data.getName();
                String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_14);
                _builder.append((Object)_firstUpper_8, "\t");
                _builder.append((Object)"().equals(maxValue));");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"//no getter for ");
            String _name_15 = data.getName();
            String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_15);
            _builder.append((Object)_firstUpper_9, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private String getNecessaryCast(DataType d) {
        String _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT8: {
                    _switchResult = "(byte) ";
                    break;
                }
                case UINT8: {
                    _switchResult = "(byte) ";
                    break;
                }
                case INT16: {
                    _switchResult = "(short) ";
                    break;
                }
                case UINT16: {
                    _switchResult = "(short) ";
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    private String getDataTypeExtention(DataType d) {
        String _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT64: {
                    _switchResult = "L";
                    break;
                }
                case UINT64: {
                    _switchResult = "L";
                    break;
                }
                case FLOAT: {
                    _switchResult = "F";
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    private CharSequence getLinearDataConversionWithInterval(Number independentVariable, double oldMin, double oldMax, double newMin, double newMax) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(((");
        double _doubleValue = independentVariable.doubleValue();
        _builder.append((Object)_doubleValue, "");
        _builder.append((Object)" - ");
        _builder.append((Object)oldMin, "");
        _builder.append((Object)") * (");
        _builder.append((Object)newMax, "");
        _builder.append((Object)" - ");
        _builder.append((Object)newMin, "");
        _builder.append((Object)")) / (");
        _builder.append((Object)oldMax, "");
        _builder.append((Object)" - ");
        _builder.append((Object)oldMin, "");
        _builder.append((Object)")) + ");
        _builder.append((Object)newMin, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence getNumberWithCast(DataType type, Object number) {
        StringConcatenation _builder = new StringConcatenation();
        String _necessaryCast = this.getNecessaryCast(type);
        _builder.append((Object)_necessaryCast, "");
        String _string = number.toString();
        Double _valueOf = Double.valueOf(_string);
        Number _dataType = this.toDataType(type, _valueOf);
        _builder.append((Object)_dataType, "");
        String _dataTypeExtention = this.getDataTypeExtention(type);
        _builder.append((Object)_dataTypeExtention, "");
        return _builder;
    }

    private Object getMinValue(Data d) {
        Object _switchResult = null;
        DataType _dataType = d.getDataType();
        if (_dataType != null) {
            switch (_dataType) {
                case INT8: {
                    _switchResult = (byte)-128;
                    break;
                }
                case UINT8: {
                    _switchResult = (byte)-128;
                    break;
                }
                case INT16: {
                    _switchResult = (short)Short.MIN_VALUE;
                    break;
                }
                case UINT16: {
                    _switchResult = (short)Short.MIN_VALUE;
                    break;
                }
                case INT32: {
                    _switchResult = Integer.MIN_VALUE;
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.MIN_VALUE;
                    break;
                }
                case INT64: {
                    _switchResult = Long.MIN_VALUE;
                    break;
                }
                case UINT64: {
                    _switchResult = Long.MIN_VALUE;
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.valueOf(-3.4028235E38f);
                    break;
                }
                case DOUBLE: {
                    _switchResult = -1.7976931348623157E308;
                    break;
                }
                case BOOLEAN: {
                    _switchResult = false;
                    break;
                }
                case STRING: {
                    _switchResult = "\"test\"";
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    private Object getMaxValue(Data d) {
        Object _switchResult = null;
        DataType _dataType = d.getDataType();
        if (_dataType != null) {
            switch (_dataType) {
                case INT8: {
                    _switchResult = (byte)127;
                    break;
                }
                case UINT8: {
                    _switchResult = (byte)127;
                    break;
                }
                case INT16: {
                    _switchResult = (short)Short.MAX_VALUE;
                    break;
                }
                case UINT16: {
                    _switchResult = (short)Short.MAX_VALUE;
                    break;
                }
                case INT32: {
                    _switchResult = Integer.MAX_VALUE;
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.MAX_VALUE;
                    break;
                }
                case INT64: {
                    _switchResult = Long.MAX_VALUE;
                    break;
                }
                case UINT64: {
                    _switchResult = Long.MAX_VALUE;
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.valueOf(Float.MAX_VALUE);
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.MAX_VALUE;
                    break;
                }
                case BOOLEAN: {
                    _switchResult = true;
                    break;
                }
                case STRING: {
                    _switchResult = "\"test\"";
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    private Number toDataType(DataType d, Double value) {
        Number _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT8: {
                    _switchResult = value.byteValue();
                    break;
                }
                case UINT8: {
                    _switchResult = value.byteValue();
                    break;
                }
                case INT16: {
                    _switchResult = value.shortValue();
                    break;
                }
                case UINT16: {
                    _switchResult = value.shortValue();
                    break;
                }
                case INT32: {
                    _switchResult = value.intValue();
                    break;
                }
                case UINT32: {
                    _switchResult = value.intValue();
                    break;
                }
                case INT64: {
                    _switchResult = value.longValue();
                    break;
                }
                case UINT64: {
                    _switchResult = value.longValue();
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.valueOf(value.floatValue());
                    break;
                }
                case DOUBLE: {
                    _switchResult = value;
                    break;
                }
                default: {
                    _switchResult = 0;
                    break;
                }
            }
        } else {
            _switchResult = 0;
        }
        return _switchResult;
    }

    private String toSimpleTypeName(DataType d) {
        String _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT8: {
                    _switchResult = "byte";
                    break;
                }
                case UINT8: {
                    _switchResult = "byte";
                    break;
                }
                case INT16: {
                    _switchResult = "short";
                    break;
                }
                case UINT16: {
                    _switchResult = "short";
                    break;
                }
                case INT32: {
                    _switchResult = "int";
                    break;
                }
                case UINT32: {
                    _switchResult = "int";
                    break;
                }
                case INT64: {
                    _switchResult = "long";
                    break;
                }
                case UINT64: {
                    _switchResult = "long";
                    break;
                }
                case FLOAT: {
                    _switchResult = "float";
                    break;
                }
                case DOUBLE: {
                    _switchResult = "double";
                    break;
                }
                case BOOLEAN: {
                    _switchResult = "boolean";
                    break;
                }
                case STRING: {
                    _switchResult = "String";
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    @Override
    public String toTypeName(Data d) {
        String _switchResult = null;
        DataType _dataType = d.getDataType();
        if (_dataType != null) {
            switch (_dataType) {
                case INT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case UINT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case INT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case UINT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case INT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case INT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case UINT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.class.getName();
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.class.getName();
                    break;
                }
                case BOOLEAN: {
                    _switchResult = Boolean.class.getName();
                    break;
                }
                case STRING: {
                    _switchResult = String.class.getName();
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    private String toTypeName(DataType d) {
        String _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case UINT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case INT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case UINT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case INT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case INT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case UINT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.class.getName();
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.class.getName();
                    break;
                }
                case BOOLEAN: {
                    _switchResult = Boolean.class.getName();
                    break;
                }
                case STRING: {
                    _switchResult = String.class.getName();
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".java";
    }

    private boolean isAdjustedByLinearDataConversionWithInterval(Data d) {
        if (d instanceof MeasurementData) {
            EList _adjustments = ((MeasurementData)d).getAdjustments();
            Functions.Function1<DataAdjustment, Boolean> _function = new Functions.Function1<DataAdjustment, Boolean>(){

                public Boolean apply(DataAdjustment adj) {
                    return adj instanceof LinearDataConversionWithInterval;
                }
            };
            return IterableExtensions.exists((Iterable)_adjustments, (Functions.Function1)_function);
        }
        return false;
    }
}

