/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.converters;

import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.converters.ConvertionValidator;
import org.eclipse.xtext.conversion.ValueConverterException;

public class BooleanValidator
extends ConvertionValidator {
    private static final String BOOLEAN_TRUE_REPRESENTATION = "true";
    private static final String BOOLEAN_FALSE_REPRESENTATION = "false";
    private static final String ERROR_MESSAGE = "No valide string for boolean type.";

    public BooleanValidator(ConvertionValidator nextValidator) {
        super(nextValidator);
    }

    @Override
    public String validate(String stringToValidate) throws ValueConverterException {
        NonMeasurementData data = (NonMeasurementData)node.getSemanticElement();
        if (data.getDataType().getValue() == 10) {
            if (stringToValidate.toLowerCase().equals(BOOLEAN_TRUE_REPRESENTATION)) {
                return BOOLEAN_TRUE_REPRESENTATION;
            }
            if (stringToValidate.toLowerCase().equals(BOOLEAN_FALSE_REPRESENTATION)) {
                return BOOLEAN_FALSE_REPRESENTATION;
            }
            throw new ValueConverterException(ERROR_MESSAGE, node, null);
        }
        return this.nextValidationRoutine(stringToValidate);
    }
}

