/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.ui.wizard;

import de.fzi.sensidl.language.ui.wizard.ErrorDialogHandler;
import de.fzi.sensidl.language.ui.wizard.SensidlConfigurationWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewSensidlProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private static final String SENSIDL_SOURCE_FOLDER = "src";
    private static final String SENSIDL_FILE_EXTENSION = ".sidl";
    private SensidlConfigurationWizardPage sensIDLPage;
    private boolean isFinished = false;

    public NewSensidlProjectWizard() {
        this.setWindowTitle("New SensIDL Project");
    }

    public void addPages() {
        super.addPages();
        this.setSensIDLPage();
        this.addPage((IWizardPage)this.sensIDLPage);
    }

    private void setSensIDLPage() {
        this.sensIDLPage = new SensidlConfigurationWizardPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == null) {
            this.isFinished = true;
        }
        return nextPage;
    }

    public boolean canFinish() {
        boolean baseCanFinish = super.canFinish();
        return this.isFinished && baseCanFinish;
    }

    public boolean performFinish() {
        boolean superResult = super.performFinish();
        final IProject project = this.getNewProject();
        IWorkspaceRunnable setUpSensIDLProject = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                NewSensidlProjectWizard.this.addSensidlFileTo(project);
                NewSensidlProjectWizard.this.addXtextNatureTo(project);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(setUpSensIDLProject, null);
        }
        catch (CoreException e) {
            new ErrorDialogHandler().execute(new Shell(), (Exception)((Object)e));
            return false;
        }
        return superResult;
    }

    private void addSensidlFileTo(IProject project) throws CoreException {
        this.createSourceFolder(project);
        this.addSensidlFileTo(project.getFolder(SENSIDL_SOURCE_FOLDER));
    }

    private void addSensidlFileTo(IFolder folder) throws CoreException {
        IFile sensIDLFile = folder.getFile(this.getFileName());
        sensIDLFile.create((InputStream)new ByteArrayInputStream("".getBytes()), false, null);
    }

    private String getFileName() {
        return String.valueOf(this.sensIDLPage.getSensidlFileName()) + SENSIDL_FILE_EXTENSION;
    }

    private void createSourceFolder(IProject project) throws CoreException {
        IFolder sourceFolder = project.getFolder(SENSIDL_SOURCE_FOLDER);
        sourceFolder.create(false, true, null);
    }

    private void addXtextNatureTo(IProject project) throws CoreException {
        String[] natureIds = (String[])Arrays.asList("org.eclipse.xtext.ui.shared.xtextNature").toArray();
        IProjectDescription description = project.getDescription();
        description.setNatureIds(natureIds);
        project.setDescription(description, null);
    }
}

